/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.search;

import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.internal.ui.search.DLTKSearchResultPage;
import org.eclipse.dltk.internal.ui.search.LevelTreeContentProvider;
import org.eclipse.dltk.internal.ui.search.SearchLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;

public class PostfixLabelProvider
extends SearchLabelProvider {
    private ITreeContentProvider fContentProvider = new LevelTreeContentProvider.FastModelElementProvider();

    public PostfixLabelProvider(DLTKSearchResultPage page) {
        super(page);
    }

    @Override
    public Image getImage(Object element) {
        Image image = super.getImage(element);
        if (image != null) {
            return image;
        }
        return this.getParticipantImage(element);
    }

    @Override
    public String getText(Object element) {
        String labelWithCounts = this.getLabelWithCounts(element, this.internalGetText(element));
        StringBuilder res = new StringBuilder(labelWithCounts);
        ITreeContentProvider provider = (ITreeContentProvider)this.fPage.getViewer().getContentProvider();
        Object visibleParent = provider.getParent(element);
        Object realParent = this.fContentProvider.getParent(element);
        Object lastElement = element;
        while (realParent != null && !(realParent instanceof IScriptModel) && !realParent.equals(visibleParent)) {
            if (!this.isSameInformation(realParent, lastElement)) {
                if (res.length() != 0) {
                    res.append(" - ");
                }
                res.append(this.internalGetText(realParent));
            }
            lastElement = realParent;
            realParent = this.fContentProvider.getParent(realParent);
        }
        return res.toString();
    }

    @Override
    protected boolean hasChildren(Object element) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.fPage.getViewer().getContentProvider();
        return contentProvider.hasChildren(element);
    }

    private String internalGetText(Object element) {
        String text = super.getText(element);
        if (text != null && text.length() > 0) {
            return text;
        }
        return this.getParticipantText(element);
    }

    private boolean isSameInformation(Object realParent, Object lastElement) {
        if (lastElement instanceof IType) {
            IType type = (IType)lastElement;
            if (realParent instanceof ISourceModule && type.getSourceModule().equals(realParent)) {
                return true;
            }
        }
        return false;
    }
}

