/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.ast.nodes.BindingResolver;
import org.eclipse.php.core.ast.nodes.DefaultBindingResolver;
import org.eclipse.php.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.typeinference.FakeField;

public class VariableBinding
implements IVariableBinding {
    private static final int VALID_MODIFIERS = 8434;
    private final BindingResolver resolver;
    private final IMember modelElement;
    private boolean isFakeField;
    private ITypeBinding declaringClassTypeBinding;
    private int id;
    private Variable varialbe;

    public Variable getVarialbe() {
        return this.varialbe;
    }

    public VariableBinding(BindingResolver resolver, IMember modelElement) {
        this.resolver = resolver;
        this.modelElement = modelElement;
        this.isFakeField = modelElement instanceof FakeField;
    }

    public VariableBinding(DefaultBindingResolver resolver, IMember modelElement, Variable variable, int id) {
        this.resolver = resolver;
        this.modelElement = modelElement;
        this.isFakeField = modelElement instanceof FakeField;
        this.varialbe = variable;
        this.id = id;
    }

    @Override
    public Object getConstantValue() {
        return null;
    }

    @Override
    public ITypeBinding getDeclaringClass() {
        IType parent;
        if (this.declaringClassTypeBinding == null && (parent = this.modelElement.getDeclaringType()) != null) {
            this.declaringClassTypeBinding = this.resolver.getTypeBinding(parent);
        }
        return this.declaringClassTypeBinding;
    }

    @Override
    public IFunctionBinding getDeclaringFunction() {
        return null;
    }

    @Override
    public String getName() {
        return this.modelElement.getElementName();
    }

    @Override
    public ITypeBinding getType() {
        if (this.modelElement instanceof IField) {
            return this.resolver.getTypeBinding((IField)this.modelElement);
        }
        return null;
    }

    @Override
    public int getVariableId() {
        return this.id;
    }

    @Override
    public boolean isField() {
        return 8 == this.modelElement.getElementType() && !this.isFakeField && this.getDeclaringClass() != null;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isLocal() {
        return 8 == this.modelElement.getElementType() && !this.isFakeField && this.getDeclaringClass() == null;
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public String getKey() {
        return this.modelElement.getHandleIdentifier();
    }

    @Override
    public int getKind() {
        return 3;
    }

    @Override
    public int getModifiers() {
        block3: {
            if (this.isField()) {
                try {
                    return ((IField)this.modelElement).getFlags() & 0x20F2;
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }

    @Override
    public IModelElement getPHPElement() {
        return this.modelElement;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IVariableBinding) {
            return this.modelElement == ((IVariableBinding)obj).getPHPElement();
        }
        return false;
    }
}

