/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.RenderingsUtil;

public class HexRendering
extends AbstractAsyncTableRendering {
    public HexRendering(String renderingId) {
        super(renderingId);
    }

    @Override
    public String getString(String dataType, BigInteger address, MemoryByte[] data) {
        StringBuilder strBuffer = new StringBuilder();
        String paddedStr = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.memory.paddedStr");
        MemoryByte[] memoryByteArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryByte memByte = memoryByteArray[n2];
            if (memByte.isReadable()) {
                strBuffer.append(new String(RenderingsUtil.convertByteToCharArray(memByte.getValue())));
            } else {
                strBuffer.append(paddedStr);
            }
            ++n2;
        }
        return strBuffer.toString().toUpperCase();
    }

    @Override
    public byte[] getBytes(String dataType, BigInteger address, MemoryByte[] currentValues, String data) {
        byte[] bytes = RenderingsUtil.convertHexStringToByteArray(data, currentValues.length, this.getNumCharsPerByte());
        return bytes;
    }

    @Override
    public int getNumCharsPerByte() {
        return 2;
    }
}

