/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDINullValue;
import org.eclipse.jdt.internal.debug.eval.ast.engine.ASTInstructionCompiler;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.CompoundInstruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;
import org.eclipse.osgi.util.NLS;

public class Cast
extends CompoundInstruction {
    public static final String IS_INSTANCE = "isInstance";
    public static final String IS_INSTANCE_SIGNATURE = "(Ljava/lang/Object;)Z";
    private final int fTypeTypeId;
    private final String fBaseTypeName;
    private final int fDimension;

    public Cast(int typeTypeId, String baseTypeName, int dimension, int start) {
        super(start);
        this.fTypeTypeId = typeTypeId;
        this.fBaseTypeName = baseTypeName;
        this.fDimension = dimension;
    }

    @Override
    public void execute() throws CoreException {
        IJavaValue value = this.popValue();
        if (value instanceof IJavaPrimitiveValue) {
            IJavaPrimitiveValue primitiveValue = (IJavaPrimitiveValue)value;
            int newTypeId = this.fTypeTypeId;
            if (this.fTypeTypeId == 1) {
                newTypeId = ASTInstructionCompiler.getPrimitiveTypeId(value.getJavaType().getName());
            }
            switch (newTypeId) {
                case 8: {
                    this.push(this.newValue(primitiveValue.getDoubleValue()));
                    break;
                }
                case 9: {
                    this.push(this.newValue(primitiveValue.getFloatValue()));
                    break;
                }
                case 7: {
                    this.push(this.newValue(primitiveValue.getLongValue()));
                    break;
                }
                case 10: {
                    this.push(this.newValue(primitiveValue.getIntValue()));
                    break;
                }
                case 4: {
                    this.push(this.newValue(primitiveValue.getShortValue()));
                    break;
                }
                case 3: {
                    this.push(this.newValue(primitiveValue.getByteValue()));
                    break;
                }
                case 2: {
                    this.push(this.newValue(primitiveValue.getCharValue()));
                }
            }
        } else if (value instanceof JDINullValue) {
            this.push(value);
        } else {
            IJavaObject classObject = this.fDimension == 0 ? this.getClassObject(this.getType(this.fBaseTypeName)) : this.getClassObject(this.getArrayType(Signature.createTypeSignature((String)this.fBaseTypeName, (boolean)true), this.fDimension));
            if (classObject == null) {
                throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, NLS.bind((String)InstructionsEvaluationMessages.Cast_No_class_object, (Object[])new String[]{this.typeName()}), null));
            }
            IJavaPrimitiveValue resultValue = (IJavaPrimitiveValue)classObject.sendMessage(IS_INSTANCE, IS_INSTANCE_SIGNATURE, new IJavaValue[]{value}, this.getContext().getThread(), false);
            if (!resultValue.getBooleanValue()) {
                throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, NLS.bind((String)InstructionsEvaluationMessages.Cast_ClassCastException__Cannot_cast__0__as__1___1, (Object[])new String[]{value.toString(), this.typeName()}), null));
            }
            this.push(value);
        }
    }

    private String typeName() {
        Object result = this.fBaseTypeName;
        int i = 0;
        while (i < this.fDimension) {
            result = (String)result + "[]";
            ++i;
        }
        return result;
    }

    public String toString() {
        return InstructionsEvaluationMessages.Cast_cast_3;
    }
}

