"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
function create() {
    return {
        name: 'vue-autoinsert-space',
        capabilities: {
            autoInsertionProvider: {
                triggerCharacters: ['}'],
                configurationSections: ['vue.autoInsert.bracketSpacing'],
            },
        },
        create(context) {
            return {
                async provideAutoInsertSnippet(document, selection, change) {
                    if (document.languageId === 'html' || document.languageId === 'jade') {
                        const enabled = await context.env.getConfiguration?.('vue.autoInsert.bracketSpacing') ?? true;
                        if (!enabled) {
                            return;
                        }
                        if (change.text === '{}'
                            && document.getText().substring(change.rangeOffset - 1, change.rangeOffset + 3) === '{{}}'
                            && document.offsetAt(selection) === change.rangeOffset + 1) {
                            return ` $0 `;
                        }
                    }
                },
            };
        },
    };
}
//# sourceMappingURL=vue-autoinsert-space.js.map