/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.jar;

import java.io.File;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.jar.ExternalZipExec;
import org.eclipse.tea.library.build.jar.InternalZipExec;
import org.eclipse.tea.library.build.jar.ZipConfig;
import org.eclipse.tea.library.build.jar.ZipExec;

@Creatable
public class ZipExecFactory {
    protected final File zipExe;
    public final TaskingLog log;
    private boolean showWarning = true;
    private static boolean ignoreExternalZipExe = false;

    @Inject
    public ZipExecFactory(TaskingLog log, ZipConfig config) {
        this(log, config.zipProgramExecutable);
    }

    public ZipExecFactory(TaskingLog log, String zipProgramExecutable) {
        this.log = log;
        this.zipExe = zipProgramExecutable == null ? null : ((zipProgramExecutable = zipProgramExecutable.trim()).isEmpty() ? null : new File(zipProgramExecutable));
    }

    public static void setIgnoreExternalZipExe(boolean ignoreExternalZipExe) {
        ZipExecFactory.ignoreExternalZipExe = ignoreExternalZipExe;
    }

    public synchronized ZipExec createZipExec() {
        if (ignoreExternalZipExe) {
            return new InternalZipExec(this.log);
        }
        if (this.zipExe == null) {
            if (this.showWarning) {
                this.log.info("no ZIP application defined");
                this.showWarning = false;
            }
            return new InternalZipExec(this.log);
        }
        if (!this.zipExe.isFile()) {
            if (this.showWarning) {
                this.log.info("cannot find " + String.valueOf(this.zipExe));
                this.showWarning = false;
            }
            return new InternalZipExec(this.log);
        }
        return new ExternalZipExec(this.zipExe);
    }
}

