/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.chain;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tea.core.MarkerStatus;
import org.eclipse.tea.library.build.chain.TeaBuildElement;

public abstract class TeaBuildProjectElement
extends TeaBuildElement {
    private final IProject project;

    public TeaBuildProjectElement(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public List<IStatus> getStatus() {
        ArrayList<IStatus> markers = new ArrayList<IStatus>();
        if (this.project != null) {
            try {
                IMarker[] iMarkerArray = this.project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                int n = iMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    markers.add((IStatus)new MarkerStatus(TeaBuildProjectElement.mapSeverity(marker.getAttribute("severity", 2)), "org.eclipse.tea.library.build", marker.getAttribute("location", marker.getResource().getProjectRelativePath().toOSString()) + ":" + marker.getAttribute("lineNumber", 0) + ": " + marker.getAttribute("message", ""), marker));
                    ++n2;
                }
            }
            catch (CoreException e) {
                markers.add((IStatus)new Status(4, "org.eclipse.tea.library.build", "cannot retrieve marker for " + this.project.getName()));
            }
        }
        return markers;
    }

    private static int mapSeverity(int severity) {
        switch (severity) {
            case 2: {
                return 4;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 1;
            }
        }
        return 2;
    }
}

