/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public final class Path
implements IPath,
Cloneable {
    private static final int HAS_LEADING = 1;
    private static final int IS_UNC = 2;
    private static final int HAS_TRAILING = 4;
    private static final int IS_FOR_WINDOWS = 8;
    private static final int ALL_SEPARATORS = 7;
    public static final Path EMPTY = Constants.empty();
    public static final Path ROOT = Constants.root();
    private final String device;
    private final String[] segments;
    private int hash;
    private final byte flags;

    public static IPath fromOSString(String pathString) {
        return IPath.fromOSString(pathString);
    }

    public static IPath fromPortableString(String pathString) {
        return IPath.fromPortableString(pathString);
    }

    static IPath parsePortableString(String pathString) {
        int firstMatch = pathString.indexOf(58) + 1;
        if (firstMatch <= 0) {
            return new Path(null, pathString, Constants.RUNNING_ON_WINDOWS);
        }
        String devicePart = null;
        int pathLength = pathString.length();
        if (firstMatch == pathLength || pathString.charAt(firstMatch) != ':') {
            devicePart = pathString.substring(0, firstMatch);
            pathString = pathString.substring(firstMatch, pathLength);
        }
        if (pathString.indexOf(58) == -1) {
            return new Path(devicePart, pathString, Constants.RUNNING_ON_WINDOWS);
        }
        char[] chars = pathString.toCharArray();
        int readOffset = 0;
        int writeOffset = 0;
        int length = chars.length;
        while (readOffset < length) {
            if (chars[readOffset] == ':' && ++readOffset >= length) break;
            chars[writeOffset++] = chars[readOffset++];
        }
        return new Path(devicePart, new String(chars, 0, writeOffset), Constants.RUNNING_ON_WINDOWS);
    }

    public static Path forPosix(String fullPath) {
        return (Path)IPath.forPosix(fullPath);
    }

    public static Path forWindows(String fullPath) {
        return (Path)IPath.forWindows(fullPath);
    }

    public Path(String fullPath) {
        this(fullPath, Constants.RUNNING_ON_WINDOWS);
    }

    public Path(String device, String path) {
        this(device, Path.backslashToForward(path, Constants.RUNNING_ON_WINDOWS), Constants.RUNNING_ON_WINDOWS);
    }

    private static String backslashToForward(String path, boolean forWindows) {
        if (forWindows) {
            return path.replace('\\', '/');
        }
        return path;
    }

    Path(String fullPath, boolean forWindows) {
        int i;
        String devicePart = null;
        if (forWindows && (i = (fullPath = fullPath.replace('\\', '/')).indexOf(58)) != -1) {
            int start = 0;
            if (fullPath.startsWith("//?/")) {
                start = 4;
            } else if (fullPath.charAt(0) == '/') {
                start = 1;
            }
            devicePart = fullPath.substring(start, i + 1);
            fullPath = fullPath.substring(i + 1, fullPath.length());
        }
        Assert.isNotNull(fullPath);
        String collapsedPath = Path.collapseSlashes(devicePart, fullPath);
        int flag = Path.computeFlags(collapsedPath, forWindows);
        String[] canonicalSegments = Path.canonicalize((flag & 1) != 0, Path.computeSegments(collapsedPath));
        if (canonicalSegments.length == 0) {
            flag &= 0xFFFFFFFB;
        }
        this.device = devicePart;
        this.segments = canonicalSegments;
        this.flags = (byte)flag;
    }

    private Path(String device, String[] segments, int flags) {
        int flag = flags;
        if (segments.length == 0) {
            flag &= 0xFFFFFFFB;
        }
        this.segments = segments;
        this.device = device;
        this.flags = (byte)flag;
    }

    @Override
    public IPath addFileExtension(String extension) {
        if (this.isRoot() || this.isEmpty() || this.hasTrailingSeparator()) {
            return this;
        }
        String[] s = this.getSegments();
        int len = s.length;
        String[] newSegments = Arrays.copyOf(s, len);
        newSegments[len - 1] = s[len - 1] + "." + extension;
        return new Path(this.device, newSegments, this.flags);
    }

    @Override
    public IPath addTrailingSeparator() {
        if (this.hasTrailingSeparator() || this.isRoot()) {
            return this;
        }
        String[] s = this.getSegments();
        if (this.isEmpty()) {
            return new Path(this.device, s, this.flags & 8 | 1);
        }
        return new Path(this.device, s, this.flags | 4);
    }

    @Override
    public IPath append(IPath tail) {
        if (tail == null || tail.segmentCount() == 0) {
            return this;
        }
        if (this.isEmpty() && (this.flags & 8) == 0 == tail.isValidSegment(":")) {
            return tail.setDevice(this.device).makeRelative().makeUNC(this.isUNC());
        }
        if (this.isRoot() && (this.flags & 8) == 0 == tail.isValidSegment(":")) {
            return tail.setDevice(this.device).makeAbsolute().makeUNC(this.isUNC());
        }
        String[] s = this.getSegments();
        int myLen = s.length;
        int tailLen = tail.segmentCount();
        String[] newSegments = Arrays.copyOf(s, myLen + tailLen);
        int i = 0;
        while (i < tailLen) {
            newSegments[myLen + i] = tail.segment(i);
            ++i;
        }
        String tailFirstSegment = newSegments[myLen];
        if (tailFirstSegment.equals("..") || tailFirstSegment.equals(".")) {
            newSegments = Path.canonicalize(this.isAbsolute(), newSegments);
        }
        return new Path(this.device, newSegments, this.flags & 0xB | (tail.hasTrailingSeparator() ? 4 : 0));
    }

    @Override
    public IPath append(String tail) {
        if (tail.indexOf(47) == -1 && tail.indexOf(92) == -1 && tail.indexOf(58) == -1) {
            int tailLength = tail.length();
            if (tailLength < 3) {
                if (tailLength == 0 || ".".equals(tail)) {
                    return this;
                }
                if ("..".equals(tail)) {
                    return this.removeLastSegments(1);
                }
            }
            String[] s = this.getSegments();
            int myLen = s.length;
            String[] newSegments = Arrays.copyOf(s, myLen + 1);
            newSegments[myLen] = tail;
            return new Path(this.device, newSegments, this.flags & 0xFFFFFFFB);
        }
        return this.append(new Path(tail, (this.flags & 8) != 0));
    }

    private static String[] canonicalize(boolean isAbsolute, String[] segments) {
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment.charAt(0) == '.' && (segment.equals("..") || segment.equals("."))) {
                return Path.collapseParentReferences(isAbsolute, segments);
            }
            ++n2;
        }
        return segments;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private static String[] collapseParentReferences(boolean isAbsolute, String[] segments) {
        int segmentCount = segments.length;
        String[] stack = new String[segmentCount];
        int stackPointer = 0;
        int i = 0;
        while (i < segmentCount) {
            String segment = segments[i];
            if (segment.equals("..")) {
                if (stackPointer == 0) {
                    if (!isAbsolute) {
                        stack[stackPointer++] = segment;
                    }
                } else if ("..".equals(stack[stackPointer - 1])) {
                    stack[stackPointer++] = "..";
                } else {
                    --stackPointer;
                }
            } else if (!segment.equals(".") || segmentCount == 1) {
                stack[stackPointer++] = segment;
            }
            ++i;
        }
        if (stackPointer == segmentCount) {
            return segments;
        }
        return Arrays.copyOf(stack, stackPointer);
    }

    private static String collapseSlashes(String device, String path) {
        int length = path.length();
        if (length < 3) {
            return path;
        }
        if (path.indexOf("//", 1) == -1) {
            return path;
        }
        char[] result = new char[path.length()];
        int count = 0;
        boolean hasPrevious = false;
        char[] characters = path.toCharArray();
        int index = 0;
        while (index < characters.length) {
            char c = characters[index];
            if (c == '/') {
                if (hasPrevious) {
                    if (device == null && index == 1) {
                        result[count] = c;
                        ++count;
                    }
                } else {
                    hasPrevious = true;
                    result[count] = c;
                    ++count;
                }
            } else {
                hasPrevious = false;
                result[count] = c;
                ++count;
            }
            ++index;
        }
        return new String(result, 0, count);
    }

    private static int computeHashCode(String device, String[] segments) {
        int hash = device == null ? 17 : device.hashCode();
        int segmentCount = segments.length;
        int i = 0;
        while (i < segmentCount) {
            hash = hash * 37 + segments[i].hashCode();
            ++i;
        }
        return hash;
    }

    private int computeLength() {
        String[] s;
        int max;
        int length = 0;
        if (this.device != null) {
            length += this.device.length();
        }
        if ((this.flags & 1) != 0) {
            ++length;
        }
        if ((this.flags & 2) != 0) {
            ++length;
        }
        if ((max = (s = this.getSegments()).length) > 0) {
            int i = 0;
            while (i < max) {
                length += s[i].length();
                ++i;
            }
            length += max - 1;
        }
        if ((this.flags & 4) != 0) {
            ++length;
        }
        return length;
    }

    private static int computeSegmentCount(String path) {
        int i;
        int len = path.length();
        if (len == 0 || len == 1 && path.charAt(0) == '/') {
            return 0;
        }
        int count = 1;
        int prev = -1;
        while ((i = path.indexOf(47, prev + 1)) != -1) {
            if (i != prev + 1 && i != len) {
                ++count;
            }
            prev = i;
        }
        if (path.charAt(len - 1) == '/') {
            --count;
        }
        return count;
    }

    private static String[] computeSegments(String path) {
        int firstPosition;
        int segmentCount = Path.computeSegmentCount(path);
        if (segmentCount == 0) {
            return Constants.NO_SEGMENTS;
        }
        String[] newSegments = new String[segmentCount];
        int len = path.length();
        int n = firstPosition = path.charAt(0) == '/' ? 1 : 0;
        if (firstPosition == 1 && len > 1 && path.charAt(1) == '/') {
            firstPosition = 2;
        }
        int lastPosition = path.charAt(len - 1) != '/' ? len - 1 : len - 2;
        int next = firstPosition;
        int i = 0;
        while (i < segmentCount) {
            int start = next;
            int end = path.indexOf(47, next);
            newSegments[i] = end == -1 ? path.substring(start, lastPosition + 1) : path.substring(start, end);
            next = end + 1;
            ++i;
        }
        return newSegments;
    }

    private void encodeSegment(String string, StringBuilder buf) {
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            buf.append(c);
            if (c == ':') {
                buf.append(':');
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Path)) {
            return false;
        }
        target = (Path)obj;
        if ((this.flags & 3) != (target.flags & 3)) {
            return false;
        }
        targetSegments = target.getSegments();
        s = this.getSegments();
        i = s.length;
        if (i == targetSegments.length) ** GOTO lbl15
        return false;
lbl-1000:
        // 1 sources

        {
            if (s[i].equals(targetSegments[i])) continue;
            return false;
lbl15:
            // 2 sources

            ** while (--i >= 0)
        }
lbl16:
        // 1 sources

        return this.device == target.device || this.device != null && this.device.equals(target.device) != false;
    }

    @Override
    public String getDevice() {
        return this.device;
    }

    @Override
    public String getFileExtension() {
        if (this.hasTrailingSeparator()) {
            return null;
        }
        String lastSegment = this.lastSegment();
        if (lastSegment == null) {
            return null;
        }
        int index = lastSegment.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return lastSegment.substring(index + 1);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = Path.computeHashCode(this.device, this.getSegments());
        }
        return h;
    }

    @Override
    public boolean hasTrailingSeparator() {
        return (this.flags & 4) != 0;
    }

    private Path(String deviceString, String path, boolean forWindows) {
        Assert.isNotNull(path);
        String collapsedPath = Path.collapseSlashes(deviceString, path);
        int flag = Path.computeFlags(collapsedPath, forWindows);
        String[] canonicalSegments = Path.canonicalize((flag & 1) != 0, Path.computeSegments(collapsedPath));
        if (canonicalSegments.length == 0) {
            flag &= 0xFFFFFFFB;
        }
        this.device = deviceString;
        this.segments = canonicalSegments;
        this.flags = (byte)flag;
    }

    private static int computeFlags(String path, boolean forWindows) {
        int flags;
        int len = path.length();
        if (len < 2) {
            flags = len == 1 && path.charAt(0) == '/' ? 1 : 0;
        } else {
            boolean hasLeading = path.charAt(0) == '/';
            boolean isUNC = hasLeading && path.charAt(1) == '/';
            boolean hasTrailing = (!isUNC || len != 2) && path.charAt(len - 1) == '/';
            int n = flags = hasLeading ? 1 : 0;
            if (isUNC) {
                flags |= 2;
            }
            if (hasTrailing) {
                flags |= 4;
            }
        }
        if (forWindows) {
            flags |= 8;
        }
        return flags;
    }

    @Override
    public boolean isAbsolute() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.getSegments().length == 0 && (this.flags & 7) != 1;
    }

    @Override
    public boolean isPrefixOf(IPath anotherPath) {
        if (this.device == null ? anotherPath.getDevice() != null : !this.device.equalsIgnoreCase(anotherPath.getDevice())) {
            return false;
        }
        if (this.isEmpty() || this.isRoot() && anotherPath.isAbsolute()) {
            return true;
        }
        String[] s = this.getSegments();
        int len = s.length;
        if (len > anotherPath.segmentCount()) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!s[i].equals(anotherPath.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isRoot() {
        return this == ROOT || this.getSegments().length == 0 && (this.flags & 7) == 1;
    }

    @Override
    public boolean isUNC() {
        if (this.device != null) {
            return false;
        }
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isValidPath(String path) {
        return Path.isValidPath(path, (this.flags & 8) != 0);
    }

    public static boolean isValidPosixPath(String path) {
        return Path.isValidPath(path, false);
    }

    public static boolean isValidWindowsPath(String path) {
        return Path.isValidPath(path, true);
    }

    private static boolean isValidPath(String path, boolean forWindows) {
        Path test = new Path(path, forWindows);
        int i = 0;
        int max = test.segmentCount();
        while (i < max) {
            if (!Path.isValidSegment(test.segment(i), forWindows)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isValidSegment(String segment) {
        return Path.isValidSegment(segment, (this.flags & 8) != 0);
    }

    public static boolean isValidPosixSegment(String segment) {
        return Path.isValidSegment(segment, false);
    }

    public static boolean isValidWindowsSegment(String segment) {
        return Path.isValidSegment(segment, true);
    }

    private static boolean isValidSegment(String segment, boolean forWindows) {
        int size = segment.length();
        if (size == 0) {
            return false;
        }
        int i = 0;
        while (i < size) {
            char c = segment.charAt(i);
            if (c == '/') {
                return false;
            }
            if (forWindows && (c == '\\' || c == ':')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String lastSegment() {
        String[] s = this.getSegments();
        int len = s.length;
        return len == 0 ? null : s[len - 1];
    }

    @Override
    public IPath makeAbsolute() {
        String first;
        if (this.isAbsolute()) {
            return this;
        }
        String[] newSegments = this.getSegments();
        if (newSegments.length > 0 && ((first = newSegments[0]).equals("..") || first.equals("."))) {
            newSegments = Path.canonicalize(true, newSegments);
        }
        return new Path(this.device, newSegments, this.flags | 1);
    }

    @Override
    public IPath makeRelative() {
        if (!this.isAbsolute()) {
            return this;
        }
        return new Path(this.device, this.getSegments(), this.flags & 0xC);
    }

    @Override
    public IPath makeRelativeTo(IPath base) {
        if (!(this.device == base.getDevice() || this.device != null && this.device.equalsIgnoreCase(base.getDevice()))) {
            return this;
        }
        int commonLength = this.matchingFirstSegments(base);
        int differenceLength = base.segmentCount() - commonLength;
        int newSegmentLength = differenceLength + this.segmentCount() - commonLength;
        if (newSegmentLength == 0) {
            return EMPTY;
        }
        Object[] newSegments = new String[newSegmentLength];
        Arrays.fill(newSegments, 0, differenceLength, "..");
        System.arraycopy(this.getSegments(), commonLength, newSegments, differenceLength, newSegmentLength - differenceLength);
        return new Path(null, (String[])newSegments, this.flags & 0xC);
    }

    @Override
    public IPath makeUNC(boolean toUNC) {
        if (!(toUNC ^ this.isUNC())) {
            return this;
        }
        int newSeparators = this.flags;
        newSeparators = toUNC ? (newSeparators |= 3) : (newSeparators &= 0xD);
        return new Path(toUNC ? null : this.device, this.getSegments(), newSeparators);
    }

    @Override
    public int matchingFirstSegments(IPath anotherPath) {
        Assert.isNotNull(anotherPath);
        int anotherPathLen = anotherPath.segmentCount();
        String[] s = this.getSegments();
        int max = Math.min(s.length, anotherPathLen);
        int count = 0;
        int i = 0;
        while (i < max) {
            if (!s[i].equals(anotherPath.segment(i))) {
                return count;
            }
            ++count;
            ++i;
        }
        return count;
    }

    @Override
    public IPath removeFileExtension() {
        String extension = this.getFileExtension();
        if (extension == null || extension.equals("")) {
            return this;
        }
        String lastSegment = this.lastSegment();
        int index = lastSegment.lastIndexOf(extension) - 1;
        return this.removeLastSegments(1).append(lastSegment.substring(0, index));
    }

    @Override
    public IPath removeFirstSegments(int count) {
        if (count == 0) {
            return this;
        }
        String[] s = this.getSegments();
        if (count >= s.length) {
            return new Path(this.device, Constants.NO_SEGMENTS, this.flags & 8);
        }
        Assert.isLegal(count > 0);
        int newSize = s.length - count;
        String[] newSegments = Arrays.copyOfRange(s, count, newSize + count);
        return new Path(this.device, newSegments, this.flags & 0xC);
    }

    @Override
    public IPath removeLastSegments(int count) {
        if (count == 0) {
            return this;
        }
        String[] s = this.getSegments();
        if (count >= s.length) {
            return new Path(this.device, Constants.NO_SEGMENTS, this.flags & 0xB);
        }
        Assert.isLegal(count > 0);
        int newSize = s.length - count;
        String[] newSegments = Arrays.copyOf(s, newSize);
        return new Path(this.device, newSegments, this.flags);
    }

    @Override
    public IPath removeTrailingSeparator() {
        if (!this.hasTrailingSeparator()) {
            return this;
        }
        return new Path(this.device, this.getSegments(), this.flags & 0xB);
    }

    @Override
    public String segment(int index) {
        String[] s = this.getSegments();
        if (index >= s.length) {
            return null;
        }
        return s[index];
    }

    private String[] getSegments() {
        return this.segments;
    }

    @Override
    public int segmentCount() {
        return this.getSegments().length;
    }

    @Override
    public String[] segments() {
        String[] s = this.getSegments();
        return Arrays.copyOf(s, s.length);
    }

    @Override
    public IPath setDevice(String value) {
        if (value != null) {
            Assert.isTrue(value.indexOf(58) == value.length() - 1, "Last character should be the device separator");
        }
        if (value == this.device || value != null && value.equals(this.device)) {
            return this;
        }
        return new Path(value, this.getSegments(), this.flags);
    }

    @Override
    public File toFile() {
        return new File(this.toOSString());
    }

    @Override
    public String toOSString() {
        String[] s;
        int len;
        int resultSize = this.computeLength();
        if (resultSize <= 0) {
            return "";
        }
        char FILE_SEPARATOR = File.separatorChar;
        char[] result = new char[resultSize];
        int offset = 0;
        if (this.device != null) {
            int size = this.device.length();
            this.device.getChars(0, size, result, offset);
            offset += size;
        }
        if ((this.flags & 1) != 0) {
            result[offset++] = FILE_SEPARATOR;
        }
        if ((this.flags & 2) != 0) {
            result[offset++] = FILE_SEPARATOR;
        }
        if ((len = (s = this.getSegments()).length - 1) >= 0) {
            int i = 0;
            while (i < len) {
                int size = s[i].length();
                s[i].getChars(0, size, result, offset);
                offset += size;
                result[offset++] = FILE_SEPARATOR;
                ++i;
            }
            int size = s[len].length();
            s[len].getChars(0, size, result, offset);
            offset += size;
        }
        if ((this.flags & 4) != 0) {
            result[offset++] = FILE_SEPARATOR;
        }
        return new String(result);
    }

    @Override
    public String toPortableString() {
        int resultSize = this.computeLength();
        if (resultSize <= 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(resultSize);
        if (this.device != null) {
            result.append(this.device);
        }
        if ((this.flags & 1) != 0) {
            result.append('/');
        }
        if ((this.flags & 2) != 0) {
            result.append('/');
        }
        String[] s = this.getSegments();
        int len = s.length;
        int i = 0;
        while (i < len) {
            if (s[i].indexOf(58) >= 0) {
                this.encodeSegment(s[i], result);
            } else {
                result.append(s[i]);
            }
            if (i < len - 1 || (this.flags & 4) != 0) {
                result.append('/');
            }
            ++i;
        }
        return result.toString();
    }

    @Override
    public String toString() {
        String[] s;
        int len;
        int resultSize = this.computeLength();
        if (resultSize <= 0) {
            return "";
        }
        char[] result = new char[resultSize];
        int offset = 0;
        if (this.device != null) {
            int size = this.device.length();
            this.device.getChars(0, size, result, offset);
            offset += size;
        }
        if ((this.flags & 1) != 0) {
            result[offset++] = 47;
        }
        if ((this.flags & 2) != 0) {
            result[offset++] = 47;
        }
        if ((len = (s = this.getSegments()).length - 1) >= 0) {
            int i = 0;
            while (i < len) {
                int size = s[i].length();
                s[i].getChars(0, size, result, offset);
                offset += size;
                result[offset++] = 47;
                ++i;
            }
            int size = s[len].length();
            s[len].getChars(0, size, result, offset);
            offset += size;
        }
        if ((this.flags & 4) != 0) {
            result[offset++] = 47;
        }
        return new String(result);
    }

    @Override
    public IPath uptoSegment(int count) {
        if (count == 0) {
            return new Path(this.device, Constants.NO_SEGMENTS, this.flags & 0xB);
        }
        String[] s = this.getSegments();
        if (count >= s.length) {
            return this;
        }
        Assert.isTrue(count > 0, "Invalid parameter to Path.uptoSegment");
        String[] newSegments = Arrays.copyOf(s, count);
        return new Path(this.device, newSegments, this.flags);
    }

    static class Constants {
        static final boolean RUNNING_ON_WINDOWS = File.separatorChar == '\\';
        static final String[] NO_SEGMENTS = new String[0];
        private static Path empty = new Path("");
        private static Path root = new Path("/");

        Constants() {
        }

        static synchronized Path empty() {
            if (empty == null) {
                empty = new Path("");
            }
            return empty;
        }

        static synchronized Path root() {
            if (root == null) {
                root = new Path("/");
            }
            return root;
        }
    }
}

