/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.pkgmanager;

import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.pkgmanager.IRPkgData;
import org.eclipse.statet.r.core.pkgmanager.IRPkgInfoAndData;
import org.eclipse.statet.r.core.pkgmanager.RPkgInfo;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RPkg;

public abstract class RPkgAction {
    public static final int UNINSTALL = 1;
    public static final int INSTALL = 2;

    private RPkgAction() {
    }

    public abstract int getAction();

    public abstract RPkg getPkg();

    public abstract String getRepoId();

    public abstract RLibLocation getLibLocation();

    public static class Install
    extends RPkgAction {
        private final IRPkgData pkg;
        private RLibLocation target;
        private final IRPkgInfoAndData reference;

        public Install(IRPkgData pkg, RLibLocation target, IRPkgInfoAndData reference) {
            this.pkg = pkg;
            this.target = target;
            this.reference = reference;
        }

        @Override
        public int getAction() {
            return 2;
        }

        @Override
        public RLibLocation getLibLocation() {
            return this.target;
        }

        public void setLibraryLocation(RLibLocation location) {
            this.target = location;
        }

        @Override
        public IRPkgData getPkg() {
            return this.pkg;
        }

        @Override
        public String getRepoId() {
            return this.pkg.getRepoId();
        }

        public IRPkgInfoAndData getReferencePkg() {
            return this.reference;
        }

        public int hashCode() {
            return 9251 + this.pkg.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            block2: {
                block3: {
                    if (this == obj) break block2;
                    if (!(obj instanceof Install)) break block3;
                    Install other = (Install)obj;
                    if (this.pkg.equals(other.pkg)) break block2;
                }
                return false;
            }
            return true;
        }

        public String toString() {
            return "RPkgAction INSTALL " + String.valueOf(this.getPkg());
        }
    }

    public static class Uninstall
    extends RPkgAction {
        private final RPkgInfo pkg;

        public Uninstall(RPkgInfo pkg) {
            this.pkg = pkg;
        }

        @Override
        public int getAction() {
            return 1;
        }

        @Override
        public RPkg getPkg() {
            return this.pkg;
        }

        @Override
        public String getRepoId() {
            return null;
        }

        @Override
        public RLibLocation getLibLocation() {
            return this.pkg.getLibLocation();
        }

        public int hashCode() {
            return 1269275 + this.pkg.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            block2: {
                block3: {
                    if (this == obj) break block2;
                    if (!(obj instanceof Uninstall)) break block3;
                    Uninstall other = (Uninstall)obj;
                    if (this.pkg.equals(other.pkg)) break block2;
                }
                return false;
            }
            return true;
        }

        public String toString() {
            return "RPkgAction UNINSTALL " + String.valueOf(this.getPkg());
        }
    }
}

