/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.buildpath.core;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.buildpath.core.BasicBuildpathElement;
import org.eclipse.statet.ltk.buildpath.core.BuildpathElement;

@NonNullByDefault
public class BuildpathUtils {
    public static final boolean equalPattern(@Nullable IPath pattern1, @Nullable IPath pattern2) {
        return pattern1 == pattern2 || pattern1 != null && pattern1.equals((Object)pattern2) && pattern1.hasTrailingSeparator() == pattern2.hasTrailingSeparator();
    }

    public static boolean equalPatterns(@Nullable List<IPath> patterns1, @Nullable List<IPath> patterns2) {
        if (patterns1 == patterns2) {
            return true;
        }
        if (patterns1 != null && patterns2 != null) {
            int length = patterns1.size();
            if (patterns2.size() == length) {
                int i = 0;
                while (i < length) {
                    if (!BuildpathUtils.equalPattern(patterns1.get(i), patterns2.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static @Nullable ImList<IPath> decodePatterns(@Nullable String sequence) {
        if (sequence != null) {
            if (sequence.isEmpty()) {
                return ImCollections.emptyList();
            }
            String[] patterns = sequence.split("\\|");
            Object[] paths = new IPath[patterns.length];
            int index = 0;
            int j = 0;
            while (j < patterns.length) {
                String pattern = patterns[j];
                if (!pattern.isEmpty()) {
                    paths[index++] = new Path(pattern);
                }
                ++j;
            }
            return ImCollections.newList((Object[])paths, (int)0, (int)index);
        }
        return null;
    }

    public static @Nullable String encodePatterns(@Nullable ImList<IPath> patterns) {
        if (patterns != null) {
            return CollectionUtils.toString(patterns, IPath::toPortableString, (char)'|');
        }
        return null;
    }

    public static final boolean isExcluded(IResource resource, BuildpathElement element) {
        IPath path = resource.getFullPath();
        int resourceType = resource.getType();
        ImList<String> inclusionPatterns = ((BasicBuildpathElement)element).getFullInclusionPatterns();
        ImList<String> exclusionPatterns = ((BasicBuildpathElement)element).getFullExclusionPatterns();
        return BuildpathUtils.isExcluded(path.toString(), resourceType == 2 || resourceType == 4, inclusionPatterns, exclusionPatterns);
    }

    public static final boolean isExcluded(String path, boolean isFolderPath, @Nullable ImList<String> inclusionPatterns, @Nullable ImList<String> exclusionPatterns) {
        block8: {
            if (inclusionPatterns == null && exclusionPatterns == null) {
                return false;
            }
            if (inclusionPatterns != null) {
                Iterator iterator = inclusionPatterns.iterator();
                while (iterator.hasNext()) {
                    int star;
                    int lastSlash;
                    String pattern;
                    String folderPattern = pattern = (String)iterator.next();
                    if (isFolderPath && (lastSlash = pattern.lastIndexOf(47)) >= 0 && lastSlash != pattern.length() - 1 && ((star = pattern.indexOf(42, lastSlash)) == -1 || star >= pattern.length() - 1 || pattern.charAt(star + 1) != '*')) {
                        folderPattern = pattern.substring(0, lastSlash);
                    }
                    if (!BuildpathUtils.matchPath(folderPattern, (String)path, true, '/')) {
                        continue;
                    }
                    break block8;
                }
                return true;
            }
        }
        if (isFolderPath) {
            path = (String)path + "/*";
        }
        if (exclusionPatterns != null) {
            for (String pattern : exclusionPatterns) {
                if (!BuildpathUtils.matchPath(pattern, (String)path, true, '/')) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean matchPath(@Nullable String pattern, @Nullable String filepath, boolean isCaseSensitive, char pathSeparator) {
        int pSegmentRestart;
        if (filepath == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int pSegmentStart = pattern.charAt(0) == pathSeparator ? 1 : 0;
        int pLength = pattern.length();
        int pSegmentEnd = pattern.indexOf(pathSeparator, pSegmentStart + 1);
        if (pSegmentEnd < 0) {
            pSegmentEnd = pLength;
        }
        boolean freeTrailingDoubleStar = pattern.charAt(pLength - 1) == pathSeparator;
        int fLength = filepath.length();
        int fSegmentStart = filepath.charAt(0) != pathSeparator ? 0 : 1;
        if (fSegmentStart != pSegmentStart) {
            return false;
        }
        int fSegmentEnd = filepath.indexOf(pathSeparator, fSegmentStart + 1);
        if (fSegmentEnd < 0) {
            fSegmentEnd = fLength;
        }
        while (!(pSegmentStart >= pLength || pSegmentEnd == pLength && freeTrailingDoubleStar || pSegmentEnd == pSegmentStart + 2 && pattern.charAt(pSegmentStart) == '*' && pattern.charAt(pSegmentStart + 1) == '*')) {
            if (fSegmentStart >= fLength) {
                return false;
            }
            if (!BuildpathUtils.match(pattern, pSegmentStart, pSegmentEnd, filepath, fSegmentStart, fSegmentEnd, isCaseSensitive)) {
                return false;
            }
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = pattern.indexOf(pathSeparator, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            if ((fSegmentEnd = filepath.indexOf(pathSeparator, fSegmentStart = fSegmentEnd + 1)) >= 0) continue;
            fSegmentEnd = fLength;
        }
        if (pSegmentStart >= pLength && freeTrailingDoubleStar || pSegmentEnd == pSegmentStart + 2 && pattern.charAt(pSegmentStart) == '*' && pattern.charAt(pSegmentStart + 1) == '*') {
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = pattern.indexOf(pathSeparator, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            pSegmentRestart = pSegmentStart;
        } else {
            if (pSegmentStart >= pLength) {
                return fSegmentStart >= fLength;
            }
            pSegmentRestart = 0;
        }
        int fSegmentRestart = fSegmentStart;
        while (fSegmentStart < fLength) {
            if (pSegmentStart >= pLength) {
                if (freeTrailingDoubleStar) {
                    return true;
                }
                pSegmentStart = pSegmentRestart;
                pSegmentEnd = pattern.indexOf(pathSeparator, pSegmentStart);
                if (pSegmentEnd < 0) {
                    pSegmentEnd = pLength;
                }
                if ((fSegmentRestart = filepath.indexOf(pathSeparator, fSegmentRestart + 1)) < 0) {
                    fSegmentRestart = fLength;
                }
                fSegmentStart = ++fSegmentRestart;
                fSegmentEnd = filepath.indexOf(pathSeparator, fSegmentStart);
                if (fSegmentEnd >= 0) continue;
                fSegmentEnd = fLength;
                continue;
            }
            if (pSegmentEnd == pSegmentStart + 2 && pattern.charAt(pSegmentStart) == '*' && pattern.charAt(pSegmentStart + 1) == '*') {
                pSegmentStart = pSegmentEnd + 1;
                if ((pSegmentEnd = pattern.indexOf(pathSeparator, pSegmentStart)) < 0) {
                    pSegmentEnd = pLength;
                }
                pSegmentRestart = pSegmentStart;
                fSegmentRestart = fSegmentStart;
                if (pSegmentStart < pLength) continue;
                return true;
            }
            if (!BuildpathUtils.match(pattern, pSegmentStart, pSegmentEnd, filepath, fSegmentStart, fSegmentEnd, isCaseSensitive)) {
                pSegmentStart = pSegmentRestart;
                pSegmentEnd = pattern.indexOf(pathSeparator, pSegmentStart);
                if (pSegmentEnd < 0) {
                    pSegmentEnd = pLength;
                }
                if ((fSegmentRestart = filepath.indexOf(pathSeparator, fSegmentRestart + 1)) < 0) {
                    fSegmentRestart = fLength;
                }
                fSegmentStart = ++fSegmentRestart;
                fSegmentEnd = filepath.indexOf(pathSeparator, fSegmentStart);
                if (fSegmentEnd >= 0) continue;
                fSegmentEnd = fLength;
                continue;
            }
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = pattern.indexOf(pathSeparator, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            if ((fSegmentEnd = filepath.indexOf(pathSeparator, fSegmentStart = fSegmentEnd + 1)) >= 0) continue;
            fSegmentEnd = fLength;
        }
        return pSegmentRestart >= pSegmentEnd || fSegmentStart >= fLength && pSegmentStart >= pLength || pSegmentStart == pLength - 2 && pattern.charAt(pSegmentStart) == '*' && pattern.charAt(pSegmentStart + 1) == '*' || pSegmentStart == pLength && freeTrailingDoubleStar;
    }

    public static final boolean match(@Nullable String pattern, int patternStart, int patternEnd, @Nullable String name, int nameStart, int nameEnd, boolean isCaseSensitive) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int iPattern = patternStart;
        int iName = nameStart;
        if (patternEnd < 0) {
            patternEnd = pattern.length();
        }
        if (nameEnd < 0) {
            nameEnd = name.length();
        }
        char patternChar = '\u0000';
        while (true) {
            if (iPattern == patternEnd) {
                return iName == nameEnd;
            }
            patternChar = pattern.charAt(iPattern);
            if (patternChar == '*') break;
            if (iName == nameEnd) {
                return false;
            }
            if (patternChar != (isCaseSensitive ? name.charAt(iName) : Character.toLowerCase(name.charAt(iName))) && patternChar != '?') {
                return false;
            }
            ++iName;
            ++iPattern;
        }
        int segmentStart = patternChar == '*' ? ++iPattern : 0;
        int prefixStart = iName;
        while (iName < nameEnd) {
            if (iPattern == patternEnd) {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            patternChar = pattern.charAt(iPattern);
            if (patternChar == '*') {
                if ((segmentStart = ++iPattern) == patternEnd) {
                    return true;
                }
                prefixStart = iName;
                continue;
            }
            if (patternChar != (isCaseSensitive ? name.charAt(iName) : Character.toLowerCase(name.charAt(iName))) && patternChar != '?') {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            ++iName;
            ++iPattern;
        }
        return segmentStart == patternEnd || iName == nameEnd && iPattern == patternEnd || iPattern == patternEnd - 1 && pattern.charAt(iPattern) == '*';
    }
}

