/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.dsl.core.source.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.dsl.core.source.ast.Comment;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.KeyValuePair;
import org.eclipse.statet.dsl.core.source.ast.NContainer;
import org.eclipse.statet.dsl.core.source.ast.NodeType;
import org.eclipse.statet.dsl.core.source.ast.PropertiesContainer;
import org.eclipse.statet.dsl.core.source.ast.Record;
import org.eclipse.statet.dsl.core.source.ast.SeqEntry;
import org.eclipse.statet.dsl.core.source.ast.SourceComponent;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.StatusDetail;

@NonNullByDefault
public abstract class DslParser {
    public static final int COLLECT_COMMENTS = 1;
    protected static final byte RECORD_NONE = 0;
    protected static final byte RECORD_DIRECTIVES = 1;
    protected static final byte RECORD_CONTENT = 2;
    private final int level;
    private TextParserInput parseInput;
    private @Nullable DslAstNode currentNode;
    private int depth;
    private final List<NContainerBuilder> containerStack = new ArrayList<NContainerBuilder>();
    private byte recordState;
    private int commentsLevel;
    private final List<Comment> comments = new ArrayList<Comment>();

    public DslParser(int level) {
        this.level = level;
    }

    public abstract String getSyntaxLabel();

    public final int getCommentLevel() {
        return this.commentsLevel;
    }

    public void setCommentLevel(int level) {
        level = (level & 1) == 0 ? 0 : (level &= 1);
        this.commentsLevel = level;
    }

    protected final TextParserInput getParseInput() {
        return this.parseInput;
    }

    protected void initInput(TextParserInput input, @Nullable AstNode parent) {
        this.parseInput = (TextParserInput)ObjectUtils.nonNullAssert((Object)input);
    }

    protected void clearInput() {
        this.parseInput = null;
        while (this.depth >= 0) {
            if (this.depth < this.containerStack.size()) {
                NContainerBuilder builder = this.containerStack.get(this.depth);
                builder.clear();
            }
            --this.depth;
        }
    }

    protected void clearData() {
        if (this.commentsLevel != 0) {
            this.comments.clear();
        }
    }

    protected void handleParseError(Exception e) {
        CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.dsl.core", String.format("An error occured while parsing %1$s source code. Input:\n%2$s", this.getSyntaxLabel(), this.parseInput.toString()), (Throwable)e));
        this.clearData();
    }

    protected final int getDepth() {
        return this.depth;
    }

    protected final DslAstNode getCurrentNode() {
        return this.currentNode;
    }

    protected final NContainerBuilder getCurrentContainerBuilder() {
        return this.containerStack.get(this.depth);
    }

    protected final byte getRecordState() {
        return this.recordState;
    }

    protected boolean isNodeProperty(DslAstNode node) {
        return switch (node.getNodeType()) {
            case NodeType.TAG -> true;
            default -> false;
        };
    }

    protected void enterNode(NContainer node) {
        if (this.depth >= 0) {
            this.addChild(node);
        }
        ++this.depth;
        this.currentNode = node;
        while (this.depth >= this.containerStack.size()) {
            this.containerStack.add(new NContainerBuilder());
        }
    }

    protected void enterNode(PropertiesContainer node) {
        this.addChild(node);
        ++this.depth;
        this.currentNode = node;
    }

    protected void enterNode(KeyValuePair node) {
        this.addChild(node);
        ++this.depth;
        this.currentNode = node;
    }

    protected void enterNode(SeqEntry node) {
        this.addChild(node);
        ++this.depth;
        this.currentNode = node;
    }

    protected void addChild(DslAstNode node) {
        DslAstNode currentNode = (DslAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
        switch (currentNode.getNodeType()) {
            case KEY_VALUE_ENTRY: {
                KeyValuePair entryNode = (KeyValuePair)currentNode;
                if (entryNode.keyChild == null && entryNode.getValueIndicatorOffset() == Integer.MIN_VALUE) {
                    entryNode.keyChild = node;
                } else {
                    entryNode.valueChild = node;
                }
                return;
            }
            case SEQ_ENTRY: {
                SeqEntry entryNode = (SeqEntry)currentNode;
                entryNode.valueChild = node;
                return;
            }
            case PROPERTIES_CONTAINER: {
                PropertiesContainer propertiesNode = (PropertiesContainer)currentNode;
                if (this.isNodeProperty(node)) {
                    propertiesNode.properties = ImCollections.addElement(propertiesNode.properties, (Object)((Object)node));
                } else {
                    propertiesNode.nodeChild = node;
                }
                return;
            }
        }
        NContainer container = (NContainer)currentNode;
        NContainerBuilder builder = this.containerStack.get(this.depth);
        container.add(builder, node);
    }

    protected void exit(int offset) {
        this.finish(offset);
        this.currentNode = this.currentNode.dslParent;
        --this.depth;
        this.checkExit();
    }

    protected final boolean exitTo(NodeType type1) {
        while (this.depth > 1) {
            NodeType currentType = this.currentNode.getNodeType();
            if (currentType == type1) {
                return true;
            }
            this.exit(Integer.MIN_VALUE);
        }
        return false;
    }

    protected final boolean exitTo(NodeType type1, NodeType type2) {
        while (this.depth > 1) {
            NodeType currentType = this.currentNode.getNodeType();
            if (currentType == type1 || currentType == type2) {
                return true;
            }
            this.exit(Integer.MIN_VALUE);
        }
        return false;
    }

    protected final boolean exitTo(Class<?> type1) {
        while (this.depth > 1) {
            Class<?> currentType = ((Object)((Object)this.currentNode)).getClass();
            if (currentType == type1) {
                return true;
            }
            this.exit(Integer.MIN_VALUE);
        }
        return false;
    }

    protected final boolean exitTo(Class<?> type1, Class<?> type2) {
        while (this.depth > 1) {
            Class<?> currentType = ((Object)((Object)this.currentNode)).getClass();
            if (currentType == type1 || currentType == type2) {
                return true;
            }
            this.exit(Integer.MIN_VALUE);
        }
        return false;
    }

    protected void checkExit() {
        if (this.depth > 1) {
            switch (this.currentNode.getNodeType()) {
                case PROPERTIES_CONTAINER: {
                    if (((PropertiesContainer)this.currentNode).nodeChild == null) break;
                    this.exit(Integer.MIN_VALUE);
                    break;
                }
                case KEY_VALUE_ENTRY: {
                    if (((KeyValuePair)this.currentNode).valueChild == null) break;
                    this.exit(Integer.MIN_VALUE);
                    break;
                }
                case SEQ_ENTRY: {
                    if (((SeqEntry)this.currentNode).valueChild == null) break;
                    this.exit(Integer.MIN_VALUE);
                    break;
                }
            }
        }
    }

    private void finish(int endOffset) {
        DslAstNode currentNode = (DslAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.currentNode)));
        switch (currentNode.getNodeType()) {
            case PROPERTIES_CONTAINER: 
            case SEQ_ENTRY: 
            case KEY_VALUE_ENTRY: {
                currentNode.finish(endOffset);
                return;
            }
            case RECORD: {
                this.recordState = 0;
            }
        }
        NContainer container = (NContainer)currentNode;
        if (endOffset != Integer.MIN_VALUE) {
            container.setEndOffset(endOffset);
        }
        NContainerBuilder builder = this.containerStack.get(this.depth);
        container.finish(endOffset, builder);
        builder.clear();
    }

    protected DslAstNode exitToRecord() {
        while (this.depth > 1) {
            this.exit(Integer.MIN_VALUE);
        }
        return this.currentNode;
    }

    protected DslAstNode exitToSourceComponent(int offset) {
        while (this.depth > 1) {
            this.exit(Integer.MIN_VALUE);
        }
        if (this.depth > 0) {
            this.exit(offset);
        }
        return this.currentNode;
    }

    public SourceComponent parseSourceUnit(TextParserInput input) {
        this.initInput(input, null);
        try {
            SourceComponent sourceNode;
            this.initTask();
            SourceComponent sourceComponent = sourceNode = this.parseSourceUnit(null, false);
            return sourceComponent;
        }
        catch (Exception e) {
            this.handleParseError(e);
            SourceComponent sourceComponent = this.createErrorSourceComponent(null);
            return sourceComponent;
        }
        finally {
            this.clearInput();
        }
    }

    public SourceComponent parseSourceUnit(String input) {
        return this.parseSourceUnit((TextParserInput)new StringParserInput(input).init());
    }

    public SourceComponent parseSourceFragment(TextParserInput input, @Nullable AstNode parent, boolean expand) {
        this.initInput(input, parent);
        try {
            SourceComponent sourceNode;
            this.initTask();
            SourceComponent sourceComponent = sourceNode = this.parseSourceUnit(parent, expand);
            return sourceComponent;
        }
        catch (Exception e) {
            this.handleParseError(e);
            SourceComponent sourceComponent = this.createErrorSourceComponent(parent);
            return sourceComponent;
        }
        finally {
            this.clearInput();
        }
    }

    protected void initTask() {
        this.clearData();
        this.depth = -1;
        this.recordState = 0;
    }

    protected SourceComponent parseSourceUnit(@Nullable AstNode parent, boolean expand) {
        SourceComponent node = new SourceComponent(parent);
        this.enterNode(node);
        this.parseInput(node);
        while (this.depth >= 0) {
            this.exit(Integer.MIN_VALUE);
        }
        if (this.commentsLevel != 0) {
            node.comments = ImCollections.toList(this.comments);
        }
        if (expand) {
            node.setStartEndOffset(this.parseInput.getStartIndex(), this.parseInput.getStopIndex());
        } else if (node.getChildCount() > 0) {
            node.setStartEndOffset(node.getChild(0).getStartOffset(), node.getChild(node.getChildCount() - 1).getEndOffset());
        } else {
            node.setStartEndOffset(this.parseInput.getStartIndex());
        }
        return node;
    }

    private SourceComponent createErrorSourceComponent(@Nullable AstNode parent) {
        int startOffset = this.parseInput.getStartIndex();
        int endOffset = this.parseInput.getStopIndex();
        if (endOffset < startOffset) {
            endOffset = startOffset;
        }
        SourceComponent node = new SourceComponent(3840, parent, startOffset, endOffset);
        if (this.commentsLevel != 0) {
            node.comments = ImCollections.emptyList();
        }
        return node;
    }

    protected abstract void parseInput(SourceComponent var1);

    protected void beginRecordDirectives(Record recordNode) {
        this.recordState = 1;
    }

    protected void beginRecordContent(Record recordNode) {
        this.recordState = (byte)2;
    }

    protected void endRecord(Record recordNode, int offset) {
        this.exit(offset);
    }

    protected void addComment(Comment comment) {
        this.comments.add(comment);
    }

    protected void setStatus(DslAstNode node, int statusCode, @Nullable StatusDetail statusDetail) {
        node.setStatus(statusCode);
        if (statusDetail != null) {
            node.addAttachment(statusDetail);
        }
    }

    protected void setStatus(DslAstNode node, int statusCode) {
        node.setStatus(statusCode);
    }

    public static final class NContainerBuilder {
        public final List<DslAstNode> children = new ArrayList<DslAstNode>(8);
        public final IntList sepOffsets = new IntArrayList(8);

        void clear() {
            this.children.clear();
            this.sepOffsets.clear();
        }
    }
}

