/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class BasicThreadFactory
implements ThreadFactory {
    private static final String NAME_SUFFIX = "]";
    private final ThreadGroup threadGroup;
    private final String threadNamePrefix;
    private final String threadNameSuffix;
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    private static String buildNamePrefix(@Nullable String s1, @Nullable String s2) {
        StringBuilder sb = new StringBuilder();
        if (s1 != null) {
            sb.append(s1);
            sb.append(' ');
        }
        if (s2 != null) {
            sb.append(s2);
            sb.append(' ');
        }
        sb.append("[Thread-");
        return sb.toString();
    }

    private static ThreadGroup getCurrentThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    public BasicThreadFactory(ThreadGroup threadGroup, String threadNamePrefix, String threadNameSuffix) {
        this.threadGroup = ObjectUtils.nonNullAssert(threadGroup);
        this.threadNamePrefix = ObjectUtils.nonNullAssert(threadNamePrefix);
        this.threadNameSuffix = ObjectUtils.nonNullAssert(threadNameSuffix);
    }

    public BasicThreadFactory(String threadBaseName) {
        this(BasicThreadFactory.getCurrentThreadGroup(), BasicThreadFactory.buildNamePrefix(threadBaseName, null), NAME_SUFFIX);
    }

    public BasicThreadFactory(ThreadGroup threadGroup, @Nullable String threadSubGroupName) {
        this(threadGroup, BasicThreadFactory.buildNamePrefix(threadGroup.getName(), threadSubGroupName), NAME_SUFFIX);
    }

    public BasicThreadFactory(ThreadGroup threadGroup) {
        this(threadGroup, null);
    }

    protected boolean getDaemon() {
        return false;
    }

    protected int getPriority() {
        return 5;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(this.threadGroup, r, this.threadNamePrefix + this.threadNumber.getAndIncrement() + this.threadNameSuffix);
        thread.setDaemon(this.getDaemon());
        thread.setPriority(this.getPriority());
        return thread;
    }
}

