/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import java.io.ObjectInput;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RComplexStore;
import org.eclipse.statet.rj.data.RDataFrame;
import org.eclipse.statet.rj.data.RFactorStore;
import org.eclipse.statet.rj.data.RIntegerStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RLogicalStore;
import org.eclipse.statet.rj.data.RNumericStore;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RRawStore;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;
import org.eclipse.statet.rj.data.impl.RArrayImpl;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;
import org.eclipse.statet.rj.data.impl.RCharacter32Utf8Store;
import org.eclipse.statet.rj.data.impl.RCharacterFix64Store;
import org.eclipse.statet.rj.data.impl.RCharacterStructStore;
import org.eclipse.statet.rj.data.impl.RComplexB32Store;
import org.eclipse.statet.rj.data.impl.RComplexBFix64Store;
import org.eclipse.statet.rj.data.impl.RComplexStructStore;
import org.eclipse.statet.rj.data.impl.RDataFrame32Impl;
import org.eclipse.statet.rj.data.impl.REnvironmentImpl;
import org.eclipse.statet.rj.data.impl.RFactor32Store;
import org.eclipse.statet.rj.data.impl.RFactorFix64Store;
import org.eclipse.statet.rj.data.impl.RFactorStructStore;
import org.eclipse.statet.rj.data.impl.RFunctionImpl;
import org.eclipse.statet.rj.data.impl.RInteger32Store;
import org.eclipse.statet.rj.data.impl.RIntegerFix64Store;
import org.eclipse.statet.rj.data.impl.RIntegerStructStore;
import org.eclipse.statet.rj.data.impl.RLanguageImpl;
import org.eclipse.statet.rj.data.impl.RList32Impl;
import org.eclipse.statet.rj.data.impl.RListFix64Impl;
import org.eclipse.statet.rj.data.impl.RLogicalByte32Store;
import org.eclipse.statet.rj.data.impl.RLogicalByteFix64Store;
import org.eclipse.statet.rj.data.impl.RLogicalStructStore;
import org.eclipse.statet.rj.data.impl.RMissingImpl;
import org.eclipse.statet.rj.data.impl.RNullImpl;
import org.eclipse.statet.rj.data.impl.RNumericB32Store;
import org.eclipse.statet.rj.data.impl.RNumericBFix64Store;
import org.eclipse.statet.rj.data.impl.RNumericStructStore;
import org.eclipse.statet.rj.data.impl.ROtherImpl;
import org.eclipse.statet.rj.data.impl.RPromiseImpl;
import org.eclipse.statet.rj.data.impl.RRaw32Store;
import org.eclipse.statet.rj.data.impl.RRawFix64Store;
import org.eclipse.statet.rj.data.impl.RRawStructStore;
import org.eclipse.statet.rj.data.impl.RReferenceImpl;
import org.eclipse.statet.rj.data.impl.RS4ObjectImpl;
import org.eclipse.statet.rj.data.impl.RVectorImpl;

@NonNullByDefault
public class DefaultRObjectFactory
implements RObjectFactory {
    public static final DefaultRObjectFactory INSTANCE = new DefaultRObjectFactory();
    public static final RNumericStore NUM_STRUCT_DUMMY = new RNumericStructStore();
    public static final RComplexStructStore CPLX_STRUCT_DUMMY = new RComplexStructStore();
    public static final RIntegerStructStore INT_STRUCT_DUMMY = new RIntegerStructStore();
    public static final RLogicalStructStore LOGI_STRUCT_DUMMY = new RLogicalStructStore();
    public static final RRawStructStore RAW_STRUCT_DUMMY = new RRawStructStore();
    public static final RCharacterStructStore CHR_STRUCT_DUMMY = new RCharacterStructStore();
    private final long storeLengthFixLong = 0x10000000L;

    @Override
    public <TData extends RStore<?>> RVector<TData> createVector(TData data, String className) {
        return new RVectorImpl<TData>(data, className);
    }

    @Deprecated(since="4.8")
    public RVector<RLogicalStore> createLogiVector(int length) {
        return this.createLogiVector((long)length);
    }

    @Deprecated(since="4.8")
    public RVector<RIntegerStore> createIntVector(int length) {
        return this.createIntVector((long)length);
    }

    @Deprecated(since="4.8")
    public RVector<RNumericStore> createNumVector(int length) {
        return this.createNumVector((long)length);
    }

    @Deprecated(since="4.8")
    public RVector<RComplexStore> createCplxVector(int length) {
        return this.createCplxVector((long)length);
    }

    @Deprecated(since="4.8")
    public RVector<RCharacterStore> createCharVector(int length) {
        return this.createCharVector((long)length);
    }

    @Deprecated(since="4.8")
    public RVector<RRawStore> createRawVector(int length) {
        return this.createRawVector((long)length);
    }

    @Deprecated(since="4.8")
    public RVector<RFactorStore> createFactorVector(int[] codes, @Nullable String[] levels) {
        return this.createUnorderedFactorVector(codes, levels);
    }

    @Deprecated(since="4.8")
    public RVector<RFactorStore> createFactorVector(int length, @Nullable String[] levels) {
        return this.createUnorderedFactorVector(length, levels);
    }

    @Deprecated(since="4.8")
    public RVector<RFactorStore> createOrderedVector(int[] codes, @Nullable String[] levels) {
        return this.createOrderedFactorVector(codes, levels);
    }

    @Deprecated(since="4.8")
    public RVector<RFactorStore> createOrderedVector(int length, @Nullable String[] levels) {
        return this.createOrderedFactorVector(length, levels);
    }

    @Override
    public <TData extends RStore<?>> RArray<TData> createArray(TData data, int[] dim, String className) {
        return new RArrayImpl<TData>(data, className, dim);
    }

    @Override
    public RDataFrame createDataFrame(@NonNull RStore<?>[] colDatas, @NonNull String[] colNames, @NonNull String @Nullable [] rowNames, String className) {
        @NonNull RObject[] colVectors = new RObject[colDatas.length];
        int i = 0;
        while (i < colVectors.length) {
            colVectors[i] = this.createVector(colDatas[i]);
            ++i;
        }
        return this.createDataFrame(colVectors, colNames, rowNames, className);
    }

    public RDataFrame createDataFrame(@NonNull RObject[] colVectors, @NonNull String[] colNames, @NonNull String @Nullable [] rowNames, String className) {
        return new RDataFrame32Impl(colVectors, className, colNames, rowNames);
    }

    @Override
    public RList createList(RObject[] components, @Nullable String @Nullable [] names, String className) {
        return new RList32Impl(components, className, names);
    }

    @Override
    public RLanguage createName(String name) {
        return new RLanguageImpl(1, name, "name");
    }

    @Override
    public RLanguage createExpression(String expr) {
        return new RLanguageImpl(2, expr, "expression");
    }

    @Override
    public RLogicalStore createLogiData(boolean[] logiValues) {
        return new RLogicalByte32Store(logiValues);
    }

    @Override
    public RLogicalStore createLogiData(long length) {
        return length <= 0x10000000L ? new RLogicalByte32Store((int)length) : new RLogicalByteFix64Store(length);
    }

    @Override
    public RIntegerStore createIntData(int[] intValues) {
        return new RInteger32Store(intValues);
    }

    @Override
    public RIntegerStore createIntData(long length) {
        return length <= 0x10000000L ? new RInteger32Store((int)length) : new RIntegerFix64Store(length);
    }

    @Override
    public RNumericStore createNumData(double[] numValues) {
        return new RNumericB32Store(numValues);
    }

    @Override
    public RNumericStore createNumData(long length) {
        return length <= 0x10000000L ? new RNumericB32Store((int)length) : new RNumericBFix64Store(length);
    }

    @Override
    public RComplexStore createCplxData(double[] reValues, double[] imValues) {
        return new RComplexB32Store(reValues, imValues, null);
    }

    @Override
    public RComplexStore createCplxData(long length) {
        return length <= 0x10000000L ? new RComplexB32Store((int)length) : new RComplexBFix64Store(length);
    }

    @Override
    public RCharacterStore createCharData(@Nullable String[] charValues) {
        return new RCharacter32Store(charValues);
    }

    @Override
    public RCharacterStore createCharDataUtf8(byte[] @Nullable [] charValues) {
        return new RCharacter32Utf8Store(charValues);
    }

    @Override
    public RCharacterStore createCharData(long length) {
        return length <= 0x10000000L ? new RCharacter32Store((int)length) : new RCharacterFix64Store(length);
    }

    @Override
    public RRawStore createRawData(byte[] rawValues) {
        return new RRaw32Store(rawValues);
    }

    @Override
    public RRawStore createRawData(long length) {
        return length <= 0x10000000L ? new RRaw32Store((int)length) : new RRawFix64Store(length);
    }

    @Override
    public RFactorStore createUnorderedFactorData(int[] codes, @Nullable String[] levels) {
        return new RFactor32Store(codes, false, levels);
    }

    @Override
    public RFactorStore createUnorderedFactorData(long length, @Nullable String[] levels) {
        if (length > 0x10000000L) {
            throw new UnsupportedOperationException("long length");
        }
        return new RFactor32Store((int)length, false, levels);
    }

    @Deprecated
    public RFactorStore createFactorData(int length, @Nullable String[] levels) {
        return this.createUnorderedFactorData(length, levels);
    }

    @Override
    public RFactorStore createOrderedFactorData(int[] codes, @Nullable String[] levels) {
        return new RFactor32Store(codes, true, levels);
    }

    @Deprecated
    public RFactorStore createOrderedData(int[] codes, @Nullable String[] levels) {
        return this.createOrderedFactorData(codes, levels);
    }

    @Override
    public RFactorStore createOrderedFactorData(long length, @Nullable String[] levels) {
        if (length > 0x10000000L) {
            throw new UnsupportedOperationException("long length");
        }
        return new RFactor32Store((int)length, true, levels);
    }

    @Deprecated
    public RFactorStore createOrderedData(int length, @Nullable String[] levels) {
        return this.createOrderedFactorData(length, levels);
    }

    @Override
    public RObject readObject(RJIO io) throws IOException {
        byte type = io.readByte();
        switch (type) {
            case -1: {
                return null;
            }
            case 1: {
                return RNullImpl.INSTANCE;
            }
            case 2: {
                return new RVectorImpl(io, this);
            }
            case 3: {
                return new RArrayImpl(io, this);
            }
            case 7: {
                int options = io.readInt();
                return (options & 7) <= 3 ? new RList32Impl(io, this, options) : new RListFix64Impl(io, this, options);
            }
            case 6: {
                int options = io.readInt();
                return (options & 7) <= 3 ? new RDataFrame32Impl(io, this, options) : new RListFix64Impl(io, this, options);
            }
            case 8: {
                return new REnvironmentImpl(io, this);
            }
            case 12: {
                return new RLanguageImpl(io, this);
            }
            case 13: {
                return new RFunctionImpl(io, this);
            }
            case 14: {
                return new RReferenceImpl(io, this);
            }
            case 10: {
                return new RS4ObjectImpl(io, this);
            }
            case 15: {
                return new ROtherImpl(io, this);
            }
            case 17: {
                return RMissingImpl.INSTANCE;
            }
            case 18: {
                if ((io.flags & 4) != 0) {
                    return new RPromiseImpl(io, this);
                }
                return RPromiseImpl.INSTANCE;
            }
        }
        throw new IOException("object type= " + type);
    }

    @Override
    public void writeObject(RObject robject, RJIO io) throws IOException {
        if (robject == null) {
            io.writeByte(-1);
            return;
        }
        byte type = robject.getRObjectType();
        io.writeByte(type);
        switch (type) {
            case 1: 
            case 17: {
                return;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                ((ExternalizableRObject)((Object)robject)).writeExternal(io, this);
                return;
            }
        }
        throw new IOException("object type= " + type);
    }

    @Override
    public RStore<?> readStore(RJIO io, long length) throws IOException {
        if ((io.flags & 1) == 0) {
            byte storeType = io.readByte();
            if (length <= Integer.MAX_VALUE) {
                switch (storeType) {
                    case 1: {
                        return new RLogicalByte32Store(io, (int)length);
                    }
                    case 2: {
                        return new RInteger32Store(io, (int)length);
                    }
                    case 3: {
                        return new RNumericB32Store(io, (int)length);
                    }
                    case 4: {
                        return new RComplexB32Store(io, (int)length);
                    }
                    case 5: {
                        return new RCharacter32Store(io, (int)length);
                    }
                    case 6: {
                        return new RRaw32Store(io, (int)length);
                    }
                    case 10: {
                        return new RFactor32Store(io, (int)length);
                    }
                }
                throw new IOException("store type= " + storeType);
            }
            switch (storeType) {
                case 1: {
                    return new RLogicalByteFix64Store(io, length);
                }
                case 2: {
                    return new RIntegerFix64Store(io, length);
                }
                case 3: {
                    return new RNumericBFix64Store(io, length);
                }
                case 4: {
                    return new RComplexBFix64Store(io, length);
                }
                case 5: {
                    return new RCharacterFix64Store(io, length);
                }
                case 6: {
                    return new RRawFix64Store(io, length);
                }
                case 10: {
                    return new RFactorFix64Store(io, length);
                }
            }
            throw new IOException("store type= " + storeType);
        }
        byte storeType = io.readByte();
        switch (storeType) {
            case 1: {
                return LOGI_STRUCT_DUMMY;
            }
            case 2: {
                return INT_STRUCT_DUMMY;
            }
            case 3: {
                return NUM_STRUCT_DUMMY;
            }
            case 4: {
                return CPLX_STRUCT_DUMMY;
            }
            case 5: {
                return CHR_STRUCT_DUMMY;
            }
            case 6: {
                return RAW_STRUCT_DUMMY;
            }
            case 10: {
                return new RFactorStructStore(io.readBoolean(), io.readInt());
            }
        }
        throw new IOException("store type= " + storeType);
    }

    @Override
    public void writeStore(RStore<?> data, RJIO io) throws IOException {
        if ((io.flags & 1) == 0) {
            io.writeByte(data.getStoreType());
            ((ExternalizableRStore)((Object)data)).writeExternal(io);
        } else {
            byte storeType = data.getStoreType();
            io.writeByte(storeType);
            if (storeType == 10) {
                RFactorStore factor = (RFactorStore)data;
                io.writeBoolean(factor.isOrdered());
                io.writeInt(factor.getLevelCount());
            }
        }
    }

    @Override
    public RList readAttributeList(RJIO io) throws IOException {
        return new RList32Impl(io, this, io.readInt());
    }

    @Override
    public void writeAttributeList(RList list, RJIO io) throws IOException {
        ((ExternalizableRObject)((Object)list)).writeExternal(io, this);
    }

    protected final int[] readDim(ObjectInput in) throws IOException {
        int length = in.readInt();
        int[] dim = new int[length];
        int i = 0;
        while (i < length) {
            dim[i] = in.readInt();
            ++i;
        }
        return dim;
    }

    @Override
    public @Nullable RStore<?> readNames(RJIO io, long length) throws IOException {
        byte type = io.readByte();
        if (type == 5) {
            return length <= Integer.MAX_VALUE ? new RCharacter32Store(io, (int)length) : new RCharacterFix64Store(io, length);
        }
        if (type == 0) {
            return null;
        }
        throw new IOException();
    }

    @Override
    public void writeNames(@Nullable RStore<?> names, RJIO io) throws IOException {
        byte type;
        if (names != null && (type = names.getStoreType()) == 5) {
            io.writeByte(type);
            ((ExternalizableRStore)((Object)names)).writeExternal(io);
            return;
        }
        io.writeByte(0);
    }
}

