/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import java.net.URI;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.ecommons.text.core.FragmentDocument;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.editors.RArgumentListContextInformation;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpInfoHoverCreator;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.string.Chars;
import org.eclipse.statet.jcommons.text.core.CharPairSet;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.jcommons.text.core.input.OffsetStringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInformationProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ElementNameCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.statet.nico.ui.console.InputSourceViewer;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.model.RElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RFunctionSpec;
import org.eclipse.statet.r.core.model.rlang.RLangMethod;
import org.eclipse.statet.r.core.source.RSourceConfig;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAsts;
import org.eclipse.statet.r.core.source.ast.RParser;
import org.eclipse.statet.r.core.source.util.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;
import org.eclipse.statet.r.ui.sourceediting.RBracketLevel;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

@NonNullByDefault
public class RElementCompletionProposal
extends ElementNameCompletionProposal<RAssistInvocationContext, RElement>
implements ICompletionProposalExtension5 {
    protected static final int PACKAGE_NAME = 1;
    protected static final int ARGUMENT_NAME = 2;
    protected static final int FUNCTION = 3;
    private static boolean rHelpInfoHoverInitialized;
    private static @Nullable IInformationControlCreator rHelpInfoHoverCreator;

    private static @Nullable IInformationControlCreator getRHelpInfoHoverCreator(AssistInvocationContext context) {
        Shell shell;
        if (!rHelpInfoHoverInitialized && (shell = context.getSourceViewer().getTextWidget().getShell()) != null) {
            if (RHelpInfoHoverCreator.isAvailable((Composite)shell)) {
                rHelpInfoHoverCreator = new RHelpInfoHoverCreator(2);
            }
            rHelpInfoHoverInitialized = true;
        }
        return rHelpInfoHoverCreator;
    }

    private static final boolean isFollowedByOpeningBracket(int forwardOffset, RAssistInvocationContext context) throws BadLocationException {
        RHeuristicTokenScanner scanner = context.getRHeuristicTokenScanner();
        scanner.configure(context.getDocument());
        int idx = scanner.findAnyNonSSpaceForward(forwardOffset, -2);
        return idx != -1 && scanner.getChar() == '(';
    }

    private static final boolean isClosedBracket(int backwardOffset, int forwardOffset, RAssistInvocationContext context) throws BadLocationException {
        RHeuristicTokenScanner scanner = context.getRHeuristicTokenScanner();
        CharPairSet brackets = RHeuristicTokenScanner.R_BRACKETS;
        int searchPairIndex = brackets.getPairIndex(Chars.ROUND_BRACKETS);
        int[] balance = new int[brackets.getPairCount()];
        int n = searchPairIndex;
        balance[n] = balance[n] + 1;
        scanner.configureDefaultPartitions(context.getDocument());
        balance = scanner.computePairBalance(backwardOffset, forwardOffset, null, brackets, balance, searchPairIndex);
        return balance[searchPairIndex] <= 0;
    }

    private static final boolean isFollowedByEqualAssign(int forwardOffset, RAssistInvocationContext context) throws BadLocationException {
        RHeuristicTokenScanner scanner = context.getRHeuristicTokenScanner();
        scanner.configure(context.getDocument());
        int idx = scanner.findAnyNonSSpaceForward(forwardOffset, -2);
        return idx != -1 && scanner.getChar() == '=';
    }

    private static final boolean isFollowedByAssign(int forwardOffset, RAssistInvocationContext data) throws BadLocationException {
        RHeuristicTokenScanner scanner = data.getRHeuristicTokenScanner();
        scanner.configure(data.getDocument());
        int idx = scanner.findAnyNonSSpaceForward(forwardOffset, -2);
        return idx != -1 && (scanner.getChar() == '=' || scanner.getChar() == '<');
    }

    public RElementCompletionProposal(RElementProposalParameters parameters) {
        super((SourceProposal.ProposalParameters)parameters, parameters.replacementName, parameters.element, parameters.labelProvider);
    }

    protected RCoreAccess getRCoreAccess() {
        return ((RAssistInvocationContext)this.getInvocationContext()).getRCoreAccess();
    }

    protected int getMode() {
        RElement element = (RElement)this.getElement();
        return element != null && (element.getElementType() & 0xF00) == 1280 ? 3 : 0;
    }

    protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) {
        int end = Math.max(caretOffset, selection.x + selection.y);
        if (overwrite) {
            try {
                RAssistInvocationContext context = (RAssistInvocationContext)this.getInvocationContext();
                RHeuristicTokenScanner scanner = context.getRHeuristicTokenScanner();
                scanner.configure(context.getDocument());
                IRegion word = scanner.findRWord(end, false, true);
                if (word != null) {
                    return word.getOffset() + word.getLength() - replacementOffset;
                }
            }
            catch (BadLocationException e) {
                RUIPlugin.logUncriticalError(e);
            }
        }
        return end - replacementOffset;
    }

    protected @Nullable String getValidationPrefix(int offset) throws BadLocationException {
        int startOffset = Math.max(this.getReplacementOffset(), 0);
        if (offset >= startOffset) {
            RAssistInvocationContext context = (RAssistInvocationContext)this.getInvocationContext();
            IDocument document = context.getDocument();
            int nameEndOffset = offset;
            int nameStartOffset = startOffset;
            if (nameEndOffset > nameStartOffset && document.getChar(nameStartOffset) == '`') {
                ++nameStartOffset;
            }
            if (nameEndOffset > nameStartOffset && document.getChar(nameEndOffset - 1) == '`') {
                --nameEndOffset;
            }
            if (nameEndOffset >= nameStartOffset) {
                return context.getIdentifierSegmentName(document.get(startOffset, offset - startOffset));
            }
        }
        return null;
    }

    protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
        RAssistInvocationContext context = (RAssistInvocationContext)this.getInvocationContext();
        IDocument document = context.getDocument();
        SourceProposal.ApplyData applyData = this.getApplyData();
        ElementName replacementName = this.getReplacementName();
        int mode = this.getMode();
        boolean assignmentFunction = mode == 3 && replacementName.getNextSegment() == null && replacementName.getSegmentName().endsWith("<-");
        Object elementName = assignmentFunction ? RElementName.create((int)17, (String)replacementName.getSegmentName().substring(0, replacementName.getSegmentName().length() - 2)) : replacementName;
        StringBuilder replacement = new StringBuilder(mode == 1 ? elementName.getSegmentName() : elementName.getDisplayName());
        int cursor = replacement.length();
        if (replacementLength > 0 && document.getChar(replacementOffset) == '`' && replacement.charAt(0) != '`') {
            if (replacement.length() == elementName.getSegmentName().length() && replacementOffset + replacementLength < document.getLength() && document.getChar(replacementOffset + replacementLength) == '`') {
                ++replacementLength;
            }
            replacement.insert(elementName.getSegmentName().length(), '`');
            replacement.insert(0, '`');
            cursor += 2;
        }
        int subMode = 0;
        int linkedMode = -1;
        Supplier contextInformationComputer = null;
        switch (mode) {
            case 3: {
                RFunctionSpec fSpec;
                subMode = 1;
                final RLangMethod rMethod = (RLangMethod)this.getElement();
                if (replacementOffset + replacementLength < document.getLength() - 1 && document.getChar(replacementOffset + replacementLength) == '(') {
                    ++cursor;
                    subMode = 10;
                } else if (!RElementCompletionProposal.isFollowedByOpeningBracket(replacementOffset + replacementLength, context)) {
                    replacement.append('(');
                    ++cursor;
                    subMode = 11;
                }
                if (subMode < 10) break;
                if (subMode == 11 && !RElementCompletionProposal.isClosedBracket(replacementOffset, replacementOffset + replacementLength, context)) {
                    replacement.append(')');
                    linkedMode = 2;
                    if (assignmentFunction && !RElementCompletionProposal.isFollowedByAssign(replacementOffset + replacementLength, context)) {
                        replacement.append(" <- ");
                        if (linkedMode >= 0) {
                            linkedMode += 4;
                        }
                    }
                }
                if ((fSpec = rMethod.getFunctionSpec()) == null || fSpec.getParamCount() > 0 || subMode == 11 && linkedMode < 0) {
                    final int argsOffset = replacementOffset + cursor;
                    contextInformationComputer = new Supplier<AssistInformationProposal>(){

                        @Override
                        public RArgumentListContextInformation get() {
                            RAstNode commandNode = RElementCompletionProposal.this.parseCommandAst(argsOffset);
                            FCall fCallNode = null;
                            if (commandNode != null && (fCallNode = (FCall)RAsts.findSurrounding((AstNode)AstSelection.search((AstNode)commandNode, (int)argsOffset, (int)argsOffset, (int)3).getCovering(), (NodeType)NodeType.F_CALL)) != null && fCallNode.getArgsOpenOffset() != argsOffset - 1) {
                                fCallNode = null;
                            }
                            return new RArgumentListContextInformation(argsOffset, fCallNode, rMethod);
                        }
                    };
                    break;
                }
                ++cursor;
                linkedMode = -1;
                break;
            }
            case 2: {
                if (RElementCompletionProposal.isFollowedByEqualAssign(replacementOffset + replacementLength, context)) break;
                RCodeStyleSettings codeStyle = this.getRCoreAccess().getRCodeStyle();
                String argAssign = codeStyle.getArgAssignString();
                replacement.append(argAssign);
                cursor += argAssign.length();
            }
        }
        document.replace(replacementOffset, replacementLength, replacement.toString());
        applyData.setSelection(replacementOffset + cursor);
        if (linkedMode >= 0) {
            this.createLinkedMode(replacementOffset + cursor - 1, linkedMode).enter();
        }
        if (contextInformationComputer != null) {
            applyData.setContextInformation((IContextInformation)contextInformationComputer.get());
        }
    }

    private LinkedModeUI createLinkedMode(int offset, int mode) throws BadLocationException {
        AssistInvocationContext context = this.getInvocationContext();
        IDocument document = context.getDocument();
        LinkedModeModel model = new LinkedModeModel();
        int pos = 0;
        LinkedPositionGroup group = new LinkedPositionGroup();
        RBracketLevel.RoundBracketPosition position = new RBracketLevel.RoundBracketPosition(document, offset + 1, 0, pos++);
        group.addPosition((LinkedPosition)position);
        model.addGroup(group);
        model.forceInstall();
        RBracketLevel level = new RBracketLevel(model, document, context.getEditor().getDocumentContentInfo(), position, context.getSourceViewer() instanceof InputSourceViewer, true);
        LinkedModeUI ui = new LinkedModeUI(model, (ITextViewer)context.getSourceViewer());
        ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
        ui.setExitPosition((ITextViewer)context.getSourceViewer(), offset + (mode & 0xFF), 0, pos);
        ui.setSimpleMode(true);
        ui.setExitPolicy((LinkedModeUI.IExitPolicy)level);
        return ui;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return RElementCompletionProposal.getRHelpInfoHoverCreator(this.getInvocationContext());
    }

    public @Nullable Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        RHelpManager rHelpManager = RCore.getRHelpManager();
        int mode = this.getMode();
        RPkgHelp helpObject = null;
        switch (mode) {
            case 1: {
                ElementName elementName = this.getReplacementName();
                if (elementName.getType() != 38) break;
                String pkgName = elementName.getSegmentName();
                if (pkgName == null) {
                    return null;
                }
                REnvHelp help = rHelpManager.getHelp(this.getRCoreAccess().getREnv());
                if (help == null) break;
                try {
                    helpObject = help.getPkgHelp(pkgName);
                    break;
                }
                finally {
                    help.unlock();
                }
            }
            default: {
                RElement element = (RElement)this.getElement();
                if (element == null) {
                    return null;
                }
                RElementName elementName = element.getElementName();
                if (elementName.getType() != 17) break;
                RElementName scope = elementName.getScope();
                if (scope == null && element.getModelParent() != null) {
                    scope = element.getModelParent().getElementName();
                }
                if (scope == null || !RElementName.isPackageFacetScopeType((int)scope.getType())) {
                    return null;
                }
                String pkgName = scope.getSegmentName();
                String topic = elementName.getSegmentName();
                if (pkgName == null || topic == null) {
                    return null;
                }
                REnvHelp help = rHelpManager.getHelp(this.getRCoreAccess().getREnv());
                if (help == null) break;
                try {
                    RPkgHelp pkgHelp = help.getPkgHelp(pkgName);
                    if (pkgHelp != null) {
                        helpObject = pkgHelp.getPageForTopic(topic);
                    }
                }
                finally {
                    help.unlock();
                }
                {
                }
            }
        }
        if (Thread.interrupted() || helpObject == null) {
            return null;
        }
        URI url = RCore.getRHelpHttpService().toHttpUrl(helpObject, "info");
        if (url != null) {
            return new RHelpInfoHoverCreator.Data((Control)((RAssistInvocationContext)this.getInvocationContext()).getSourceViewer().getTextWidget(), helpObject, url);
        }
        return null;
    }

    private @Nullable RAstNode parseCommandAst(int endOffset) {
        int startOffset;
        IDocument document;
        RAssistInvocationContext context;
        block6: {
            RAstNode node;
            block5: {
                try {
                    context = (RAssistInvocationContext)this.getInvocationContext();
                    node = RAsts.findSurroundingCommand((AstNode)context.getInvocationRAstNode());
                    if (node != null) break block5;
                    return null;
                }
                catch (BadLocationException e) {
                    RUIPlugin.logUncriticalError(e);
                    return null;
                }
            }
            document = context.getDocument();
            startOffset = node.getStartOffset();
            if (startOffset != Integer.MIN_VALUE) break block6;
            return null;
        }
        int offsetShift = 0;
        if (document instanceof FragmentDocument) {
            FragmentDocument fragmentDoc = (FragmentDocument)document;
            document = fragmentDoc.getMasterDocument();
            offsetShift = fragmentDoc.getOffsetInMasterDocument();
        }
        OffsetStringParserInput input = new OffsetStringParserInput(document.get(startOffset + offsetShift, endOffset - startOffset), startOffset);
        RSourceConfig rSourceConfig = context.getRCoreAccess().getRSourceConfig();
        RParser rParser = new RParser(rSourceConfig, 1, null);
        return rParser.parseSourceFragment((TextParserInput)input.initAtOffset(), null, true);
    }

    public static class ArgumentProposal
    extends RElementCompletionProposal {
        public ArgumentProposal(RElementProposalParameters parameters) {
            super(parameters);
        }

        @Override
        protected int getMode() {
            return 2;
        }

        public String getDisplayString() {
            return this.getReplacementName().getDisplayName();
        }

        public StyledString computeStyledText() {
            return new StyledString(this.getReplacementName().getDisplayName());
        }

        public Image getImage() {
            return RUI.getImage("org.eclipse.statet.r/images/obj/argument.assign");
        }
    }

    public static class ContextInformationProposal
    extends RElementCompletionProposal {
        private final FCall fCall;

        public ContextInformationProposal(RElementProposalParameters parameters, FCall fCall) {
            super(parameters);
            this.fCall = fCall;
        }

        public boolean isAutoInsertable() {
            return true;
        }

        @Override
        protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
            SourceProposal.ApplyData applyData = this.getApplyData();
            applyData.clearSelection();
            applyData.setContextInformation((IContextInformation)new RArgumentListContextInformation(this.getReplacementOffset(), this.fCall, (RLangMethod)ObjectUtils.nonNullAssert((Object)((RLangMethod)this.getElement()))));
        }
    }

    public static class RElementProposalParameters
    extends SourceProposal.ProposalParameters<RAssistInvocationContext> {
        public final ElementLabelProvider labelProvider;
        public ElementName replacementName;
        public @Nullable RElement<?> element;

        public RElementProposalParameters(RAssistInvocationContext context, int replacementOffset, SearchPattern namePattern, int baseRelevance, ElementLabelProvider labelProvider) {
            super((AssistInvocationContext)context, replacementOffset, namePattern, baseRelevance);
            this.labelProvider = labelProvider;
        }

        public RElementProposalParameters(RAssistInvocationContext context, int replacementOffset, SearchPattern namePattern, ElementLabelProvider labelProvider) {
            super((AssistInvocationContext)context, replacementOffset, namePattern);
            this.labelProvider = labelProvider;
        }

        public RElementProposalParameters(RAssistInvocationContext context, int replacementOffset, ElementLabelProvider labelProvider) {
            super((AssistInvocationContext)context, replacementOffset, 0);
            this.labelProvider = labelProvider;
        }
    }
}

