/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.core.FragmentDocument;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.internal.r.ui.FCallNamePattern;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.editors.RElementCompletionProposal;
import org.eclipse.statet.internal.r.ui.editors.RPkgCompletionProposal;
import org.eclipse.statet.internal.r.ui.editors.RSimpleCompletionProposal;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.ltk.core.util.EntityRole;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SimpleCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RSearchPattern;
import org.eclipse.statet.r.core.RSymbolComparator;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RCoreFunctions;
import org.eclipse.statet.r.core.model.RElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RFunctionSpec;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.r.core.model.rlang.RFrame;
import org.eclipse.statet.r.core.model.rlang.RFrameSearchPath;
import org.eclipse.statet.r.core.model.rlang.RLangElement;
import org.eclipse.statet.r.core.model.rlang.RLangMethod;
import org.eclipse.statet.r.core.model.rlang.RSrcStrFrame;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.rlang.RTokens;
import org.eclipse.statet.r.core.source.RSourceConfig;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAsts;
import org.eclipse.statet.r.core.source.util.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.RLabelProvider;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.RPkgBuilt;
import org.eclipse.statet.rj.renv.core.RPkgCompilation;
import org.eclipse.statet.rj.renv.runtime.RPkgManagerDataset;

@NonNullByDefault
public abstract class AbstractRCompletionElementComputer
implements ContentAssistComputer {
    private static final ImList<String> KEYWORDS = ImCollections.concatList((Collection)RTokens.CONSTANT_WORDS, (Collection)RTokens.FLOWCONTROL_WORDS, (Comparator)RSymbolComparator.R_NAMES_COLLATOR);
    private static final PartitionConstraint NO_R_COMMENT_CONSTRAINT = new PartitionConstraint(){

        public boolean matches(String contentType) {
            return contentType != "R.Comment";
        }
    };
    private static final int AS_STRING_VECTOR = 0x6000000;
    protected static final int NA_PRIO = Integer.MIN_VALUE;
    protected static final int ARG_NAME_PRIO = 80;
    protected static final int ARG_TYPE_PRIO = 40;
    protected static final int ARG_TYPE_NO_PRIO = -40;
    protected static final byte IN_DEFAULT = 1;
    protected static final byte IN_STRING = 2;
    protected static final byte IN_STRING_VECTOR = 3;
    protected static final int CONTEXT_SUBJECT_COUNT = 4;
    protected final ElementLabelProvider labelProvider = new RLabelProvider(1);
    protected final int rSearchMode;
    private int searchMatchRules;
    private RAssistInvocationContext rContext = (RAssistInvocationContext)((Object)ObjectUtils.nonNullLateInit());
    protected byte in;
    protected int pkgNamePrio;
    private final ImList<ContextSubject> foundSubjects = ImCollections.newList((Object[])new ContextSubject[]{new ContextSubject(), new ContextSubject(), new ContextSubject(), new ContextSubject()});
    private final HashSet<String> argNames = new HashSet();
    protected AssistProposalCollector proposals = (AssistProposalCollector)ObjectUtils.nonNullLateInit();

    public AbstractRCompletionElementComputer(int rSearchMode) {
        this.rSearchMode = rSearchMode;
    }

    public void onSessionStarted(SourceEditor editor, ContentAssist assist) {
        int matchRules = 4;
        if (assist.getShowSubstringMatches()) {
            matchRules |= 0x10;
        }
        this.searchMatchRules = matchRules;
    }

    public void onSessionEnded() {
    }

    protected void initR(RAssistInvocationContext context, IProgressMonitor monitor) {
        this.rContext = context;
        this.in = (byte)(context.getInvocationContentType() == "R.String" ? 2 : 1);
    }

    protected void clear() {
        this.argNames.clear();
        this.rContext = null;
        this.proposals = null;
        this.pkgNamePrio = Integer.MIN_VALUE;
        int i = 0;
        while (i < 4) {
            ContextSubject subject = (ContextSubject)this.foundSubjects.get(i);
            subject.type = 0;
            ++i;
        }
    }

    protected final RAssistInvocationContext getRContext() {
        return this.rContext;
    }

    protected final int getRSearchMode() {
        if (this.rSearchMode != 0) {
            return this.rSearchMode;
        }
        return this.getRContext().getDefaultRFrameSearchMode();
    }

    protected int getSearchMatchRules() {
        return this.searchMatchRules;
    }

    protected final @Nullable ContextSubject getSubject(int type) {
        int i = 0;
        while (i < 4) {
            ContextSubject subject = (ContextSubject)this.foundSubjects.get(i);
            if (subject.type == type) {
                return subject;
            }
            ++i;
        }
        return null;
    }

    protected final int getSubjectPrio(int type) {
        int i = 0;
        while (i < 4) {
            ContextSubject subject = (ContextSubject)this.foundSubjects.get(i);
            if (subject.type == type) {
                return type;
            }
            ++i;
        }
        return Integer.MIN_VALUE;
    }

    protected final void addSubject(int type, int prio) {
        int i = 0;
        while (i < 4) {
            ContextSubject subject = (ContextSubject)this.foundSubjects.get(i);
            if (subject.type == type) {
                if (subject.prio > prio) {
                    subject.prio = prio;
                }
                return;
            }
            ++i;
        }
        ContextSubject replaceSubject = null;
        int i2 = 0;
        while (i2 < 4) {
            ContextSubject subject = (ContextSubject)this.foundSubjects.get(i2);
            if (subject.type == 0) {
                replaceSubject = subject;
                break;
            }
            if (prio > subject.prio && (replaceSubject == null || subject.prio <= replaceSubject.prio)) {
                replaceSubject = subject;
            }
            ++i2;
        }
        if (replaceSubject != null) {
            replaceSubject.type = type;
            replaceSubject.prio = prio;
        }
    }

    protected List<? extends RLangElement> getChildren(RLangElement e) {
        if (e instanceof RReference) {
            RReference ref = (RReference)e;
            RObject rObject = ref.getResolvedRObject();
            if (rObject == null && e instanceof CombinedRElement && this.getRContext().getTool() != null) {
                this.getRContext().getToolReferencesUtil().resolve(ref, 0);
            }
            if (rObject instanceof CombinedRElement) {
                e = (CombinedRElement)rObject;
            }
        }
        return e.getModelChildren(null);
    }

    protected final @Nullable RPkgManagerDataset getRPkgDataset() {
        IRPkgManager manager = RCore.getRPkgManager((REnv)this.getRContext().getRCoreAccess().getREnv());
        if (manager != null) {
            return manager.getDataset();
        }
        return null;
    }

    public void computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        try {
            this.proposals = proposals;
            if (context instanceof RAssistInvocationContext) {
                this.initR((RAssistInvocationContext)context, monitor);
                this.computeCompletionProposals(mode, monitor);
            }
        }
        finally {
            this.clear();
        }
    }

    protected void computeCompletionProposals(int mode, IProgressMonitor monitor) {
    }

    public void computeInformationProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        try {
            this.proposals = proposals;
            if (context instanceof RAssistInvocationContext) {
                this.initR((RAssistInvocationContext)context, monitor);
                this.computeContextProposals(monitor);
            }
        }
        finally {
            this.clear();
        }
    }

    protected void computeContextProposals(IProgressMonitor monitor) {
    }

    protected void addKeywordCompletions(RElementName prefixName) {
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        if (prefixName.getScope() != null) {
            return;
        }
        String prefixSource = this.getRContext().getIdentifierPrefix();
        if (!prefixSegmentName.isEmpty() && prefixSource.charAt(0) != '`') {
            SourceProposal.ProposalParameters parameters = new SourceProposal.ProposalParameters((AssistInvocationContext)this.getRContext(), this.getRContext().getIdentifierOffset(), (SearchPattern)new RSearchPattern(4, prefixSegmentName));
            for (String keyword : KEYWORDS) {
                if (!parameters.matchesNamePattern(keyword)) continue;
                this.proposals.add((AssistProposal)new RSimpleCompletionProposal((SourceProposal.ProposalParameters<RAssistInvocationContext>)parameters, keyword));
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void addMainElementCompletions(RFrameSearchPath searchPath, RElementName prefixName) throws Exception {
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        RElementCompletionProposal.RElementProposalParameters parameters = new RElementCompletionProposal.RElementProposalParameters(this.getRContext(), this.getRContext().getIdentifierLastSegmentOffset(), (SearchPattern)new RSearchPattern(this.getSearchMatchRules(), prefixSegmentName), this.labelProvider);
        HashSet<String> mainNames = new HashSet<String>();
        ArrayList<String> methodNames = new ArrayList<String>();
        RFrameSearchPath.Iterator iter = searchPath.iterator();
        while (iter.hasNext()) {
            RFrame envir = iter.next();
            parameters.baseRelevance = iter.getRelevance();
            List elements = envir.getModelChildren(null);
            for (RElement element : elements) {
                boolean isRich;
                RElementName elementName = element.getElementName();
                int c1type = element.getElementType() & 0xF00;
                boolean bl = isRich = c1type == 1280;
                if (!isRich && c1type != 1536 || !this.isCompletable(elementName) || !parameters.matchesNamePattern(elementName.getSegmentName()) || parameters.baseRelevance < 0 && !isRich && mainNames.contains(elementName.getSegmentName())) continue;
                parameters.replacementName = elementName;
                parameters.element = element;
                RElementCompletionProposal proposal = new RElementCompletionProposal(parameters);
                if (elementName.getNextSegment() == null) {
                    if (isRich) {
                        methodNames.add(elementName.getSegmentName());
                    } else {
                        mainNames.add(elementName.getSegmentName());
                    }
                }
                this.proposals.add((AssistProposal)proposal);
            }
        }
        mainNames.addAll(methodNames);
        for (RFrame envir : searchPath) {
            parameters.baseRelevance = 0;
            if (!(envir instanceof RSrcStrFrame)) continue;
            RSrcStrFrame sframe = (RSrcStrFrame)envir;
            @Nullable Set elementNames = sframe.getAllAccessNames();
            for (String candidate : elementNames) {
                if (candidate == null || candidate.equals(prefixSegmentName) && sframe.getAllAccessOf(candidate, false).size() <= 1 || mainNames.contains(candidate) || !parameters.matchesNamePattern(candidate)) continue;
                RSimpleCompletionProposal proposal = new RSimpleCompletionProposal(parameters, candidate);
                mainNames.add(candidate);
                this.proposals.add((AssistProposal)proposal);
            }
        }
    }

    protected FCallProposalContext createFCallProposalContext(byte in, RAssistInvocationContext.FCallInfo fCallInfo) throws BadLocationException {
        boolean argName = false;
        boolean argValue = false;
        int argIdx = fCallInfo.getInvocationArgIdx();
        if (argIdx >= 0) {
            int offset;
            RHeuristicTokenScanner scanner;
            FCall.Arg arg = fCallInfo.getArg(argIdx);
            int argBeginOffset = fCallInfo.getArgBeginOffset(argIdx);
            IDocument document = this.getRContext().getDocument();
            int offsetShift = 0;
            if (document instanceof FragmentDocument) {
                FragmentDocument inputDoc = (FragmentDocument)document;
                document = inputDoc.getMasterDocument();
                offsetShift = inputDoc.getOffsetInMasterDocument();
            }
            if (argBeginOffset != Integer.MIN_VALUE) {
                scanner = this.getRContext().getRHeuristicTokenScanner();
                scanner.configure(document, NO_R_COMMENT_CONSTRAINT);
                offset = this.getRContext().getIdentifierOffset();
                if (argBeginOffset == offset || this.in == 2 || scanner.findNonMSpaceForward(argBeginOffset + offsetShift, offset + offsetShift) == -1) {
                    argName = this.in == 1 && this.getRContext().getIdentifierElementName().getScope() == null;
                    argValue = true;
                }
            }
            if (!argValue && arg != null && arg.getAssignOffset() != Integer.MIN_VALUE) {
                scanner = this.getRContext().getRHeuristicTokenScanner();
                scanner.configure(document, NO_R_COMMENT_CONSTRAINT);
                offset = this.getRContext().getIdentifierOffset();
                if (arg.getAssignOffset() + 1 == offset || this.in == 2 || scanner.findNonMSpaceForward(arg.getAssignOffset() + 1 + offsetShift, offset + offsetShift) == -1) {
                    argValue = true;
                }
            }
        }
        return new FCallProposalContext(in, fCallInfo, argName, argValue);
    }

    protected boolean checkArgsDef(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable RFunctionSpec.Parameter parameter, @Nullable RElementName fName, boolean guess, int relevance) {
        if (parameter != null) {
            boolean typedDef;
            boolean bl = typedDef = parameter.getType() != 0;
            int type = typedDef ? parameter.getType() : (guess ? this.guessArgType(parameter.getName()) : 0);
            int prio = 40 + relevance;
            if ((type & 0x200) != 0 && prio > this.pkgNamePrio && this.isValidNameContext(parameter)) {
                this.pkgNamePrio = prio;
            }
            if ((type & 0x40000) != 0 && this.isValidNameContext(parameter)) {
                this.addSubject(262144, prio);
            }
            if ((type & 0x100000) != 0 && this.isValidNameContext(parameter)) {
                this.addSubject(0x100000, prio);
            }
            return typedDef;
        }
        return false;
    }

    protected boolean checkArgsDef(FCallProposalContext fCall, RFunctionSpec fSpec, @Nullable RElementName fName, boolean guess, int relevance) {
        return this.checkArgsDef(RAsts.matchArgs((FCall)fCall.callInfo.getNode(), (RFunctionSpec)fSpec).getParamForFCall(fCall.callInfo.getInvocationArgIdx()), fName, guess, relevance);
    }

    protected void addFCallArgNameCompletions(RLangMethod element, RElementCompletionProposal.RElementProposalParameters parameters) {
        RFunctionSpec elementFSpec = element.getFunctionSpec();
        if (elementFSpec == null) {
            return;
        }
        int i = 0;
        while (i < elementFSpec.getParamCount()) {
            RFunctionSpec.Parameter param = elementFSpec.getParam(i);
            String paramName = param.getName();
            if (paramName != null && !paramName.isEmpty() && !paramName.equals("...") && parameters.matchesNamePattern(paramName) && this.argNames.add(paramName)) {
                RElementName name = RElementName.create((int)17, (String)param.getName());
                parameters.replacementName = name;
                parameters.element = element;
                this.proposals.add((AssistProposal)new RElementCompletionProposal.ArgumentProposal(parameters));
            }
            ++i;
        }
    }

    protected void addFCallArgCompletions(RAssistInvocationContext.FCallInfo fCallInfo, RElementName prefixName, @Nullable RFrameSearchPath searchPath) throws Exception {
        RAssistInvocationContext.FCallInfo enclosingFCallInfo;
        String prefixSegmentName = (String)ObjectUtils.nonNullAssert((Object)prefixName.getSegmentName());
        byte savedIn = this.in;
        ArrayList<FCallProposalContext> fCalls = new ArrayList<FCallProposalContext>(2);
        FCallProposalContext mainFCall = this.createFCallProposalContext(savedIn, fCallInfo);
        fCalls.add(mainFCall);
        if (mainFCall.argValue() && savedIn == 2 && this.isVectorFun((RElementName)fCallInfo.getAccess()) && (enclosingFCallInfo = this.findFCall(fCallInfo.getNode().getRParent(), null)) != null) {
            fCalls.add(new FCallProposalContext(3, enclosingFCallInfo, false, true));
        }
        RElementCompletionProposal.RElementProposalParameters parameters = new RElementCompletionProposal.RElementProposalParameters(this.getRContext(), this.getRContext().getIdentifierOffset(), (SearchPattern)new RSearchPattern(this.getSearchMatchRules(), prefixSegmentName), this.labelProvider);
        for (FCallProposalContext fCall : fCalls) {
            FCall.Arg arg;
            if (!fCall.argAny()) continue;
            this.in = fCall.in();
            if (fCall.argValue() && !fCall.argName() && (arg = fCall.callInfo.getArg(fCall.callInfo.getInvocationArgIdx())) != null && arg.hasName()) {
                this.checkArgsDef(new RFunctionSpec.Parameter(fCall.callInfo.getInvocationArgIdx(), arg.getNameChild().getText(), 0, null), (RElementName)fCall.callInfo.getAccess(), true, 0);
            }
            FCallArgHandler search = new FCallArgHandler(fCall, parameters);
            search.searchFDef(searchPath != null ? searchPath : fCall.callInfo.getSearchPath(this.getRSearchMode()));
        }
        this.in = savedIn;
    }

    protected void addFCallArgContexts(final RAssistInvocationContext.FCallInfo fCallInfo, @Nullable RFrameSearchPath searchPath) {
        final RElementCompletionProposal.RElementProposalParameters parameters = new RElementCompletionProposal.RElementProposalParameters(this.getRContext(), fCallInfo.getNode().getArgsOpenOffset() + 1, this.labelProvider);
        FCallNamePattern pattern = new FCallNamePattern((RElementName)fCallInfo.getAccess()){

            @Override
            protected void handleMatch(RLangMethod<?> element, RFrame<?> frame, RFrameSearchPath.Iterator iterator) {
                parameters.baseRelevance = iterator.getRelevance();
                parameters.replacementName = element.getElementName();
                parameters.element = element;
                AbstractRCompletionElementComputer.this.proposals.add((AssistProposal)new RElementCompletionProposal.ContextInformationProposal(parameters, fCallInfo.getNode()));
            }
        };
        pattern.searchFDef(searchPath != null ? searchPath : fCallInfo.getSearchPath(this.getRSearchMode()));
    }

    protected void addPkgNameCompletions(String prefix, int prio) {
        Object envNames;
        RElementCompletionProposal.RElementProposalParameters parameters = new RElementCompletionProposal.RElementProposalParameters(this.getRContext(), this.getRContext().getInvocationOffset() - prefix.length(), (SearchPattern)new RSearchPattern(this.getSearchMatchRules(), prefix), prio, this.labelProvider);
        RPkgManagerDataset rPkgDataset = this.getRPkgDataset();
        if (rPkgDataset != null) {
            RPkgCompilation pkgs = rPkgDataset.getInstalled();
            envNames = pkgs.getNames();
            Iterator iterator = envNames.iterator();
            while (iterator.hasNext()) {
                String pkgName = (String)iterator.next();
                if (!parameters.matchesNamePattern(pkgName)) continue;
                parameters.replacementName = RElementName.create((int)38, (String)pkgName);
                RPkgCompletionProposal proposal = new RPkgCompletionProposal(parameters, (RPkgBuilt)pkgs.getFirst(pkgName));
                this.proposals.add((AssistProposal)proposal);
            }
        } else {
            envNames = ImCollections.emptySet();
        }
        Set workspaceNames = RModel.getRModelManager().getPkgNames();
        for (String pkgName : workspaceNames) {
            if (envNames.contains(pkgName) || !parameters.matchesNamePattern(pkgName)) continue;
            parameters.replacementName = RElementName.create((int)38, (String)pkgName);
            this.proposals.add((AssistProposal)new RPkgCompletionProposal(parameters, null));
        }
    }

    protected void addRoleCodeCompletions(int prio) {
        String prefixSource = this.getRContext().getIdentifierPrefix();
        int contentOffset = 1;
        SourceProposal.ProposalParameters parameters = new SourceProposal.ProposalParameters((AssistInvocationContext)this.getRContext(), this.getRContext().getIdentifierOffset() + contentOffset, new SearchPattern(4, prefixSource.substring(contentOffset, prefixSource.length())));
        for (EntityRole role : EntityRole.COMMON_ROLES) {
            if ((role.getFlags() & 0x1000) == 0 || !parameters.matchesNamePattern(role.getCode())) continue;
            this.proposals.add((AssistProposal)new SimpleCompletionProposal(parameters, role.getCode(), role.getName()));
        }
    }

    protected final boolean isPackageName(RElementName elementName) {
        return (elementName.getType() == 17 || RElementName.isPackageFacetScopeType((int)elementName.getType())) && elementName.getNextSegment() == null;
    }

    protected final boolean isFun(RElementName expected, RElementName actual) {
        RElementName segment;
        return actual.getType() == 17 && actual.getNextSegment() == null && expected.getSegmentName().equals(actual.getSegmentName()) && ((segment = actual.getScope()) == null || expected.getScope().getSegmentName().equals(segment.getSegmentName()));
    }

    protected final boolean isVectorFun(RElementName elementName) {
        RElementName segment;
        return elementName.getType() == 17 && elementName.getNextSegment() == null && "c".equals(elementName.getSegmentName()) && ((segment = elementName.getScope()) == null || "base".equals(segment.getSegmentName()));
    }

    protected final boolean isCompletable(@Nullable RElementName elementName) {
        if (elementName == null) {
            return false;
        }
        do {
            switch (elementName.getType()) {
                case 27: 
                case 28: {
                    return false;
                }
            }
            if (elementName.getSegmentName() != null) continue;
            return false;
        } while ((elementName = elementName.getNextSegment()) != null);
        return true;
    }

    protected final boolean isValidNameContext(RFunctionSpec.Parameter parameter) {
        return switch (this.in) {
            case 2 -> {
                if ((parameter.getType() & 0x2000000) != 0) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if ((parameter.getType() & 0x6000000) == 0x6000000) {
                    yield true;
                }
                yield false;
            }
            default -> (parameter.getType() & 0x1000000) != 0;
        };
    }

    protected final int guessArgType(@Nullable String name) {
        block7: {
            if (name == null) break block7;
            switch (name) {
                case "package": {
                    return 0x2000200;
                }
            }
        }
        return 0;
    }

    protected final @Nullable RAssistInvocationContext.FCallInfo findFCall(@Nullable RAstNode node, @Nullable String name) {
        while (node != null) {
            if (node.getNodeType() == NodeType.F_CALL_ARGS) {
                RAssistInvocationContext.FCallInfo nextInfo = this.getRContext().createFCallInfo(((FCall.Args)node).getRParent());
                if (name == null || nextInfo != null && name.equals(nextInfo.getAccess().getSegmentName())) {
                    return nextInfo;
                }
            }
            node = node.getRParent();
        }
        return null;
    }

    protected void log(Exception e) {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("An error occurred when gathering assist proposals.");
        sb.addProp("class", this.getClass().getName());
        sb.addProp("in", (int)this.in);
        RUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.ui", sb.build(), (Throwable)e));
    }

    protected static class ContextSubject {
        private int type;
        public int prio;

        protected ContextSubject() {
        }
    }

    protected class FCallArgHandler
    extends FCallNamePattern {
        private final FCallProposalContext fCall;
        private final @Nullable RCoreFunctions coreFunction;
        private int matchCount;
        private final RElementCompletionProposal.RElementProposalParameters parameters;

        public FCallArgHandler(FCallProposalContext fCall, RElementCompletionProposal.RElementProposalParameters parameters) {
            super((RElementName)fCall.callInfo.getAccess());
            this.fCall = fCall;
            this.coreFunction = fCall.callInfo.getAccess().getNextSegment() == null ? RCoreFunctions.getDefinitions((RSourceConfig)AbstractRCompletionElementComputer.this.getRContext().getRCoreAccess().getRSourceConfig()) : null;
            this.parameters = parameters;
        }

        @Override
        public void searchFDef(RFrameSearchPath searchPath) {
            RFunctionSpec coreFSpec;
            super.searchFDef(searchPath);
            if (this.matchCount == 0 && this.coreFunction != null && (coreFSpec = this.coreFunction.getFunctionSpec(this.getElementName().getSegmentName())) != null) {
                AbstractRCompletionElementComputer.this.checkArgsDef(this.fCall, coreFSpec, this.getElementName(), false, 0);
            }
        }

        @Override
        protected void handleMatch(RLangMethod<?> element, RFrame<?> frame, RFrameSearchPath.Iterator iterator) {
            RFunctionSpec coreFSpec;
            RFunctionSpec elementFSpec = element.getFunctionSpec();
            if (elementFSpec == null) {
                return;
            }
            int contextRelevance = iterator.getRelevance();
            ++this.matchCount;
            if (this.fCall.argName()) {
                this.parameters.baseRelevance = contextRelevance + 80;
                AbstractRCompletionElementComputer.this.addFCallArgNameCompletions(element, this.parameters);
            }
            if (this.fCall.argValue() && !AbstractRCompletionElementComputer.this.checkArgsDef(this.fCall, elementFSpec, element.getElementName(), true, contextRelevance) && frame.getFrameType() == 2 && this.coreFunction != null && this.coreFunction.getPackageNames().contains((Object)frame.getElementName().getSegmentName()) && (coreFSpec = this.coreFunction.getFunctionSpec(this.getElementName().getSegmentName())) != null) {
                AbstractRCompletionElementComputer.this.checkArgsDef(this.fCall, coreFSpec, element.getElementName(), false, contextRelevance);
            }
        }
    }

    protected record FCallProposalContext(byte in, RAssistInvocationContext.FCallInfo callInfo, boolean argName, boolean argValue) {
        public boolean argAny() {
            return this.argName || this.argValue;
        }
    }
}

