/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.refactoring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.refactoring.Messages;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringDescriptor;
import org.eclipse.statet.ltk.refactoring.core.LtkRefactoring;
import org.eclipse.statet.ltk.refactoring.core.RefactoringChange;
import org.eclipse.statet.ltk.refactoring.core.RefactoringMessages;
import org.eclipse.statet.ltk.refactoring.core.SourceUnitChange;
import org.eclipse.statet.ltk.refactoring.core.TextChangeCompatibility;
import org.eclipse.statet.ltk.refactoring.core.TextChangeManager;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.model.RWorkspaceSourceUnit;
import org.eclipse.statet.r.core.model.rlang.RFrame;
import org.eclipse.statet.r.core.model.rlang.RLangSrcStrElement;
import org.eclipse.statet.r.core.model.rlang.RSrcStrFrame;
import org.eclipse.statet.r.core.project.RProject;
import org.eclipse.statet.r.core.refactoring.RElementSearchProcessor;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAsts;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameInWorkspaceRefactoring
extends LtkRefactoring {
    private static final int FOUND_NONE = 0;
    private static final int FOUND_READ = 1;
    private static final int FOUND_WRITE = 2;
    private final RRefactoringAdapter adapter = new RRefactoringAdapter();
    private final ElementSet elementSet;
    private TextRegion selectionRegion;
    private final RWorkspaceSourceUnit sourceUnit;
    private RAstNode initialSymbolNode;
    private RElementAccess initialAccess;
    private SearchProcessor searchProcessor;
    private String newName;
    private Change[] changes;

    public RenameInWorkspaceRefactoring(RWorkspaceSourceUnit su, TextRegion region) {
        this.sourceUnit = su;
        this.elementSet = new ElementSet(new Object[]{su});
        if (region != null && region.getStartOffset() >= 0 && region.getLength() >= 0) {
            this.selectionRegion = region;
        }
    }

    public RenameInWorkspaceRefactoring(RWorkspaceSourceUnit su, RAstNode node) {
        this.sourceUnit = su;
        this.elementSet = new ElementSet(new Object[]{su});
        if (node.getNodeType() == NodeType.SYMBOL || node.getNodeType() == NodeType.STRING_CONST) {
            this.initialSymbolNode = node;
        }
    }

    public String getBundleId() {
        return "org.eclipse.statet.r.core";
    }

    public String getIdentifier() {
        return "org.eclipse.statet.r.refactoring.RenameInWorkspaceOperation";
    }

    public String getName() {
        return Messages.RenameInWorkspace_label;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        try {
            if (this.selectionRegion != null) {
                this.initialSymbolNode = this.adapter.searchPotentialNameNode(this.sourceUnit, this.selectionRegion, false, (IProgressMonitor)m.newChild(4));
            }
            if (this.initialSymbolNode == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)Messages.RenameInWorkspace_error_InvalidSelection_message);
                return refactoringStatus;
            }
            if (this.sourceUnit.getResource() == null || this.sourceUnit.getResource().getProject() == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)"The file is not in the workspace");
                return refactoringStatus;
            }
            RefactoringStatus result = new RefactoringStatus();
            this.adapter.checkInitialToModify(result, this.elementSet);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.checkVariable(result);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        catch (BadLocationException e) {
            throw this.handleUnexpectedError(e);
        }
        finally {
            m.done();
        }
    }

    private void checkVariable(RefactoringStatus result) {
        this.initialAccess = RElementAccess.getMainElementAccessOfNameNode(this.initialSymbolNode);
        RElementAccess subAccess = RElementAccess.getElementAccessOfNameNode(this.initialSymbolNode);
        RElementName fullName = this.initialAccess != null && subAccess != null ? RElementName.create(this.initialAccess, subAccess.getNextSegment(), false) : null;
        this.searchProcessor = new SearchProcessor(fullName, this.sourceUnit, this.initialAccess);
        if (this.searchProcessor.getStatus().getSeverity() >= 4) {
            result.merge(RefactoringStatus.create((IStatus)this.searchProcessor.getStatus()));
            return;
        }
        this.newName = fullName.getDisplayName();
    }

    public String getCurrentName() {
        return this.searchProcessor.getElementName().getDisplayName();
    }

    public String getNewName() {
        return this.newName;
    }

    public RefactoringStatus checkNewName(String name) {
        String message = this.adapter.validateIdentifier(name, "The variable name");
        if (message != null) {
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        return new RefactoringStatus();
    }

    public void setNewName(String name) {
        this.newName = name;
    }

    public List<RElementSearchProcessor.Mode> getAvailableModes() {
        return this.searchProcessor.getAvailableModes();
    }

    public RElementSearchProcessor.Mode getMode() {
        return this.searchProcessor.getMode();
    }

    public void setMode(RElementSearchProcessor.Mode mode) {
        this.searchProcessor.setMode(mode);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_FinalCheck_label, (int)23);
        try {
            RefactoringStatus status = this.checkNewName(this.newName);
            if (status.getSeverity() >= 4) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (this.getMode() == RElementSearchProcessor.Mode.LOCAL_FRAME) {
                this.changes = this.createLocalChanges(m.newChild(20));
                this.adapter.checkFinalToModify(status, this.elementSet, (IProgressMonitor)m.newChild(2));
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            this.searchProcessor.run(m.newChild(20));
            if (this.searchProcessor.getStatus() != Status.OK_STATUS) {
                status.merge(RefactoringStatus.create((IStatus)this.searchProcessor.getStatus()));
            }
            TextChangeManager changeManager = this.searchProcessor.changeManager;
            this.changes = changeManager.getAllChanges();
            m.worked(1);
            ElementSet elements = new ElementSet((Object[])changeManager.getAllSourceUnits());
            this.adapter.checkFinalToModify(status, elements, (IProgressMonitor)m.newChild(2));
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_CreateChanges_label, (int)3);
        try {
            HashMap arguments = new HashMap();
            String description = NLS.bind((String)Messages.RenameInWorkspace_Descriptor_description, (Object)RUtil.formatVarName(this.getNewName()));
            IProject resource = this.elementSet.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String source = project != null ? NLS.bind((String)RefactoringMessages.Common_Source_Project_label, (Object)project) : RefactoringMessages.Common_Source_Workspace_label;
            boolean flags = false;
            String comment = "";
            CommonRefactoringDescriptor descriptor = new CommonRefactoringDescriptor(this.getIdentifier(), project, description, "", arguments, 0);
            RefactoringChange refactoringChange = new RefactoringChange((RefactoringDescriptor)descriptor, this.getName(), this.changes);
            return refactoringChange;
        }
        finally {
            m.done();
        }
    }

    private Change[] createLocalChanges(SubMonitor m) {
        m.setWorkRemaining(6);
        SourceUnitChange change = new SourceUnitChange((SourceUnit)this.sourceUnit);
        if (this.sourceUnit.getWorkingContext() == Ltk.EDITOR_CONTEXT) {
            change.setSaveMode(4);
        }
        this.sourceUnit.connect((IProgressMonitor)m.newChild(1));
        try {
            ImList<? extends RElementAccess> accessList = this.initialAccess.getAllInUnit(false);
            String unquoted = RRefactoringAdapter.getUnquotedIdentifier(this.newName);
            String quoted = RRefactoringAdapter.getQuotedIdentifier(this.newName);
            boolean isQuoted = this.newName.charAt(0) == '`';
            for (RElementAccess access : accessList) {
                RAstNode nameNode = access.getNameNode();
                String text = isQuoted && nameNode.getNodeType() == NodeType.SYMBOL && nameNode.getOperator(0) == RTerminal.SYMBOL ? this.newName : unquoted;
                TextRegion nameRegion = RAsts.getElementNameRegion(nameNode);
                if (nameRegion == null) continue;
                TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.RenameInWorkspace_Changes_ReplaceOccurrence_name, (TextEdit)new ReplaceEdit(nameRegion.getStartOffset(), nameRegion.getLength(), text));
            }
            m.worked(4);
            Change[] changeArray = new Change[]{change};
            return changeArray;
        }
        finally {
            this.sourceUnit.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    private int createChanges(SourceUnit su, TextFileChange change, Set<String> definitionFrameIds, SubMonitor m) throws BadLocationException {
        m.setWorkRemaining(9);
        int found = 0;
        su.connect((IProgressMonitor)m.newChild(1));
        try {
            RSourceUnitModelInfo modelInfo = (RSourceUnitModelInfo)su.getModelInfo("R", 2, (IProgressMonitor)m.newChild(1));
            String unquoted = RRefactoringAdapter.getUnquotedIdentifier(this.newName);
            String quoted = RRefactoringAdapter.getQuotedIdentifier(this.newName);
            boolean isQuoted = this.newName.charAt(0) == '`';
            ArrayList<ImList<? extends RElementAccess>> allFrameAccess = new ArrayList<ImList<? extends RElementAccess>>();
            for (String string : definitionFrameIds) {
                ImList<? extends RElementAccess> allAccess;
                RFrame<RLangSrcStrElement> frame = string == null ? modelInfo.getTopFrame() : (RFrame)modelInfo.getReferencedFrames().get(string);
                if (!(frame instanceof RSrcStrFrame) || (allAccess = frame.getAllAccessOf(this.searchProcessor.mainName.getSegmentName(), false)) == null || allAccess.size() <= 0) continue;
                allFrameAccess.add(allAccess);
            }
            m.worked(2);
            for (List list : allFrameAccess) {
                for (RElementAccess access : list) {
                    found |= access.isWriteAccess() && access.getNextSegment() == null ? 2 : 1;
                    RAstNode nameNode = access.getNameNode();
                    String text = isQuoted && nameNode.getNodeType() == NodeType.SYMBOL && nameNode.getOperator(0) == RTerminal.SYMBOL ? this.newName : unquoted;
                    TextRegion nameRegion = RAsts.getElementNameRegion(nameNode);
                    if (nameRegion == null) continue;
                    TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.RenameInWorkspace_Changes_ReplaceOccurrence_name, (TextEdit)new ReplaceEdit(nameRegion.getStartOffset(), nameRegion.getLength(), text));
                }
            }
            m.worked(4);
            int n = found;
            return n;
        }
        finally {
            su.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    private class SearchProcessor
    extends RElementSearchProcessor {
        TextChangeManager changeManager;

        public SearchProcessor(RElementName elementName, RSourceUnit sourceUnit, RElementAccess mainAccess) {
            super(elementName, sourceUnit, mainAccess, null, 65536);
        }

        @Override
        public void begin(SubMonitor m) {
            this.changeManager = new TextChangeManager();
        }

        @Override
        public void beginFinalProcessing(SubMonitor m) {
            m.subTask(RefactoringMessages.Common_CreateChanges_label);
            RSourceUnit initialSu = this.getInitialSourceUnit();
            TextFileChange textFileChange = this.changeManager.get((SourceUnit)initialSu);
            if (initialSu.getWorkingContext() == Ltk.EDITOR_CONTEXT) {
                textFileChange.setSaveMode(4);
            }
        }

        @Override
        public void process(RProject project, List<SourceUnit> sus, SubMonitor m) throws BadLocationException {
            if (sus != null) {
                int workRemaining = sus.size();
                for (SourceUnit su : sus) {
                    m.setWorkRemaining(workRemaining--);
                    TextFileChange change = this.changeManager.get(su);
                    RenameInWorkspaceRefactoring.this.createChanges(su, change, this.definitionFrameIds, m.newChild(1));
                }
            }
        }
    }
}

