/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.rdata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.internal.r.rdata.BasicCombinedRElement;
import org.eclipse.statet.internal.r.rdata.CombinedFactory;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.data.CombinedRList;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RS4Object;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;

@NonNullByDefault
public final class RS4ObjectVar
extends BasicCombinedRElement
implements RS4Object,
CombinedRList,
ExternalizableRObject {
    private final String className;
    private final RCharacter32Store slotNames;
    private final @NonNull BasicCombinedRElement[] slotValues;
    private final int dataSlotIdx;

    public RS4ObjectVar(RJIO io, CombinedFactory factory, @Nullable BasicCombinedRElement parent, @Nullable RElementName name) throws IOException {
        super(parent, name);
        int options = io.readInt();
        this.className = io.readString();
        int l = (int)io.readVULong((byte)(options & 7));
        this.dataSlotIdx = io.readInt();
        this.slotNames = new RCharacter32Store(io, l);
        this.slotValues = new BasicCombinedRElement[l];
        int i = 0;
        while (i < l) {
            this.slotValues[i] = factory.readObject(io, this, RElementName.create((int)25, (String)this.slotNames.getChar(i)));
            ++i;
        }
    }

    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        int l = this.slotValues.length;
        byte options = io.getVULongGrade((long)l);
        io.writeInt((int)options);
        io.writeString(this.className);
        io.writeVULong((byte)(options & 7), (long)l);
        io.writeInt(this.dataSlotIdx);
        this.slotNames.writeExternal(io);
        int i = 0;
        while (i < l) {
            factory.writeObject((RObject)this.slotValues[i], io);
            ++i;
        }
    }

    public byte getRObjectType() {
        return 10;
    }

    public String getRClassName() {
        return this.className;
    }

    public long getLength() {
        return this.slotValues.length;
    }

    public boolean hasDataSlot() {
        return this.dataSlotIdx >= 0;
    }

    public @Nullable RObject getDataSlot() {
        return this.dataSlotIdx >= 0 ? this.slotValues[this.dataSlotIdx] : null;
    }

    public @Nullable RStore<?> getData() {
        return this.dataSlotIdx >= 0 && this.slotValues[this.dataSlotIdx] != null ? this.slotValues[this.dataSlotIdx].getData() : null;
    }

    public RCharacterStore getNames() {
        return this.slotNames;
    }

    public String getName(int idx) {
        return this.slotNames.getChar(idx);
    }

    public String getName(long idx) {
        return this.slotNames.getChar(idx);
    }

    public CombinedRElement get(int idx) {
        return this.slotValues[idx];
    }

    public CombinedRElement get(long idx) {
        if (idx < 0L || idx >= (long)this.slotValues.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.slotValues[(int)idx];
    }

    public CombinedRElement get(String name) {
        int idx = this.slotNames.indexOf(name, 0);
        if (idx >= 0) {
            return this.slotValues[idx];
        }
        throw new IllegalArgumentException();
    }

    public int getElementType() {
        return 1552;
    }

    public boolean hasModelChildren(@Nullable LtkModelElementFilter filter) {
        if (filter == null) {
            return this.slotValues.length > 0;
        }
        BasicCombinedRElement[] basicCombinedRElementArray = this.slotValues;
        int n = this.slotValues.length;
        int n2 = 0;
        while (n2 < n) {
            BasicCombinedRElement component = basicCombinedRElementArray[n2];
            if (filter.include((LtkModelElement)component)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List<? extends CombinedRElement> getModelChildren(@Nullable LtkModelElementFilter filter) {
        if (filter == null) {
            return ImCollections.newList((Object[])this.slotValues);
        }
        ArrayList<BasicCombinedRElement> list = new ArrayList<BasicCombinedRElement>();
        BasicCombinedRElement[] basicCombinedRElementArray = this.slotValues;
        int n = this.slotValues.length;
        int n2 = 0;
        while (n2 < n) {
            BasicCombinedRElement component = basicCombinedRElementArray[n2];
            if (filter.include((LtkModelElement)component)) {
                list.add(component);
            }
            ++n2;
        }
        return list;
    }
}

