/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.apps.ui.viewer;

import java.net.URI;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserSession;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookBrowserPage;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookBrowserView;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.apps.ui.viewer.AppBrowserPage;
import org.eclipse.statet.internal.r.apps.ui.viewer.AppBrowserSession;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.apps.ui.AppRegistry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class AppBrowserView
extends PageBookBrowserView {
    public static final String VIEW_ID = "org.eclipse.statet.r.apps.views.AppViewer";
    public static final String APP_CONTROL_GROUP_ID = "app.Control";
    private AppRegistry.Listener appRegistryListener;

    public void dispose() {
        if (this.appRegistryListener != null) {
            AppRegistry.getInstance().removeListener(this.appRegistryListener);
            this.appRegistryListener = null;
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.appRegistryListener = new AppRegistry.Listener(){

            @Override
            public void onAppStateChanged(AppRegistry.AppStateEvent event) {
                UIAccess.getDisplay((Shell)AppBrowserView.this.getSite().getShell()).asyncExec(() -> {
                    if (AppBrowserView.this.isCurrent(event.getId())) {
                        AppBrowserView.this.updateTitle();
                        AppBrowserView.this.updateState();
                    }
                });
            }
        };
        AppRegistry.getInstance().addListener(this.appRegistryListener);
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        super.contributeToActionBars(serviceLocator, actionBars, handlers);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.insertBefore("additions", (IContributionItem)new Separator(APP_CONTROL_GROUP_ID));
    }

    protected PageBookBrowserPage doCreatePage(BrowserSession session) {
        if (session instanceof AppBrowserSession) {
            return new AppBrowserPage(this, (AppBrowserSession)session);
        }
        return super.doCreatePage(session);
    }

    private boolean isCurrent(URI id) {
        BrowserSession session = (BrowserSession)this.getCurrentSession();
        return session != null && id.equals(session.getId()) && UIAccess.isOkToUse((Control)this.getPageBook());
    }
}

