/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.console;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.util.AbstractFragmentDocument;
import org.eclipse.statet.ecommons.text.ui.InformationDispatchHandler;
import org.eclipse.statet.ecommons.text.ui.TextHandlerUtil;
import org.eclipse.statet.ecommons.text.ui.TextViewerCustomCaretSupport;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.internal.nico.ui.console.InputDocument;
import org.eclipse.statet.internal.nico.ui.console.PromptHighlighter;
import org.eclipse.statet.internal.nico.ui.preferences.ConsolePreferences;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.text.core.CharPairMatcher;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.SourceViewerDecorationSupport;
import org.eclipse.statet.ltk.ui.sourceediting.StructureSelectHandler;
import org.eclipse.statet.ltk.ui.sourceediting.StructureSelectionHistory;
import org.eclipse.statet.ltk.ui.sourceediting.StructureSelectionHistoryBackHandler;
import org.eclipse.statet.ltk.ui.sourceediting.TextEditToolSynchronizer;
import org.eclipse.statet.ltk.ui.sourceediting.actions.CutLineHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.CutToLineBeginHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.CutToLineEndHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.DeleteLineHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.DeleteNextWordHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.DeletePreviousWordHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.DeleteToLineBeginHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.DeleteToLineEndHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.GotoLineBeginHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.GotoLineEndHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.GotoMatchingBracketHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.GotoNextWordHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.GotoPreviousWordHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.SelectLineBeginHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.SelectLineEndHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.SelectNextWordHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.SelectPreviousWordHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.SourceEditorOperationHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.SpecificContentAssistHandler;
import org.eclipse.statet.ltk.ui.sourceediting.util.SourceViewerEditorPreferenceUpdater;
import org.eclipse.statet.nico.core.runtime.History;
import org.eclipse.statet.nico.core.runtime.IHistoryListener;
import org.eclipse.statet.nico.core.runtime.Prompt;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;
import org.eclipse.statet.nico.ui.console.InputSourceViewer;
import org.eclipse.statet.nico.ui.console.NIConsolePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public class ConsolePageEditor
implements ISettingsChangedHandler,
SourceEditor {
    static final int KEY_HIST_UP = 0x1000001;
    static final int KEY_HIST_DOWN = 0x1000002;
    static final int KEY_HIST_SPREFIX_UP = 0x1010001;
    static final int KEY_HIST_SPREFIX_DOWN = 0x1010002;
    static final int KEY_SUBMIT_DEFAULT = 13;
    static final int KEY_SUBMIT_KEYPAD = 0x1000050;
    static final int KEY_OUTPUT_LINEUP = 0x1020001;
    static final int KEY_OUTPUT_LINEDOWN = 0x1020002;
    static final int KEY_OUTPUT_PAGEUP = 16908293;
    static final int KEY_OUTPUT_PAGEDOWN = 16908294;
    static final int KEY_OUTPUT_START = SWT.MOD1 | 0x20000 | 0x1000007;
    static final int KEY_OUTPUT_END = SWT.MOD1 | 0x20000 | 0x1000008;
    private NIConsolePage consolePage;
    private ToolProcess process;
    private final IContentType contentType;
    private final SourceUnit sourceUnit;
    private Composite composite;
    private Label prompt;
    private PromptHighlighter promptHighlighter;
    private InputSourceViewer sourceViewer;
    private final InputDocument document;
    private Button submitButton;
    private ScrollControl scroller;
    private final StatusLine statusLine = new StatusLine();
    private org.eclipse.ui.texteditor.SourceViewerDecorationSupport sourceViewerDecorationSupport;
    private SourceEditorViewerConfigurator configurator;
    private TextViewerCustomCaretSupport customCarretSupport;
    private History.Entry submitHistoryCurrentEntry;
    private IHistoryListener submitHistoryListener;
    private EnumSet<SubmitType> submitHistoryTypesFilter;
    private Point historyCompoundChange;
    private Point historyCaretWorkaround;
    private boolean inHistoryChange = false;
    private StructureSelectionHistory selectionHistory;
    private ToolWorkspace.Listener workspaceListener;

    public ConsolePageEditor(NIConsolePage page, IContentType contentType) {
        this.consolePage = page;
        this.process = page.getConsole().getProcess();
        this.contentType = contentType;
        this.document = new InputDocument();
        this.sourceUnit = this.createSourceUnit();
        this.updateSettings();
    }

    private void updateSettings() {
        this.submitHistoryTypesFilter = (EnumSet)EPreferences.getInstancePrefs().getPreferenceValue(ConsolePreferences.HISTORYNAVIGATION_SUBMIT_TYPES_PREF);
    }

    public AbstractFragmentDocument getDocument() {
        return this.document;
    }

    protected SourceUnit createSourceUnit() {
        return null;
    }

    public Composite createControl(Composite parent, SourceEditorViewerConfigurator editorConfig) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 3;
        this.composite.setLayout((Layout)layout);
        this.prompt = new Label(this.composite, 16384);
        GridData gd = new GridData(16384, 4, false, false);
        gd.verticalIndent = 1;
        this.prompt.setLayoutData((Object)gd);
        this.prompt.setText("> ");
        this.prompt.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (UIAccess.isOkToUse((Viewer)ConsolePageEditor.this.sourceViewer)) {
                    ConsolePageEditor.this.sourceViewer.doOperation(7);
                }
            }
        });
        this.createSourceViewer(editorConfig);
        gd = new GridData(4, 4, true, true);
        gd.verticalIndent = 1;
        this.sourceViewer.getControl().setLayoutData((Object)gd);
        this.sourceViewer.appendVerifyKeyListener(new ThisKeyListener());
        StyledText textWidget = this.sourceViewer.getTextWidget();
        textWidget.setKeyBinding(0x1000001, 0);
        textWidget.setKeyBinding(0x1000002, 0);
        textWidget.setKeyBinding(13, 0);
        textWidget.setKeyBinding(0x1000050, 0);
        textWidget.setKeyBinding(0x1020001, 0);
        textWidget.setKeyBinding(0x1020002, 0);
        textWidget.setKeyBinding(16908293, 0);
        textWidget.setKeyBinding(16908294, 0);
        textWidget.setKeyBinding(KEY_OUTPUT_START, 0);
        textWidget.setKeyBinding(KEY_OUTPUT_END, 0);
        this.submitButton = new Button(this.composite, 0);
        gd = new GridData(4, 4, false, true);
        gd.horizontalIndent = layout.verticalSpacing;
        gd.heightHint = new PixelConverter((Control)this.submitButton).convertHeightInCharsToPixels(1) + 4;
        gd.verticalSpan = 2;
        this.submitButton.setLayoutData((Object)gd);
        this.submitButton.setText(Messages.Console_SubmitButton_label);
        this.submitButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConsolePageEditor.this.doSubmit();
                ConsolePageEditor.this.sourceViewer.getControl().setFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.promptHighlighter = new PromptHighlighter((Control)this.prompt, EPreferences.getInstancePrefs(), this.configurator.getSourceViewerConfiguration().getPreferences());
        Slider slider = new Slider(this.composite, 256);
        slider.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.scroller = new ScrollControl(slider);
        this.setFont(this.consolePage.getConsole().getFont());
        this.submitHistoryListener = new IHistoryListener(){

            public void entryAdded(History source, History.Entry e) {
            }

            public void entryRemoved(History source, History.Entry e) {
            }

            public void completeChange(History source, History.Entry[] es) {
                ConsolePageEditor.this.submitHistoryCurrentEntry = null;
            }
        };
        this.process.getHistory().addListener(this.submitHistoryListener);
        this.document.addPrenotifiedDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
                if (ConsolePageEditor.this.historyCompoundChange != null && !ConsolePageEditor.this.inHistoryChange) {
                    ConsolePageEditor.this.historyCompoundChange = null;
                    ConsolePageEditor.this.sourceViewer.getUndoManager().endCompoundChange();
                }
            }

            public void documentChanged(DocumentEvent event) {
            }
        });
        this.workspaceListener = new ToolWorkspace.Listener(){

            public void propertyChanged(ToolWorkspace workspace, Map<String, Object> properties) {
                if (properties.containsKey("wd")) {
                    UIAccess.getDisplay(null).asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).ConsolePageEditor.this.statusLine.updateWD();
                        }
                    });
                }
            }
        };
        this.consolePage.getControl().addListener(26, new Listener(){

            public void handleEvent(Event event) {
                ConsolePageEditor.this.statusLine.refresh();
            }
        });
        this.consolePage.getTool().getWorkspace().addPropertyListener(this.workspaceListener);
        this.statusLine.updateWD();
        return this.composite;
    }

    protected void createSourceViewer(SourceEditorViewerConfigurator editorConfigurator) {
        this.configurator = editorConfigurator;
        this.sourceViewer = new InputSourceViewer(this.composite);
        this.configurator.setTarget((SourceEditor)this);
        SourceEditorViewerConfiguration configuration = this.configurator.getSourceViewerConfiguration();
        this.sourceViewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)this.sourceViewer, null, null, EditorsUI.getSharedTextColors());
        this.configurator.configureSourceViewerDecorationSupport(this.sourceViewerDecorationSupport);
        MarkerAnnotationPreferences markerAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        for (Object pref : markerAnnotationPreferences.getAnnotationPreferences()) {
            this.sourceViewerDecorationSupport.setAnnotationPreference((AnnotationPreference)pref);
        }
        this.sourceViewerDecorationSupport.install(configuration.getPreferences());
        IDocumentSetupParticipant docuSetup = this.configurator.getDocumentSetupParticipant();
        if (docuSetup != null) {
            docuSetup.setup((IDocument)this.document.getMasterDocument());
        }
        new SourceViewerEditorPreferenceUpdater((SourceViewer)this.sourceViewer, true, false, configuration.getPreferences());
        AnnotationModel annotationModel = new AnnotationModel();
        this.sourceViewer.setDocument((IDocument)this.document, (IAnnotationModel)annotationModel);
        this.sourceViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConsolePageEditor.this.statusLine.cleanStatusLine();
            }
        });
        this.sourceViewer.getTextWidget().addListener(16, new Listener(){

            public void handleEvent(Event event) {
                ConsolePageEditor.this.statusLine.cleanStatusLine();
            }
        });
        this.customCarretSupport = new TextViewerCustomCaretSupport((TextViewer)this.sourceViewer, configuration.getPreferences());
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        this.configurator.handleSettingsChanged(groupIds, options);
        if (groupIds.contains("nico.console")) {
            this.updateSettings();
        }
        if (groupIds.contains("nico.console/output/textstyle") && this.promptHighlighter != null) {
            this.promptHighlighter.updateSettings();
            this.promptHighlighter.updateControl();
        }
    }

    public void initActions(IServiceLocator serviceLocator, ContextHandlers handlers) {
        GotoMatchingBracketHandler handler;
        StyledText textWidget = this.sourceViewer.getTextWidget();
        WorkbenchUIUtils.activateContext((IServiceLocator)serviceLocator, (String)"org.eclipse.statet.nico.contexts.ConsoleEditor");
        IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        TextHandlerUtil.disable((StyledText)textWidget, (String)"org.eclipse.ui.edit.text.deleteNext");
        GotoLineBeginHandler handler2 = new GotoLineBeginHandler((SourceEditor)this);
        handlers.addActivate("org.eclipse.ui.edit.text.goto.lineStart", (IHandler2)handler2);
        handler2 = new GotoLineEndHandler((SourceEditor)this);
        handlers.addActivate("org.eclipse.ui.edit.text.goto.lineEnd", (IHandler2)handler2);
        handler2 = new SelectLineBeginHandler((SourceEditor)this);
        handlers.addActivate("org.eclipse.ui.edit.text.select.lineStart", (IHandler2)handler2);
        handler2 = new SelectLineEndHandler((SourceEditor)this);
        handlers.addActivate("org.eclipse.ui.edit.text.select.lineEnd", (IHandler2)handler2);
        handler2 = new CutLineHandler((SourceEditor)this);
        handlers.addActivate("org.eclipse.ui.edit.text.cut.line", (IHandler2)handler2);
        handler2 = new CutToLineBeginHandler((SourceEditor)this);
        handlers.addActivate("org.eclipse.ui.edit.text.cut.line.to.beginning", (IHandler2)handler2);
        handler2 = new CutToLineEndHandler((SourceEditor)this);
        handlers.addActivate("org.eclipse.ui.edit.text.cut.line.to.end", (IHandler2)handler2);
        handler2 = new DeleteLineHandler((SourceEditor)this);
        handlers.addActivate("org.eclipse.ui.edit.text.delete.line", (IHandler2)handler2);
        handler2 = new DeleteToLineBeginHandler((SourceEditor)this);
        handlers.addActivate("org.eclipse.ui.edit.text.delete.line.to.beginning", (IHandler2)handler2);
        handler2 = new DeleteToLineEndHandler((SourceEditor)this);
        handlers.addActivate("org.eclipse.ui.edit.text.delete.line.to.end", (IHandler2)handler2);
        handler2 = new GotoPreviousWordHandler((SourceEditor)this);
        TextHandlerUtil.disable((StyledText)textWidget, (String)"org.eclipse.ui.edit.text.goto.wordPrevious");
        handlerService.activateHandler("org.eclipse.ui.edit.text.goto.wordPrevious", (IHandler)handler2);
        handler2 = new GotoNextWordHandler((SourceEditor)this);
        TextHandlerUtil.disable((StyledText)textWidget, (String)"org.eclipse.ui.edit.text.goto.wordNext");
        handlerService.activateHandler("org.eclipse.ui.edit.text.goto.wordNext", (IHandler)handler2);
        handler2 = new SelectPreviousWordHandler((SourceEditor)this);
        TextHandlerUtil.disable((StyledText)textWidget, (String)"org.eclipse.ui.edit.text.select.wordPrevious");
        handlerService.activateHandler("org.eclipse.ui.edit.text.select.wordPrevious", (IHandler)handler2);
        handler2 = new SelectNextWordHandler((SourceEditor)this);
        TextHandlerUtil.disable((StyledText)textWidget, (String)"org.eclipse.ui.edit.text.select.wordNext");
        handlerService.activateHandler("org.eclipse.ui.edit.text.select.wordNext", (IHandler)handler2);
        handler2 = new DeletePreviousWordHandler((SourceEditor)this);
        TextHandlerUtil.disable((StyledText)textWidget, (String)"org.eclipse.ui.edit.text.deletePreviousWord");
        handlerService.activateHandler("org.eclipse.ui.edit.text.deletePreviousWord", (IHandler)handler2);
        handler2 = new DeleteNextWordHandler((SourceEditor)this);
        TextHandlerUtil.disable((StyledText)textWidget, (String)"org.eclipse.ui.edit.text.deleteNextWord");
        handlerService.activateHandler("org.eclipse.ui.edit.text.deleteNextWord", (IHandler)handler2);
        CharPairMatcher matcher = this.configurator.getSourceViewerConfiguration().getPairMatcher();
        if (matcher != null) {
            handler = new GotoMatchingBracketHandler(matcher, (SourceEditor)this);
            handlers.addActivate("org.eclipse.statet.ecommons.text.commands.GotoMatchingBracket", (IHandler2)handler);
        }
        handler = new SourceEditorOperationHandler((SourceEditor)this, 13);
        handlers.addActivate("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler2)handler);
        handler = new SpecificContentAssistHandler((SourceEditor)this, this.configurator.getSourceViewerConfiguration().getContentAssist());
        handlers.addActivate("org.eclipse.statet.ltk.commands.SpecificContentAssist", (IHandler2)handler);
        handler = new SourceEditorOperationHandler((SourceEditor)this, 14);
        handlers.addActivate("org.eclipse.ui.edit.text.contentAssist.contextInformation", (IHandler2)handler);
        handler = new InformationDispatchHandler((ISourceViewer)this.getViewer());
        handlers.addActivate("org.eclipse.ui.edit.text.showInformation", (IHandler2)handler);
        this.selectionHistory = new StructureSelectionHistory((SourceEditor)this);
        handlerService.activateHandler("org.eclipse.statet.workbench.commands.SelectExpandEnclosing", (IHandler)new StructureSelectHandler.Enclosing((SourceEditor)this, this.selectionHistory));
        handlerService.activateHandler("org.eclipse.statet.workbench.commands.SelectExpandPrevious", (IHandler)new StructureSelectHandler.Previous((SourceEditor)this, this.selectionHistory));
        handlerService.activateHandler("org.eclipse.statet.workbench.commands.SelectExpandNext", (IHandler)new StructureSelectHandler.Next((SourceEditor)this, this.selectionHistory));
        StructureSelectionHistoryBackHandler backHandler = new StructureSelectionHistoryBackHandler((SourceEditor)this, this.selectionHistory);
        handlerService.activateHandler("org.eclipse.statet.workbench.commands.SelectLast", (IHandler)backHandler);
        this.selectionHistory.addUpdateListener((IUpdate)backHandler);
        AbstractHandler handler3 = new AbstractHandler(){

            public Object execute(ExecutionEvent arg0) throws ExecutionException {
                ConsolePageEditor.this.doHistoryOlder(ConsolePageEditor.this.getLineStart());
                return null;
            }
        };
        textWidget.setKeyBinding(0x1010001, 0);
        handlerService.activateHandler("org.eclipse.statet.nico.commands.SearchHistoryOlder", (IHandler)handler3);
        handler3 = new AbstractHandler(){

            public Object execute(ExecutionEvent arg0) throws ExecutionException {
                ConsolePageEditor.this.doHistoryNewer(ConsolePageEditor.this.getLineStart());
                return null;
            }
        };
        textWidget.setKeyBinding(0x1010002, 0);
        handlerService.activateHandler("org.eclipse.statet.nico.commands.SearchHistoryNewer", (IHandler)handler3);
        handler3 = new AbstractHandler(){

            public Object execute(ExecutionEvent arg0) throws ExecutionException {
                ConsolePageEditor.this.doHistoryNewest();
                return null;
            }
        };
        handlerService.activateHandler("org.eclipse.statet.nico.commands.GotoHistoryNewest", (IHandler)handler3);
        this.customCarretSupport.initActions(handlerService);
    }

    void setFont(Font font) {
        this.prompt.setFont(font);
        this.sourceViewer.getControl().setFont(font);
    }

    void updateBusy(boolean isBusy) {
        PromptHighlighter prefixRenderer = this.promptHighlighter;
        if (prefixRenderer != null) {
            prefixRenderer.setHighlight(!isBusy);
        }
    }

    void updatePrompt(Prompt prompt) {
        Prompt p;
        Prompt prompt2 = p = prompt != null ? prompt : this.process.getWorkspace().getPrompt();
        if (UIAccess.isOkToUse((Control)this.prompt)) {
            int start = 0;
            int i = 0;
            while (i < p.text.length()) {
                char c = p.text.charAt(i);
                if (c >= ' ' || c == '\t') break;
                start = i + 1;
                ++i;
            }
            String newText = start == 0 ? p.text : p.text.substring(start, p.text.length());
            String oldText = this.prompt.getText();
            if (!oldText.equals(newText)) {
                this.prompt.setText(newText);
                if (oldText.length() != newText.length()) {
                    this.getComposite().layout(new Control[]{this.prompt});
                }
            }
            this.onPromptUpdate(p);
        }
    }

    protected void onPromptUpdate(Prompt prompt) {
    }

    protected void setInputPrefix(String source) {
        this.document.setPrefix(source);
    }

    private String getLineStart() {
        try {
            return this.document.get(0, this.sourceViewer.getSelectedRange().x);
        }
        catch (BadLocationException e) {
            NicoUIPlugin.logError(-1, "Error while extracting prefix for history search", e);
            return "";
        }
    }

    public void doHistoryNewer(String prefix) {
        SubmitType type;
        if (this.submitHistoryCurrentEntry == null) {
            return;
        }
        History.Entry next = this.submitHistoryCurrentEntry.getNewer();
        EnumSet<SubmitType> filter = this.submitHistoryTypesFilter;
        while (next != null && ((type = next.getSubmitType()) != null && !filter.contains(type) || next.getCommandMarker() < 0 || prefix != null && !next.getCommand().startsWith(prefix))) {
            next = next.getNewer();
        }
        if (next == null && prefix != null) {
            Display.getCurrent().beep();
            return;
        }
        this.submitHistoryCurrentEntry = next;
        this.setHistoryContent(this.submitHistoryCurrentEntry != null ? this.submitHistoryCurrentEntry.getCommand() : "");
    }

    public void doHistoryOlder(String prefix) {
        SubmitType type;
        History.Entry next = this.submitHistoryCurrentEntry != null ? this.submitHistoryCurrentEntry.getOlder() : this.process.getHistory().getNewest();
        EnumSet<SubmitType> filter = this.submitHistoryTypesFilter;
        while (next != null && ((type = next.getSubmitType()) != null && !filter.contains(type) || next.getCommandMarker() < 0 || prefix != null && !next.getCommand().startsWith(prefix))) {
            next = next.getOlder();
        }
        if (next == null) {
            Display.getCurrent().beep();
            return;
        }
        this.submitHistoryCurrentEntry = next;
        this.setHistoryContent(this.submitHistoryCurrentEntry.getCommand());
    }

    public void doHistoryNewest() {
        History.Entry next = this.process.getHistory().getNewest();
        if (next == null) {
            Display.getCurrent().beep();
            return;
        }
        this.submitHistoryCurrentEntry = next;
        this.setHistoryContent(this.submitHistoryCurrentEntry.getCommand());
    }

    protected void setHistoryContent(String text) {
        if (this.historyCompoundChange == null) {
            this.historyCompoundChange = this.sourceViewer.getSelectedRange();
            this.sourceViewer.getUndoManager().beginCompoundChange();
        } else {
            Point current = this.sourceViewer.getSelectedRange();
            if (!current.equals((Object)this.historyCaretWorkaround)) {
                this.historyCompoundChange = current;
            }
        }
        this.inHistoryChange = true;
        try {
            StyledText widget = this.sourceViewer.getTextWidget();
            if (UIAccess.isOkToUse((Control)widget)) {
                widget.setRedraw(false);
                this.document.set(text);
                this.sourceViewer.setSelectedRange(this.historyCompoundChange.x, this.historyCompoundChange.y);
                widget.setRedraw(true);
            } else {
                this.document.set(text);
            }
            this.historyCaretWorkaround = this.sourceViewer.getSelectedRange();
        }
        finally {
            this.inHistoryChange = false;
        }
    }

    public void doSubmit() {
        String content = this.document.get();
        ToolController controller = this.process.getController();
        if (controller != null) {
            Status status = controller.submit(content, SubmitType.CONSOLE);
            if (status.getSeverity() >= 4) {
                this.statusLine.setMessage(true, status.getMessage(), null);
                Display.getCurrent().beep();
                return;
            }
            this.clear();
        }
    }

    public void clear() {
        this.sourceViewer.clear();
        this.submitHistoryCurrentEntry = null;
        this.historyCompoundChange = null;
        this.sourceViewer.resetPlugins();
        this.scroller.reset();
        this.selectionHistory.flush();
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Button getSubmitButton() {
        return this.submitButton;
    }

    protected NIConsolePage getConsolePage() {
        return this.consolePage;
    }

    public void dispose() {
        this.process.getHistory().removeListener(this.submitHistoryListener);
        this.submitHistoryListener = null;
        this.submitHistoryCurrentEntry = null;
        if (this.workspaceListener != null) {
            this.consolePage.getTool().getWorkspace().removePropertyListener(this.workspaceListener);
            this.workspaceListener = null;
        }
        if (this.sourceViewerDecorationSupport != null) {
            this.sourceViewerDecorationSupport.dispose();
            this.sourceViewerDecorationSupport = null;
        }
        this.process = null;
        this.consolePage = null;
        if (this.promptHighlighter != null) {
            this.promptHighlighter.dispose();
            this.promptHighlighter = null;
        }
    }

    public IContentType getContentType() {
        return this.contentType;
    }

    public String getModelTypeId() {
        return this.sourceUnit.getModelTypeId();
    }

    public SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public IWorkbenchPart getWorkbenchPart() {
        return this.consolePage.getView();
    }

    public IServiceLocator getServiceLocator() {
        return this.consolePage.inputServices.getLocator();
    }

    public InputSourceViewer getViewer() {
        return this.sourceViewer;
    }

    public DocContentSections getDocumentContentInfo() {
        return this.configurator.getDocumentContentInfo();
    }

    public boolean isEditable(boolean validate) {
        return true;
    }

    public void selectAndReveal(int offset, int length) {
        if (UIAccess.isOkToUse((Viewer)this.sourceViewer)) {
            this.sourceViewer.setSelectedRange(offset, length);
            this.sourceViewer.revealRange(offset, length);
        }
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == SourceEditor.class) {
            return (T)this;
        }
        if (adapterType == IEditorStatusLine.class) {
            return (T)this.statusLine;
        }
        if (adapterType == ITextOperationTarget.class) {
            return (T)((Object)this.sourceViewer);
        }
        if (adapterType == IContentType.class) {
            return (T)this.contentType;
        }
        return this.consolePage.getAdapter(adapterType);
    }

    public TextEditToolSynchronizer getTextEditToolSynchronizer() {
        return null;
    }

    private final class ScrollControl
    implements Listener {
        private static final int MAX = 150;
        private static final int SPECIAL = 80;
        private final Slider fSlider;
        private int fLastPos = 0;

        private ScrollControl(Slider slider) {
            this.fSlider = slider;
            this.fSlider.setMaximum(150);
            this.fSlider.addListener(13, (Listener)this);
        }

        public void handleEvent(Event event) {
            int newIndex;
            int selection = this.fSlider.getSelection();
            StyledText output = ConsolePageEditor.this.consolePage.getOutputViewer().getTextWidget();
            StyledText input = ConsolePageEditor.this.sourceViewer.getTextWidget();
            int current = Math.max(output.getHorizontalIndex(), input.getHorizontalIndex());
            if (event.detail == 1) {
                if (this.fLastPos < 0) {
                    this.fLastPos = current;
                }
                if (current > 80 || this.fLastPos > 80) {
                    current = this.fLastPos;
                    double diff = selection - 80;
                    newIndex = current + (int)(Math.signum(diff) * Math.max(Math.exp(Math.abs(diff) / 7.5) - 1.0, 0.0) * 2.0);
                    if (newIndex < selection) {
                        newIndex = selection;
                    }
                } else {
                    newIndex = selection;
                }
            } else {
                newIndex = current > 80 ? current + selection - 80 : selection;
            }
            output.setHorizontalIndex(newIndex);
            input.setHorizontalIndex(newIndex);
            current = Math.max(output.getHorizontalIndex(), input.getHorizontalIndex());
            if (event.detail != 1) {
                this.fSlider.setSelection(current > 80 ? 80 : current);
                this.fLastPos = -1;
            }
        }

        public void reset() {
            this.fSlider.setSelection(0);
            StyledText output = ConsolePageEditor.this.consolePage.getOutputViewer().getTextWidget();
            output.setHorizontalIndex(0);
            this.fLastPos = -1;
        }
    }

    private class StatusLine
    implements IEditorStatusLine {
        private boolean messageSetted;
        private String message;

        private StatusLine() {
        }

        public void setMessage(boolean error, String message, Image image) {
            IStatusLineManager manager = ConsolePageEditor.this.consolePage.getSite().getActionBars().getStatusLineManager();
            if (manager != null) {
                this.messageSetted = true;
                if (error) {
                    manager.setErrorMessage(image, message);
                } else {
                    manager.setMessage(image, message);
                }
            }
        }

        void cleanStatusLine() {
            IStatusLineManager manager;
            if (this.messageSetted && (manager = ConsolePageEditor.this.consolePage.getSite().getActionBars().getStatusLineManager()) != null) {
                this.messageSetted = false;
                manager.setErrorMessage(null);
                this.updateWD();
            }
        }

        void updateWD() {
            IStatusLineManager manager;
            if (!this.messageSetted && (manager = ConsolePageEditor.this.consolePage.getSite().getActionBars().getStatusLineManager()) != null) {
                String path;
                this.message = path = FileUtil.toString((IFileStore)ConsolePageEditor.this.consolePage.getTool().getWorkspace().getWorkspaceDir());
                manager.setMessage(path);
            }
        }

        void refresh() {
            IStatusLineManager manager = ConsolePageEditor.this.consolePage.getSite().getActionBars().getStatusLineManager();
            if (manager != null) {
                manager.setMessage(this.message);
            }
        }
    }

    private class ThisKeyListener
    implements VerifyKeyListener {
        private ThisKeyListener() {
        }

        public void verifyKey(VerifyEvent e) {
            int key = e.stateMask | e.keyCode;
            switch (key) {
                case 0x1000001: {
                    ConsolePageEditor.this.doHistoryOlder(null);
                    break;
                }
                case 0x1000002: {
                    ConsolePageEditor.this.doHistoryNewer(null);
                    break;
                }
                case 13: 
                case 0x1000050: {
                    ConsolePageEditor.this.doSubmit();
                    return;
                }
                case 0x1020001: {
                    this.doOutputLineUp();
                    break;
                }
                case 0x1020002: {
                    this.doOutputLineDown();
                    break;
                }
                case 16908293: {
                    this.doOutputPageUp();
                    break;
                }
                case 16908294: {
                    this.doOutputPageDown();
                    break;
                }
                default: {
                    if (key == KEY_OUTPUT_START) {
                        this.doOutputFirstLine();
                        break;
                    }
                    if (key == KEY_OUTPUT_END) {
                        this.doOutputLastLine();
                        break;
                    }
                    return;
                }
            }
            e.doit = false;
        }

        private void doOutputLineUp() {
            StyledText output = (StyledText)ConsolePageEditor.this.consolePage.getOutputViewer().getControl();
            int next = output.getTopIndex() - 1;
            if (next < 0) {
                return;
            }
            output.setTopIndex(next);
        }

        private void doOutputLineDown() {
            StyledText output = (StyledText)ConsolePageEditor.this.consolePage.getOutputViewer().getControl();
            int next = output.getTopIndex() + 1;
            if (next >= output.getLineCount()) {
                return;
            }
            output.setTopIndex(next);
        }

        private void doOutputPageUp() {
            int move;
            StyledText output = (StyledText)ConsolePageEditor.this.consolePage.getOutputViewer().getControl();
            int current = output.getTopIndex();
            int next = Math.max(0, current - (move = Math.max(1, output.getClientArea().height / output.getLineHeight() - 1)));
            if (next == current) {
                return;
            }
            output.setTopIndex(next);
        }

        private void doOutputPageDown() {
            int move;
            StyledText output = (StyledText)ConsolePageEditor.this.consolePage.getOutputViewer().getControl();
            int current = output.getTopIndex();
            int next = Math.min(current + (move = Math.max(1, output.getClientArea().height / output.getLineHeight() - 1)), output.getLineCount() - 1);
            if (next == current) {
                return;
            }
            output.setTopIndex(next);
        }

        private void doOutputFirstLine() {
            StyledText output = (StyledText)ConsolePageEditor.this.consolePage.getOutputViewer().getControl();
            boolean next = false;
            output.setTopIndex(0);
        }

        private void doOutputLastLine() {
            StyledText output = (StyledText)ConsolePageEditor.this.consolePage.getOutputViewer().getControl();
            int next = output.getLineCount() - 1;
            if (next < 0) {
                return;
            }
            output.setTopIndex(next);
        }
    }
}

