/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.nico.ui.DecoratorsRegistry;
import org.eclipse.statet.internal.nico.ui.ToolRegistry;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

@NonNullByDefault
public final class NicoUIPlugin
extends AbstractUIPlugin {
    public static final int INTERNAL_ERROR = 100;
    private static NicoUIPlugin instance;
    private ToolRegistry toolRegistry;
    private @Nullable DecoratorsRegistry uiDecoratorsRegistry;

    public static NicoUIPlugin getInstance() {
        return instance;
    }

    public static void logError(int code, String message, Throwable e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.nico.core", code, message, e));
    }

    public NicoUIPlugin() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.toolRegistry = new ToolRegistry();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.toolRegistry != null) {
                this.toolRegistry.dispose();
                this.toolRegistry = null;
            }
            if (this.uiDecoratorsRegistry != null) {
                this.uiDecoratorsRegistry = null;
            }
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register("org.eclipse.statet.nico/images/obj/task.consolecommand", "obj_16", "task-consolecommand.png");
        util.register("org.eclipse.statet.nico/images/obj/task.commanddummy", "obj_16", "task-dummy.png");
        util.register("org.eclipse.statet.nico/images/obj/consolecommand", "obj_16", "consolecommand.png");
    }

    public ToolRegistry getToolRegistry() {
        return this.toolRegistry;
    }

    public synchronized DecoratorsRegistry getUIDecoratorsRegistry() {
        DecoratorsRegistry registry = this.uiDecoratorsRegistry;
        if (registry == null) {
            this.uiDecoratorsRegistry = registry = new DecoratorsRegistry();
        }
        return registry;
    }
}

