/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.presentation;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.text.ui.presentation.AbstractRuleBasedScanner;
import org.eclipse.statet.ecommons.text.ui.presentation.TextStyleManager;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.issues.core.TaskIssueConfig;
import org.eclipse.statet.ltk.issues.core.TaskTag;

@NonNullByDefault
public class CommentScanner
extends AbstractRuleBasedScanner
implements ISettingsChangedHandler {
    private final PreferenceAccess prefs;
    private TaskTagRule taskTagRule = (TaskTagRule)((Object)ObjectUtils.nonNullLateInit());
    private final String commentTokenKey;
    private final String taskTokenKey;
    private static final String GROUP_ID = "statet.task_tags";

    public CommentScanner(TextStyleManager<?> textStyles, String commentTokenKey, String taskTokenKey, PreferenceAccess prefs) {
        super(textStyles);
        this.commentTokenKey = commentTokenKey;
        this.taskTokenKey = taskTokenKey;
        this.initRules();
        this.prefs = prefs;
        this.loadTaskTags();
    }

    @Override
    protected void createRules(List<IRule> rules) {
        TextStyleManager.TextStyleToken<?> defaultToken = this.getToken(this.commentTokenKey);
        TextStyleManager.TextStyleToken<?> taskToken = this.getToken(this.taskTokenKey);
        this.setDefaultReturnToken(defaultToken);
        this.taskTagRule = new TaskTagRule(taskToken, defaultToken);
        rules.add((IRule)this.taskTagRule);
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        if (groupIds.contains(GROUP_ID)) {
            this.loadTaskTags();
            options.put("affects.Presentation", Boolean.TRUE);
        }
    }

    private void loadTaskTags() {
        TaskIssueConfig taskConfig = TaskIssueConfig.getConfig((PreferenceAccess)this.prefs);
        this.taskTagRule.setKeywords((ImList<String>)taskConfig.getTaskTags().map(TaskTag::getKeyword).toList());
    }

    private static class TaskTagDetector
    implements IWordDetector {
        private TaskTagDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isLetterOrDigit(c);
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c);
        }
    }

    private static class TaskTagRule
    extends WordRule {
        private final IToken token;

        public TaskTagRule(IToken token, IToken defaultToken) {
            super((IWordDetector)new TaskTagDetector(), defaultToken);
            this.token = token;
        }

        public void setKeywords(ImList<String> tags) {
            this.fWords.clear();
            for (String tag : tags) {
                this.addWord(tag, this.token);
            }
        }
    }
}

