/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui.presentation;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.statet.ecommons.text.ui.presentation.TextStyleManager;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class FixTokenScanner
implements ITokenScanner {
    private final TextStyleManager<?> textStyles;
    private final IToken defaultToken;
    private ImList<ITypedRegion> styleRegions;
    private int documentStartOffset;
    private int documentEndOffset;
    private int regionIdx;
    private int tokenOffset;
    private int tokenLength;

    public FixTokenScanner(TextStyleManager<?> textStyles, String defaultTokenKey) {
        this.textStyles = textStyles;
        this.defaultToken = textStyles.getToken(defaultTokenKey);
        this.styleRegions = ImCollections.emptyList();
    }

    public void setStyleRegions(ImList<ITypedRegion> regions) {
        this.styleRegions = regions;
        this.regionIdx = 0;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.documentStartOffset = offset;
        this.documentEndOffset = length;
        this.regionIdx = 0;
        this.tokenOffset = offset;
        this.tokenLength = 0;
    }

    public IToken nextToken() {
        this.tokenOffset += this.tokenLength;
        if (this.tokenOffset == this.documentEndOffset) {
            return Token.EOF;
        }
        ITypedRegion region = this.nextRegion();
        if (region != null) {
            if (this.tokenOffset >= region.getOffset()) {
                this.setTokenEndOffset(region.getOffset() + region.getLength());
                return this.textStyles.getToken(region.getType());
            }
            this.setTokenEndOffset(region.getOffset());
            return this.defaultToken;
        }
        this.setTokenEndOffset(Integer.MAX_VALUE);
        return this.defaultToken;
    }

    private @Nullable ITypedRegion nextRegion() {
        int idx = this.regionIdx;
        while (idx < this.styleRegions.size()) {
            ITypedRegion region = (ITypedRegion)this.styleRegions.get(idx);
            if (this.tokenOffset < region.getOffset() + region.getLength()) {
                this.regionIdx = idx;
                return region;
            }
            ++idx;
        }
        return null;
    }

    private void setTokenEndOffset(int offset) {
        this.tokenLength = Math.min(offset, this.documentEndOffset) - this.tokenOffset;
    }

    public int getTokenOffset() {
        return this.tokenOffset;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }
}

