/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.image;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.image.ImageManager;
import org.eclipse.sirius.business.api.image.ImageManagerProvider;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;

public class Base64ImageHelper {
    public static final String BASE64_IMAGE_PATTERN_WITH_SUBSTRINGS = "\"data:image/([a-zA-Z]{3,4});base64,(.*?)\"";
    private static final String BASE64_IMAGE_PATTERN = "data:image/[a-zA-Z]{3,4};base64,";

    public Map<String, String> createFileAndUpdateAttribute(EObject eObject, EAttribute attr) {
        String strValue = (String)eObject.eGet((EStructuralFeature)attr);
        if (strValue != null) {
            Map<String, String> pathToImages = this.createFiles(eObject, strValue);
            this.updateField(eObject, attr, strValue, pathToImages);
            return pathToImages;
        }
        return new HashMap<String, String>();
    }

    private void updateField(EObject eObject, EAttribute attr, String strValue, Map<String, String> pathToImages) {
        String newStringValue = strValue;
        for (Map.Entry<String, String> entry : pathToImages.entrySet()) {
            newStringValue = newStringValue.replaceAll(BASE64_IMAGE_PATTERN + Pattern.quote(entry.getKey()), entry.getValue());
        }
        if (!Objects.equals(newStringValue, strValue)) {
            eObject.eSet((EStructuralFeature)attr, (Object)newStringValue);
        }
    }

    private Map<String, String> createFiles(EObject notifier, String strValue) {
        Pattern pattern = Pattern.compile(BASE64_IMAGE_PATTERN_WITH_SUBSTRINGS);
        Matcher matcher = pattern.matcher(strValue);
        LinkedHashMap<String, String> pathToImages = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            if (matcher.groupCount() != 2) continue;
            ImageManager imageManager = ImageManagerProvider.getImageManager();
            String simpleImageName = ImageManager.generateName(matcher.group(1));
            try {
                ImageManager.CreateImageFileProvider createFileFunc = imageManager.getCreateFileFunc(notifier, simpleImageName, matcher.group(2));
                createFileFunc.exec();
                pathToImages.put(matcher.group(2), createFileFunc.getFileName());
            }
            catch (IOException | CoreException e) {
                SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ImageManager_imageCreationFailure, simpleImageName), e);
            }
        }
        return pathToImages;
    }
}

