/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk.migration;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class EmptyJunctionPointsStringValueStyleMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("15.4.3.202406261640");

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    private void updateEdge(View edge) {
        StringValueStyle stringValueStyle = (StringValueStyle)edge.getStyle(NotationPackage.Literals.STRING_VALUE_STYLE);
        if (stringValueStyle != null && "junctionPoints".equals(stringValueStyle.getName()) && "()".equals(stringValueStyle.getStringValue())) {
            edge.getStyles().remove((Object)stringValueStyle);
        }
    }

    private void migrateDiagram(Diagram diagram) {
        EList edges = diagram.getEdges();
        edges.stream().forEach(edge -> this.updateEdge((View)edge));
    }

    private Optional<Diagram> getGMFDiagram(DDiagram dDiagram) {
        DDiagramGraphicalQuery query = new DDiagramGraphicalQuery(dDiagram);
        return Optional.ofNullable((Diagram)query.getAssociatedGMFDiagram().get());
    }

    private Stream<DRepresentationDescriptor> getRepresentationsDescriptors(DView dView) {
        return new DViewQuery(dView).getLoadedRepresentationsDescriptors().stream();
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            dAnalysis.getOwnedViews().stream().flatMap(this::getRepresentationsDescriptors).map(descriptor -> descriptor.getRepresentation()).filter(representation -> representation instanceof DDiagram).map(representation -> (DDiagram)representation).map(this::getGMFDiagram).flatMap(Optional::stream).forEach(this::migrateDiagram);
        }
    }
}

