/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.utils.menu;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.swt.finder.finders.ContextMenuFinder;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.ListResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.hamcrest.Matcher;

public class FirstContextMenuFinder
extends ContextMenuFinder {
    public FirstContextMenuFinder(Control control) {
        super(control);
    }

    public List<MenuItem> findMenus(Shell[] shells, Matcher<MenuItem> matcher, boolean recursive) {
        LinkedHashSet result = new LinkedHashSet();
        Shell[] shellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            result.addAll(this.findMenus(shell, matcher, recursive));
            if (!result.isEmpty()) break;
            ++n2;
        }
        return new ArrayList<MenuItem>(result);
    }

    public List<MenuItem> findMenus(final Menu bar, final Matcher<MenuItem> matcher, final boolean recursive) {
        return (List)UIThreadRunnable.syncExec((Display)this.display, (Result)new ListResult<MenuItem>(){

            public List<MenuItem> run() {
                return FirstContextMenuFinder.this.findMenuInternal(bar, (Matcher<MenuItem>)matcher, recursive);
            }
        });
    }

    private List<MenuItem> findMenuInternal(Menu bar, Matcher<MenuItem> matcher, boolean recursive) {
        LinkedHashSet<MenuItem> result = new LinkedHashSet<MenuItem>();
        if (bar != null) {
            MenuItem[] items;
            bar.notifyListeners(22, new Event());
            MenuItem[] menuItemArray = items = bar.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                if (!this.isSeparator(menuItem)) {
                    if (matcher.matches((Object)menuItem)) {
                        result.add(menuItem);
                        break;
                    }
                    if (recursive) {
                        result.addAll(this.findMenuInternal(menuItem.getMenu(), matcher, recursive));
                        if (!result.isEmpty()) break;
                    }
                }
                ++n2;
            }
            bar.notifyListeners(23, new Event());
        }
        return new ArrayList<MenuItem>(result);
    }

    private boolean isSeparator(MenuItem menuItem) {
        return (menuItem.getStyle() & 2) != 0;
    }
}

