/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.elk.core.service.DiagramLayoutEngine;
import org.eclipse.elk.core.ui.ElkUiPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class LayoutHandler
extends AbstractHandler {
    public static final String PREF_ANIMATION = "org.eclipse.elk.animation";
    public static final String PREF_ZOOM = "org.eclipse.elk.zoomToFit";
    public static final String PREF_PROGRESS = "org.eclipse.elk.progressDialog";
    public static final String PARAM_LAYOUT_SCOPE = "org.eclipse.elk.core.ui.layoutScope";
    public static final String VAL_DIAGRAM = "diagram";
    public static final String VAL_SELECTION = "selection";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = null;
        String layoutScope = event.getParameter(PARAM_LAYOUT_SCOPE);
        if (layoutScope != null && layoutScope.equals(VAL_SELECTION)) {
            selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        }
        IPreferenceStore preferenceStore = ElkUiPlugin.getInstance().getPreferenceStore();
        boolean animation = preferenceStore.getBoolean(PREF_ANIMATION);
        boolean zoomToFit = preferenceStore.getBoolean(PREF_ZOOM);
        boolean progressDialog = preferenceStore.getBoolean(PREF_PROGRESS);
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        Object diagramPart = null;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            diagramPart = structuredSelection.size() == 1 ? structuredSelection.getFirstElement() : structuredSelection.toList();
        }
        DiagramLayoutEngine.invokeLayout((IWorkbenchPart)editorPart, diagramPart, (boolean)animation, (boolean)progressDialog, (boolean)false, (boolean)zoomToFit);
        return null;
    }
}

