/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.BendpointLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.ConnectionBendpointEditPolicy;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.LineMode;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionEditPartQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionQuery;
import org.eclipse.sirius.diagram.ui.business.internal.command.TreeLayoutSetConnectionBendpointsCommand;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.MoveEdgeGroupManager;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SetConnectionBendpointsAndLabelCommmand;
import org.eclipse.sirius.diagram.ui.internal.edit.handles.SiriusBendpointMoveHandle;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.InitialPointsOfRequestDataManager;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.SiriusConnectionBendpointEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;

public class TreeLayoutConnectionLineSegEditPolicy
extends SiriusConnectionBendpointEditPolicy {
    private InitialPointsOfRequestDataManager initialPointsManager = new InitialPointsOfRequestDataManager();

    public TreeLayoutConnectionLineSegEditPolicy() {
        super(LineMode.ORTHOGONAL_FREE);
    }

    @Override
    protected Command getBendpointsChangedCommand(BendpointRequest request) {
        ICommand iCommand;
        PointList originalPoints = InitialPointsOfRequestDataManager.getOriginalPoints((LocationRequest)request);
        Command result = super.getBendpointsChangedCommand(request);
        if (result instanceof CompoundCommand) {
            Object[] objectArray = ((CompoundCommand)result).getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand iCommand2;
                Object subCmd = objectArray[n2];
                if (subCmd instanceof ICommandProxy && (iCommand2 = ((ICommandProxy)subCmd).getICommand()) instanceof SetConnectionBendpointsAndLabelCommmand) {
                    ((SetConnectionBendpointsAndLabelCommmand)iCommand2).setLabelsToUpdate((ConnectionEditPart)this.getHost(), originalPoints);
                }
                ++n2;
            }
        } else if (result instanceof ICommandProxy && (iCommand = ((ICommandProxy)result).getICommand()) instanceof SetConnectionBendpointsAndLabelCommmand) {
            ((SetConnectionBendpointsAndLabelCommmand)iCommand).setLabelsToUpdate((ConnectionEditPart)this.getHost(), originalPoints);
        }
        return result;
    }

    @Override
    protected Command getBendpointsChangedCommand(Connection connection, Edge edge) {
        boolean isTreeLayout = false;
        if (new ConnectionQuery(connection).isOrthogonalTreeBranch(connection.getPoints()) && this.getHost() instanceof ConnectionEditPart && new ConnectionEditPartQuery((org.eclipse.gef.ConnectionEditPart)((ConnectionEditPart)this.getHost())).isLayoutComponent()) {
            isTreeLayout = true;
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (!isTreeLayout) {
            CompoundCommand compoundCommand = new CompoundCommand();
            Point ptRef1 = connection.getSourceAnchor().getReferencePoint();
            this.getConnection().translateToRelative((Translatable)ptRef1);
            Point ptRef2 = connection.getTargetAnchor().getReferencePoint();
            this.getConnection().translateToRelative((Translatable)ptRef2);
            SetConnectionBendpointsAndLabelCommmand sbbCommand = new SetConnectionBendpointsAndLabelCommmand(editingDomain);
            sbbCommand.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)edge));
            sbbCommand.setNewPointList(connection.getPoints(), ptRef1, ptRef2);
            compoundCommand.add((Command)new ICommandProxy((ICommand)sbbCommand));
            ICommand command = CommandFactory.createICommand(editingDomain, new CenterEdgeEndModelChangeOperation((ConnectionEditPart)this.getHost(), edge));
            compoundCommand.add((Command)new ICommandProxy(command));
            return compoundCommand;
        }
        Point ptRef1 = connection.getSourceAnchor().getReferencePoint();
        this.getConnection().translateToRelative((Translatable)ptRef1);
        Point ptRef2 = connection.getTargetAnchor().getReferencePoint();
        this.getConnection().translateToRelative((Translatable)ptRef2);
        TreeLayoutSetConnectionBendpointsCommand sbbCommand = new TreeLayoutSetConnectionBendpointsCommand(editingDomain);
        sbbCommand.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)edge));
        sbbCommand.setNewPointList(connection.getPoints(), ptRef1, ptRef2);
        return new ICommandProxy((ICommand)sbbCommand);
    }

    @Override
    protected List createManualHandles() {
        ArrayList<SiriusBendpointMoveHandle> list = new ArrayList<SiriusBendpointMoveHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        int i = 1;
        while (i < points.size() - 1) {
            this.addInvisibleCreationHandle(list, (org.eclipse.gef.ConnectionEditPart)connEP, i - 1);
            list.add(new SiriusBendpointMoveHandle((org.eclipse.gef.ConnectionEditPart)connEP, i, (Locator)new BendpointLocator(this.getConnection(), i)));
            ++i;
        }
        this.addInvisibleCreationHandle(list, (org.eclipse.gef.ConnectionEditPart)connEP, points.size() - 2);
        return list;
    }

    protected void showMoveLineSegFeedback(BendpointRequest request) {
        this.initialPointsManager.storeInitialPointsInRequest((LocationRequest)request, (org.eclipse.gef.ConnectionEditPart)((ConnectionEditPart)this.getHost()));
        super.showMoveLineSegFeedback(request);
    }

    @Override
    public void showSourceFeedback(Request request) {
        MoveEdgeGroupManager nodesGroupMoveManager = new MoveEdgeGroupManager(request);
        if (nodesGroupMoveManager.isToolActivated()) {
            nodesGroupMoveManager.showGroupFeedback();
        } else {
            nodesGroupMoveManager.eraseGroupFeedback();
            if (this.getLineSegMode() != LineMode.OBLIQUE) {
                if ("create bendpoint".equals(request.getType())) {
                    this.showMoveLineSegFeedback((BendpointRequest)request);
                } else if ("move bendpoint".equals(request.getType())) {
                    this.showMoveOrthogonalBendpointFeedback2((BendpointRequest)request);
                }
            } else if ("move bendpoint".equals(request.getType())) {
                this.showMoveBendpointFeedback((BendpointRequest)request);
            } else if ("create bendpoint".equals(request.getType())) {
                this.showCreateBendpointFeedback((BendpointRequest)request);
            }
        }
    }

    protected void showMoveOrthogonalBendpointFeedback2(BendpointRequest request) {
        if (!ReflectionHelper.invokeMethodWithoutException((Object)((Object)this), ConnectionBendpointEditPolicy.class, (String)"showMoveOrthogonalBenspointFeedback", (Class[])new Class[]{BendpointRequest.class}, (Object[])new Object[]{request}, (boolean)true)) {
            DiagramUIPlugin.INSTANCE.log(new Status(2, "org.eclipse.sirius.diagram.ui", "Impossible to call showMoveOrthogonalBenspointFeedback by reflection to handle edge label correctly during edge move (bug 465328)."));
        } else {
            this.initialPointsManager.storeInitialPointsInRequest((LocationRequest)request, (org.eclipse.gef.ConnectionEditPart)((ConnectionEditPart)this.getHost()));
        }
    }

    @Override
    protected void eraseConnectionFeedback(BendpointRequest request, boolean removeFeedbackFigure) {
        super.eraseConnectionFeedback(request, removeFeedbackFigure);
        if (removeFeedbackFigure) {
            this.initialPointsManager.eraseInitialPoints(this.getConnection());
        }
    }
}

