/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.straighten;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.requests.StraightenToRequest;
import org.eclipse.ui.IWorkbenchPage;

public class StraightenToAction
extends DiagramAction {
    public static final int TO_TOP = 0;
    public static final int TO_BOTTOM = 1;
    public static final int TO_LEFT = 2;
    public static final int TO_RIGHT = 3;
    public static final int LEFT_SIDE_PINNED = 4;
    public static final int RIGHT_SIDE_PINNED = 5;
    public static final int TOP_SIDE_PINNED = 6;
    public static final int BOTTOM_SIDE_PINNED = 7;
    private int straightenType;

    protected StraightenToAction(IWorkbenchPage workbenchPage, int straightenType) {
        super(workbenchPage);
        this.straightenType = straightenType;
        this.setText(StraightenToAction.getLabel(straightenType));
        this.setToolTipText(StraightenToAction.getTooltip(straightenType));
    }

    public static String getLabel(int straightenType) {
        String label = "";
        switch (straightenType) {
            case 0: {
                label = Messages.StraightenToAction_toTopLabel;
                break;
            }
            case 1: {
                label = Messages.StraightenToAction_toBottomLabel;
                break;
            }
            case 2: {
                label = Messages.StraightenToAction_toLeftLabel;
                break;
            }
            case 3: {
                label = Messages.StraightenToAction_toRightLabel;
                break;
            }
            case 4: {
                label = Messages.StraightenToAction_LeftSidePinnedLabel;
                break;
            }
            case 5: {
                label = Messages.StraightenToAction_RightSidePinnedLabel;
                break;
            }
            case 6: {
                label = Messages.StraightenToAction_TopSidePinnedLabel;
                break;
            }
            case 7: {
                label = Messages.StraightenToAction_BottomSidePinnedLabel;
                break;
            }
        }
        return label;
    }

    public static String getTooltip(int straightenType) {
        String tooltip = "";
        switch (straightenType) {
            case 0: {
                tooltip = Messages.StraightenToAction_toTopTooltip;
                break;
            }
            case 1: {
                tooltip = Messages.StraightenToAction_toBottomTooltip;
                break;
            }
            case 2: {
                tooltip = Messages.StraightenToAction_toLeftTooltip;
                break;
            }
            case 3: {
                tooltip = Messages.StraightenToAction_toRightTooltip;
                break;
            }
            case 4: {
                tooltip = Messages.StraightenToAction_LeftSidePinnedTooltip;
                break;
            }
            case 5: {
                tooltip = Messages.StraightenToAction_RightSidePinnedTooltip;
                break;
            }
            case 6: {
                tooltip = Messages.StraightenToAction_TopSidePinnedTooltip;
                break;
            }
            case 7: {
                tooltip = Messages.StraightenToAction_BottomSidePinnedTooltip;
                break;
            }
        }
        return tooltip;
    }

    public static StraightenToAction createStraightenToTopAction(IWorkbenchPage workbenchPage) {
        StraightenToAction action = new StraightenToAction(workbenchPage, 0);
        action.setId("straightenToTop");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/straightenToTop.png");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static StraightenToAction createStraightenToBottomAction(IWorkbenchPage workbenchPage) {
        StraightenToAction action = new StraightenToAction(workbenchPage, 1);
        action.setId("straightenToBottom");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/straightenToBottom.png");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static StraightenToAction createStraightenToLeftAction(IWorkbenchPage workbenchPage) {
        StraightenToAction action = new StraightenToAction(workbenchPage, 2);
        action.setId("straightenToLeft");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/straightenToLeft.png");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static StraightenToAction createStraightenToRightAction(IWorkbenchPage workbenchPage) {
        StraightenToAction action = new StraightenToAction(workbenchPage, 3);
        action.setId("straightenToRight");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/straightenToRight.png");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static StraightenToAction createStraightenLeftSidePinnedAction(IWorkbenchPage workbenchPage) {
        StraightenToAction action = new StraightenToAction(workbenchPage, 4);
        action.setId("straightenToLeftSidePinned");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/straightenWithLeftPinned.png");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static StraightenToAction createStraightenRightSidePinnedAction(IWorkbenchPage workbenchPage) {
        StraightenToAction action = new StraightenToAction(workbenchPage, 5);
        action.setId("straightenToRightSidePinned");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/straightenWithRightPinned.png");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static StraightenToAction createStraightenTopSidePinnedAction(IWorkbenchPage workbenchPage) {
        StraightenToAction action = new StraightenToAction(workbenchPage, 6);
        action.setId("straightenToTopSidePinned");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/straightenWithTopPinned.png");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static StraightenToAction createStraightenBottomSidePinnedAction(IWorkbenchPage workbenchPage) {
        StraightenToAction action = new StraightenToAction(workbenchPage, 7);
        action.setId("straightenToBottomSidePinned");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/straightenWithBottomPinned.png");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    protected Request createTargetRequest() {
        StraightenToRequest straightenRequest = new StraightenToRequest();
        straightenRequest.setStraightenType(this.straightenType);
        return straightenRequest;
    }

    protected void updateTargetRequest() {
        StraightenToRequest straightenRequest = (StraightenToRequest)this.getTargetRequest();
        straightenRequest.setStraightenType(this.straightenType);
        straightenRequest.setSelectedEdgeEditParts(this.getSelectedEdgeEditParts());
    }

    protected Command getCommand() {
        List operationSet = this.getOperationSet();
        if (!operationSet.isEmpty()) {
            for (Object object : operationSet) {
                if (!(object instanceof AbstractDiagramEdgeEditPart)) continue;
                return ((AbstractDiagramEdgeEditPart)object).getCommand(this.getTargetRequest());
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected List<?> createOperationSet() {
        List selection = this.getSelectedObjects();
        if (!selection.stream().anyMatch(AbstractDiagramEdgeEditPart.class::isInstance)) {
            selection = Collections.EMPTY_LIST;
        }
        return selection;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected boolean isOperationHistoryListener() {
        return true;
    }

    private List<AbstractDiagramEdgeEditPart> getSelectedEdgeEditParts() {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.getOperationSet(), AbstractDiagramEdgeEditPart.class));
    }
}

