/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.session;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.ReloadingPolicy;
import org.eclipse.sirius.business.api.session.SavingPolicy;
import org.eclipse.sirius.business.api.session.SessionEventBroker;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionService;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.business.api.session.SiriusPreferences;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.ui.RefreshEditorsPrecommitListener;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public interface Session {
    public static final String INVALID_SESSION = "INVALID SESSION";

    public static Optional<Session> of(EObject obj) {
        return Optional.ofNullable(new EObjectQuery(obj).getSession());
    }

    public void open(IProgressMonitor var1);

    public boolean isOpen();

    public TransactionalEditingDomain getTransactionalEditingDomain();

    public ModelAccessor getModelAccessor();

    public String getID();

    public Resource getSessionResource();

    public Set<Resource> getReferencedSessionResources();

    public Set<Resource> getAllSessionResources();

    public void addSemanticResource(URI var1, IProgressMonitor var2);

    public Collection<Resource> getSemanticResources();

    public void removeSemanticResource(Resource var1, IProgressMonitor var2, boolean var3);

    public void save(IProgressMonitor var1);

    public void save(Map<?, ?> var1, IProgressMonitor var2);

    public void close(IProgressMonitor var1);

    public Collection<Viewpoint> getSelectedViewpoints(boolean var1);

    public void createView(Viewpoint var1, Collection<EObject> var2, IProgressMonitor var3);

    public void createView(Viewpoint var1, Collection<EObject> var2, boolean var3, IProgressMonitor var4);

    public void addSelectedView(DView var1, IProgressMonitor var2) throws IllegalArgumentException;

    public void removeSelectedView(DView var1, IProgressMonitor var2);

    public Collection<DView> getSelectedViews();

    public Collection<DView> getOwnedViews();

    public void addListener(SessionListener var1);

    public void removeListener(SessionListener var1);

    public IInterpreter getInterpreter();

    public ECrossReferenceAdapter getSemanticCrossReferencer();

    public SessionService getServices();

    public SessionStatus getStatus();

    public void setReloadingPolicy(ReloadingPolicy var1);

    public ReloadingPolicy getReloadingPolicy();

    public void setSavingPolicy(SavingPolicy var1);

    public SavingPolicy getSavingPolicy();

    public SessionEventBroker getEventBroker();

    public RefreshEditorsPrecommitListener getRefreshEditorsListener();

    public Collection<Resource> getSrmResources();

    public SiriusPreferences getSiriusPreferences();

    public Optional<DAnalysis> getSharedMainDAnalysis();
}

