/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LabelAlignment implements Enumerator
{
    CENTER(0, "CENTER", "CENTER"),
    LEFT(1, "LEFT", "LEFT"),
    RIGHT(2, "RIGHT", "RIGHT");

    public static final int CENTER_VALUE = 0;
    public static final int LEFT_VALUE = 1;
    public static final int RIGHT_VALUE = 2;
    private static final LabelAlignment[] VALUES_ARRAY;
    public static final List<LabelAlignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LabelAlignment[]{CENTER, LEFT, RIGHT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LabelAlignment get(String literal) {
        LabelAlignment[] labelAlignmentArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            LabelAlignment result = labelAlignmentArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static LabelAlignment getByName(String name) {
        LabelAlignment[] labelAlignmentArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            LabelAlignment result = labelAlignmentArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static LabelAlignment get(int value) {
        switch (value) {
            case 0: {
                return CENTER;
            }
            case 1: {
                return LEFT;
            }
            case 2: {
                return RIGHT;
            }
        }
        return null;
    }

    private LabelAlignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

