/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.diagram.ui.tools.api.editor.tabbar.ITabbarContributor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.AbstractTabbarFiller;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.ITabbarContributorProvider;
import org.eclipse.ui.IWorkbenchPage;

public class TabbarFillerWithContributor
extends AbstractTabbarFiller {
    private ITabbarContributorProvider tabbarContributorProvider;

    public TabbarFillerWithContributor(ToolBarManager manager, IWorkbenchPage page, ITabbarContributorProvider tabbarContributorProvider) {
        super(manager, page);
        this.tabbarContributorProvider = tabbarContributorProvider;
    }

    @Override
    protected void doFill() {
        ITabbarContributor contributor = this.tabbarContributorProvider.getContributor();
        if (contributor != null) {
            List<IContributionItem> contributionItems = contributor.getContributionItems(this.part, this.manager);
            for (IContributionItem item : contributionItems) {
                this.manager.add(item);
            }
        }
    }

    @Override
    public void update(ISelection iSelection) {
        ITabbarContributor contributor = this.tabbarContributorProvider.getContributor(iSelection);
        List<IContributionItem> existingItems = Arrays.asList(this.manager.getItems());
        for (IContributionItem current : existingItems) {
            current.setVisible(false);
        }
        if (contributor != null) {
            List<IContributionItem> contributionItems = contributor.getContributionItems(iSelection, this.part, this.manager);
            for (IContributionItem item : contributionItems) {
                if (existingItems.contains(item)) {
                    item.setVisible(true);
                    continue;
                }
                this.manager.add(item);
            }
        }
        this.manager.update(true);
    }

    @Override
    public void dispose() {
        this.tabbarContributorProvider = null;
        this.manager.dispose();
        super.dispose();
    }
}

