/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.FileURIHandlerImpl;
import org.eclipse.sirius.tools.internal.resource.ProgressMonitorInputStream;
import org.eclipse.sirius.tools.internal.resource.ProgressMonitorOutputStream;

public class FileURIHandlerWithProgressMonitorImpl
extends FileURIHandlerImpl {
    private IProgressMonitor monitor = new NullProgressMonitor();

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        InputStream inputStream = super.createInputStream(uri, options);
        File file = new File(uri.toFileString());
        inputStream = new ProgressMonitorInputStream(inputStream, file.length(), 1, this.monitor);
        return inputStream;
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        OutputStream outputStream = super.createOutputStream(uri, options);
        File file = new File(uri.toFileString());
        outputStream = new ProgressMonitorOutputStream(outputStream, file.length(), 1, this.monitor);
        return outputStream;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
    }
}

