/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.sirius.business.api.helper.RepresentationHelper;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class ChangeIdUpdaterListener
extends ResourceSetListenerImpl {
    private final DAnalysisSessionImpl dAnalysisSessionImpl;

    ChangeIdUpdaterListener(DAnalysisSessionImpl dAnalysisSessionImpl) {
        this.dAnalysisSessionImpl = dAnalysisSessionImpl;
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        List notifications = event.getNotifications();
        HashSet<EObject> notifierWithoutRepresentationDescriptors = new HashSet<EObject>();
        HashMap<EObject, DRepresentationDescriptor> notifierToDRepMap = new HashMap<EObject, DRepresentationDescriptor>();
        final HashSet<DRepresentationDescriptor> descriptorsToUpdate = new HashSet<DRepresentationDescriptor>();
        HashSet<DRepresentationDescriptor> descriptorsToIgnore = new HashSet<DRepresentationDescriptor>();
        for (Notification notification : notifications) {
            DRepresentationDescriptor representationDescriptor;
            EClass eClass;
            EPackage ePackage;
            boolean isTransient;
            Object notifier = notification.getNotifier();
            boolean isEObject = notifier instanceof EObject;
            boolean bl = isTransient = notification.getFeature() instanceof EStructuralFeature && ((EStructuralFeature)notification.getFeature()).isTransient();
            if (isEObject && !isTransient && ViewpointPackage.Literals.IDENTIFIED_ELEMENT.isInstance(notifier)) {
                DRepresentationDescriptor representationDescriptor2 = this.getDRepresentationDescriptor((EObject)notifier, notifierWithoutRepresentationDescriptors, notifierToDRepMap);
                if (representationDescriptor2 != null) {
                    descriptorsToUpdate.add(representationDescriptor2);
                }
                if (!ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR.isInstance(notifier) || !ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__CHANGE_ID.equals(notification.getFeature())) continue;
                descriptorsToIgnore.add((DRepresentationDescriptor)notifier);
                continue;
            }
            if (!isEObject || isTransient || !"notation".equals((ePackage = (eClass = ((EObject)notifier).eClass()).getEPackage()).getNsPrefix()) || (representationDescriptor = this.getDRepresentationDescriptor((EObject)notifier, notifierWithoutRepresentationDescriptors, notifierToDRepMap)) == null) continue;
            descriptorsToUpdate.add(representationDescriptor);
        }
        descriptorsToUpdate.removeAll(descriptorsToIgnore);
        if (!descriptorsToUpdate.isEmpty()) {
            RecordingCommand changeIdRecordingCommand = new RecordingCommand(this.dAnalysisSessionImpl.getTransactionalEditingDomain()){

                protected void doExecute() {
                    for (DRepresentationDescriptor dRepresentationDescriptor : descriptorsToUpdate) {
                        RepresentationHelper.updateChangeId(dRepresentationDescriptor);
                    }
                }
            };
            return changeIdRecordingCommand;
        }
        return null;
    }

    private DRepresentationDescriptor getDRepresentationDescriptor(EObject eObject, Set<EObject> notifierWithoutRepresentationDescriptors, Map<EObject, DRepresentationDescriptor> notifierToDRepMap) {
        DRepresentationDescriptor dRepresentationDescriptor = null;
        DRepresentationDescriptor repAssociatedToEObject = notifierToDRepMap.get(eObject);
        if (repAssociatedToEObject == null && !notifierWithoutRepresentationDescriptors.contains(eObject)) {
            EObject eContainer = eObject.eContainer();
            if (eObject.eContainingFeature() == null || !eObject.eContainingFeature().isTransient()) {
                if (eContainer != null && !(eObject instanceof DRepresentation)) {
                    dRepresentationDescriptor = this.getDRepresentationDescriptor(eContainer, notifierWithoutRepresentationDescriptors, notifierToDRepMap);
                    if (dRepresentationDescriptor == null) {
                        notifierWithoutRepresentationDescriptors.add(eObject);
                    } else {
                        notifierToDRepMap.put(eObject, dRepresentationDescriptor);
                    }
                } else if (eObject instanceof DRepresentation) {
                    dRepresentationDescriptor = new DRepresentationQuery((DRepresentation)eObject).getRepresentationDescriptor();
                    notifierToDRepMap.put(eObject, dRepresentationDescriptor);
                }
            } else {
                notifierWithoutRepresentationDescriptors.add(eObject);
            }
        } else {
            dRepresentationDescriptor = repAssociatedToEObject;
        }
        return dRepresentationDescriptor;
    }
}

