/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.internal.util.SharedInstanceBuffer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.graphics.ColorUtil;

public class ResourceFactory {
    private final SharedInstanceBuffer<Integer, Color> colors = new SharedInstanceBuffer();
    private final SharedInstanceBuffer<Integer, Font> fonts = new SharedInstanceBuffer();
    private final SharedInstanceBuffer<Integer, Cursor> cursors = new SharedInstanceBuffer();

    public Color getColor(int red, int green, int blue) {
        int colorNr = ColorUtil.computeColorNr(red, green, blue);
        return this.getColor(colorNr);
    }

    private Color getColor(final int value) {
        Integer key = new Integer(value);
        return this.colors.get(key, new SharedInstanceBuffer.IInstanceCreator<Color>(){

            @Override
            public Color createInstance() {
                return ResourceFactory.createColorInstance(value);
            }
        });
    }

    public Font getFont(final FontData fontData) {
        Integer key = new Integer(fontData.hashCode());
        return this.fonts.get(key, new SharedInstanceBuffer.IInstanceCreator<Font>(){

            @Override
            public Font createInstance() {
                return ResourceFactory.createFontInstance(fontData);
            }
        });
    }

    public Cursor getCursor(final int style) {
        Integer key = new Integer(style);
        return this.cursors.get(key, new SharedInstanceBuffer.IInstanceCreator<Cursor>(){

            @Override
            public Cursor createInstance() {
                return ResourceFactory.createCursorInstance(style);
            }
        });
    }

    private static Color createColorInstance(int colorNr) {
        Class[] paramTypes = new Class[]{Integer.TYPE};
        Object[] paramValues = new Object[]{new Integer(colorNr)};
        return ClassUtil.newInstance(Color.class, paramTypes, paramValues);
    }

    private static Font createFontInstance(FontData fontData) {
        Class[] paramTypes = new Class[]{FontData.class};
        Object[] paramValues = new Object[]{fontData};
        return ClassUtil.newInstance(Font.class, paramTypes, paramValues);
    }

    private static Cursor createCursorInstance(int style) {
        Class[] paramTypes = new Class[]{Integer.TYPE};
        Object[] paramValues = new Object[]{new Integer(style)};
        return ClassUtil.newInstance(Cursor.class, paramTypes, paramValues);
    }
}

