/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;

public class RTFTransfer
extends ByteArrayTransfer {
    private static final String CF_RTF = "rtf";
    private static final int CF_RTFID = RTFTransfer.registerType("rtf");

    private RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        RTFTransfer instance = SessionSingletonBase.getInstance(RTFTransfer.class);
        return instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkRTF(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.data = object;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.result != 1) {
            return null;
        }
        return transferData.data;
    }

    protected int[] getTypeIds() {
        return new int[]{CF_RTFID};
    }

    protected String[] getTypeNames() {
        return new String[]{CF_RTF};
    }

    boolean checkRTF(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkRTF(object);
    }
}

