/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.engine;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.rwt.application.Application;
import org.eclipse.rwt.application.ApplicationConfiguration;
import org.eclipse.rwt.application.ApplicationRunner;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.lifecycle.IEntryPoint;

public class RWTServletContextListener
implements ServletContextListener {
    static final String ENTRY_POINTS_PARAM = "org.eclipse.rwt.entryPoints";
    private ApplicationRunner applicationRunner;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        ApplicationConfiguration configuration = this.readConfiguration(servletContext);
        this.applicationRunner = new ApplicationRunner(configuration, servletContext);
        this.applicationRunner.start();
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.applicationRunner.stop();
        this.applicationRunner = null;
    }

    private ApplicationConfiguration readConfiguration(ServletContext servletContext) {
        ApplicationConfiguration result = this.hasConfigurationParam(servletContext) ? this.readApplicationConfiguration(servletContext) : this.readEntryPointRunnerConfiguration(servletContext);
        return result;
    }

    private boolean hasConfigurationParam(ServletContext servletContext) {
        return servletContext.getInitParameter("org.eclipse.rap.applicationConfiguration") != null;
    }

    private ApplicationConfiguration readApplicationConfiguration(ServletContext servletContext) {
        String name = servletContext.getInitParameter("org.eclipse.rap.applicationConfiguration");
        return this.createConfiguration(name);
    }

    private ApplicationConfiguration createConfiguration(String className) {
        ClassLoader loader = this.getClass().getClassLoader();
        return (ApplicationConfiguration)ClassUtil.newInstance(loader, className);
    }

    private ApplicationConfiguration readEntryPointRunnerConfiguration(ServletContext context) {
        try {
            return this.doReadEntryPointRunnerConfiguration(context);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException(cnfe);
        }
    }

    private ApplicationConfiguration doReadEntryPointRunnerConfiguration(ServletContext context) throws ClassNotFoundException {
        String className = context.getInitParameter(ENTRY_POINTS_PARAM);
        ClassLoader loader = this.getClass().getClassLoader();
        Class<?> entryPointClass = loader.loadClass(className);
        return new EntryPointRunnerConfiguration(entryPointClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryPointRunnerConfiguration
    implements ApplicationConfiguration {
        private final Class<? extends IEntryPoint> entryPointClass;

        private EntryPointRunnerConfiguration(Class<? extends IEntryPoint> entryPointClass) {
            this.entryPointClass = entryPointClass;
        }

        @Override
        public void configure(Application application) {
            application.addEntryPoint("/rap", this.entryPointClass, null);
        }
    }
}

