/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.ctabfolderkit;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.custom.ICTabFolderAdapter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTabFolderOperationHandler
extends ControlOperationHandler<CTabFolder> {
    private static final String PROP_MINIMIZED = "minimized";
    private static final String PROP_MAXIMIZED = "maximized";
    private static final String PROP_SELECTION = "selection";

    public CTabFolderOperationHandler(CTabFolder folder) {
        super(folder);
    }

    @Override
    public void handleSet(CTabFolder folder, JsonObject properties) {
        super.handleSet(folder, properties);
        this.handleSetMinimized(folder, properties);
        this.handleSetMaximized(folder, properties);
        this.handleSetSelection(folder, properties);
    }

    @Override
    public void handleNotify(CTabFolder folder, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(folder, properties);
        } else if ("DefaultSelection".equals(eventName)) {
            this.handleNotifyDefaultSelection(folder, properties);
        } else if ("Folder".equals(eventName)) {
            this.handleNotifyFolder(folder, properties);
        } else {
            super.handleNotify(folder, eventName, properties);
        }
    }

    public void handleSetMinimized(CTabFolder folder, JsonObject properties) {
        JsonValue value = properties.get(PROP_MINIMIZED);
        if (value != null) {
            folder.setMinimized(value.asBoolean());
        }
    }

    public void handleSetMaximized(CTabFolder folder, JsonObject properties) {
        JsonValue value = properties.get(PROP_MAXIMIZED);
        if (value != null) {
            folder.setMaximized(value.asBoolean());
        }
    }

    public void handleSetSelection(final CTabFolder folder, JsonObject properties) {
        JsonValue value = properties.get(PROP_SELECTION);
        if (value != null) {
            final CTabItem item = CTabFolderOperationHandler.getItem(folder, value.asString());
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    folder.setSelection(item);
                    WidgetLCAUtil.preserveProperty((Widget)folder, CTabFolderOperationHandler.PROP_SELECTION, WidgetUtil.getId(item));
                }
            });
        }
    }

    public void handleNotifySelection(CTabFolder folder, JsonObject properties) {
        Event event = CTabFolderOperationHandler.createSelectionEvent(13, properties);
        event.item = CTabFolderOperationHandler.getItem(folder, properties.get("item").asString());
        folder.notifyListeners(13, event);
    }

    public void handleNotifyDefaultSelection(CTabFolder folder, JsonObject properties) {
        Event event = CTabFolderOperationHandler.createSelectionEvent(14, properties);
        event.item = CTabFolderOperationHandler.getItem(folder, properties.get("item").asString());
        folder.notifyListeners(14, event);
    }

    public void handleNotifyFolder(CTabFolder folder, JsonObject properties) {
        JsonValue value = properties.get("detail");
        if (value != null) {
            String detail = value.asString();
            if ("minimize".equals(detail)) {
                folder.notifyListeners(5032, new Event());
            } else if ("maximize".equals(detail)) {
                folder.notifyListeners(5033, new Event());
            } else if ("restore".equals(detail)) {
                folder.notifyListeners(5034, new Event());
            } else if ("close".equals(detail)) {
                CTabItem item = CTabFolderOperationHandler.getItem(folder, properties.get("item").asString());
                CTabFolderOperationHandler.notifyCloseListeners(item);
            } else if ("showList".equals(detail)) {
                CTabFolderOperationHandler.notifyShowListListeners(folder);
            }
        }
    }

    private static void notifyCloseListeners(final CTabItem item) {
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                boolean doit = CTabFolderOperationHandler.sendCloseEvent(item);
                if (doit) {
                    item.dispose();
                }
            }
        });
    }

    private static boolean sendCloseEvent(CTabItem item) {
        Event event = new Event();
        event.item = item;
        event.doit = true;
        item.getParent().notifyListeners(5031, event);
        return event.doit;
    }

    private static void notifyShowListListeners(final CTabFolder folder) {
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                boolean doit = CTabFolderOperationHandler.sendShowListEvent(folder);
                if (doit) {
                    CTabFolderOperationHandler.getCTabFolderAdapter(folder).showListMenu();
                }
            }
        });
    }

    private static boolean sendShowListEvent(CTabFolder folder) {
        Event event = new Event();
        Rectangle chevronRect = CTabFolderOperationHandler.getChevronBounds(folder);
        event.x = chevronRect.x;
        event.y = chevronRect.y;
        event.height = chevronRect.height;
        event.width = chevronRect.width;
        event.doit = true;
        folder.notifyListeners(5035, event);
        return event.doit;
    }

    private static Rectangle getChevronBounds(CTabFolder folder) {
        return CTabFolderOperationHandler.getCTabFolderAdapter(folder).getChevronRect();
    }

    private static CTabItem getItem(CTabFolder folder, String itemId) {
        return (CTabItem)WidgetUtil.find(folder, itemId);
    }

    private static ICTabFolderAdapter getCTabFolderAdapter(CTabFolder folder) {
        return folder.getAdapter(ICTabFolderAdapter.class);
    }
}

