/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.dropdown.viewer;

import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rap.addons.dropdown.DropDown;
import org.eclipse.rap.addons.dropdown.viewer.internal.resources.ResourceLoaderUtil;
import org.eclipse.rap.clientscripting.ClientListener;
import org.eclipse.rap.clientscripting.WidgetDataWhiteList;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptLoader;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.ControlDecorator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DropDownViewer
extends ContentViewer {
    private static final String REMOTE_TYPE = "rwt.remote.UniversalRemoteObject";
    private static final String UNIVERSAL_REMOTE_OBJECT_JS = "rwt/remote/UniversalRemoteObject.js";
    private static final String ATTR_CLIENT_LISTNER_HOLDER = String.valueOf(ClientListenerHolder.class.getName()) + "#instance";
    private static final String SELECTION_CHANGED = "SelectionChanged";
    private static final String VIEWER_LINK = String.valueOf(DropDownViewer.class.getName()) + "#viewer";
    private static final String DROPDOWN_KEY = "dropDown";
    private static final String TEXT_KEY = "text";
    private static final String DECORATOR_KEY = "decorator";
    private static final String ELEMENTS_KEY = "elements";
    private final DropDown dropDown;
    private final Text text;
    private final ClientListenerHolder clientListeners;
    private final RemoteObject remoteObject;
    private Object[] elements;
    private ControlDecorator decorator;

    public DropDownViewer(Text text) {
        this.text = text;
        this.checkParent();
        this.ensureTypeHandler();
        this.dropDown = new DropDown((Control)text);
        this.clientListeners = this.getClientListenerHolder();
        this.remoteObject = RWT.getUISession().getConnection().createRemoteObject(REMOTE_TYPE);
        this.remoteObject.setHandler((OperationHandler)new InternalOperationHandler());
        this.setClientElements(new String[0]);
        this.createControlDecorator();
        this.attachClientListener();
        this.linkClientObjects();
        this.hookControl((Control)text);
    }

    public Control getControl() {
        return this.text;
    }

    public ISelection getSelection() {
        return null;
    }

    public void refresh() {
        this.updateElements();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        throw new UnsupportedOperationException("Setting the selection is currently not supported");
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        super.addSelectionChangedListener(listener);
        this.remoteObject.listen(SELECTION_CHANGED, true);
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.updateElements();
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.remoteObject.destroy();
    }

    private void checkParent() {
        if (this.text.getData(VIEWER_LINK) != null) {
            throw new IllegalStateException("Text already has a " + ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    private void updateElements() {
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.getContentProvider();
        Object input = this.getInput();
        if (contentProvider != null && input != null) {
            this.elements = contentProvider.getElements(input);
            this.updateClientElements();
        }
    }

    private void updateClientElements() {
        ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
        if (this.elements != null) {
            String[] clientElements = new String[this.elements.length];
            int i = 0;
            while (i < this.elements.length) {
                clientElements[i] = labelProvider.getText(this.elements[i]);
                ++i;
            }
            this.setClientElements(clientElements);
        }
    }

    private void setClientElements(String[] elements) {
        this.remoteObject.set(ELEMENTS_KEY, (JsonValue)JsonUtil.createJsonArray((String[])elements));
    }

    private void createControlDecorator() {
        this.decorator = new ControlDecorator((Control)this.text, 16512, null);
        this.decorator.setMarginWidth(2);
        this.decorator.setImage(DropDownViewer.getDecorationImage("DEC_ERROR"));
        this.decorator.hide();
    }

    private static Image getDecorationImage(String id) {
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        FieldDecoration decoration = registry.getFieldDecoration(id);
        return decoration.getImage();
    }

    private void attachClientListener() {
        this.text.addListener(24, (Listener)this.getTextModifyListener());
        this.text.addListener(25, (Listener)this.getTextVerifyListener());
        this.text.addListener(1, (Listener)this.getTextKeyDownListener());
        this.text.addListener(3, (Listener)this.getTextMouseDownListener());
        this.dropDown.addListener(13, (Listener)this.getDropDownSelectionListener());
        this.dropDown.addListener(14, (Listener)this.getDropDownDefaultSelectionListener());
        this.dropDown.addListener(22, (Listener)this.getDropDownShowListener());
    }

    private void linkClientObjects() {
        WidgetDataWhiteList.addKey((String)VIEWER_LINK);
        this.text.setData(VIEWER_LINK, (Object)this.remoteObject.getId());
        this.dropDown.setData(VIEWER_LINK, (Object)this.remoteObject.getId());
        this.remoteObject.set(DROPDOWN_KEY, WidgetUtil.getId((Widget)this.dropDown));
        this.remoteObject.set(TEXT_KEY, WidgetUtil.getId((Widget)this.text));
        this.remoteObject.set(DECORATOR_KEY, WidgetUtil.getId((Widget)this.decorator));
    }

    RemoteObject getRemoteObject() {
        return this.remoteObject;
    }

    ClientListener getTextModifyListener() {
        return this.clientListeners.getTextModifyListener();
    }

    ClientListener getTextVerifyListener() {
        return this.clientListeners.getTextVerifyListener();
    }

    ClientListener getTextKeyDownListener() {
        return this.clientListeners.getTextKeyDownListener();
    }

    ClientListener getTextMouseDownListener() {
        return this.clientListeners.getTextMouseDownListener();
    }

    DropDown getDropDown() {
        return this.dropDown;
    }

    ControlDecorator getDecorator() {
        return this.decorator;
    }

    ClientListener getDropDownSelectionListener() {
        return this.clientListeners.getDropDownSelectionListener();
    }

    ClientListener getDropDownDefaultSelectionListener() {
        return this.clientListeners.getDropDownDefaultSelectionListener();
    }

    ClientListener getDropDownShowListener() {
        return this.clientListeners.getDropDownShowListener();
    }

    private ClientListenerHolder getClientListenerHolder() {
        Object result = RWT.getUISession().getAttribute(ATTR_CLIENT_LISTNER_HOLDER);
        if (result == null) {
            result = new ClientListenerHolder();
            RWT.getUISession().setAttribute(ATTR_CLIENT_LISTNER_HOLDER, result);
        }
        return (ClientListenerHolder)result;
    }

    private void fireSelectionChanged(int index) {
        Object element = this.elements[index];
        StructuredSelection selection = new StructuredSelection(element);
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)selection));
    }

    private void ensureTypeHandler() {
        ResourceManager manager = RWT.getResourceManager();
        if (!manager.isRegistered(UNIVERSAL_REMOTE_OBJECT_JS)) {
            manager.register(UNIVERSAL_REMOTE_OBJECT_JS, ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(UNIVERSAL_REMOTE_OBJECT_JS));
        }
        JavaScriptLoader jsl = (JavaScriptLoader)RWT.getClient().getService(JavaScriptLoader.class);
        jsl.require(manager.getLocation(UNIVERSAL_REMOTE_OBJECT_JS));
    }

    private static class ClientListenerHolder {
        private final String PREFIX = "org/eclipse/rap/addons/dropdown/viewer/internal/resources/";
        private final ClientListener textListener = this.createListener("TextEventListener.js");
        private final ClientListener dropDownListener = this.createListener("DropDownEventListener.js");

        private ClientListenerHolder() {
        }

        private ClientListener createListener(String name) {
            return new ClientListener(ResourceLoaderUtil.readTextContent("org/eclipse/rap/addons/dropdown/viewer/internal/resources/" + name));
        }

        public ClientListener getDropDownShowListener() {
            return this.dropDownListener;
        }

        public ClientListener getTextModifyListener() {
            return this.textListener;
        }

        public ClientListener getDropDownDefaultSelectionListener() {
            return this.dropDownListener;
        }

        public ClientListener getDropDownSelectionListener() {
            return this.dropDownListener;
        }

        public ClientListener getTextKeyDownListener() {
            return this.textListener;
        }

        public ClientListener getTextMouseDownListener() {
            return this.textListener;
        }

        public ClientListener getTextVerifyListener() {
            return this.textListener;
        }
    }

    private class InternalOperationHandler
    extends AbstractOperationHandler {
        private InternalOperationHandler() {
        }

        public void handleNotify(String event, JsonObject properties) {
            if (DropDownViewer.SELECTION_CHANGED.equals(event)) {
                int index = properties.get("index").asInt();
                DropDownViewer.this.fireSelectionChanged(index);
            }
        }
    }
}

