/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.clientscripting.internal.resources;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.application.Application;
import org.eclipse.rap.rwt.client.service.JavaScriptLoader;
import org.eclipse.rap.rwt.service.ResourceLoader;

public final class ClientScriptingResources {
    private static final String CHARSET = "UTF-8";
    private static final String REGISTER_NAME = "clientscripting.js";
    private static final String PREFIX = "org/eclipse/rap/clientscripting/";
    private static final String[] ALL_RESOURCES = new String[]{"ClientScriptingUtil.js", "EventBindingAdapter.js", "EventBinding.js", "EventProxy.js", "Function.js", "ListenerAdapter.js", "SWT.js", "WidgetProxy.js"};

    public static void ensure() {
        ClientScriptingResources.ensureRegistered();
        ClientScriptingResources.ensureLoaded();
    }

    private static void ensureRegistered() {
        if (!RWT.getResourceManager().isRegistered(REGISTER_NAME)) {
            try {
                ClientScriptingResources.register();
            }
            catch (IOException exception) {
                throw new RuntimeException("Failed to register resources", exception);
            }
        }
    }

    private static void ensureLoaded() {
        JavaScriptLoader loader = (JavaScriptLoader)RWT.getClient().getService(JavaScriptLoader.class);
        loader.require(RWT.getResourceManager().getLocation(REGISTER_NAME));
    }

    private static void register() throws IOException {
        InputStream inputStream = ClientScriptingResources.getConcatentatedInputStream();
        try {
            RWT.getResourceManager().register(REGISTER_NAME, inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    public static void register(Application application) {
        application.addResource(REGISTER_NAME, new ResourceLoader(){

            public InputStream getResourceAsStream(String resourceName) throws IOException {
                return ClientScriptingResources.getConcatentatedInputStream();
            }
        });
    }

    private static InputStream getConcatentatedInputStream() throws IOException {
        return new ByteArrayInputStream(ClientScriptingResources.concatResources().getBytes(CHARSET));
    }

    private static String concatResources() throws IOException {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = ALL_RESOURCES;
        int n = ALL_RESOURCES.length;
        int n2 = 0;
        while (n2 < n) {
            String resourceName = stringArray[n2];
            InputStream inputStream = ClientScriptingResources.getResourceAsStream(resourceName);
            try {
                ClientScriptingResources.read(inputStream, builder);
            }
            finally {
                inputStream.close();
            }
            ++n2;
        }
        return builder.toString();
    }

    private static InputStream getResourceAsStream(String resourceName) {
        ClassLoader classLoader = ClientScriptingResources.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(PREFIX + resourceName);
        if (inputStream == null) {
            throw new RuntimeException("Resource not found: " + resourceName);
        }
        return inputStream;
    }

    static void read(InputStream inputStream, StringBuilder builder) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream, CHARSET);
        BufferedReader bufferedReader = new BufferedReader(reader);
        char[] buffer = new char[4096];
        int read = bufferedReader.read(buffer);
        while (read != -1) {
            builder.append(buffer, 0, read);
            read = bufferedReader.read(buffer);
        }
    }

    private ClientScriptingResources() {
    }
}

