/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.clientscripting.internal;

import java.util.Collection;
import org.eclipse.rap.clientscripting.ClientListener;
import org.eclipse.rap.clientscripting.internal.ClientListenerAdapter;
import org.eclipse.rap.clientscripting.internal.ClientListenerBinding;
import org.eclipse.rap.clientscripting.internal.ClientListenerBindingSynchronizer;
import org.eclipse.rap.clientscripting.internal.ClientListenerManager;
import org.eclipse.rap.clientscripting.internal.ClientListenerSynchronizer;
import org.eclipse.rap.clientscripting.internal.IClientObjectAdapter2;
import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.PhaseEvent;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.rap.rwt.lifecycle.PhaseListener;
import org.eclipse.rap.rwt.service.IApplicationStore;

final class ClientScriptingRenderer {
    private static final String ATTR_RENDERING_PHASE_LISTENER = ClientScriptingRenderer.class.getName().concat("#renderingPhaseListener");
    private static final ClientListenerSynchronizer clientListenerSynchronizer;
    private static final ClientListenerBindingSynchronizer clientListenerBindingSynchronizer;
    private static final Object lock;

    static {
        lock = new Object();
        clientListenerSynchronizer = new ClientListenerSynchronizer();
        clientListenerBindingSynchronizer = new ClientListenerBindingSynchronizer();
    }

    ClientScriptingRenderer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerPhaseListener() {
        IApplicationStore store = RWT.getApplicationStore();
        Object object = lock;
        synchronized (object) {
            PhaseListener phaseListener = (PhaseListener)store.getAttribute(ATTR_RENDERING_PHASE_LISTENER);
            if (phaseListener == null) {
                phaseListener = new RenderPhaseListener();
                RWT.getLifeCycle().addPhaseListener(phaseListener);
                store.setAttribute(ATTR_RENDERING_PHASE_LISTENER, (Object)phaseListener);
            }
        }
    }

    static void render() {
        ClientListenerManager manager = ClientListenerManager.getInstance();
        Collection<ClientListener> listeners = manager.getListeners();
        for (ClientListener listener : listeners) {
            ClientScriptingRenderer.render(listener);
            ClientListenerAdapter listenerAdapter = listener.getAdapter(ClientListenerAdapter.class);
            Collection<ClientListenerBinding> bindings = listenerAdapter.getBindings();
            for (ClientListenerBinding binding : bindings) {
                ClientScriptingRenderer.render(binding);
            }
            listenerAdapter.removeDisposedBindings();
        }
    }

    private static void render(ClientListener listener) {
        IClientObjectAdapter2 adapter = listener.getAdapter(IClientObjectAdapter2.class);
        if (!adapter.isCreated()) {
            IClientObject clientObject = ClientObjectFactory.getClientObject((Adaptable)listener);
            clientListenerSynchronizer.renderCreate(listener, clientObject);
            adapter.setCreated();
        }
    }

    private static void render(ClientListenerBinding binding) {
        IClientObject clientObject;
        IClientObjectAdapter2 adapter = binding.getAdapter(IClientObjectAdapter2.class);
        if (!adapter.isCreated()) {
            clientObject = ClientObjectFactory.getClientObject((Adaptable)binding);
            clientListenerBindingSynchronizer.renderCreate(binding, clientObject);
            adapter.setCreated();
        }
        if (binding.isDisposed()) {
            clientObject = ClientObjectFactory.getClientObject((Adaptable)binding);
            clientListenerBindingSynchronizer.renderDestroy(binding, clientObject);
        }
    }

    private static class RenderPhaseListener
    implements PhaseListener {
        private RenderPhaseListener() {
        }

        public PhaseId getPhaseId() {
            return PhaseId.RENDER;
        }

        public void beforePhase(PhaseEvent event) {
        }

        public void afterPhase(PhaseEvent event) {
            ClientScriptingRenderer.render();
        }
    }
}

