/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.clientscripting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.rap.clientscripting.internal.ClientListenerAdapter;
import org.eclipse.rap.clientscripting.internal.ClientListenerBinding;
import org.eclipse.rap.clientscripting.internal.ClientListenerManager;
import org.eclipse.rap.clientscripting.internal.ClientObjectAdapterImpl;
import org.eclipse.rap.clientscripting.internal.IClientObjectAdapter2;
import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.internal.protocol.IClientObjectAdapter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientListener
implements Adaptable {
    public static final int KeyDown = 1;
    public static final int KeyUp = 2;
    public static final int MouseDown = 3;
    public static final int MouseUp = 4;
    public static final int MouseMove = 5;
    public static final int MouseEnter = 6;
    public static final int MouseExit = 7;
    public static final int MouseDoubleClick = 8;
    public static final int Paint = 9;
    public static final int FocusIn = 15;
    public static final int FocusOut = 16;
    public static final int Modify = 24;
    public static final int Verify = 25;
    private final String scriptCode;
    private boolean disposed;
    private IClientObjectAdapter2 iClientObjectAdapter2;
    private ClientListenerAdapter clientListenerAdapter;
    protected Collection<ClientListenerBinding> bindings;

    public ClientListener(String scriptCode) {
        this.scriptCode = scriptCode;
        this.disposed = false;
        this.bindings = new ArrayList<ClientListenerBinding>();
        if (scriptCode == null) {
            throw new NullPointerException("Parameter is null: scriptCode");
        }
    }

    public void addTo(Widget widget, int eventType) {
        if (this.disposed) {
            throw new IllegalStateException("ClientListener is disposed");
        }
        if (widget == null) {
            throw new NullPointerException("widget is null");
        }
        if (widget.isDisposed()) {
            throw new IllegalArgumentException("Widget is disposed");
        }
        ClientListenerBinding binding = new ClientListenerBinding(widget, eventType, this);
        this.addBinding(binding);
        ClientListenerManager.getInstance().addListener(this);
    }

    public void removeFrom(Widget widget, int eventType) {
        if (this.disposed) {
            throw new IllegalStateException("ClientListener is disposed");
        }
        if (widget == null) {
            throw new NullPointerException("widget is null");
        }
        ClientListenerBinding binding = this.findBinding(widget, eventType);
        if (binding != null) {
            binding.markDisposed();
        }
    }

    public void dispose() {
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object result = null;
        if (adapter == IClientObjectAdapter2.class || adapter == IClientObjectAdapter.class) {
            if (this.iClientObjectAdapter2 == null) {
                this.iClientObjectAdapter2 = new ClientObjectAdapterImpl();
            }
            result = this.iClientObjectAdapter2;
        } else if (adapter == ClientListenerAdapter.class) {
            if (this.clientListenerAdapter == null) {
                this.clientListenerAdapter = this.createClientListenerAdapter();
            }
            result = this.clientListenerAdapter;
        }
        return (T)result;
    }

    private void addBinding(final ClientListenerBinding binding) {
        if (!this.bindings.contains(binding)) {
            this.bindings.add(binding);
            binding.getWidget().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    binding.markDisposed();
                }
            });
        }
    }

    private ClientListenerBinding findBinding(Widget widget, int eventType) {
        for (ClientListenerBinding binding : this.bindings) {
            if (binding.getWidget() != widget || binding.getEventType() != eventType) continue;
            return binding;
        }
        return null;
    }

    private ClientListenerAdapter createClientListenerAdapter() {
        return new ClientListenerAdapter(){

            @Override
            public Collection<ClientListenerBinding> getBindings() {
                return Collections.unmodifiableCollection(ClientListener.this.bindings);
            }

            @Override
            public String getScriptCode() {
                return ClientListener.this.scriptCode;
            }

            @Override
            public void removeDisposedBindings() {
                ArrayList<ClientListenerBinding> toRemove = new ArrayList<ClientListenerBinding>();
                for (ClientListenerBinding binding : ClientListener.this.bindings) {
                    if (!binding.isDisposed()) continue;
                    toRemove.add(binding);
                }
                for (ClientListenerBinding binding : toRemove) {
                    ClientListener.this.bindings.remove(binding);
                }
            }
        };
    }
}

