/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.progressbarkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.widgets.progressbarkit.ProgressBarOperationHandler;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;

public class ProgressBarLCA
extends WidgetLCA<ProgressBar> {
    public static final ProgressBarLCA INSTANCE = new ProgressBarLCA();
    private static final String TYPE = "rwt.widgets.ProgressBar";
    private static final String[] ALLOWED_STYLES = new String[]{"SMOOTH", "HORIZONTAL", "VERTICAL", "INDETERMINATE", "BORDER"};
    static final String PROP_MINIMUM = "minimum";
    static final String PROP_MAXIMUM = "maximum";
    static final String PROP_SELECTION = "selection";
    static final String PROP_STATE = "state";
    private static final int DEFAULT_MINIMUM = 0;
    private static final int DEFAULT_MAXIMUM = 100;
    private static final int DEFAULT_SELECTION = 0;
    private static final String DEFAULT_STATE = "normal";

    @Override
    public void preserveValues(ProgressBar progressBar) {
        WidgetLCAUtil.preserveProperty((Widget)progressBar, PROP_MINIMUM, (Object)progressBar.getMinimum());
        WidgetLCAUtil.preserveProperty((Widget)progressBar, PROP_MAXIMUM, (Object)progressBar.getMaximum());
        WidgetLCAUtil.preserveProperty((Widget)progressBar, PROP_SELECTION, (Object)progressBar.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)progressBar, PROP_STATE, ProgressBarLCA.getState(progressBar));
    }

    @Override
    public void renderInitialization(ProgressBar progressBar) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(progressBar, TYPE);
        remoteObject.setHandler(new ProgressBarOperationHandler(progressBar));
        remoteObject.set("parent", WidgetUtil.getId(progressBar.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(progressBar, ALLOWED_STYLES)));
    }

    @Override
    public void renderChanges(ProgressBar progressBar) throws IOException {
        ControlLCAUtil.renderChanges(progressBar);
        WidgetLCAUtil.renderCustomVariant(progressBar);
        WidgetLCAUtil.renderProperty((Widget)progressBar, PROP_MINIMUM, progressBar.getMinimum(), 0);
        WidgetLCAUtil.renderProperty((Widget)progressBar, PROP_MAXIMUM, progressBar.getMaximum(), 100);
        WidgetLCAUtil.renderProperty((Widget)progressBar, PROP_SELECTION, progressBar.getSelection(), 0);
        WidgetLCAUtil.renderProperty((Widget)progressBar, PROP_STATE, ProgressBarLCA.getState(progressBar), DEFAULT_STATE);
        WidgetLCAUtil.renderClientListeners(progressBar);
    }

    private static String getState(ProgressBar progressBar) {
        String result = DEFAULT_STATE;
        int state = progressBar.getState();
        if (state == 1) {
            result = "error";
        } else if (state == 4) {
            result = "paused";
        }
        return result;
    }

    private ProgressBarLCA() {
    }
}

