/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.swt.internal.widgets.ControlRemoteAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class ActiveKeysUtil {
    private static final Map<String, Integer> KEY_MAP = new HashMap<String, Integer>();
    private static final String ALT = "ALT+";
    private static final String CTRL = "CTRL+";
    private static final String SHIFT = "SHIFT+";
    static final String PROP_ACTIVE_KEYS = "activeKeys";
    static final String PROP_CANCEL_KEYS = "cancelKeys";
    static final String PROP_MNEMONIC_ACTIVATOR = "mnemonicActivator";

    static {
        KEY_MAP.put("BACKSPACE", 8);
        KEY_MAP.put("BS", 8);
        KEY_MAP.put("TAB", 9);
        KEY_MAP.put("RETURN", 13);
        KEY_MAP.put("ENTER", 13);
        KEY_MAP.put("CR", 13);
        KEY_MAP.put("PAUSE", 19);
        KEY_MAP.put("BREAK", 19);
        KEY_MAP.put("CAPS_LOCK", 20);
        KEY_MAP.put("ESCAPE", 27);
        KEY_MAP.put("ESC", 27);
        KEY_MAP.put("SPACE", 32);
        KEY_MAP.put("PAGE_UP", 33);
        KEY_MAP.put("PAGE_DOWN", 34);
        KEY_MAP.put("END", 35);
        KEY_MAP.put("HOME", 36);
        KEY_MAP.put("ARROW_LEFT", 37);
        KEY_MAP.put("ARROW_UP", 38);
        KEY_MAP.put("ARROW_RIGHT", 39);
        KEY_MAP.put("ARROW_DOWN", 40);
        KEY_MAP.put("PRINT_SCREEN", 44);
        KEY_MAP.put("INSERT", 45);
        KEY_MAP.put("DEL", 46);
        KEY_MAP.put("DELETE", 46);
        KEY_MAP.put("F1", 112);
        KEY_MAP.put("F2", 113);
        KEY_MAP.put("F3", 114);
        KEY_MAP.put("F4", 115);
        KEY_MAP.put("F5", 116);
        KEY_MAP.put("F6", 117);
        KEY_MAP.put("F7", 118);
        KEY_MAP.put("F8", 119);
        KEY_MAP.put("F9", 120);
        KEY_MAP.put("F10", 121);
        KEY_MAP.put("F11", 122);
        KEY_MAP.put("F12", 123);
        KEY_MAP.put("NUMPAD_0", 96);
        KEY_MAP.put("NUMPAD_1", 97);
        KEY_MAP.put("NUMPAD_2", 98);
        KEY_MAP.put("NUMPAD_3", 99);
        KEY_MAP.put("NUMPAD_4", 100);
        KEY_MAP.put("NUMPAD_5", 101);
        KEY_MAP.put("NUMPAD_6", 102);
        KEY_MAP.put("NUMPAD_7", 103);
        KEY_MAP.put("NUMPAD_8", 104);
        KEY_MAP.put("NUMPAD_9", 105);
        KEY_MAP.put("NUMPAD_MULTIPLY", 106);
        KEY_MAP.put("NUMPAD_ADD", 107);
        KEY_MAP.put("NUMPAD_SUBTRACT", 109);
        KEY_MAP.put("NUMPAD_DECIMAL", 110);
        KEY_MAP.put("NUMPAD_DIVIDE", 111);
        KEY_MAP.put("NUM_LOCK", 144);
        KEY_MAP.put("SCROLL_LOCK", 145);
    }

    private ActiveKeysUtil() {
    }

    public static void preserveActiveKeys(Display display) {
        RemoteAdapter adapter = DisplayUtil.getAdapter(display);
        adapter.preserve(PROP_ACTIVE_KEYS, ActiveKeysUtil.getActiveKeys(display));
    }

    public static void preserveActiveKeys(Control control) {
        ControlRemoteAdapter adapter = (ControlRemoteAdapter)WidgetUtil.getAdapter(control);
        if (!adapter.hasPreservedActiveKeys()) {
            adapter.preserveActiveKeys(ActiveKeysUtil.getActiveKeys(control));
        }
    }

    public static void preserveCancelKeys(Display display) {
        RemoteAdapter adapter = DisplayUtil.getAdapter(display);
        adapter.preserve(PROP_CANCEL_KEYS, ActiveKeysUtil.getCancelKeys(display));
    }

    public static void preserveCancelKeys(Control control) {
        ControlRemoteAdapter adapter = (ControlRemoteAdapter)WidgetUtil.getAdapter(control);
        if (!adapter.hasPreservedCancelKeys()) {
            adapter.preserveCancelKeys(ActiveKeysUtil.getCancelKeys(control));
        }
    }

    public static void renderActiveKeys(Display display) {
        if (!display.isDisposed()) {
            Object[] preserved;
            RemoteAdapter adapter = DisplayUtil.getAdapter(display);
            Object[] actual = ActiveKeysUtil.getActiveKeys(display);
            if (!Arrays.equals(actual, preserved = (String[])adapter.getPreserved(PROP_ACTIVE_KEYS))) {
                RemoteObjectFactory.getRemoteObject(display).set(PROP_ACTIVE_KEYS, ActiveKeysUtil.translateKeySequences((String[])actual));
            }
        }
    }

    public static void renderActiveKeys(Control control) {
        Object[] preserved;
        Object[] actual;
        ControlRemoteAdapter adapter;
        if (!control.isDisposed() && (adapter = (ControlRemoteAdapter)WidgetUtil.getAdapter(control)).hasPreservedActiveKeys() && !Arrays.equals(actual = ActiveKeysUtil.getActiveKeys(control), preserved = adapter.getPreservedActiveKeys())) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_ACTIVE_KEYS, ActiveKeysUtil.translateKeySequences((String[])actual));
        }
    }

    public static void renderCancelKeys(Display display) {
        if (!display.isDisposed()) {
            Object[] preserved;
            RemoteAdapter adapter = DisplayUtil.getAdapter(display);
            Object[] actual = ActiveKeysUtil.getCancelKeys(display);
            if (!Arrays.equals(actual, preserved = (String[])adapter.getPreserved(PROP_CANCEL_KEYS))) {
                RemoteObjectFactory.getRemoteObject(display).set(PROP_CANCEL_KEYS, ActiveKeysUtil.translateKeySequences((String[])actual));
            }
        }
    }

    public static void renderCancelKeys(Control control) {
        Object[] preserved;
        Object[] actual;
        ControlRemoteAdapter adapter;
        if (!control.isDisposed() && (adapter = (ControlRemoteAdapter)WidgetUtil.getAdapter(control)).hasPreservedCancelKeys() && !Arrays.equals(actual = ActiveKeysUtil.getCancelKeys(control), preserved = adapter.getPreservedCancelKeys())) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_CANCEL_KEYS, ActiveKeysUtil.translateKeySequences((String[])actual));
        }
    }

    public static void preserveMnemonicActivator(Display display) {
        RemoteAdapter adapter = DisplayUtil.getAdapter(display);
        adapter.preserve(PROP_MNEMONIC_ACTIVATOR, ActiveKeysUtil.getMnemonicActivator(display));
    }

    public static void renderMnemonicActivator(Display display) {
        if (!display.isDisposed()) {
            String preserved;
            RemoteAdapter adapter = DisplayUtil.getAdapter(display);
            String actual = ActiveKeysUtil.getMnemonicActivator(display);
            if (!ActiveKeysUtil.equals(actual, preserved = (String)adapter.getPreserved(PROP_MNEMONIC_ACTIVATOR))) {
                RemoteObjectFactory.getRemoteObject(display).set(PROP_MNEMONIC_ACTIVATOR, ActiveKeysUtil.getModifierKeys(actual));
            }
        }
    }

    private static String[] getActiveKeys(Display display) {
        Object data = display.getData("org.eclipse.rap.rwt.activeKeys");
        String[] result = null;
        if (data != null) {
            if (data instanceof String[]) {
                result = ActiveKeysUtil.getArrayCopy((String[])data);
            } else {
                String mesg = "Illegal value for RWT.ACTIVE_KEYS in display data, must be a string array";
                throw new IllegalArgumentException(mesg);
            }
        }
        return result;
    }

    private static String[] getActiveKeys(Control control) {
        Object data = control.getData("org.eclipse.rap.rwt.activeKeys");
        return data != null ? ActiveKeysUtil.getArrayCopy((String[])data) : null;
    }

    private static String[] getCancelKeys(Display display) {
        String[] result = null;
        Object data = display.getData("org.eclipse.rap.rwt.cancelKeys");
        if (data != null) {
            if (data instanceof String[]) {
                result = ActiveKeysUtil.getArrayCopy((String[])data);
            } else {
                String mesg = "Illegal value for RWT.CANCEL_KEYS in display data, must be a string array";
                throw new IllegalArgumentException(mesg);
            }
        }
        return result;
    }

    private static String[] getCancelKeys(Control control) {
        Object data = control.getData("org.eclipse.rap.rwt.cancelKeys");
        return data != null ? ActiveKeysUtil.getArrayCopy((String[])data) : null;
    }

    private static String getMnemonicActivator(Display display) {
        Object result = null;
        Object data = display.getData("org.eclipse.rap.rwt.mnemonicActivator");
        if (data != null) {
            if (data instanceof String) {
                result = (String)data;
                if (!((String)result).endsWith("+")) {
                    result = (String)result + "+";
                }
            } else {
                String mesg = "Illegal value for RWT.MNEMONIC_ACTIVATOR in display data, must be a string";
                throw new IllegalArgumentException(mesg);
            }
        }
        return result;
    }

    private static JsonArray translateKeySequences(String[] activeKeys) {
        JsonArray result = new JsonArray();
        if (activeKeys != null) {
            int i = 0;
            while (i < activeKeys.length) {
                result.add(ActiveKeysUtil.translateKeySequence(activeKeys[i]));
                ++i;
            }
        }
        return result;
    }

    private static String translateKeySequence(String keySequence) {
        if (keySequence == null) {
            throw new NullPointerException("Null argument");
        }
        if (keySequence.trim().length() == 0) {
            throw new IllegalArgumentException("Empty key sequence definition found");
        }
        String modifierPart = "";
        String keyPart = "";
        int lastPlusIndex = keySequence.lastIndexOf("+", keySequence.length() - 2);
        if (lastPlusIndex != -1) {
            modifierPart = keySequence.substring(0, lastPlusIndex + 1);
            keyPart = keySequence.substring(lastPlusIndex + 1);
        } else {
            keyPart = keySequence;
        }
        return ActiveKeysUtil.getModifierKeys(modifierPart) + ActiveKeysUtil.formatKey(keyPart);
    }

    private static String formatKey(String key) {
        int keyCode = ActiveKeysUtil.getKeyCode(key);
        return keyCode == -1 ? key : "#" + keyCode;
    }

    private static String getModifierKeys(String modifier) {
        StringBuilder result = new StringBuilder();
        if (modifier.indexOf(ALT) != -1) {
            result.append(ALT);
        }
        if (modifier.indexOf(CTRL) != -1) {
            result.append(CTRL);
        }
        if (modifier.indexOf(SHIFT) != -1) {
            result.append(SHIFT);
        }
        if (modifier.length() != result.length()) {
            throw new IllegalArgumentException("Unrecognized modifier found in key sequence: " + modifier);
        }
        return result.toString();
    }

    private static int getKeyCode(String key) {
        int result = -1;
        Integer value = KEY_MAP.get(key);
        if (value instanceof Integer) {
            result = value;
        } else if (key.length() == 1) {
            if (Character.isLetterOrDigit(key.charAt(0))) {
                result = key.toUpperCase().charAt(0);
            }
        } else {
            throw new IllegalArgumentException("Unrecognized key: " + key);
        }
        return result;
    }

    private static String[] getArrayCopy(String[] data) {
        return Arrays.copyOf(data, data.length);
    }

    private static boolean equals(Object object1, Object object2) {
        boolean result = object1 == object2 ? true : (object1 == null ? false : object1.equals(object2));
        return result;
    }
}

