/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.UISessionEvent;
import org.eclipse.rap.rwt.service.UISessionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IIdentifierListener;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.commands.CommandPersistence;
import org.eclipse.ui.internal.commands.CommandService;
import org.eclipse.ui.internal.expressions.AlwaysEnabledExpression;
import org.eclipse.ui.internal.handlers.HandlerPersistence;
import org.eclipse.ui.internal.handlers.HandlerProxy;
import org.eclipse.ui.internal.handlers.HandlerService;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.menus.AbstractMenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.ContributionRoot;
import org.eclipse.ui.internal.menus.InternalMenuService;
import org.eclipse.ui.internal.menus.MenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.MenuLocationURI;
import org.eclipse.ui.internal.menus.MenuPersistence;
import org.eclipse.ui.internal.menus.ProxyMenuAdditionCacheEntry;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.services.IEvaluationReference;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

public final class WorkbenchMenuService
extends InternalMenuService {
    private static final String INDEX_AFTER_ADDITIONS = "after=additions";
    private static final String PROP_VISIBLE = "visible";
    private final MenuPersistence menuPersistence;
    private IEvaluationService evaluationService;
    private IPropertyChangeListener serviceListener;
    private IServiceLocator serviceLocator;
    private IActivityManagerListener activityManagerListener;
    private Map uriToFactories = new HashMap();
    private Map evaluationsByItem = new HashMap();
    private Map activityListenersByItem = new HashMap();
    private Set managersAwaitingUpdates = new HashSet();
    private HashMap populatedManagers = new HashMap();
    private IRegistryChangeListener registryChangeListener;

    public WorkbenchMenuService(IServiceLocator serviceLocator) {
        this.menuPersistence = new MenuPersistence(this);
        this.serviceLocator = serviceLocator;
        this.evaluationService = serviceLocator.getService(IEvaluationService.class);
        this.evaluationService.addServiceListener(this.getServiceListener());
        final IWorkbenchLocationService wls = serviceLocator.getService(IWorkbenchLocationService.class);
        wls.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener(this.getActivityManagerListener());
        final IExtensionRegistry registry = Platform.getExtensionRegistry();
        final IRegistryChangeListener registryChangeListener = new IRegistryChangeListener(){

            public void registryChanged(final IRegistryChangeEvent event) {
                wls.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkbenchMenuService.this.handleRegistryChanges(event);
                    }
                });
            }
        };
        registry.addRegistryChangeListener(registryChangeListener);
        RWT.getUISession().addUISessionListener(new UISessionListener(){

            public void beforeDestroy(UISessionEvent event) {
                registry.removeRegistryChangeListener(registryChangeListener);
            }
        });
    }

    private IActivityManagerListener getActivityManagerListener() {
        if (this.activityManagerListener == null) {
            this.activityManagerListener = new IActivityManagerListener(){

                @Override
                public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
                    if (activityManagerEvent.haveEnabledActivityIdsChanged()) {
                        WorkbenchMenuService.this.updateManagers();
                    }
                }
            };
        }
        return this.activityManagerListener;
    }

    private IPropertyChangeListener getServiceListener() {
        if (this.serviceListener == null) {
            this.serviceListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("org.eclipse.ui.services.notifying") && !((Boolean)event.getNewValue()).booleanValue()) {
                        WorkbenchMenuService.this.updateManagers();
                    }
                }
            };
        }
        return this.serviceListener;
    }

    public void updateManagers() {
        Object[] managers = this.managersAwaitingUpdates.toArray();
        this.managersAwaitingUpdates.clear();
        int i = 0;
        while (i < managers.length) {
            IContributionManager parent;
            IContributionManager mgr = (IContributionManager)managers[i];
            mgr.update(true);
            if (mgr instanceof ToolBarManager) {
                if (!this.updateCoolBar((ToolBarManager)mgr)) {
                    this.updateTrim((ToolBarManager)mgr);
                }
            } else if (mgr instanceof MenuManager && (parent = ((MenuManager)mgr).getParent()) != null) {
                parent.update(true);
            }
            ++i;
        }
    }

    private void updateTrim(ToolBarManager mgr) {
        ToolBar control = mgr.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        LayoutUtil.resize((Control)control);
    }

    private boolean updateCoolBar(ToolBarManager mgr) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            WorkbenchWindow window = (WorkbenchWindow)windows[i];
            ICoolBarManager cb = window.getCoolBarManager2();
            if (cb != null) {
                IContributionItem[] items = cb.getItems();
                int j = 0;
                while (j < items.length) {
                    IToolBarManager tbm;
                    if (items[j] instanceof ToolBarContributionItem && mgr == (tbm = ((ToolBarContributionItem)items[j]).getToolBarManager())) {
                        cb.update(true);
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public final void addSourceProvider(ISourceProvider provider) {
    }

    @Override
    public final void dispose() {
        IWorkbenchLocationService wls;
        IWorkbench workbench;
        this.menuPersistence.dispose();
        if (this.registryChangeListener != null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.removeRegistryChangeListener(this.registryChangeListener);
            this.registryChangeListener = null;
        }
        for (IEvaluationReference ref : this.evaluationsByItem.values()) {
            this.evaluationService.removeEvaluationListener(ref);
        }
        this.evaluationsByItem.clear();
        this.managersAwaitingUpdates.clear();
        if (this.serviceListener != null) {
            this.evaluationService.removeServiceListener(this.serviceListener);
            this.serviceListener = null;
        }
        if (this.activityManagerListener != null && (workbench = (wls = this.serviceLocator.getService(IWorkbenchLocationService.class)).getWorkbench()) != null) {
            workbench.getActivitySupport().getActivityManager().removeActivityManagerListener(this.activityManagerListener);
        }
    }

    public final void readRegistry() {
        this.menuPersistence.read();
    }

    @Override
    public final void removeSourceProvider(ISourceProvider provider) {
    }

    private String getIdFromURI(MenuLocationURI uri) {
        return uri.getScheme() + ":" + uri.getPath();
    }

    @Override
    public List getAdditionsForURI(MenuLocationURI uri) {
        if (uri == null) {
            return null;
        }
        ArrayList caches = (ArrayList)this.uriToFactories.get(this.getIdFromURI(uri));
        if (caches == null) {
            caches = new ArrayList();
            this.uriToFactories.put(this.getIdFromURI(uri), caches);
        }
        return caches;
    }

    @Override
    public void addContributionFactory(AbstractContributionFactory factory) {
        if (factory == null || factory.getLocation() == null) {
            return;
        }
        MenuLocationURI uri = new MenuLocationURI(factory.getLocation());
        String factoryId = this.getIdFromURI(uri);
        ArrayList<AbstractContributionFactory> factories = (ArrayList<AbstractContributionFactory>)this.uriToFactories.get(factoryId);
        if (factories == null) {
            factories = new ArrayList<AbstractContributionFactory>();
            this.uriToFactories.put(factoryId, factories);
        }
        if (factory instanceof MenuAdditionCacheEntry && ((MenuAdditionCacheEntry)factory).hasAdditions()) {
            factories.add(0, factory);
        } else {
            factories.add(factory);
        }
        ArrayList<AbstractContributionFactory> factoryList = new ArrayList<AbstractContributionFactory>();
        factoryList.add(factory);
        List affectedManagers = this.getManagersFor(factoryId);
        for (ContributionManager mgr : affectedManagers) {
            ManagerPopulationRecord mpr = (ManagerPopulationRecord)this.populatedManagers.get(mgr);
            this.addContributionsToManager(mpr.serviceLocatorToUse, mpr.restriction, mgr, mpr.uri, mpr.recurse, factoryList);
            mgr.update(true);
        }
    }

    private List getManagersFor(String factoryId) {
        ArrayList<ContributionManager> mgrs = new ArrayList<ContributionManager>();
        for (ContributionManager mgr : this.populatedManagers.keySet()) {
            ManagerPopulationRecord mpr = (ManagerPopulationRecord)this.populatedManagers.get(mgr);
            if (!factoryId.equals(mpr.uri)) continue;
            mgrs.add(mgr);
        }
        return mgrs;
    }

    @Override
    public void removeContributionFactory(AbstractContributionFactory factory) {
        if (factory == null || factory.getLocation() == null) {
            return;
        }
        MenuLocationURI uri = new MenuLocationURI(factory.getLocation());
        String factoryId = this.getIdFromURI(uri);
        List factories = (List)this.uriToFactories.get(factoryId);
        if (factories != null) {
            List subCaches;
            if (factory instanceof MenuAdditionCacheEntry && (subCaches = ((MenuAdditionCacheEntry)factory).getSubCaches()) != null) {
                for (AbstractMenuAdditionCacheEntry mace : subCaches) {
                    this.removeContributionFactory(mace);
                }
            }
            factories.remove(factory);
        }
        ArrayList<AbstractContributionFactory> factoryList = new ArrayList<AbstractContributionFactory>();
        factoryList.add(factory);
        List affectedManagers = this.getManagersFor(factoryId);
        for (ContributionManager mgr : affectedManagers) {
            this.removeContributionsForFactory((IContributionManager)mgr, factory);
            mgr.update(true);
        }
    }

    private boolean processAdditions(final IServiceLocator serviceLocatorToUse, Set restriction, final ContributionManager mgr, final AbstractContributionFactory cache, final Set itemsAdded) {
        if (!this.processFactory(mgr, cache)) {
            return true;
        }
        final int idx = this.getInsertionIndex(mgr, cache.getLocation());
        if (idx == -1) {
            return false;
        }
        final ContributionRoot ciList = new ContributionRoot(this, restriction, mgr, cache);
        ISafeRunnable run = new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                int insertionIndex = idx;
                cache.createContributionItems(serviceLocatorToUse, ciList);
                if (ciList.getItems().size() > 0) {
                    ManagerPopulationRecord mpr = (ManagerPopulationRecord)WorkbenchMenuService.this.populatedManagers.get(mgr);
                    ContributionRoot contributions = mpr.getContributions(cache);
                    if (contributions != null) {
                        for (IContributionItem item : contributions.getItems()) {
                            if (!item.equals(mgr.find(item.getId()))) continue;
                            --insertionIndex;
                        }
                    }
                    mpr.addFactoryContribution(cache, ciList);
                    for (IContributionItem ici : ciList.getItems()) {
                        if ((ici instanceof ContributionManager || ici instanceof IToolBarContributionItem || ici instanceof AbstractGroupMarker) && ici.getId() != null && !"".equals(ici.getId())) {
                            IContributionItem foundIci = mgr.find(ici.getId());
                            if (foundIci instanceof ContributionManager) {
                                if (((ContributionManager)ici).getSize() <= 0) continue;
                                Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, "Menu contribution id collision: " + ici.getId());
                                StatusManager.getManager().handle((IStatus)status);
                                continue;
                            }
                            if (foundIci instanceof IToolBarContributionItem) {
                                IToolBarManager toolBarManager = ((IToolBarContributionItem)ici).getToolBarManager();
                                if (!(toolBarManager instanceof ContributionManager) || ((ContributionManager)toolBarManager).getSize() <= 0) continue;
                                Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, "Toolbar contribution id collision: " + ici.getId());
                                StatusManager.getManager().handle((IStatus)status);
                                continue;
                            }
                            if (foundIci instanceof AbstractGroupMarker) continue;
                        }
                        int oldSize = mgr.getSize();
                        mgr.insert(insertionIndex, ici);
                        if (ici.getId() != null) {
                            itemsAdded.add(ici.getId());
                        }
                        if (mgr.getSize() <= oldSize) continue;
                        ++insertionIndex;
                    }
                }
            }
        };
        SafeRunner.run((ISafeRunnable)run);
        return true;
    }

    private boolean processFactory(ContributionManager mgr, AbstractContributionFactory factory) {
        MenuLocationURI uri = new MenuLocationURI(factory.getLocation());
        if ("popup:org.eclipse.ui.popup.any".equals(uri.getScheme() + ":" + uri.getPath()) && mgr.indexOf("additions") == -1 && factory instanceof MenuAdditionCacheEntry) {
            MenuAdditionCacheEntry menuEntry = (MenuAdditionCacheEntry)factory;
            return menuEntry.contributeToAllPopups();
        }
        return true;
    }

    protected void removeContributionsForFactory(IContributionManager manager, AbstractContributionFactory factory) {
        ManagerPopulationRecord mpr = (ManagerPopulationRecord)this.populatedManagers.get(manager);
        mpr.removeFactoryContribution(factory);
    }

    private void releaseCache(ContributionRoot items) {
        items.release();
    }

    @Override
    public void populateContributionManager(ContributionManager mgr, String uri) {
        this.populateContributionManager(this.serviceLocator, null, mgr, uri, true);
    }

    @Override
    public void populateContributionManager(IServiceLocator serviceLocatorToUse, Set restriction, ContributionManager mgr, String uri, boolean recurse) {
        ManagerPopulationRecord mpr = (ManagerPopulationRecord)this.populatedManagers.get(mgr);
        if (mpr == null) {
            mpr = new ManagerPopulationRecord(serviceLocatorToUse, restriction, uri, recurse);
            this.populatedManagers.put(mgr, mpr);
        }
        MenuLocationURI contributionLocation = new MenuLocationURI(uri);
        List factories = this.getAdditionsForURI(contributionLocation);
        this.addContributionsToManager(serviceLocatorToUse, restriction, mgr, uri, recurse, factories);
    }

    public void addContributionsToManager(IServiceLocator serviceLocatorToUse, Set restriction, ContributionManager mgr, String uri, boolean recurse, List factories) {
        MenuLocationURI contributionLocation = new MenuLocationURI(uri);
        ArrayList<AbstractContributionFactory> retryList = new ArrayList<AbstractContributionFactory>();
        HashSet itemsAdded = new HashSet();
        for (AbstractContributionFactory cache : factories) {
            if (this.processAdditions(serviceLocatorToUse, restriction, mgr, cache, itemsAdded)) continue;
            retryList.add(cache);
        }
        boolean done = retryList.size() == 0;
        while (!done) {
            ArrayList curRetry = new ArrayList(retryList);
            int retryCount = retryList.size();
            retryList.clear();
            for (AbstractContributionFactory cache : curRetry) {
                if (this.processAdditions(serviceLocatorToUse, restriction, mgr, cache, itemsAdded)) continue;
                retryList.add(cache);
            }
            boolean bl = done = retryList.size() == 0 || retryList.size() == retryCount;
        }
        IContributionItem[] curItems = mgr.getItems();
        int i = 0;
        while (i < curItems.length) {
            IToolBarContributionItem tbci;
            if (curItems[i] instanceof ContributionManager) {
                String id = curItems[i].getId();
                if (id != null && id.length() > 0 && (recurse || itemsAdded.contains(id))) {
                    this.populateContributionManager(serviceLocatorToUse, restriction, (ContributionManager)curItems[i], contributionLocation.getScheme() + ":" + id, true);
                }
            } else if (curItems[i] instanceof IToolBarContributionItem && (tbci = (IToolBarContributionItem)curItems[i]).getId() != null && tbci.getId().length() > 0 && (recurse || itemsAdded.contains(tbci.getId()))) {
                this.populateContributionManager(serviceLocatorToUse, restriction, (ContributionManager)tbci.getToolBarManager(), contributionLocation.getScheme() + ":" + tbci.getId(), true);
            }
            ++i;
        }
    }

    private int getInsertionIndex(ContributionManager mgr, String location) {
        MenuLocationURI uri = new MenuLocationURI(location);
        String query = uri.getQuery();
        int additionsIndex = -1;
        if (query.length() == 0 || query.equals(INDEX_AFTER_ADDITIONS)) {
            additionsIndex = mgr.indexOf("additions");
            additionsIndex = additionsIndex == -1 ? mgr.getItems().length : ++additionsIndex;
        } else {
            String[] queryParts = Util.split(query, '=');
            if (queryParts.length > 1 && queryParts[1].length() > 0) {
                String modifier = queryParts[0];
                String id = queryParts[1];
                additionsIndex = mgr.indexOf(id);
                if (additionsIndex != -1 && !"before".equals(modifier)) {
                    if ("after".equals(modifier)) {
                        ++additionsIndex;
                    } else if ("endof".equals(modifier)) {
                        IContributionItem[] items = mgr.getItems();
                        ++additionsIndex;
                        while (additionsIndex < items.length) {
                            if (items[additionsIndex].isGroupMarker()) break;
                            ++additionsIndex;
                        }
                    }
                }
            }
        }
        return additionsIndex;
    }

    @Override
    public IEvaluationContext getCurrentState() {
        return this.evaluationService.getCurrentState();
    }

    @Override
    public void registerVisibleWhen(IContributionItem item, Expression visibleWhen, Set restriction, String identifierID) {
        if (item == null) {
            throw new IllegalArgumentException("item cannot be null");
        }
        if (visibleWhen == null) {
            throw new IllegalArgumentException("visibleWhen expression cannot be null");
        }
        if (this.evaluationsByItem.get(item) != null) {
            String id = item.getId();
            WorkbenchPlugin.log("item is already registered: " + (id == null ? "no id" : id));
            return;
        }
        IIdentifier identifier = null;
        if (identifierID != null) {
            identifier = PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getIdentifier(identifierID);
        }
        ContributionItemUpdater listener = new ContributionItemUpdater(item, identifier);
        if (visibleWhen != AlwaysEnabledExpression.INSTANCE) {
            IEvaluationReference ref = this.evaluationService.addEvaluationListener(visibleWhen, listener, PROP_VISIBLE);
            if (restriction != null) {
                restriction.add(ref);
            }
            this.evaluationsByItem.put(item, ref);
        }
        this.activityListenersByItem.put(item, listener);
    }

    @Override
    public void unregisterVisibleWhen(IContributionItem item, Set restriction) {
        IEvaluationReference ref;
        ContributionItemUpdater identifierListener = (ContributionItemUpdater)this.activityListenersByItem.remove(item);
        if (identifierListener != null) {
            identifierListener.dispose();
        }
        if ((ref = (IEvaluationReference)this.evaluationsByItem.remove(item)) == null) {
            return;
        }
        this.evaluationService.removeEvaluationListener(ref);
        if (restriction != null) {
            restriction.remove(ref);
        }
    }

    protected void releaseContributions(ContributionRoot items) {
        ContributionManager mgr = items.getManager();
        for (IContributionItem item : items.getItems()) {
            this.releaseItem(item, items.restriction);
            mgr.remove(item);
        }
        this.releaseCache(items);
    }

    @Override
    public void releaseContributions(ContributionManager mgr) {
        if (mgr == null) {
            return;
        }
        IContributionItem[] items = mgr.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof ContributionManager) {
                this.releaseContributions((ContributionManager)items[i]);
            } else if (items[i] instanceof IToolBarContributionItem) {
                IToolBarContributionItem tbci = (IToolBarContributionItem)items[i];
                this.releaseContributions((ContributionManager)tbci.getToolBarManager());
            }
            ++i;
        }
        ManagerPopulationRecord mpr = (ManagerPopulationRecord)this.populatedManagers.remove(mgr);
        if (mpr != null) {
            mpr.releaseContributions();
        }
        this.managersAwaitingUpdates.remove(mgr);
    }

    private void releaseItem(IContributionItem item, Set restriction) {
        this.unregisterVisibleWhen(item, restriction);
        if (item instanceof ContributionManager) {
            this.releaseContributions((ContributionManager)item);
        } else if (item instanceof IToolBarContributionItem) {
            IToolBarContributionItem tbci = (IToolBarContributionItem)item;
            this.releaseContributions((ContributionManager)tbci.getToolBarManager());
        }
    }

    public void handleDynamicAdditions(List menuAdditions) {
        Iterator additionsIter = menuAdditions.iterator();
        while (additionsIter.hasNext()) {
            AbstractMenuAdditionCacheEntry newFactory = null;
            IConfigurationElement menuAddition = (IConfigurationElement)additionsIter.next();
            newFactory = this.isProgramaticContribution(menuAddition) ? new ProxyMenuAdditionCacheEntry(menuAddition.getAttribute("locationURI"), menuAddition.getNamespaceIdentifier(), menuAddition) : new MenuAdditionCacheEntry(this, menuAddition, menuAddition.getAttribute("locationURI"), menuAddition.getNamespaceIdentifier());
            if (newFactory == null) continue;
            this.addContributionFactory(newFactory);
        }
    }

    private boolean isProgramaticContribution(IConfigurationElement menuAddition) {
        return menuAddition.getAttribute("class") != null;
    }

    public void handleDynamicRemovals(List menuRemovals) {
        for (IConfigurationElement ceToRemove : menuRemovals) {
            AbstractMenuAdditionCacheEntry factoryToRemove = this.findFactory(ceToRemove);
            this.removeContributionFactory(factoryToRemove);
        }
    }

    private AbstractMenuAdditionCacheEntry findFactory(IConfigurationElement ceToRemove) {
        String uriStr = ceToRemove.getAttribute("locationURI");
        MenuLocationURI uri = new MenuLocationURI(uriStr);
        List factories = this.getAdditionsForURI(uri);
        for (AbstractContributionFactory factory : factories) {
            AbstractMenuAdditionCacheEntry mace;
            if (!(factory instanceof AbstractMenuAdditionCacheEntry) || !(mace = (AbstractMenuAdditionCacheEntry)factory).getConfigElement().equals((Object)ceToRemove)) continue;
            return mace;
        }
        return null;
    }

    private void handleMenuChanges(IRegistryChangeEvent event) {
        IExtensionDelta[] menuDeltas = event.getExtensionDeltas("org.eclipse.ui", "menus");
        ArrayList<IConfigurationElement> menuAdditions = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> menuRemovals = new ArrayList<IConfigurationElement>();
        int i = 0;
        while (i < menuDeltas.length) {
            IConfigurationElement[] ices = menuDeltas[i].getExtension().getConfigurationElements();
            int j = 0;
            while (j < ices.length) {
                if ("menuContribution".equals(ices[j].getName())) {
                    if (menuDeltas[i].getKind() == 1) {
                        menuAdditions.add(ices[j]);
                    } else {
                        menuRemovals.add(ices[j]);
                    }
                }
                ++j;
            }
            ++i;
        }
        if (menuAdditions.size() > 0) {
            this.handleDynamicAdditions(menuAdditions);
        }
        if (menuRemovals.size() > 0) {
            this.handleDynamicRemovals(menuRemovals);
        }
    }

    public void handleRegistryChanges(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas();
        if (deltas.length == 0) {
            return;
        }
        boolean isAddition = deltas[0].getKind() == 1;
        HandlerService handlerSvc = (HandlerService)this.serviceLocator.getService(IHandlerService.class);
        HandlerPersistence handlerPersistence = handlerSvc.getHandlerPersistence();
        CommandService cmdSvc = (CommandService)this.serviceLocator.getService(ICommandService.class);
        CommandPersistence cmdPersistence = cmdSvc.getCommandPersistence();
        boolean needsUpdate = false;
        if (isAddition) {
            if (cmdPersistence.commandsNeedUpdating(event)) {
                cmdPersistence.reRead();
                needsUpdate = true;
            }
            if (handlerPersistence.handlersNeedUpdating(event)) {
                handlerPersistence.reRead();
                needsUpdate = true;
            }
            if (this.menuPersistence.menusNeedUpdating(event)) {
                this.handleMenuChanges(event);
                needsUpdate = true;
            }
        } else {
            if (this.menuPersistence.menusNeedUpdating(event)) {
                this.handleMenuChanges(event);
                needsUpdate = true;
            }
            if (handlerPersistence.handlersNeedUpdating(event)) {
                IExtensionDelta[] handlerDeltas = event.getExtensionDeltas("org.eclipse.ui", "handlers");
                int i = 0;
                while (i < handlerDeltas.length) {
                    IConfigurationElement[] ices = handlerDeltas[i].getExtension().getConfigurationElements();
                    HandlerProxy.updateStaleCEs(ices);
                    ++i;
                }
                handlerPersistence.reRead();
                needsUpdate = true;
            }
            if (cmdPersistence.commandsNeedUpdating(event)) {
                cmdPersistence.reRead();
                needsUpdate = true;
            }
        }
        if (needsUpdate) {
            for (ContributionManager mgr : this.populatedManagers.keySet()) {
                mgr.update(true);
            }
        }
    }

    public MenuPersistence getMenuPersistence() {
        return this.menuPersistence;
    }

    @Override
    public void populateContributionManager(ContributionManager mgr, String uri, boolean recurse) {
        this.populateContributionManager(this.serviceLocator, null, mgr, uri, recurse);
    }

    private final class ContributionItemUpdater
    implements IPropertyChangeListener,
    IIdentifierListener {
        private final IContributionItem item;
        private IIdentifier identifier;
        private boolean lastExpressionResult = true;

        private ContributionItemUpdater(IContributionItem item, IIdentifier identifier) {
            this.item = item;
            if (identifier != null) {
                this.identifier = identifier;
                this.identifier.addIdentifierListener(this);
                this.updateVisibility();
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty() == WorkbenchMenuService.PROP_VISIBLE) {
                this.lastExpressionResult = event.getNewValue() != null ? (Boolean)event.getNewValue() : false;
                this.updateVisibility();
            }
        }

        private void updateVisibility() {
            boolean visible = this.identifier != null ? this.identifier.isEnabled() && this.lastExpressionResult : this.lastExpressionResult;
            this.item.setVisible(visible);
            IContributionManager parent = null;
            if (this.item instanceof ContributionItem) {
                parent = ((ContributionItem)this.item).getParent();
            } else if (this.item instanceof MenuManager) {
                parent = ((MenuManager)this.item).getParent();
            }
            if (parent != null) {
                parent.markDirty();
                WorkbenchMenuService.this.managersAwaitingUpdates.add(parent);
            }
        }

        @Override
        public void identifierChanged(IdentifierEvent identifierEvent) {
            this.updateVisibility();
        }

        public void dispose() {
            if (this.identifier != null) {
                this.identifier.removeIdentifierListener(this);
            }
        }
    }

    private final class ManagerPopulationRecord {
        public IServiceLocator serviceLocatorToUse;
        public Set restriction;
        public String uri;
        public boolean recurse;
        Map factoryToItems = new HashMap();

        public ManagerPopulationRecord(IServiceLocator serviceLocatorToUse, Set restriction, String uri, boolean recurse) {
            this.serviceLocatorToUse = serviceLocatorToUse;
            this.restriction = restriction;
            this.uri = uri;
            this.recurse = recurse;
        }

        public void addFactoryContribution(AbstractContributionFactory factory, ContributionRoot ciList) {
            this.removeFactoryContribution(factory);
            this.factoryToItems.put(factory, ciList);
        }

        public void removeFactoryContribution(AbstractContributionFactory factory) {
            ContributionRoot items = (ContributionRoot)this.factoryToItems.remove(factory);
            if (items != null) {
                WorkbenchMenuService.this.releaseContributions(items);
            }
        }

        public ContributionRoot getContributions(AbstractContributionFactory factory) {
            return (ContributionRoot)this.factoryToItems.get(factory);
        }

        public void releaseContributions() {
            Collection cRoots = this.factoryToItems.values();
            for (ContributionRoot items : cRoots) {
                WorkbenchMenuService.this.releaseContributions(items);
            }
            this.factoryToItems.clear();
        }
    }
}

