/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Resource;

public class Transform
extends Resource {
    private static final float[] IDENTITY_MATRIX = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    private float[] elements;

    public Transform(Device device) {
        this(device, IDENTITY_MATRIX);
    }

    public Transform(Device device, float[] elements) {
        this(device, Transform.checkTransform(elements)[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
    }

    public Transform(Device device, float m11, float m12, float m21, float m22, float dx, float dy) {
        super(device);
        this.elements = new float[]{m11, m12, m21, m22, dx, dy};
    }

    static float[] checkTransform(float[] elements) {
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        return elements;
    }

    @Override
    void destroy() {
        this.elements = null;
    }

    public void getElements(float[] elements) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        System.arraycopy(this.elements, 0, elements, 0, 6);
    }

    public void setElements(float m11, float m12, float m21, float m22, float dx, float dy) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.elements = new float[]{m11, m12, m21, m22, dx, dy};
    }

    public void identity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        System.arraycopy(IDENTITY_MATRIX, 0, this.elements, 0, 6);
    }

    public boolean isIdentity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return Arrays.equals(this.elements, IDENTITY_MATRIX);
    }

    public void invert() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        float d = this.elements[0] * this.elements[3] - this.elements[1] * this.elements[2];
        this.elements = new float[]{this.elements[3] / d, -this.elements[1] / d, -this.elements[2] / d, this.elements[0] / d, (this.elements[2] * this.elements[5] - this.elements[4] * this.elements[3]) / d, (this.elements[4] * this.elements[1] - this.elements[5] * this.elements[0]) / d};
    }

    public void multiply(Transform matrix) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (matrix == null) {
            SWT.error(4);
        }
        if (matrix.isDisposed()) {
            SWT.error(5);
        }
        float[] elements = new float[6];
        matrix.getElements(elements);
        this.multiply(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
    }

    public void translate(float offsetX, float offsetY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.multiply(1.0f, 0.0f, 0.0f, 1.0f, offsetX, offsetY);
    }

    public void scale(float scaleX, float scaleY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.multiply(scaleX, 0.0f, 0.0f, scaleY, 0.0f, 0.0f);
    }

    public void rotate(float angle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        double radians = Math.toRadians(angle);
        float m11 = (float)Math.cos(radians);
        float m12 = (float)Math.sin(radians);
        float m21 = -((float)Math.sin(radians));
        float m22 = (float)Math.cos(radians);
        this.multiply(m11, m12, m21, m22, 0.0f, 0.0f);
    }

    public void shear(float shearX, float shearY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.multiply(1.0f, shearY, shearX, 1.0f, 0.0f, 0.0f);
    }

    public void transform(float[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        int i = 1;
        while (i < pointArray.length) {
            float dx = pointArray[i - 1];
            float dy = pointArray[i];
            pointArray[i - 1] = this.elements[0] * dx + this.elements[2] * dy + this.elements[4];
            pointArray[i] = this.elements[1] * dx + this.elements[3] * dy + this.elements[5];
            i += 2;
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Transform {*DISPOSED*}";
        }
        return "Transform {" + this.elements[0] + "," + this.elements[1] + "," + this.elements[2] + "," + this.elements[3] + "," + this.elements[4] + "," + this.elements[5] + "}";
    }

    private void multiply(float m11, float m12, float m21, float m22, float dx, float dy) {
        this.elements = new float[]{this.elements[0] * m11 + this.elements[2] * m12, this.elements[1] * m11 + this.elements[3] * m12, this.elements[0] * m21 + this.elements[2] * m22, this.elements[1] * m21 + this.elements[3] * m22, this.elements[0] * dx + this.elements[2] * dy + this.elements[4], this.elements[1] * dx + this.elements[3] * dy + this.elements[5]};
    }
}

