/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.eclipse.persistence.jpa.jpql.AbstractValidator;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPAVersion;
import org.eclipse.persistence.jpa.jpql.JPQLQueryDeclaration;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractConditionalClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractDoubleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractOrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTraverseParentVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTripleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AggregateFunction;
import org.eclipse.persistence.jpa.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.CompoundExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpression;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LogicalExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.OnClause;
import org.eclipse.persistence.jpa.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.QueryPosition;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.eclipse.persistence.jpa.jpql.tools.ContentAssistExtension;
import org.eclipse.persistence.jpa.jpql.tools.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.tools.DefaultContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.tools.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.tools.TypeHelper;
import org.eclipse.persistence.jpa.jpql.tools.resolver.Declaration;
import org.eclipse.persistence.jpa.jpql.tools.resolver.Resolver;
import org.eclipse.persistence.jpa.jpql.tools.resolver.StateFieldResolver;
import org.eclipse.persistence.jpa.jpql.tools.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.utility.filter.AndFilter;
import org.eclipse.persistence.jpa.jpql.utility.CollectionTools;
import org.eclipse.persistence.jpa.jpql.utility.filter.Filter;
import org.eclipse.persistence.jpa.jpql.utility.filter.NullFilter;

public abstract class AbstractContentAssistVisitor
extends AnonymousExpressionVisitor {
    protected Stack<Integer> corrections;
    protected Map<Class<?>, Object> helpers;
    protected Map<String, Filter<Expression>> identifierFilters;
    protected Stack<Expression> lockedExpressions;
    protected DefaultContentAssistProposals proposals;
    protected final JPQLQueryContext queryContext;
    protected QueryPosition queryPosition;
    protected Stack<Integer> virtualSpaces;
    protected String word;
    protected WordParser wordParser;
    protected static final Filter<Expression> INVALID_IDENTIFIER_FILTER = new Filter<Expression>(){

        @Override
        public boolean accept(Expression expression) {
            return false;
        }
    };
    protected static final int SPACE_LENGTH = 1;
    protected static final Filter<Expression> VALID_IDENTIFIER_FILTER = new Filter<Expression>(){

        @Override
        public boolean accept(Expression expression) {
            return true;
        }
    };

    protected AbstractContentAssistVisitor(JPQLQueryContext queryContext) {
        Assert.isNotNull(queryContext, "The JPQLQueryContext cannot be null");
        this.queryContext = queryContext;
        this.initialize();
    }

    protected void addAggregateIdentifier(String identifier) {
        if (this.isAggregate(identifier)) {
            this.addIdentifier(identifier);
        }
    }

    protected void addAggregateIdentifiers(JPQLQueryBNF queryBNF) {
        for (String identifier : queryBNF.getIdentifiers()) {
            this.addAggregateIdentifier(identifier);
        }
    }

    protected void addAggregateIdentifiers(String queryBNFId) {
        this.addAggregateIdentifiers(this.getQueryBNF(queryBNFId));
    }

    protected void addArithmeticIdentifiers() {
        if (this.word.length() == 0) {
            this.addExpressionFactoryIdentifiers("*/-+");
        }
    }

    protected void addClauseIdentifier(String identifier) {
        if (this.isClause(identifier)) {
            this.addIdentifier(identifier);
        }
    }

    protected void addClauseIdentifiers(JPQLQueryBNF queryBNF) {
        for (String identifier : queryBNF.getIdentifiers()) {
            this.addClauseIdentifier(identifier);
        }
    }

    protected void addClauseIdentifiers(String queryBNFId) {
        this.addClauseIdentifiers(this.getQueryBNF(queryBNFId));
    }

    protected void addComparisonIdentifiers(Expression expression) {
        if (this.word.length() == 0) {
            String[] stringArray = this.getExpressionFactory("comparison").identifiers();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String identifier = stringArray[n2];
                Filter<Expression> filter = this.getFilter(identifier);
                if (filter.accept(expression)) {
                    this.addIdentifier(identifier);
                }
                ++n2;
            }
        }
    }

    protected void addCompositeIdentifier(String identifier, int offset) {
        if (this.word.length() == 0 && offset == -1) {
            this.addIdentifier(identifier);
        } else if (this.isValidVersion(identifier)) {
            offset = Math.max(offset, 0);
            int position = this.queryPosition.getPosition();
            int index = identifier.length();
            while (--index > offset) {
                char character;
                String fragment = identifier.substring(0, index);
                if (!this.wordParser.endsWithIgnoreCase(position, fragment) || !Character.isWhitespace(character = this.wordParser.character(position - fragment.length() - 1))) continue;
                this.proposals.addIdentifier(identifier);
                break;
            }
        }
    }

    protected void addCompoundIdentifier(String identifier, Expression expression, boolean hasIs, boolean hasNot) {
        if (this.isCompoundFunction(identifier)) {
            Filter<Expression> filter = this.getFilter(identifier);
            if (hasIs && !hasNot) {
                if (identifier.startsWith("IS ") && filter.accept(expression)) {
                    this.addCompositeIdentifier(identifier, 0);
                }
            } else if (!hasIs && hasNot) {
                if (identifier.startsWith("NOT ") && filter.accept(expression)) {
                    this.addCompositeIdentifier(identifier, 0);
                }
            } else if (hasIs && hasNot) {
                if (identifier.startsWith("IS NOT ") && filter.accept(expression)) {
                    this.addCompositeIdentifier(identifier, 0);
                }
            } else if (filter.accept(expression)) {
                this.addIdentifier(identifier);
            }
        }
    }

    protected void addCompoundIdentifiers(JPQLQueryBNF queryBNF, Expression expression, boolean hasIs, boolean hasNot) {
        for (String identifier : queryBNF.getIdentifiers()) {
            this.addCompoundIdentifier(identifier, expression, hasIs, hasNot);
        }
    }

    protected void addCompoundIdentifiers(String queryBNFId, Expression expression, boolean hasIs, boolean hasNot) {
        this.addCompoundIdentifiers(this.getQueryBNF(queryBNFId), expression, hasIs, hasNot);
    }

    protected void addEntities() {
        for (IEntity entity : this.queryContext.getProvider().entities()) {
            if (!this.isValidProposal(entity.getName(), this.word)) continue;
            this.proposals.addEntity(entity);
        }
    }

    protected void addEntities(IType type) {
        for (IEntity entity : this.queryContext.getProvider().entities()) {
            if (!this.isValidProposal(entity.getName(), this.word) || !type.isAssignableTo(entity.getType())) continue;
            this.proposals.addEntity(entity);
        }
    }

    protected void addEnumConstant(IType enumType, String enumConstant) {
        this.proposals.addEnumConstant(enumType, enumConstant);
    }

    protected void addEnumConstants(IType enumType, String word) {
        String[] stringArray = enumType.getEnumConstants();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String enumConstant = stringArray[n2];
            if (ExpressionTools.startWithIgnoreCase(enumConstant, word)) {
                this.addEnumConstant(enumType, enumConstant);
            }
            ++n2;
        }
    }

    protected void addExpressionFactoryIdentifiers(ExpressionFactory expressionFactory) {
        String[] stringArray = expressionFactory.identifiers();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String identifier = stringArray[n2];
            this.addIdentifier(identifier);
            ++n2;
        }
    }

    protected void addExpressionFactoryIdentifiers(String expressionFactoryId) {
        this.addExpressionFactoryIdentifiers(this.getExpressionFactory(expressionFactoryId));
    }

    protected void addFunctionIdentifier(String identifier) {
        if (this.isFunction(identifier)) {
            this.addIdentifier(identifier);
        }
    }

    protected void addFunctionIdentifiers(Expression expression) {
        JPQLQueryBNF queryBNF = expression.getParent().findQueryBNF(expression);
        this.addIdentificationVariables();
        this.addFunctionIdentifiers(queryBNF);
        if (this.isValid(queryBNF, "subquery", true) && this.isEncapsulated(expression)) {
            this.addIdentifier("SELECT");
        }
    }

    protected void addFunctionIdentifiers(JPQLQueryBNF queryBNF) {
        for (String identifier : queryBNF.getIdentifiers()) {
            this.addFunctionIdentifier(identifier);
        }
    }

    protected void addFunctionIdentifiers(String queryBNFId) {
        this.addFunctionIdentifiers(this.getQueryBNF(queryBNFId));
    }

    protected void addIdentificationVariable(String identificationVariable) {
        if (ExpressionTools.stringIsNotEmpty(identificationVariable) && this.isValidProposal(identificationVariable, this.word)) {
            this.proposals.addIdentificationVariable(identificationVariable);
        }
    }

    protected void addIdentificationVariables() {
        this.addIdentificationVariables(null, IdentificationVariableType.ALL);
    }

    protected void addIdentificationVariables(Expression expression, IdentificationVariableType type) {
        for (Declaration declaration : this.queryContext.getDeclarations()) {
            boolean stop = type.add(this, declaration, expression);
            if (stop) break;
        }
    }

    protected void addIdentifier(String identifier) {
        if (this.isValidVersion(identifier) && this.isValidProposal(identifier, this.word)) {
            this.proposals.addIdentifier(identifier);
        }
    }

    protected void addJoinIdentifiers() {
        this.addIdentifier("INNER JOIN");
        this.addIdentifier("INNER JOIN FETCH");
        this.addIdentifier("JOIN");
        this.addIdentifier("JOIN FETCH");
        this.addIdentifier("LEFT JOIN");
        this.addIdentifier("LEFT JOIN FETCH");
        this.addIdentifier("LEFT OUTER JOIN");
        this.addIdentifier("LEFT OUTER JOIN FETCH");
    }

    protected void addLeftIdentificationVariables(Expression expression) {
        this.addIdentificationVariables(expression, IdentificationVariableType.LEFT);
    }

    protected void addLogicalIdentifiers() {
        this.addIdentifier("AND");
        this.addIdentifier("OR");
    }

    protected void addRangeIdentificationVariable(String identificationVariable) {
        if (ExpressionTools.stringIsNotEmpty(identificationVariable) && this.isValidProposal(identificationVariable, this.word)) {
            Resolver resolver = this.queryContext.getResolver(identificationVariable);
            IEntity entity = this.queryContext.getProvider().getEntity(resolver.getType());
            if (entity != null) {
                this.proposals.addRangeIdentificationVariable(identificationVariable, entity);
            } else {
                this.proposals.addIdentificationVariable(identificationVariable);
            }
        }
    }

    protected void addResultVariables() {
        for (String resultVariable : this.queryContext.getResultVariables()) {
            this.addIdentificationVariable(resultVariable);
        }
    }

    protected final void addVirtualSpace() {
        this.virtualSpaces.add(1);
    }

    protected boolean areArithmeticSymbolsAppendable(Expression expression) {
        return this.isAppendable(expression, AppendableType.ARITHMETIC);
    }

    protected boolean areComparisonSymbolsAppendable(Expression expression) {
        return this.isAppendable(expression, AppendableType.COMPARISON);
    }

    protected boolean areLogicalSymbolsAppendable(Expression expression) {
        return this.isAppendable(expression, AppendableType.LOGICAL);
    }

    protected abstract AcceptableTypeVisitor buildAcceptableTypeVisitor();

    protected AppendableExpressionVisitor buildAppendableExpressionVisitor() {
        return new AppendableExpressionVisitor(this);
    }

    protected Filter<Expression> buildCollectionCompoundTypeFilter() {
        return new Filter<Expression>(){

            @Override
            public boolean accept(Expression expression) {
                IType type = AbstractContentAssistVisitor.this.queryContext.getType(expression);
                TypeHelper typeHelper = AbstractContentAssistVisitor.this.queryContext.getTypeHelper();
                return typeHelper.isCollectionType(type) || typeHelper.isMapType(type);
            }
        };
    }

    protected CollectionExpressionVisitor buildCollectionExpressionVisitor() {
        return new CollectionExpressionVisitor();
    }

    protected CollectionMappingFilter buildCollectionMappingFilter() {
        return new CollectionMappingFilter();
    }

    protected ConcatExpressionCollectionHelper buildConcatExpressionCollectionHelper() {
        return new ConcatExpressionCollectionHelper(this);
    }

    protected ConditionalClauseCollectionHelper buildConditionalClauseCollectionHelper() {
        return new ConditionalClauseCollectionHelper(this);
    }

    protected ConstrutorCollectionHelper buildConstrutorCollectionHelper() {
        return new ConstrutorCollectionHelper(this);
    }

    protected DeclarationVisitor buildDeclarationVisitor() {
        return new DeclarationVisitor();
    }

    protected DefaultMappingCollector buildDefaultMappingCollector() {
        return new DefaultMappingCollector();
    }

    protected DeleteClauseCollectionHelper buildDeleteClauseCollectionHelper() {
        return new DeleteClauseCollectionHelper(this);
    }

    protected DeleteClauseStatementHelper buildDeleteClauseStatementHelper() {
        return new DeleteClauseStatementHelper(this);
    }

    protected Filter<Expression> buildDifferentComparisonFilter() {
        return new DifferentComparisonFilter();
    }

    protected DoubleEncapsulatedCollectionHelper buildDoubleEncapsulatedCollectionHelper() {
        return new DoubleEncapsulatedCollectionHelper(this);
    }

    protected EncapsulatedExpressionVisitor buildEncapsulatedExpressionVisitor() {
        return new EncapsulatedExpressionVisitor();
    }

    protected QueryPosition buildEndingPositionFromInvalidExpression(Expression invalidExpression, Expression startingPointExpression, boolean[] virtualSpace) {
        EndingQueryPositionBuilder visitor = this.getEndingQueryPositionBuilder();
        try {
            visitor.prepare(invalidExpression);
            startingPointExpression.accept(visitor);
            virtualSpace[0] = visitor.hasVirtualSpace();
            QueryPosition queryPosition = visitor.getQueryPosition();
            return queryPosition;
        }
        finally {
            visitor.dispose();
        }
    }

    protected EndingQueryPositionBuilder buildEndingQueryPositionBuilder() {
        return new EndingQueryPositionBuilder(this);
    }

    protected EnumVisitor buildEnumVisitor() {
        return new EnumVisitor();
    }

    protected FilteringMappingCollector buildFilteringMappingCollector(AbstractPathExpression expression, Resolver resolver, Filter<IMapping> filter, String pattern) {
        return new FilteringMappingCollector(resolver, this.buildMappingFilter(expression, filter), pattern);
    }

    protected FollowingClausesVisitor buildFollowingClausesVisitor() {
        return new FollowingClausesVisitor();
    }

    protected FollowingInvalidExpressionVisitor buildFollowingInvalidExpressionVisitor() {
        return new FollowingInvalidExpressionVisitor(this);
    }

    protected FromClauseCollectionHelper buildFromClauseCollectionHelper() {
        return new FromClauseCollectionHelper(this);
    }

    protected FromClauseStatementHelper buildFromClauseStatementHelper() {
        return new FromClauseStatementHelper(this);
    }

    protected GroupByClauseCollectionHelper buildGroupByClauseCollectionHelper() {
        return new GroupByClauseCollectionHelper(this);
    }

    protected GroupByClauseStatementHelper buildGroupByClauseStatementHelper() {
        return new GroupByClauseStatementHelper(this);
    }

    protected HavingClauseStatementHelper buildHavingClauseStatementHelper() {
        return new HavingClauseStatementHelper(this);
    }

    protected IncompleteCollectionExpressionVisitor buildIncompleteCollectionExpressionVisitor() {
        return new IncompleteCollectionExpressionVisitor();
    }

    protected InvalidExpressionVisitor buildInvalidExpressionVisitor() {
        return new InvalidExpressionVisitor();
    }

    protected JoinCollectionHelper buildJoinCollectionHelper() {
        return new JoinCollectionHelper(this);
    }

    protected AbstractValidator.JPQLQueryBNFValidator buildJPQLQueryBNFValidator(JPQLQueryBNF queryBNF) {
        return new AbstractValidator.JPQLQueryBNFValidator(queryBNF);
    }

    protected MappingCollector buildMappingCollector(AbstractPathExpression expression, Resolver resolver, Filter<IMapping> filter) {
        return this.buildFilteringMappingCollector(expression, resolver, filter, "");
    }

    protected Filter<IMapping> buildMappingFilter(AbstractPathExpression expression, Filter<IMapping> filter) {
        IType type = this.getAcceptableType(expression.getParent());
        if (type == null) {
            return filter;
        }
        return new AndFilter<IMapping>(new MappingTypeFilter(type, this), filter);
    }

    protected Filter<IMapping> buildMappingFilter(Expression expression) {
        MappingFilterBuilder visitor = this.getMappingFilterBuilder();
        try {
            expression.accept(visitor);
            Filter<IMapping> filter = visitor.filter;
            return filter;
        }
        finally {
            visitor.dispose();
        }
    }

    protected MappingFilterBuilder buildMappingFilterBuilder() {
        return new MappingFilterBuilder(this);
    }

    protected Filter<Expression> buildNonCollectionCompoundTypeFilter() {
        return new Filter<Expression>(){

            @Override
            public boolean accept(Expression expression) {
                IType type = AbstractContentAssistVisitor.this.queryContext.getType(expression);
                TypeHelper typeHelper = AbstractContentAssistVisitor.this.queryContext.getTypeHelper();
                return !typeHelper.isCollectionType(type) && !typeHelper.isMapType(type);
            }
        };
    }

    protected NotExpressionVisitor buildNotExpressionVisitor() {
        return new NotExpressionVisitor();
    }

    protected OrderByClauseCollectionHelper buildOrderByClauseCollectionHelper() {
        return new OrderByClauseCollectionHelper(this);
    }

    protected OrderByClauseStatementHelper buildOrderByClauseStatementHelper() {
        return new OrderByClauseStatementHelper(this);
    }

    protected PropertyMappingFilter buildPropertyMappingFilter() {
        return new PropertyMappingFilter();
    }

    public ContentAssistProposals buildProposals(int position) {
        return this.buildProposals(position, ContentAssistExtension.NULL_HELPER);
    }

    public ContentAssistProposals buildProposals(int position, ContentAssistExtension extension) {
        try {
            JPQLExpression jpqlExpression = this.queryContext.getJPQLExpression();
            String jpqlQuery = this.queryContext.getJPQLQuery();
            this.queryPosition = jpqlExpression.buildPosition(jpqlQuery, position);
            this.wordParser = new WordParser(jpqlQuery);
            this.wordParser.setPosition(position);
            this.word = this.wordParser.partialWord();
            this.proposals = new DefaultContentAssistProposals(this.queryContext.getGrammar(), extension);
            this.queryPosition.getExpression().accept(this);
            DefaultContentAssistProposals defaultContentAssistProposals = this.proposals;
            return defaultContentAssistProposals;
        }
        finally {
            this.dispose();
        }
    }

    protected RangeVariableDeclarationVisitor buildRangeVariableDeclarationVisitor() {
        return new RangeVariableDeclarationVisitor();
    }

    protected ResultVariableVisitor buildResultVariableVisitor() {
        return new ResultVariableVisitor();
    }

    protected SelectClauseCollectionHelper buildSelectClauseCollectionHelper() {
        return new SelectClauseCollectionHelper(this);
    }

    protected SelectClauseStatementHelper buildSelectClauseStatementHelper() {
        return new SelectClauseStatementHelper(this);
    }

    protected SimpleFromClauseStatementHelper buildSimpleFromClauseStatementHelper() {
        return new SimpleFromClauseStatementHelper(this);
    }

    protected SimpleGroupByClauseStatementHelper buildSimpleGroupByClauseStatementHelper() {
        return new SimpleGroupByClauseStatementHelper(this);
    }

    protected SimpleHavingClauseStatementHelper buildSimpleHavingClauseStatementHelper() {
        return new SimpleHavingClauseStatementHelper(this);
    }

    protected SimpleSelectClauseCollectionHelper buildSimpleSelectClauseCollectionHelper() {
        return new SimpleSelectClauseCollectionHelper(this);
    }

    protected SimpleSelectClauseStatementHelper buildSimpleSelectClauseStatementHelper() {
        return new SimpleSelectClauseStatementHelper(this);
    }

    protected SimpleWhereClauseSelectStatementHelper buildSimpleWhereClauseSelectStatementHelper() {
        return new SimpleWhereClauseSelectStatementHelper(this);
    }

    protected SubqueryAppendableExpressionVisitor buildSubqueryAppendableExpressionVisitor() {
        return new SubqueryAppendableExpressionVisitor();
    }

    protected SubqueryVisitor buildSubqueryVisitor() {
        return new SubqueryVisitor();
    }

    protected TripleEncapsulatedCollectionHelper buildTripleEncapsulatedCollectionHelper() {
        return new TripleEncapsulatedCollectionHelper(this);
    }

    protected UpdateClauseStatementHelper buildUpdateClauseStatementHelper() {
        return new UpdateClauseStatementHelper(this);
    }

    protected UpdateItemCollectionHelper buildUpdateItemCollectionHelper() {
        return new UpdateItemCollectionHelper(this);
    }

    protected VisitParentVisitor buildVisitParentVisitor() {
        return new VisitParentVisitor(this);
    }

    protected WhenClauseConditionalClauseCollectionHelper buildWhenClauseConditionalClauseCollectionHelper() {
        return new WhenClauseConditionalClauseCollectionHelper(this);
    }

    protected WhereClauseDeleteStatementHelper buildWhereClauseDeleteStatementHelper() {
        return new WhereClauseDeleteStatementHelper(this);
    }

    protected WhereClauseSelectStatementHelper buildWhereClauseSelectStatementHelper() {
        return new WhereClauseSelectStatementHelper(this);
    }

    protected WhereClauseUpdateStatementHelper buildWhereClauseUpdateStatementHelper() {
        return new WhereClauseUpdateStatementHelper(this);
    }

    protected WithinInvalidExpressionVisitor buildWithinInvalidExpressionVisitor() {
        return new WithinInvalidExpressionVisitor();
    }

    public void dispose() {
        this.word = null;
        this.proposals = null;
        this.wordParser = null;
        this.queryPosition = null;
        this.corrections.setSize(1);
        this.virtualSpaces.setSize(1);
        this.lockedExpressions.clear();
    }

    protected RangeVariableDeclaration findRangeVariableDeclaration(UpdateClause expression) {
        RangeVariableDeclarationVisitor visitor = this.getRangeVariableDeclarationVisitor();
        try {
            expression.getRangeVariableDeclaration().accept(visitor);
            RangeVariableDeclaration rangeVariableDeclaration = visitor.expression;
            return rangeVariableDeclaration;
        }
        finally {
            visitor.dispose();
        }
    }

    protected IType getAcceptableType(Expression expression) {
        AcceptableTypeVisitor visitor = this.getExpressionTypeVisitor();
        try {
            expression.accept(visitor);
            IType iType = visitor.type;
            return iType;
        }
        finally {
            visitor.dispose();
        }
    }

    protected AppendableExpressionVisitor getAppendableExpressionVisitor() {
        AppendableExpressionVisitor helper = this.getHelper(AppendableExpressionVisitor.class);
        if (helper == null) {
            helper = this.buildAppendableExpressionVisitor();
            this.registerHelper(AppendableExpressionVisitor.class, helper);
        }
        return helper;
    }

    protected CollectionExpression getCollectionExpression(Expression expression) {
        CollectionExpressionVisitor visitor = this.getCollectionExpressionVisitor();
        try {
            expression.accept(visitor);
            CollectionExpression collectionExpression = visitor.expression;
            return collectionExpression;
        }
        finally {
            visitor.dispose();
        }
    }

    protected CollectionExpressionVisitor getCollectionExpressionVisitor() {
        CollectionExpressionVisitor visitor = this.getHelper(CollectionExpressionVisitor.class);
        if (visitor == null) {
            visitor = this.buildCollectionExpressionVisitor();
            this.registerHelper(CollectionExpressionVisitor.class, visitor);
        }
        return visitor;
    }

    protected ConcatExpressionCollectionHelper getConcatExpressionCollectionHelper() {
        ConcatExpressionCollectionHelper helper = this.getHelper(ConcatExpressionCollectionHelper.class);
        if (helper == null) {
            helper = this.buildConcatExpressionCollectionHelper();
            this.registerHelper(ConcatExpressionCollectionHelper.class, helper);
        }
        return helper;
    }

    protected ConditionalClauseCollectionHelper getConditionalClauseCollectionHelper() {
        ConditionalClauseCollectionHelper helper = this.getHelper(ConditionalClauseCollectionHelper.class);
        if (helper == null) {
            helper = this.buildConditionalClauseCollectionHelper();
            this.registerHelper(ConditionalClauseCollectionHelper.class, helper);
        }
        return helper;
    }

    protected ConstrutorCollectionHelper getConstructorCollectionHelper() {
        ConstrutorCollectionHelper helper = this.getHelper(ConstrutorCollectionHelper.class);
        if (helper == null) {
            helper = this.buildConstrutorCollectionHelper();
            this.registerHelper(ConstrutorCollectionHelper.class, helper);
        }
        return helper;
    }

    protected DeclarationVisitor getDeclarationVisitor() {
        DeclarationVisitor helper = this.getHelper(DeclarationVisitor.class);
        if (helper == null) {
            helper = this.buildDeclarationVisitor();
            this.registerHelper(DeclarationVisitor.class, helper);
        }
        return helper;
    }

    protected MappingCollector getDefaultMappingCollector() {
        DefaultMappingCollector helper = this.getHelper(DefaultMappingCollector.class);
        if (helper == null) {
            helper = this.buildDefaultMappingCollector();
            this.registerHelper(DefaultMappingCollector.class, helper);
        }
        return helper;
    }

    protected DeleteClauseCollectionHelper getDeleteClauseCollectionHelper() {
        DeleteClauseCollectionHelper helper = this.getHelper(DeleteClauseCollectionHelper.class);
        if (helper == null) {
            helper = this.buildDeleteClauseCollectionHelper();
            this.registerHelper(DeleteClauseCollectionHelper.class, helper);
        }
        return helper;
    }

    protected DeleteClauseStatementHelper getDeleteClauseStatementHelper() {
        DeleteClauseStatementHelper helper = this.getHelper(DeleteClauseStatementHelper.class);
        if (helper == null) {
            helper = this.buildDeleteClauseStatementHelper();
            this.registerHelper(DeleteClauseStatementHelper.class, helper);
        }
        return helper;
    }

    protected DoubleEncapsulatedCollectionHelper getDoubleEncapsulatedCollectionHelper() {
        DoubleEncapsulatedCollectionHelper helper = this.getHelper(DoubleEncapsulatedCollectionHelper.class);
        if (helper == null) {
            helper = this.buildDoubleEncapsulatedCollectionHelper();
            this.registerHelper(DoubleEncapsulatedCollectionHelper.class, helper);
        }
        return helper;
    }

    protected EncapsulatedExpressionVisitor getEncapsulatedExpressionVisitor() {
        EncapsulatedExpressionVisitor helper = this.getHelper(EncapsulatedExpressionVisitor.class);
        if (helper == null) {
            helper = this.buildEncapsulatedExpressionVisitor();
            this.registerHelper(EncapsulatedExpressionVisitor.class, helper);
        }
        return helper;
    }

    protected EndingQueryPositionBuilder getEndingQueryPositionBuilder() {
        EndingQueryPositionBuilder visitor = this.getHelper(EndingQueryPositionBuilder.class);
        if (visitor == null) {
            visitor = this.buildEndingQueryPositionBuilder();
            this.registerHelper(EndingQueryPositionBuilder.class, visitor);
        }
        return visitor;
    }

    protected EnumVisitor getEnumVisitor() {
        EnumVisitor helper = this.getHelper(EnumVisitor.class);
        if (helper == null) {
            helper = this.buildEnumVisitor();
            this.helpers.put(EnumVisitor.class, helper);
        }
        return helper;
    }

    protected ExpressionFactory getExpressionFactory(String expressionFactoryId) {
        return this.queryContext.getExpressionRegistry().getExpressionFactory(expressionFactoryId);
    }

    protected AcceptableTypeVisitor getExpressionTypeVisitor() {
        AcceptableTypeVisitor helper = this.getHelper(AcceptableTypeVisitor.class);
        if (helper == null) {
            helper = this.buildAcceptableTypeVisitor();
            this.registerHelper(AcceptableTypeVisitor.class, helper);
        }
        return helper;
    }

    protected Filter<Expression> getFilter(String identifier) {
        Filter<Expression> filter = this.identifierFilters.get(identifier);
        return filter != null ? filter : INVALID_IDENTIFIER_FILTER;
    }

    protected FollowingClausesVisitor getFollowingClausesVisitor() {
        FollowingClausesVisitor helper = this.getHelper(FollowingClausesVisitor.class);
        if (helper == null) {
            helper = this.buildFollowingClausesVisitor();
            this.helpers.put(FollowingClausesVisitor.class, helper);
        }
        return helper;
    }

    protected FollowingInvalidExpressionVisitor getFollowingInvalidExpressionVisitor() {
        FollowingInvalidExpressionVisitor helper = this.getHelper(FollowingInvalidExpressionVisitor.class);
        if (helper == null) {
            helper = this.buildFollowingInvalidExpressionVisitor();
            this.registerHelper(FollowingInvalidExpressionVisitor.class, helper);
        }
        return helper;
    }

    protected FromClauseCollectionHelper getFromClauseCollectionHelper() {
        FromClauseCollectionHelper helper = this.getHelper(FromClauseCollectionHelper.class);
        if (helper == null) {
            helper = this.buildFromClauseCollectionHelper();
            this.registerHelper(FromClauseCollectionHelper.class, helper);
        }
        return helper;
    }

    protected FromClauseStatementHelper getFromClauseStatementHelper() {
        FromClauseStatementHelper helper = this.getHelper(FromClauseStatementHelper.class);
        if (helper == null) {
            helper = this.buildFromClauseStatementHelper();
            this.registerHelper(FromClauseStatementHelper.class, helper);
        }
        return helper;
    }

    protected GroupByClauseCollectionHelper getGroupByClauseCollectionHelper() {
        GroupByClauseCollectionHelper helper = this.getHelper(GroupByClauseCollectionHelper.class);
        if (helper == null) {
            helper = this.buildGroupByClauseCollectionHelper();
            this.registerHelper(GroupByClauseCollectionHelper.class, helper);
        }
        return helper;
    }

    protected GroupByClauseStatementHelper getGroupByClauseStatementHelper() {
        GroupByClauseStatementHelper helper = this.getHelper(GroupByClauseStatementHelper.class);
        if (helper == null) {
            helper = this.buildGroupByClauseStatementHelper();
            this.registerHelper(GroupByClauseStatementHelper.class, helper);
        }
        return helper;
    }

    protected HavingClauseStatementHelper getHavingClauseStatementHelper() {
        HavingClauseStatementHelper helper = this.getHelper(HavingClauseStatementHelper.class);
        if (helper == null) {
            helper = this.buildHavingClauseStatementHelper();
            this.registerHelper(HavingClauseStatementHelper.class, helper);
        }
        return helper;
    }

    protected final <T> T getHelper(Class<T> helperClass) {
        return (T)this.helpers.get(helperClass);
    }

    protected IdentifierRole getIdentifierRole(String identifier) {
        return this.queryContext.getExpressionRegistry().getIdentifierRole(identifier);
    }

    protected IncompleteCollectionExpressionVisitor getIncompleteCollectionExpressionVisitor() {
        IncompleteCollectionExpressionVisitor helper = this.getHelper(IncompleteCollectionExpressionVisitor.class);
        if (helper == null) {
            helper = this.buildIncompleteCollectionExpressionVisitor();
            this.registerHelper(IncompleteCollectionExpressionVisitor.class, helper);
        }
        return helper;
    }

    protected InvalidExpressionVisitor getInvalidExpressionVisitor() {
        InvalidExpressionVisitor visitor = this.getHelper(InvalidExpressionVisitor.class);
        if (visitor == null) {
            visitor = this.buildInvalidExpressionVisitor();
            this.registerHelper(InvalidExpressionVisitor.class, visitor);
        }
        return visitor;
    }

    protected JoinCollectionHelper getJoinCollectionHelper() {
        JoinCollectionHelper helper = this.getHelper(JoinCollectionHelper.class);
        if (helper == null) {
            helper = this.buildJoinCollectionHelper();
            this.registerHelper(JoinCollectionHelper.class, helper);
        }
        return helper;
    }

    protected abstract JPQLGrammar getLatestGrammar();

    protected Filter<IMapping> getMappingCollectionFilter() {
        CollectionMappingFilter helper = this.getHelper(CollectionMappingFilter.class);
        if (helper == null) {
            helper = this.buildCollectionMappingFilter();
            this.registerHelper(CollectionMappingFilter.class, helper);
        }
        return helper;
    }

    protected MappingFilterBuilder getMappingFilterBuilder() {
        MappingFilterBuilder helper = this.getHelper(MappingFilterBuilder.class);
        if (helper == null) {
            helper = this.buildMappingFilterBuilder();
            this.helpers.put(MappingFilterBuilder.class, helper);
        }
        return helper;
    }

    protected Filter<IMapping> getMappingPropertyFilter() {
        PropertyMappingFilter helper = this.getHelper(PropertyMappingFilter.class);
        if (helper == null) {
            helper = this.buildPropertyMappingFilter();
            this.helpers.put(PropertyMappingFilter.class, helper);
        }
        return helper;
    }

    protected NotExpressionVisitor getNotExpressionVisitor() {
        NotExpressionVisitor helper = this.getHelper(NotExpressionVisitor.class);
        if (helper == null) {
            helper = this.buildNotExpressionVisitor();
            this.registerHelper(NotExpressionVisitor.class, helper);
        }
        return helper;
    }

    protected OrderByClauseCollectionHelper getOrderByClauseCollectionHelper() {
        OrderByClauseCollectionHelper helper = this.getHelper(OrderByClauseCollectionHelper.class);
        if (helper == null) {
            helper = this.buildOrderByClauseCollectionHelper();
            this.registerHelper(OrderByClauseCollectionHelper.class, helper);
        }
        return helper;
    }

    protected OrderByClauseStatementHelper getOrderByClauseStatementHelper() {
        OrderByClauseStatementHelper helper = this.getHelper(OrderByClauseStatementHelper.class);
        if (helper == null) {
            helper = this.buildOrderByClauseStatementHelper();
            this.registerHelper(OrderByClauseStatementHelper.class, helper);
        }
        return helper;
    }

    protected JPQLQueryBNF getQueryBNF(String queryBNFId) {
        return this.queryContext.getExpressionRegistry().getQueryBNF(queryBNFId);
    }

    protected RangeVariableDeclarationVisitor getRangeVariableDeclarationVisitor() {
        RangeVariableDeclarationVisitor helper = this.getHelper(RangeVariableDeclarationVisitor.class);
        if (helper == null) {
            helper = this.buildRangeVariableDeclarationVisitor();
            this.registerHelper(RangeVariableDeclarationVisitor.class, helper);
        }
        return helper;
    }

    protected ResultVariableVisitor getResultVariableVisitor() {
        ResultVariableVisitor helper = this.getHelper(ResultVariableVisitor.class);
        if (helper == null) {
            helper = this.buildResultVariableVisitor();
            this.registerHelper(ResultVariableVisitor.class, helper);
        }
        return helper;
    }

    protected SelectClauseCollectionHelper getSelectClauseCollectionHelper() {
        SelectClauseCollectionHelper helper = this.getHelper(SelectClauseCollectionHelper.class);
        if (helper == null) {
            helper = this.buildSelectClauseCollectionHelper();
            this.registerHelper(SelectClauseCollectionHelper.class, helper);
        }
        return helper;
    }

    protected SelectClauseStatementHelper getSelectClauseStatementHelper() {
        SelectClauseStatementHelper helper = this.getHelper(SelectClauseStatementHelper.class);
        if (helper == null) {
            helper = this.buildSelectClauseStatementHelper();
            this.registerHelper(SelectClauseStatementHelper.class, helper);
        }
        return helper;
    }

    protected SimpleFromClauseStatementHelper getSimpleFromClauseStatementHelper() {
        SimpleFromClauseStatementHelper helper = this.getHelper(SimpleFromClauseStatementHelper.class);
        if (helper == null) {
            helper = this.buildSimpleFromClauseStatementHelper();
            this.registerHelper(SimpleFromClauseStatementHelper.class, helper);
        }
        return helper;
    }

    protected SimpleGroupByClauseStatementHelper getSimpleGroupByClauseStatementHelper() {
        SimpleGroupByClauseStatementHelper helper = this.getHelper(SimpleGroupByClauseStatementHelper.class);
        if (helper == null) {
            helper = this.buildSimpleGroupByClauseStatementHelper();
            this.registerHelper(SimpleGroupByClauseStatementHelper.class, helper);
        }
        return helper;
    }

    protected SimpleHavingClauseStatementHelper getSimpleHavingClauseStatementHelper() {
        SimpleHavingClauseStatementHelper helper = this.getHelper(SimpleHavingClauseStatementHelper.class);
        if (helper == null) {
            helper = this.buildSimpleHavingClauseStatementHelper();
            this.registerHelper(SimpleHavingClauseStatementHelper.class, helper);
        }
        return helper;
    }

    protected SimpleSelectClauseCollectionHelper getSimpleSelectClauseCollectionHelper() {
        SimpleSelectClauseCollectionHelper helper = this.getHelper(SimpleSelectClauseCollectionHelper.class);
        if (helper == null) {
            helper = this.buildSimpleSelectClauseCollectionHelper();
            this.registerHelper(SimpleSelectClauseCollectionHelper.class, helper);
        }
        return helper;
    }

    protected SimpleSelectClauseStatementHelper getSimpleSelectClauseStatementHelper() {
        SimpleSelectClauseStatementHelper helper = this.getHelper(SimpleSelectClauseStatementHelper.class);
        if (helper == null) {
            helper = this.buildSimpleSelectClauseStatementHelper();
            this.registerHelper(SimpleSelectClauseStatementHelper.class, helper);
        }
        return helper;
    }

    protected SimpleWhereClauseSelectStatementHelper getSimpleWhereClauseSelectStatementHelper() {
        SimpleWhereClauseSelectStatementHelper helper = this.getHelper(SimpleWhereClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildSimpleWhereClauseSelectStatementHelper();
            this.registerHelper(SimpleWhereClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected SubqueryAppendableExpressionVisitor getSubqueryAppendableExpressionVisitor() {
        SubqueryAppendableExpressionVisitor helper = this.getHelper(SubqueryAppendableExpressionVisitor.class);
        if (helper == null) {
            helper = this.buildSubqueryAppendableExpressionVisitor();
            this.registerHelper(SubqueryAppendableExpressionVisitor.class, helper);
        }
        return helper;
    }

    protected SubqueryVisitor getSubqueryVisitor() {
        SubqueryVisitor helper = this.getHelper(SubqueryVisitor.class);
        if (helper == null) {
            helper = this.buildSubqueryVisitor();
            this.registerHelper(SubqueryVisitor.class, helper);
        }
        return helper;
    }

    protected TripleEncapsulatedCollectionHelper getTripleEncapsulatedCollectionHelper() {
        TripleEncapsulatedCollectionHelper helper = this.getHelper(TripleEncapsulatedCollectionHelper.class);
        if (helper == null) {
            helper = this.buildTripleEncapsulatedCollectionHelper();
            this.registerHelper(TripleEncapsulatedCollectionHelper.class, helper);
        }
        return helper;
    }

    protected UpdateClauseStatementHelper getUpdateClauseStatementHelper() {
        UpdateClauseStatementHelper helper = this.getHelper(UpdateClauseStatementHelper.class);
        if (helper == null) {
            helper = this.buildUpdateClauseStatementHelper();
            this.registerHelper(UpdateClauseStatementHelper.class, helper);
        }
        return helper;
    }

    protected UpdateItemCollectionHelper getUpdateItemCollectionHelper() {
        UpdateItemCollectionHelper helper = this.getHelper(UpdateItemCollectionHelper.class);
        if (helper == null) {
            helper = this.buildUpdateItemCollectionHelper();
            this.registerHelper(UpdateItemCollectionHelper.class, helper);
        }
        return helper;
    }

    protected VisitParentVisitor getVisitParentVisitor() {
        VisitParentVisitor helper = this.getHelper(VisitParentVisitor.class);
        if (helper == null) {
            helper = this.buildVisitParentVisitor();
            this.registerHelper(VisitParentVisitor.class, helper);
        }
        return helper;
    }

    protected WhenClauseConditionalClauseCollectionHelper getWhenClauseConditionalClauseCollectionHelper() {
        WhenClauseConditionalClauseCollectionHelper helper = this.getHelper(WhenClauseConditionalClauseCollectionHelper.class);
        if (helper == null) {
            helper = this.buildWhenClauseConditionalClauseCollectionHelper();
            this.registerHelper(WhenClauseConditionalClauseCollectionHelper.class, helper);
        }
        return helper;
    }

    protected WhereClauseDeleteStatementHelper getWhereClauseDeleteStatementHelper() {
        WhereClauseDeleteStatementHelper helper = this.getHelper(WhereClauseDeleteStatementHelper.class);
        if (helper == null) {
            helper = this.buildWhereClauseDeleteStatementHelper();
            this.registerHelper(WhereClauseDeleteStatementHelper.class, helper);
        }
        return helper;
    }

    protected WhereClauseSelectStatementHelper getWhereClauseSelectStatementHelper() {
        WhereClauseSelectStatementHelper helper = this.getHelper(WhereClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildWhereClauseSelectStatementHelper();
            this.registerHelper(WhereClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected WhereClauseUpdateStatementHelper getWhereClauseUpdateStatementHelper() {
        WhereClauseUpdateStatementHelper helper = this.getHelper(WhereClauseUpdateStatementHelper.class);
        if (helper == null) {
            helper = this.buildWhereClauseUpdateStatementHelper();
            this.registerHelper(WhereClauseUpdateStatementHelper.class, helper);
        }
        return helper;
    }

    protected WithinInvalidExpressionVisitor getWithinInvalidExpressionVisitor() {
        WithinInvalidExpressionVisitor helper = this.getHelper(WithinInvalidExpressionVisitor.class);
        if (helper == null) {
            helper = this.buildWithinInvalidExpressionVisitor();
            this.registerHelper(WithinInvalidExpressionVisitor.class, helper);
        }
        return helper;
    }

    protected boolean hasClausesDefinedBetween(Expression expression, String afterIdentifier, String beforeIdentifier) {
        FollowingClausesVisitor visitor = this.getFollowingClausesVisitor();
        try {
            visitor.afterIdentifier = afterIdentifier;
            visitor.beforeIdentifier = beforeIdentifier;
            expression.accept(visitor);
            boolean bl = visitor.hasFollowUpClauses;
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected final boolean hasVirtualSpace() {
        return this.virtualSpaces.peek() > 0;
    }

    protected void initialize() {
        this.helpers = new HashMap();
        this.lockedExpressions = new Stack();
        this.virtualSpaces = new Stack();
        this.virtualSpaces.add(0);
        this.corrections = new Stack();
        this.corrections.add(0);
        this.identifierFilters = new HashMap<String, Filter<Expression>>();
        this.identifierFilters.put("<>", VALID_IDENTIFIER_FILTER);
        this.identifierFilters.put("=", VALID_IDENTIFIER_FILTER);
        this.identifierFilters.put("MEMBER", VALID_IDENTIFIER_FILTER);
        this.identifierFilters.put("MEMBER OF", VALID_IDENTIFIER_FILTER);
        this.identifierFilters.put("NOT MEMBER", VALID_IDENTIFIER_FILTER);
        this.identifierFilters.put("NOT MEMBER OF", VALID_IDENTIFIER_FILTER);
        this.identifierFilters.put("IS NULL", VALID_IDENTIFIER_FILTER);
        this.identifierFilters.put("IS NOT NULL", VALID_IDENTIFIER_FILTER);
        this.identifierFilters.put("IN", VALID_IDENTIFIER_FILTER);
        this.identifierFilters.put("NOT IN", VALID_IDENTIFIER_FILTER);
        Filter<Expression> filter = this.buildCollectionCompoundTypeFilter();
        this.identifierFilters.put("IS EMPTY", filter);
        this.identifierFilters.put("IS NOT EMPTY", filter);
        filter = this.buildNonCollectionCompoundTypeFilter();
        this.identifierFilters.put("BETWEEN", filter);
        this.identifierFilters.put("NOT BETWEEN", filter);
        this.identifierFilters.put("LIKE", filter);
        this.identifierFilters.put("NOT LIKE", filter);
        filter = this.buildDifferentComparisonFilter();
        this.identifierFilters.put(">", filter);
        this.identifierFilters.put(">=", filter);
        this.identifierFilters.put("<", filter);
        this.identifierFilters.put("<=", filter);
    }

    protected boolean isAggregate(String identifier) {
        return this.getIdentifierRole(identifier) == IdentifierRole.AGGREGATE;
    }

    protected boolean isAppendable(Expression expression, AppendableType appendableType) {
        AppendableExpressionVisitor visitor = this.getAppendableExpressionVisitor();
        try {
            visitor.appendableType = appendableType;
            expression.accept(visitor);
            boolean bl = visitor.isAppendable();
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected boolean isAppendableToCollection(Expression expression) {
        IncompleteCollectionExpressionVisitor visitor = this.getIncompleteCollectionExpressionVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.isComplete();
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected boolean isClause(String identifier) {
        return this.getIdentifierRole(identifier) == IdentifierRole.CLAUSE;
    }

    protected boolean isClauseAppendable(Expression expression) {
        return this.isAppendable(expression, AppendableType.CLAUSE);
    }

    protected boolean isComplete(Expression expression) {
        return this.isAppendable(expression, AppendableType.COMPLETE);
    }

    protected boolean isCompoundable(Expression expression) {
        return this.isAppendable(expression, AppendableType.COMPOUNDABLE);
    }

    protected boolean isCompoundFunction(String identifier) {
        if (identifier == "IS" || identifier == "OF") {
            return false;
        }
        return this.getIdentifierRole(identifier) == IdentifierRole.COMPOUND_FUNCTION;
    }

    protected boolean isDeclaration(AbstractPathExpression expression) {
        DeclarationVisitor visitor = this.getDeclarationVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.isDeclaration();
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected boolean isEncapsulated(Expression expression) {
        EncapsulatedExpressionVisitor visitor = this.getEncapsulatedExpressionVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.isEncapsulated();
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected boolean isEnumAllowed(AbstractPathExpression expression) {
        EnumVisitor visitor = this.getEnumVisitor();
        try {
            visitor.pathExpression = expression;
            expression.accept(visitor);
            boolean bl = visitor.isValid();
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected boolean isFollowingInvalidExpression(Expression expression) {
        FollowingInvalidExpressionVisitor visitor = this.getFollowingInvalidExpressionVisitor();
        try {
            visitor.expression = expression;
            expression.accept(visitor);
            boolean bl = visitor.isFollowingInvalidExpression();
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected boolean isFunction(String identifier) {
        return this.getIdentifierRole(identifier) == IdentifierRole.FUNCTION;
    }

    protected boolean isInSubquery(Expression expression) {
        SubqueryVisitor visitor = this.getSubqueryVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.isInSubquery();
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected boolean isInvalidExpression(Expression expression) {
        InvalidExpressionVisitor visitor = this.getInvalidExpressionVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.isInvalid();
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected abstract boolean isJoinFetchIdentifiable();

    protected boolean isLocked(Expression expression) {
        return !this.lockedExpressions.empty() && this.lockedExpressions.peek() == expression;
    }

    protected boolean isNotExpression(Expression expression) {
        NotExpressionVisitor visitor = this.getNotExpressionVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.isNotExpression();
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected boolean isPositionWithin(int position, int offset, String word) {
        return position >= offset && position - offset <= word.length();
    }

    protected boolean isPositionWithin(int position, String word) {
        return this.isPositionWithin(position, 0, word);
    }

    protected boolean isSubqueryAppendable(Expression expression) {
        SubqueryAppendableExpressionVisitor visitor = this.getSubqueryAppendableExpressionVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.isAppendable();
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected boolean isValid(Expression expression, JPQLQueryBNF queryBNF) {
        AbstractValidator.JPQLQueryBNFValidator validator = this.buildJPQLQueryBNFValidator(queryBNF);
        try {
            expression.accept(validator);
            boolean bl = validator.isValid();
            return bl;
        }
        finally {
            validator.dispose();
        }
    }

    protected boolean isValid(Expression expression, String queryBNFId) {
        return this.isValid(expression, this.getQueryBNF(queryBNFId));
    }

    protected boolean isValid(JPQLQueryBNF parentQueryBNF, JPQLQueryBNF queryBNF) {
        return this.isValid(parentQueryBNF, queryBNF, false);
    }

    protected boolean isValid(JPQLQueryBNF parentQueryBNF, JPQLQueryBNF queryBNF, boolean bypassCompound) {
        AbstractValidator.JPQLQueryBNFValidator validator = this.buildJPQLQueryBNFValidator(parentQueryBNF);
        try {
            validator.setBypassCompound(bypassCompound);
            validator.validate(queryBNF);
            boolean bl = validator.isValid();
            return bl;
        }
        finally {
            validator.dispose();
        }
    }

    protected boolean isValid(JPQLQueryBNF parentQueryBNF, String queryBNFId, boolean bypassCompound) {
        return this.isValid(parentQueryBNF, this.getQueryBNF(queryBNFId), bypassCompound);
    }

    protected boolean isValidProposal(String proposal, String word) {
        if (word.length() == 0) {
            return true;
        }
        char character = word.charAt(0);
        if (character == '+' || character == '-' || character == '*' || character == '/') {
            return true;
        }
        if (word.length() > proposal.length()) {
            return false;
        }
        int index = 0;
        int length = word.length();
        while (index < length) {
            char upperCase2;
            char character1 = proposal.charAt(index);
            char character2 = word.charAt(index);
            char upperCase1 = Character.toUpperCase(character1);
            if (upperCase1 != (upperCase2 = Character.toUpperCase(character2))) {
                return false;
            }
            if (Character.toLowerCase(upperCase1) != Character.toLowerCase(upperCase2)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    protected boolean isValidVersion(String identifier) {
        JPAVersion identifierVersion = this.getLatestGrammar().getExpressionRegistry().getIdentifierVersion(identifier);
        return this.queryContext.getJPAVersion().isNewerThanOrEqual(identifierVersion);
    }

    protected boolean isWithinInvalidExpression(Expression expression) {
        WithinInvalidExpressionVisitor validator = this.getWithinInvalidExpressionVisitor();
        try {
            expression.accept(validator);
            boolean bl = validator.isWithinInvalidExpression();
            return bl;
        }
        finally {
            validator.dispose();
        }
    }

    protected final <T> void registerHelper(Class<T> helperClass, T helper) {
        this.helpers.put(helperClass, helper);
    }

    protected final void removeVirtualSpace() {
        this.virtualSpaces.pop();
    }

    public String toString() {
        return this.proposals.toString();
    }

    @Override
    public void visit(AbsExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(AbstractSchemaName expression) {
        this.corrections.add(this.queryPosition.getPosition(expression));
        super.visit(expression);
        this.corrections.pop();
        super.visit(expression);
    }

    @Override
    public void visit(AdditionExpression expression) {
        super.visit(expression);
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(AllOrAnyExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.NONE, "ALL", "ANY", "SOME");
    }

    @Override
    public void visit(AndExpression expression) {
        super.visit(expression);
        this.visitLogicalExpression(expression);
    }

    @Override
    public void visit(ArithmeticFactor expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        int length = 1;
        if (position == length) {
            this.addIdentificationVariables();
            this.addFunctionIdentifiers("arithmetic_primary");
        } else if ((expression.hasSpaceAfterArithmeticOperator() || this.hasVirtualSpace()) && position == ++length) {
            this.addIdentificationVariables();
            this.addFunctionIdentifiers("arithmetic_primary");
        }
    }

    @Override
    public void visit(AvgFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(BadExpression expression) {
        super.visit(expression);
        this.visitInvalidExpression(expression);
    }

    @Override
    public void visit(BetweenExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasExpression()) {
            length += expression.getExpression().getLength() + 1;
        }
        if (expression.hasNot() && this.isPositionWithin(position, length, "NOT BETWEEN") || !expression.hasNot() && this.isPositionWithin(position, length, "BETWEEN")) {
            this.proposals.addIdentifier("BETWEEN");
            this.proposals.addIdentifier("NOT BETWEEN");
        } else if (expression.hasSpaceAfterBetween()) {
            if (position == (length += expression.getIdentifier().length() + 1)) {
                this.addIdentificationVariables();
                this.addFunctionIdentifiers(expression.getBoundExpressionQueryBNFId());
            }
            if (expression.hasLowerBoundExpression()) {
                int lowerBoundLength = expression.getLowerBoundExpression().getLength();
                if (!expression.hasAnd() && position > length && position < length + lowerBoundLength && this.isAppendableToCollection(expression.getLowerBoundExpression())) {
                    this.addIdentifier("AND");
                }
                length += lowerBoundLength;
                if (expression.hasSpaceAfterLowerBound()) {
                    if (position == ++length) {
                        this.proposals.addIdentifier("AND");
                    } else if (expression.hasAnd() && this.isPositionWithin(position, length, "AND")) {
                        this.proposals.addIdentifier("AND");
                    } else if (expression.hasSpaceAfterAnd()) {
                        if (position == (length += "AND".length() + 1)) {
                            this.addIdentificationVariables();
                            this.addFunctionIdentifiers("internal_between_expression");
                        }
                    } else if (!expression.hasAnd() && expression.hasUpperBoundExpression() && position == (length += expression.getUpperBoundExpression().getLength())) {
                        this.addIdentifier("AND");
                    }
                }
            }
        }
    }

    @Override
    public void visit(CaseExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "CASE")) {
            this.addIdentifier("CASE");
            this.addIdentificationVariables();
            this.addFunctionIdentifiers(expression.getParent().findQueryBNF(expression));
        } else if (expression.hasSpaceAfterCase()) {
            int length = "CASE".length() + 1;
            if (position == length) {
                this.addIdentificationVariables();
                this.addFunctionIdentifiers("case_operand");
                this.proposals.addIdentifier("WHEN");
            }
            if (expression.hasCaseOperand() && expression.hasSpaceAfterCaseOperand() && position == (length += expression.getCaseOperand().getLength() + 1)) {
                this.proposals.addIdentifier("WHEN");
            }
            if (expression.hasWhenClauses() && expression.hasSpaceAfterWhenClauses()) {
                if (this.isPositionWithin(position, length += expression.getWhenClauses().getLength() + 1, "ELSE")) {
                    this.proposals.addIdentifier("ELSE");
                }
                if (expression.hasElse() && expression.hasSpaceAfterElse()) {
                    if (position == (length += "ELSE".length() + 1)) {
                        this.addIdentificationVariables();
                        this.addFunctionIdentifiers("scalar_expression");
                    }
                    if (expression.hasElseExpression() && expression.hasSpaceAfterElseExpression() && this.isPositionWithin(position, length += expression.getElseExpression().getLength() + 1, "END")) {
                        this.proposals.addIdentifier("END");
                    }
                }
            }
        }
    }

    @Override
    public void visit(CoalesceExpression expression) {
        int length;
        super.visit(expression);
        if (this.isFollowingInvalidExpression(expression)) {
            return;
        }
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "COALESCE")) {
            this.addIdentifier("COALESCE");
            this.addIdentificationVariables();
            this.addFunctionIdentifiers(expression.getParent().findQueryBNF(expression));
        } else if (expression.hasLeftParenthesis() && position == (length = "COALESCE".length() + 1)) {
            this.addIdentificationVariables();
            this.addFunctionIdentifiers(expression.getEncapsulatedExpressionQueryBNFId());
        }
    }

    @Override
    public void visit(CollectionExpression expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
        }
    }

    @Override
    public void visit(CollectionMemberDeclaration expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "IN")) {
            if (!this.isWithinInvalidExpression(expression)) {
                this.proposals.addIdentifier("IN");
            }
            this.addIdentificationVariables();
            this.addFunctionIdentifiers(expression.getParent().findQueryBNF(expression));
        }
        if (this.isInSubquery(expression) && expression.hasSpaceAfterIn()) {
            int length = "IN".length() + 1;
            if (position == length) {
                this.addLeftIdentificationVariables(expression);
            }
        } else if (expression.hasLeftParenthesis()) {
            int length = "IN".length() + 1;
            if (position == length) {
                this.addLeftIdentificationVariables(expression);
                this.addFunctionIdentifiers("collection_valued_path_expression");
            }
            if (expression.hasRightParenthesis()) {
                if (position == (length += expression.getCollectionValuedPathExpression().getLength() + 1) && !expression.hasSpaceAfterRightParenthesis()) {
                    this.proposals.addIdentifier("AS");
                }
                if (expression.hasSpaceAfterRightParenthesis()) {
                    ++length;
                }
                if (this.isPositionWithin(position, length, "AS")) {
                    this.proposals.addIdentifier("AS");
                }
            }
        }
    }

    @Override
    public void visit(CollectionMemberExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        String identifier = expression.getIdentifier();
        int length = 0;
        if (expression.hasEntityExpression()) {
            length = expression.getEntityExpression().getLength() + 1;
        }
        if (this.isPositionWithin(position, length, identifier)) {
            this.proposals.addIdentifier("NOT MEMBER");
            this.proposals.addIdentifier("NOT MEMBER OF");
            this.proposals.addIdentifier("MEMBER");
            this.proposals.addIdentifier("MEMBER OF");
        } else if ((expression.hasOf() && expression.hasSpaceAfterOf() || !expression.hasOf() && expression.hasSpaceAfterMember()) && position == (length += identifier.length() + 1)) {
            if (!expression.hasOf()) {
                this.addIdentifier("OF");
            }
            this.addIdentificationVariables();
        }
    }

    @Override
    public void visit(CollectionValuedPathExpression expression) {
        super.visit(expression);
        if (!this.isFollowingInvalidExpression(expression)) {
            this.visitPathExpression(expression);
            if (this.isDeclaration(expression)) {
                this.proposals.setClassNamePrefix(this.word, ContentAssistProposals.ClassType.INSTANTIABLE);
            }
        }
    }

    @Override
    public void visit(ComparisonExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasLeftExpression()) {
            length += expression.getLeftExpression().getLength() + 1;
        }
        if (this.isPositionWithin(position, length, expression.getComparisonOperator())) {
            this.addExpressionFactoryIdentifiers("comparison");
        }
        length += expression.getComparisonOperator().length();
        if (expression.hasSpaceAfterIdentifier()) {
            ++length;
        }
        if (position == length) {
            this.addIdentificationVariables();
            this.addFunctionIdentifiers(expression.getRightExpressionQueryBNFId());
            this.addClauseIdentifiers(expression.getRightExpressionQueryBNFId());
        }
    }

    @Override
    public void visit(ConcatExpression expression) {
        super.visit(expression);
        this.visitCollectionExpression(expression, "CONCAT", this.getConcatExpressionCollectionHelper());
    }

    @Override
    public void visit(ConstructorExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "NEW")) {
            this.proposals.addIdentifier("NEW");
        } else if (expression.hasSpaceAfterNew()) {
            int length = "NEW".length() + 1;
            String className = expression.getClassName();
            int classNameLength = className.length();
            if (position >= length && position <= length + classNameLength) {
                this.proposals.setClassNamePrefix(className.substring(0, position - length), ContentAssistProposals.ClassType.INSTANTIABLE);
            } else if (expression.hasLeftParenthesis()) {
                if (position == (length += classNameLength + 1)) {
                    this.addIdentificationVariables();
                    this.addFunctionIdentifiers("constructor_item");
                } else {
                    this.visitCollectionExpression(expression, "NEW", this.getConstructorCollectionHelper());
                }
            }
        }
    }

    @Override
    public void visit(CountFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(DateTime expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (expression.isCurrentDate() && this.isPositionWithin(position, "CURRENT_DATE") || expression.isCurrentTime() && this.isPositionWithin(position, "CURRENT_TIME") || expression.isCurrentTimestamp() && this.isPositionWithin(position, "CURRENT_TIMESTAMP")) {
            this.proposals.addIdentifier("CURRENT_DATE");
            this.proposals.addIdentifier("CURRENT_TIME");
            this.proposals.addIdentifier("CURRENT_TIMESTAMP");
            this.addFunctionIdentifiers(expression.getParent().findQueryBNF(expression));
        }
    }

    @Override
    public void visit(DeleteClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "DELETE FROM", this.getDeleteClauseCollectionHelper());
        }
    }

    @Override
    public void visit(DeleteStatement expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitStatement(expression, this.getDeleteClauseStatementHelper());
        }
    }

    @Override
    public void visit(DivisionExpression expression) {
        super.visit(expression);
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(EmptyCollectionComparisonExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasExpression()) {
            length = expression.getExpression().getLength() + 1;
        }
        if (this.isPositionWithin(position, length, expression.getIdentifier())) {
            this.proposals.addIdentifier("IS EMPTY");
            this.proposals.addIdentifier("IS NOT EMPTY");
        }
    }

    @Override
    public void visit(EntityTypeLiteral expression) {
        this.corrections.add(this.queryPosition.getPosition(expression));
        super.visit(expression);
        this.corrections.pop();
        this.addEntities();
    }

    @Override
    public void visit(EntryExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.COLLECTION);
    }

    @Override
    public void visit(ExistsExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.NONE, "EXISTS", "NOT EXISTS");
    }

    @Override
    protected void visit(Expression expression) {
        expression.getParent().accept(this);
    }

    @Override
    public void visit(FromClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "FROM", this.getFromClauseCollectionHelper());
        }
    }

    @Override
    public void visit(FunctionExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(GroupByClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "GROUP BY", this.getGroupByClauseCollectionHelper());
        }
    }

    @Override
    public void visit(HavingClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, expression.getIdentifier(), this.getConditionalClauseCollectionHelper());
        }
    }

    @Override
    public void visit(IdentificationVariable expression) {
        this.corrections.add(this.queryPosition.getPosition(expression));
        super.visit(expression);
        this.corrections.pop();
        super.visit(expression);
    }

    @Override
    public void visit(IdentificationVariableDeclaration expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (position > 0 && (expression.hasSpace() || this.hasVirtualSpace())) {
            Expression rangeVariableDeclaration = expression.getRangeVariableDeclaration();
            int length = rangeVariableDeclaration.getLength() + 1;
            if (position == length) {
                if (this.isComplete(rangeVariableDeclaration)) {
                    this.addJoinIdentifiers();
                }
            } else {
                this.visitCollectionExpression(expression, "", this.getJoinCollectionHelper());
            }
        }
    }

    @Override
    public void visit(IndexExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(InExpression expression) {
        expression.accept(this.getVisitParentVisitor());
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasExpression()) {
            length = expression.getExpression().getLength() + 1;
        }
        if (this.isPositionWithin(position, length, expression.getIdentifier())) {
            if (length > 2) {
                this.proposals.addIdentifier("IN");
                this.proposals.addIdentifier("NOT IN");
            }
            this.addIdentificationVariables();
            this.addFunctionIdentifiers(expression.getParent().findQueryBNF(expression));
        } else if (expression.hasLeftParenthesis() && position == (length += expression.getIdentifier().length() + 1)) {
            this.addFunctionIdentifiers("in_expression_item");
            this.proposals.addIdentifier("SELECT");
        }
    }

    @Override
    public void visit(InputParameter expression) {
        super.visit(expression);
    }

    @Override
    public void visit(Join expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        String identifier = expression.getIdentifier();
        boolean joinFetch = expression.hasFetch();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier("JOIN");
            this.proposals.addIdentifier("INNER JOIN");
            this.proposals.addIdentifier("LEFT JOIN");
            this.proposals.addIdentifier("LEFT OUTER JOIN");
            if (this.isJoinFetchIdentifiable() || !expression.hasAs() && !expression.hasIdentificationVariable()) {
                this.proposals.addIdentifier("JOIN FETCH");
                this.proposals.addIdentifier("INNER JOIN FETCH");
                this.proposals.addIdentifier("LEFT JOIN FETCH");
                this.proposals.addIdentifier("LEFT OUTER JOIN FETCH");
            }
        } else if (expression.hasSpaceAfterJoin()) {
            int length = identifier.length() + 1;
            if (position == length) {
                if (identifier == "LEFT") {
                    this.addIdentifier("LEFT JOIN");
                    this.addIdentifier("LEFT OUTER JOIN");
                    if (this.isJoinFetchIdentifiable() || !expression.hasAs() && !expression.hasIdentificationVariable()) {
                        this.addIdentifier("LEFT JOIN FETCH");
                        this.addIdentifier("LEFT OUTER JOIN FETCH");
                    }
                } else if (identifier == "INNER") {
                    this.addIdentifier("INNER JOIN");
                    if (this.isJoinFetchIdentifiable() || !expression.hasAs() && !expression.hasIdentificationVariable()) {
                        this.addIdentifier("INNER JOIN FETCH");
                    }
                } else if (identifier.equals("LEFT_OUTER")) {
                    this.addIdentifier("LEFT OUTER JOIN");
                    if (this.isJoinFetchIdentifiable() || !expression.hasAs() && !expression.hasIdentificationVariable()) {
                        this.addIdentifier("LEFT OUTER JOIN FETCH");
                    }
                } else {
                    this.addLeftIdentificationVariables(expression);
                }
            }
            if (expression.hasJoinAssociationPath() && expression.hasSpaceAfterJoinAssociation()) {
                length += expression.getJoinAssociationPath().getLength() + 1;
                if (!joinFetch || joinFetch && this.isJoinFetchIdentifiable()) {
                    if (this.isPositionWithin(position, length, "AS")) {
                        this.addIdentifier("AS");
                    }
                    if (expression.hasAs()) {
                        length += 2;
                        if (expression.hasSpaceAfterAs()) {
                            ++length;
                        }
                    }
                }
                if (joinFetch || expression.hasIdentificationVariable()) {
                    length += expression.getIdentificationVariable().getLength();
                    if (expression.hasSpaceAfterIdentificationVariable()) {
                        ++length;
                    }
                    if (position == length) {
                        this.addIdentifier("ON");
                    }
                }
            }
        }
    }

    @Override
    public void visit(JPQLExpression expression) {
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (position == 0) {
            this.addIdentifier("DELETE FROM");
            this.addIdentifier("SELECT");
            this.addIdentifier("UPDATE");
        }
    }

    @Override
    public void visit(KeyExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.LEFT_COLLECTION);
    }

    @Override
    public void visit(KeywordExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        String keyword = expression.getText();
        if (keyword == "TRUE" && this.isPositionWithin(position, "TRUE") || keyword == "FALSE" && this.isPositionWithin(position, "FALSE") || keyword == "NULL" && this.isPositionWithin(position, "NULL")) {
            this.proposals.addIdentifier("TRUE");
            this.proposals.addIdentifier("FALSE");
            this.proposals.addIdentifier("NULL");
            this.addIdentificationVariables();
            this.addFunctionIdentifiers(expression.getParent().findQueryBNF(expression));
        }
    }

    @Override
    public void visit(LengthExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(LikeExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (expression.hasStringExpression()) {
            int length = expression.getStringExpression().getLength() + 1;
            if (this.isPositionWithin(position, length, expression.getIdentifier())) {
                this.proposals.addIdentifier("LIKE");
                this.proposals.addIdentifier("NOT LIKE");
            } else if (expression.hasSpaceAfterLike()) {
                length += expression.getIdentifier().length() + 1;
                if (expression.hasPatternValue() && expression.hasSpaceAfterPatternValue() && this.isPositionWithin(position, length += expression.getPatternValue().getLength() + 1, "ESCAPE")) {
                    this.proposals.addIdentifier("ESCAPE");
                }
            }
        }
    }

    @Override
    public void visit(LocateExpression expression) {
        super.visit(expression);
        this.visitCollectionExpression(expression, "LOCATE", this.getTripleEncapsulatedCollectionHelper());
    }

    @Override
    public void visit(LowerExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(MaxFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(MinFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(ModExpression expression) {
        super.visit(expression);
        this.visitCollectionExpression(expression, "MOD", this.getDoubleEncapsulatedCollectionHelper());
    }

    @Override
    public void visit(MultiplicationExpression expression) {
        super.visit(expression);
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(NotExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "NOT")) {
            this.proposals.addIdentifier("NOT");
        }
    }

    @Override
    public void visit(NullComparisonExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasExpression()) {
            length += expression.getExpression().getLength() + 1;
        }
        if (this.isPositionWithin(position, length, expression.getIdentifier())) {
            this.proposals.addIdentifier("IS NULL");
            this.proposals.addIdentifier("IS NOT NULL");
        }
    }

    @Override
    public void visit(NullExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(NullIfExpression expression) {
        super.visit(expression);
        this.visitCollectionExpression(expression, "NULLIF", this.getDoubleEncapsulatedCollectionHelper());
    }

    @Override
    public void visit(NumericLiteral expression) {
        super.visit(expression);
    }

    @Override
    public void visit(ObjectExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(OnClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, expression.getIdentifier(), this.getConditionalClauseCollectionHelper());
        }
    }

    @Override
    public void visit(OrderByClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "ORDER BY", this.getOrderByClauseCollectionHelper());
        }
    }

    @Override
    public void visit(OrderByItem expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (expression.hasExpression()) {
            int length = expression.getExpression().getLength();
            if (position > -1 && position <= length) {
                if (!expression.hasNulls() && !expression.hasOrdering()) {
                    this.addIdentifier("ASC");
                    this.addIdentifier("DESC");
                }
            } else if (expression.hasSpaceAfterExpression()) {
                if (position == ++length) {
                    this.proposals.addIdentifier("ASC");
                    this.proposals.addIdentifier("DESC");
                } else {
                    OrderByItem.Ordering ordering = expression.getOrdering();
                    if (ordering != OrderByItem.Ordering.DEFAULT && this.isPositionWithin(position, length, ordering.name())) {
                        this.proposals.addIdentifier("ASC");
                        this.proposals.addIdentifier("DESC");
                    }
                }
            }
        }
    }

    @Override
    public void visit(OrExpression expression) {
        super.visit(expression);
        this.visitLogicalExpression(expression);
    }

    @Override
    public void visit(RangeVariableDeclaration expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (expression.hasRootObject()) {
            int length = expression.getRootObject().getLength();
            if (expression.hasSpaceAfterRootObject()) {
                if (position == ++length) {
                    this.addIdentifier("AS");
                } else if (expression.hasAs() && this.isPositionWithin(position, length, "AS")) {
                    this.addIdentifier("AS");
                }
            }
        }
    }

    @Override
    public void visit(ResultVariable expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (expression.hasSelectExpression()) {
            Expression selectItem = expression.getSelectExpression();
            int length = selectItem.getLength() + 1;
            if (position == length) {
                if (this.isComplete(selectItem)) {
                    this.addIdentifier("AS");
                }
                if (this.areArithmeticSymbolsAppendable(selectItem)) {
                    this.addArithmeticIdentifiers();
                }
            } else if (expression.hasAs() && this.isPositionWithin(position, length, "AS")) {
                if (this.isComplete(selectItem)) {
                    this.addIdentifier("AS");
                }
                this.addFunctionIdentifiers(selectItem);
            }
        } else if (expression.hasAs() && this.isPositionWithin(position, "AS")) {
            this.addFunctionIdentifiers(expression);
        }
    }

    @Override
    public void visit(SelectClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "SELECT", this.getSelectClauseCollectionHelper());
        }
    }

    @Override
    public void visit(SelectStatement expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitStatement(expression, this.getSelectClauseStatementHelper());
        }
    }

    @Override
    public void visit(SimpleFromClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "FROM", this.getFromClauseCollectionHelper());
        }
    }

    @Override
    public void visit(SimpleSelectClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "SELECT", this.getSimpleSelectClauseCollectionHelper());
        }
    }

    @Override
    public void visit(SimpleSelectStatement expression) {
        if (!this.isLocked(expression)) {
            this.visitStatement(expression, this.getSimpleSelectClauseStatementHelper());
        }
    }

    @Override
    public void visit(SizeExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(SqrtExpression expression) {
        expression.accept(this.getVisitParentVisitor());
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(StateFieldPathExpression expression) {
        super.visit(expression);
        if (!this.isFollowingInvalidExpression(expression)) {
            this.visitPathExpression(expression);
        }
    }

    @Override
    public void visit(StringLiteral expression) {
        super.visit(expression);
    }

    @Override
    public void visit(SubExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (position == 1) {
            this.addFunctionIdentifiers(expression);
        }
    }

    @Override
    public void visit(SubstringExpression expression) {
        super.visit(expression);
        this.visitCollectionExpression(expression, "SUBSTRING", this.getTripleEncapsulatedCollectionHelper());
    }

    @Override
    public void visit(SubtractionExpression expression) {
        super.visit(expression);
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(SumFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(TreatExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "TREAT")) {
            this.addIdentifier("TREAT");
            this.addIdentificationVariables();
            this.addFunctionIdentifiers(expression.getParent().findQueryBNF(expression));
        } else if (expression.hasLeftParenthesis()) {
            Expression collectionValuedPathExpression;
            int length = "TREAT".length() + 1;
            if (position == length) {
                this.addLeftIdentificationVariables(expression);
            }
            if (expression.hasCollectionValuedPathExpression() && expression.hasSpaceAfterCollectionValuedPathExpression() && this.isPositionWithin(position, length += (collectionValuedPathExpression = expression.getCollectionValuedPathExpression()).getLength() + 1, "AS")) {
                this.addIdentifier("AS");
                if (!expression.hasEntityType()) {
                    IType type = this.queryContext.getType(collectionValuedPathExpression);
                    if (type.isResolvable()) {
                        this.addEntities(type);
                    } else {
                        this.addEntities();
                    }
                }
            }
            if (expression.hasAs() && expression.hasSpaceAfterAs() && position == (length += "AS".length() + 1)) {
                IType type = this.queryContext.getType(expression.getCollectionValuedPathExpression());
                if (type.isResolvable()) {
                    this.addEntities(type);
                } else {
                    this.addEntities();
                }
            }
        }
    }

    @Override
    public void visit(TrimExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (this.isPositionWithin(position, "TRIM")) {
            this.addIdentifier("TRIM");
            this.addIdentificationVariables();
            this.addFunctionIdentifiers(expression.getParent().findQueryBNF(expression));
        } else if (expression.hasLeftParenthesis()) {
            if (position == (length += "TRIM".length() + 1)) {
                this.addIdentifier("BOTH");
                this.addIdentifier("LEADING");
                this.addIdentifier("TRAILING");
                if (!expression.hasTrimCharacter() && !expression.hasFrom()) {
                    this.addIdentificationVariables();
                    this.addFunctionIdentifiers("string_primary");
                }
            }
            if (expression.hasSpecification()) {
                String specification = expression.getSpecification().name();
                if (this.isPositionWithin(position, length, specification)) {
                    this.addIdentifier("BOTH");
                    this.addIdentifier("LEADING");
                    this.addIdentifier("TRAILING");
                    if (!expression.hasTrimCharacter() && !expression.hasFrom()) {
                        this.addIdentificationVariables();
                        this.addFunctionIdentifiers("string_primary");
                    }
                }
                length += specification.length();
            }
            if (expression.hasSpaceAfterSpecification()) {
                ++length;
            }
            if (expression.hasTrimCharacter()) {
                length += expression.getTrimCharacter().getLength();
            }
            if (expression.hasSpaceAfterTrimCharacter()) {
                ++length;
            }
            if (position == length) {
                this.addIdentifier("FROM");
                if (!expression.hasFrom()) {
                    this.addIdentificationVariables();
                    this.addFunctionIdentifiers("string_primary");
                }
            }
            if (expression.hasFrom()) {
                if (this.isPositionWithin(position, length, "FROM")) {
                    this.addIdentifier("FROM");
                }
                length += "FROM".length();
            }
            if (expression.hasSpaceAfterFrom()) {
                ++length;
            }
            if (position == length) {
                this.addIdentificationVariables();
                this.addFunctionIdentifiers("string_primary");
            }
            if (expression.hasExpression() && position == (length += expression.getExpression().getLength()) + this.virtualSpaces.peek() && !expression.hasTrimCharacter() && !expression.hasFrom()) {
                this.addIdentifier("FROM");
            }
        }
    }

    @Override
    public void visit(TypeExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(UnknownExpression expression) {
        super.visit(expression);
        this.visitInvalidExpression(expression);
    }

    @Override
    public void visit(UpdateClause expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "UPDATE")) {
            this.proposals.addIdentifier("UPDATE");
        } else if (expression.hasSpaceAfterUpdate()) {
            RangeVariableDeclaration rangeVariableDeclaration;
            int length = "UPDATE".length() + 1;
            if (position == length) {
                this.addEntities();
            } else if (expression.hasRangeVariableDeclaration() && (rangeVariableDeclaration = this.findRangeVariableDeclaration(expression)) != null && rangeVariableDeclaration.hasRootObject() && rangeVariableDeclaration.hasSpaceAfterRootObject()) {
                if (!expression.hasSet() && !rangeVariableDeclaration.hasAs() && this.isPositionWithin(position, length += rangeVariableDeclaration.getRootObject().getLength() + 1, "SET")) {
                    this.addIdentifier("SET");
                } else {
                    if (rangeVariableDeclaration.hasAs()) {
                        length += 2;
                    }
                    if (rangeVariableDeclaration.hasSpaceAfterAs()) {
                        ++length;
                    }
                    if (rangeVariableDeclaration.hasIdentificationVariable()) {
                        length += rangeVariableDeclaration.getIdentificationVariable().getLength();
                    }
                    if (expression.hasSpaceAfterRangeVariableDeclaration()) {
                        ++length;
                    }
                    if ((rangeVariableDeclaration.hasAs() && rangeVariableDeclaration.hasIdentificationVariable() || !rangeVariableDeclaration.hasAs() && rangeVariableDeclaration.hasIdentificationVariable()) && this.isPositionWithin(position, length, "SET")) {
                        this.addIdentifier("SET");
                    } else if (expression.hasSet() && expression.hasSpaceAfterSet()) {
                        if (position == (length += "SET".length() + 1)) {
                            this.addIdentificationVariables();
                        } else {
                            this.visitCollectionExpression(expression, "", this.getUpdateItemCollectionHelper());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void visit(UpdateItem expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (position == length) {
            this.addIdentificationVariables();
        } else if (expression.hasStateFieldPathExpression() && expression.hasSpaceAfterStateFieldPathExpression()) {
            if (position == (length += expression.getStateFieldPathExpression().getLength() + 1)) {
                this.proposals.addIdentifier("=");
            } else if (expression.hasEqualSign()) {
                if (position == ++length) {
                    this.proposals.addIdentifier("=");
                    this.addIdentificationVariables();
                    this.addFunctionIdentifiers("new_value");
                } else if (expression.hasSpaceAfterEqualSign() && position == ++length) {
                    this.addIdentificationVariables();
                    this.addFunctionIdentifiers("new_value");
                }
            }
        }
    }

    @Override
    public void visit(UpdateStatement expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitStatement(expression, this.getUpdateClauseStatementHelper());
        }
    }

    @Override
    public void visit(UpperExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(ValueExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.LEFT_COLLECTION);
    }

    @Override
    public void visit(WhenClause expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "WHEN")) {
            if (!this.isWithinInvalidExpression(expression)) {
                this.proposals.addIdentifier("WHEN");
            }
        } else if (expression.hasSpaceAfterWhen()) {
            int length = 5;
            if (position == length) {
                this.visitCollectionExpression(expression, "WHEN", this.getWhenClauseConditionalClauseCollectionHelper());
            } else {
                length += expression.getWhenExpression().getLength();
                if (expression.hasSpaceAfterWhenExpression()) {
                    if (position == ++length) {
                        this.visitCollectionExpression(expression, "WHEN", this.getWhenClauseConditionalClauseCollectionHelper());
                        if (this.isComplete(expression)) {
                            this.proposals.addIdentifier("THEN");
                        }
                    } else if (expression.hasThen()) {
                        if (this.isPositionWithin(position, length, "THEN")) {
                            this.proposals.addIdentifier("THEN");
                        } else {
                            length += 4;
                            if (expression.hasSpaceAfterThen() && position == ++length) {
                                this.addIdentificationVariables();
                                this.addFunctionIdentifiers("scalar_expression");
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void visit(WhereClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, expression.getIdentifier(), this.getConditionalClauseCollectionHelper());
        }
    }

    protected void visitAggregateFunction(AggregateFunction expression) {
        String identifier;
        if (this.isFollowingInvalidExpression(expression)) {
            return;
        }
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, identifier = expression.getIdentifier())) {
            this.addIdentifier(identifier);
            this.addFunctionIdentifiers(expression);
        } else if (expression.hasLeftParenthesis()) {
            int length = identifier.length() + 1;
            boolean hasDistinct = expression.hasDistinct();
            if (hasDistinct && this.isPositionWithin(position, length, "DISTINCT")) {
                this.addIdentifier("DISTINCT");
            } else {
                if (hasDistinct && expression.hasSpaceAfterDistinct()) {
                    length += "DISTINCT".length() + 1;
                }
                if (position == length) {
                    if (!hasDistinct) {
                        this.addIdentifier("DISTINCT");
                    }
                    this.addIdentificationVariables();
                    this.addFunctionIdentifiers(expression.getEncapsulatedExpressionQueryBNFId());
                }
            }
        }
    }

    protected void visitArithmeticExpression(ArithmeticExpression expression) {
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasLeftExpression()) {
            length += expression.getLeftExpression().getLength() + 1;
        }
        if (this.isPositionWithin(position, length, "+")) {
            this.addAggregateIdentifiers(expression.getQueryBNF());
        } else if (expression.hasSpaceAfterIdentifier() && position == (length += 2)) {
            this.addIdentificationVariables();
            this.addFunctionIdentifiers(expression.getRightExpressionQueryBNFId());
        }
    }

    protected <T extends Expression> void visitCollectionExpression(T expression, String identifier, CollectionExpressionHelper<T> helper) {
        if (this.isFollowingInvalidExpression(expression)) {
            return;
        }
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        boolean hasIdentifier = identifier.length() > 0;
        boolean virtualSpace = this.hasVirtualSpace();
        if (hasIdentifier && this.isPositionWithin(position, identifier)) {
            helper.addIdentifier(expression, identifier);
        } else if (helper.hasDelimiterAfterIdentifier(expression)) {
            int length;
            int n = length = !hasIdentifier ? 0 : identifier.length() + 1;
            if (position == (length += helper.preExpressionLength(expression))) {
                helper.addTheBeginningOfChild(expression, null, 0, false);
            } else {
                CollectionExpression collectionExpression = helper.buildCollectionExpression(expression);
                boolean hasComma = false;
                boolean previousHasComma = false;
                int childrenCount = collectionExpression.childrenSize();
                int count = Math.min(childrenCount, helper.maxCollectionSize(expression));
                int index = 0;
                while (index < count) {
                    Expression child = collectionExpression.getChild(index);
                    int childLength = 0;
                    if (position == length) {
                        helper.addTheBeginningOfChild(expression, collectionExpression, index, hasComma);
                        break;
                    }
                    if (index > 0 && !hasComma) {
                        if (position == (length += child.getLength())) {
                            helper.addAtTheEndOfChild(expression, collectionExpression, index, hasComma, false);
                            break;
                        }
                        if (!helper.canContinue(expression, collectionExpression, index)) break;
                        if (index + 1 == count) {
                            helper.addAtTheEndOfChild(expression, collectionExpression, index, hasComma, false);
                        }
                    } else {
                        childLength = child.getLength();
                        if (position == length + childLength || virtualSpace && position == length + childLength + 1) {
                            helper.addAtTheEndOfChild(expression, collectionExpression, index, hasComma, virtualSpace);
                            break;
                        }
                    }
                    length += childLength;
                    previousHasComma = hasComma;
                    hasComma = collectionExpression.hasComma(index);
                    if (hasComma) {
                        if (index > 0 && !previousHasComma) {
                            return;
                        }
                        if (position == ++length) {
                            helper.addTheBeginningOfChild(expression, collectionExpression, index + 1, hasComma);
                            break;
                        }
                    }
                    if (collectionExpression.hasSpace(index) && !hasComma && position == ++length) {
                        helper.addAtTheEndOfChild(expression, collectionExpression, index, hasComma, true);
                    }
                    if (position < length) break;
                    ++index;
                }
            }
        }
    }

    protected void visitEndingExpression(Expression expression) {
        QueryPosition oldQueryPosition = this.queryPosition;
        this.queryPosition = this.buildEndingPositionFromInvalidExpression(expression, expression, new boolean[1]);
        expression = this.queryPosition.getExpression();
        while (expression != null) {
            int position = this.queryPosition.getPosition(expression);
            if (position == -1) {
                expression = null;
                continue;
            }
            this.queryPosition.addPosition(expression, position + 1);
            expression = expression.getParent();
        }
        this.corrections.add(0);
        this.addVirtualSpace();
        this.queryPosition.getExpression().accept(this);
        this.queryPosition = oldQueryPosition;
        this.corrections.pop();
        this.removeVirtualSpace();
    }

    protected void visitEnumConstant(AbstractPathExpression expression) {
        int position = this.queryPosition.getPosition(expression);
        String text = expression.toActualText();
        int lastDotIndex = text.lastIndexOf(46);
        if (this.isEnumAllowed(expression)) {
            String enumType;
            IType type;
            boolean enumConstant = false;
            if (position > lastDotIndex && (type = this.queryContext.getType(enumType = expression.toParsedText().substring(0, lastDotIndex))).isResolvable() && type.isEnum()) {
                enumConstant = true;
                String word = text.substring(lastDotIndex + 1, position);
                this.addEnumConstants(type, word);
            }
            if (!enumConstant) {
                text = text.substring(0, position);
                this.proposals.setClassNamePrefix(text, ContentAssistProposals.ClassType.ENUM);
            }
        }
    }

    protected void visitInvalidExpression(Expression expression) {
        if (!this.isLocked(expression)) {
            boolean virtualSpace;
            int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
            boolean bl = virtualSpace = position == 1 && this.word.length() == 0;
            if (this.isPositionWithin(position, this.word) || virtualSpace) {
                this.lockedExpressions.add(expression);
                QueryPosition oldQueryPosition = this.queryPosition;
                boolean[] spaces = new boolean[1];
                this.queryPosition = this.buildEndingPositionFromInvalidExpression(expression, expression.getRoot(), spaces);
                this.corrections.add(0);
                if (spaces[0] || virtualSpace) {
                    this.addVirtualSpace();
                }
                this.queryPosition.getExpression().accept(this);
                this.queryPosition = oldQueryPosition;
                this.corrections.pop();
                this.lockedExpressions.pop();
                if (spaces[0] || virtualSpace) {
                    this.removeVirtualSpace();
                }
            }
        }
    }

    protected void visitLogicalExpression(LogicalExpression expression) {
        if (this.isFollowingInvalidExpression(expression)) {
            return;
        }
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        String identifier = expression.getIdentifier();
        int length = 0;
        if (expression.hasLeftExpression()) {
            length += expression.getLeftExpression().getLength() + 1;
        }
        if (this.isPositionWithin(position, length, identifier)) {
            this.proposals.addIdentifier(identifier);
        } else if (expression.hasSpaceAfterIdentifier() && position == (length += identifier.length() + 1)) {
            this.addIdentificationVariables();
            this.addFunctionIdentifiers(expression.getRightExpressionQueryBNFId());
        }
    }

    protected void visitPathExpression(AbstractPathExpression expression) {
        int position = this.queryPosition.getPosition(expression);
        String text = expression.toActualText();
        int dotIndex = text.indexOf(46);
        if (position > -1) {
            String variableName = this.queryContext.literal(expression.getIdentificationVariable(), LiteralType.IDENTIFICATION_VARIABLE);
            boolean variable = ExpressionTools.stringIsNotEmpty(variableName);
            if (dotIndex > -1 && position > dotIndex) {
                this.visitPathExpression(expression, this.buildMappingFilter(expression));
                if (variable) {
                    this.visitEnumConstant(expression);
                    this.visitThirdPartyPathExpression(expression, variableName);
                }
            } else if (variable) {
                this.corrections.add(this.queryPosition.getPosition(expression));
                this.visit(expression);
                this.corrections.pop();
            }
        }
    }

    protected void visitPathExpression(AbstractPathExpression expression, Filter<IMapping> filter) {
        MappingCollector mappingCollector = this.getDefaultMappingCollector();
        int position = this.queryPosition.getPosition(expression);
        boolean mappingCollectorCreated = false;
        Resolver resolver = null;
        int length = 0;
        int index = 0;
        int count = expression.pathSize();
        while (index < count) {
            Resolver childResolver;
            String path = expression.getPath(index);
            if (position <= length + path.length()) {
                if (length == position) {
                    path = "";
                } else if (position - length > -1) {
                    path = path.substring(0, position - length);
                }
                if (resolver == null) break;
                mappingCollector = this.buildFilteringMappingCollector(expression, resolver, filter, path);
                mappingCollectorCreated = true;
                break;
            }
            if (resolver == null) {
                resolver = this.queryContext.getResolver(expression.getIdentificationVariable());
            } else if ((index + 1 < count || expression.endsWithDot()) && (childResolver = resolver.getChild(path)) == null) {
                childResolver = new StateFieldResolver(resolver, path);
                resolver.addChild(path, childResolver);
                resolver = childResolver;
            }
            length += path.length() + 1;
            ++index;
        }
        if (!mappingCollectorCreated && resolver != null) {
            mappingCollector = this.buildMappingCollector(expression, resolver, filter);
        }
        this.proposals.addMappings(mappingCollector.buildProposals());
    }

    protected void visitSingleEncapsulatedExpression(AbstractSingleEncapsulatedExpression expression, IdentificationVariableType identificationVariableType) {
        this.visitSingleEncapsulatedExpression(expression, identificationVariableType, expression.getIdentifier());
    }

    protected void visitSingleEncapsulatedExpression(AbstractSingleEncapsulatedExpression expression, IdentificationVariableType identificationVariableType, String ... expressionIdentifiers) {
        if (this.isFollowingInvalidExpression(expression)) {
            return;
        }
        int position = this.queryPosition.getPosition(expression) - this.corrections.peek();
        String actualIdentifier = expression.getIdentifier();
        boolean added = false;
        String[] stringArray = expressionIdentifiers;
        int n = expressionIdentifiers.length;
        int n2 = 0;
        while (n2 < n) {
            String identifier = stringArray[n2];
            if (this.isPositionWithin(position, actualIdentifier)) {
                int n3;
                String[] stringArray2;
                this.addFunctionIdentifiers(expression);
                if (!this.isWithinInvalidExpression(expression)) {
                    stringArray2 = expressionIdentifiers;
                    n3 = expressionIdentifiers.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String jpqlIdentifier = stringArray2[n4];
                        this.proposals.addIdentifier(identifier);
                        ++n4;
                    }
                } else {
                    stringArray2 = expressionIdentifiers;
                    n3 = expressionIdentifiers.length;
                    int n5 = 0;
                    while (n5 < n3) {
                        String jpqlIdentifier = stringArray2[n5];
                        this.proposals.removeIdentifier(identifier);
                        ++n5;
                    }
                }
            } else if (expression.hasLeftParenthesis()) {
                int length = identifier.length() + 1;
                if (!added && position == length) {
                    added = true;
                    this.addIdentificationVariables(expression, identificationVariableType);
                    String queryBNF = expression.getEncapsulatedExpressionQueryBNFId();
                    this.addFunctionIdentifiers(queryBNF);
                    this.addClauseIdentifiers(queryBNF);
                }
            }
            ++n2;
        }
    }

    protected <T extends Expression> void visitStatement(T expression, StatementHelper<T> helper) {
        this.lockedExpressions.add(expression);
        try {
            int position = this.queryPosition.getPosition(expression);
            int length = 0;
            while (helper != null) {
                Expression clause = helper.getClause(expression);
                if (position < (length += clause.getLength())) {
                    break;
                }
                boolean complete = false;
                if (position == length) {
                    complete = this.isClauseAppendable(clause);
                } else if (helper.hasSpaceAfterClause(expression) && position == ++length) {
                    this.visitEndingExpression(clause);
                    complete = helper.isClauseComplete(expression);
                }
                if (!complete) {
                    helper = helper.getNextHelper();
                    continue;
                }
                helper.addInternalClauseProposals(expression);
                do {
                    if ((helper = helper.getNextHelper()) == null) continue;
                    helper.addClauseProposals();
                    if (!helper.isRequired() && !helper.hasClause(expression)) continue;
                    helper = null;
                } while (helper != null);
            }
        }
        finally {
            this.lockedExpressions.pop();
        }
    }

    protected void visitThirdPartyPathExpression(AbstractPathExpression expression, String variableName) {
    }

    protected static class AbstractAppendableExpressionVisitor
    extends AnonymousExpressionVisitor {
        protected boolean appendable;

        protected AbstractAppendableExpressionVisitor() {
        }

        public void dispose() {
            this.appendable = false;
        }

        public boolean isAppendable() {
            return this.appendable;
        }
    }

    protected static abstract class AbstractConditionalClauseCollectionHelper<T extends Expression>
    extends AbstractVisitorHelper
    implements CollectionExpressionHelper<T> {
        protected AbstractConditionalClauseCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addAtTheEndOfChild(Expression expression, CollectionExpression collectionExpression, int index, boolean hasComma, boolean virtualSpace) {
            if (index < 0) {
                index = -index / 10 - 1;
            }
            if (index == 0 && !virtualSpace) {
                Expression child = collectionExpression.getChild(0);
                if (this.visitor.areArithmeticSymbolsAppendable(child)) {
                    this.visitor.addArithmeticIdentifiers();
                }
            } else {
                Object[] result = this.findChild(collectionExpression, index);
                if (result == null) {
                    return;
                }
                Expression child = (Expression)result[0];
                boolean hasIs = (Boolean)result[1];
                boolean hasNot = (Boolean)result[2];
                if (!hasIs && !hasNot) {
                    if (this.visitor.areLogicalSymbolsAppendable(child)) {
                        this.visitor.addLogicalIdentifiers();
                    }
                    if (this.visitor.areArithmeticSymbolsAppendable(child)) {
                        this.visitor.addArithmeticIdentifiers();
                    }
                    if (this.visitor.areComparisonSymbolsAppendable(child)) {
                        this.visitor.addComparisonIdentifiers(child);
                    }
                }
                if (this.visitor.isCompoundable(child)) {
                    this.visitor.addCompoundIdentifiers("conditional_expression", child, hasIs, hasNot);
                }
            }
        }

        @Override
        public void addIdentifier(Expression expression, String identifier) {
            this.visitor.proposals.addIdentifier(identifier);
        }

        @Override
        public void addTheBeginningOfChild(Expression expression, CollectionExpression collectionExpression, int index, boolean hasComma) {
            if (index == 0) {
                this.visitor.addIdentificationVariables();
                this.visitor.addFunctionIdentifiers("conditional_expression");
                if (collectionExpression != null && this.visitor.isSubqueryAppendable(collectionExpression.getChild(index))) {
                    this.visitor.addIdentifier("SELECT");
                }
            } else {
                this.addAtTheEndOfChild(expression, collectionExpression, index * -10, hasComma, true);
            }
        }

        @Override
        public boolean canContinue(Expression expression, CollectionExpression collectionExpression, int index) {
            Expression child = collectionExpression.getChild(index);
            if (this.visitor.isNotExpression(child)) {
                return true;
            }
            String text = child.toParsedText();
            return text.equalsIgnoreCase("IS") || text.equalsIgnoreCase("NOT") || text.equalsIgnoreCase("IS NOT");
        }

        protected Object[] findChild(CollectionExpression collectionExpression, int index) {
            boolean notFound = false;
            boolean isFound = false;
            boolean scanPrevious = false;
            while (index > -1) {
                Expression child = collectionExpression.getChild(index);
                String text = child.toParsedText();
                if (text.equalsIgnoreCase("NOT") || this.visitor.isNotExpression(child)) {
                    if (isFound || notFound) break;
                    notFound = true;
                } else if (text.equalsIgnoreCase("IS")) {
                    if (isFound) break;
                    isFound = true;
                } else if ("IS NOT".equalsIgnoreCase(text)) {
                    if (isFound || notFound) break;
                    isFound = true;
                    notFound = true;
                } else {
                    if (index > 0) {
                        Object[] result = this.findChild(collectionExpression, index - 1);
                        isFound |= ((Boolean)result[1]).booleanValue();
                        notFound |= ((Boolean)result[2]).booleanValue();
                    }
                    return new Object[]{child, isFound, notFound};
                }
                --index;
            }
            return null;
        }

        @Override
        public int maxCollectionSize(Expression expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(Expression expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(Expression expression, int index) {
            return this.visitor.getQueryBNF("conditional_expression");
        }
    }

    protected static abstract class AbstractFromClauseStatementHelper<T extends AbstractSelectStatement>
    extends AbstractVisitorHelper
    implements StatementHelper<T> {
        protected AbstractFromClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addClauseProposals() {
            this.visitor.addIdentifier("FROM");
        }

        @Override
        public void addInternalClauseProposals(T expression) {
        }

        @Override
        public Expression getClause(T expression) {
            return ((AbstractSelectStatement)expression).getFromClause();
        }

        @Override
        public boolean hasClause(T expression) {
            return ((AbstractSelectStatement)expression).hasFromClause();
        }

        @Override
        public boolean hasSpaceAfterClause(T expression) {
            return ((AbstractSelectStatement)expression).hasSpaceAfterFrom();
        }

        @Override
        public boolean isClauseComplete(T expression) {
            return this.visitor.isComplete(((AbstractSelectStatement)expression).getFromClause());
        }

        @Override
        public boolean isRequired() {
            return true;
        }
    }

    protected static abstract class AbstractGroupByClauseStatementHelper<T extends AbstractSelectStatement>
    extends AbstractVisitorHelper
    implements StatementHelper<T> {
        protected AbstractGroupByClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addClauseProposals() {
            this.visitor.addCompositeIdentifier("GROUP BY", -1);
        }

        @Override
        public void addInternalClauseProposals(T expression) {
        }

        @Override
        public Expression getClause(T expression) {
            return ((AbstractSelectStatement)expression).getGroupByClause();
        }

        @Override
        public boolean hasClause(T expression) {
            return ((AbstractSelectStatement)expression).hasGroupByClause();
        }

        @Override
        public boolean hasSpaceAfterClause(T expression) {
            return ((AbstractSelectStatement)expression).hasSpaceAfterGroupBy();
        }

        @Override
        public boolean isClauseComplete(T expression) {
            return this.visitor.isComplete(((AbstractSelectStatement)expression).getGroupByClause());
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    }

    protected static abstract class AbstractHavingClauseStatementHelper<T extends AbstractSelectStatement>
    extends AbstractVisitorHelper
    implements StatementHelper<T> {
        protected AbstractHavingClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addClauseProposals() {
            this.visitor.addIdentifier("HAVING");
        }

        @Override
        public void addInternalClauseProposals(T expression) {
        }

        @Override
        public Expression getClause(T expression) {
            return ((AbstractSelectStatement)expression).getHavingClause();
        }

        @Override
        public boolean hasClause(T expression) {
            return ((AbstractSelectStatement)expression).hasHavingClause();
        }

        @Override
        public boolean isClauseComplete(T expression) {
            return this.visitor.isComplete(((AbstractSelectStatement)expression).getHavingClause());
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    }

    protected static abstract class AbstractSelectClauseCollectionHelper<T extends AbstractSelectClause>
    extends AbstractVisitorHelper
    implements CollectionExpressionHelper<T> {
        protected AbstractSelectClauseCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addAtTheEndOfChild(T expression, CollectionExpression collectionExpression, int index, boolean hasComma, boolean virtualSpace) {
            Expression child;
            if (this.queryBNF(expression, index).handleAggregate() && this.visitor.areArithmeticSymbolsAppendable(child = collectionExpression.getChild(index))) {
                this.visitor.addArithmeticIdentifiers();
            }
        }

        @Override
        public void addIdentifier(T expression, String identifier) {
            this.visitor.proposals.addIdentifier(identifier);
        }

        @Override
        public void addTheBeginningOfChild(T expression, CollectionExpression collectionExpression, int index, boolean hasComma) {
            if (index == 0 || hasComma) {
                this.visitor.addIdentificationVariables();
                this.visitor.addFunctionIdentifiers(((AbstractSelectClause)expression).getSelectItemQueryBNFId());
            }
        }

        @Override
        public CollectionExpression buildCollectionExpression(T expression) {
            CollectionExpression collectionExpression = this.visitor.getCollectionExpression(((AbstractSelectClause)expression).getSelectExpression());
            if (collectionExpression == null) {
                collectionExpression = ((AbstractSelectClause)expression).buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean canContinue(T expression, CollectionExpression collectionExpression, int index) {
            return false;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(T expression) {
            return ((AbstractSelectClause)expression).hasSpaceAfterSelect();
        }

        @Override
        public int maxCollectionSize(T expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(T expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(T expression, int index) {
            return this.visitor.getQueryBNF(((AbstractSelectClause)expression).getSelectItemQueryBNFId());
        }
    }

    protected static abstract class AbstractSelectClauseStatementHelper
    extends AbstractVisitorHelper
    implements StatementHelper<AbstractSelectStatement> {
        protected AbstractSelectClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addClauseProposals() {
            this.visitor.addIdentifier("SELECT");
        }

        @Override
        public void addInternalClauseProposals(AbstractSelectStatement expression) {
        }

        @Override
        public Expression getClause(AbstractSelectStatement expression) {
            return expression.getSelectClause();
        }

        @Override
        public boolean hasClause(AbstractSelectStatement expression) {
            return expression.hasSelectClause();
        }

        @Override
        public boolean hasSpaceAfterClause(AbstractSelectStatement expression) {
            return expression.hasSpaceAfterSelect();
        }

        @Override
        public boolean isClauseComplete(AbstractSelectStatement expression) {
            return this.visitor.isComplete(expression.getSelectClause());
        }

        @Override
        public boolean isRequired() {
            return true;
        }
    }

    private static abstract class AbstractVisitorHelper {
        protected final AbstractContentAssistVisitor visitor;

        AbstractVisitorHelper(AbstractContentAssistVisitor visitor) {
            this.visitor = visitor;
        }
    }

    protected static abstract class AbstractWhereClauseSelectStatementHelper<T extends AbstractSelectStatement>
    extends AbstractVisitorHelper
    implements StatementHelper<T> {
        protected AbstractWhereClauseSelectStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addClauseProposals() {
            this.visitor.addIdentifier("WHERE");
        }

        @Override
        public void addInternalClauseProposals(T expression) {
        }

        @Override
        public Expression getClause(T expression) {
            return ((AbstractSelectStatement)expression).getWhereClause();
        }

        @Override
        public boolean hasClause(T expression) {
            return ((AbstractSelectStatement)expression).hasWhereClause();
        }

        @Override
        public boolean hasSpaceAfterClause(T expression) {
            return ((AbstractSelectStatement)expression).hasSpaceAfterWhere();
        }

        @Override
        public boolean isClauseComplete(T expression) {
            return this.visitor.isComplete(((AbstractSelectStatement)expression).getWhereClause());
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    }

    protected static abstract class AcceptableTypeVisitor
    extends AbstractExpressionVisitor {
        protected IType type;

        protected AcceptableTypeVisitor() {
        }

        public void dispose() {
            this.type = null;
        }

        @Override
        public void visit(CollectionExpression expression) {
            expression.getParent().accept(this);
        }

        @Override
        public void visit(SubExpression expression) {
            expression.getParent().accept(this);
        }
    }

    protected static class AppendableExpressionVisitor
    extends AbstractAppendableExpressionVisitor {
        protected final AbstractContentAssistVisitor visitor;
        protected AppendableType appendableType;
        protected boolean clauseOfItems;
        protected CollectionExpression collectionExpression;
        protected boolean conditionalExpression;
        protected boolean hasComma;
        protected int positionInCollection;
        protected boolean subExpression;

        AppendableExpressionVisitor(AbstractContentAssistVisitor visitor) {
            this.visitor = visitor;
            this.positionInCollection = -1;
        }

        @Override
        public void visit(AbsExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(AbstractSchemaName expression) {
            this.appendable = !this.conditionalExpression;
        }

        @Override
        public void visit(AdditionExpression expression) {
            if (expression.hasRightExpression()) {
                expression.getRightExpression().accept(this);
            }
        }

        @Override
        public void visit(AllOrAnyExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(AndExpression expression) {
            if (expression.hasRightExpression()) {
                expression.getRightExpression().accept(this);
            }
        }

        @Override
        public void visit(ArithmeticFactor expression) {
            if (expression.hasExpression()) {
                expression.getExpression().accept(this);
            }
        }

        @Override
        public void visit(AvgFunction expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(BadExpression expression) {
            this.appendable = true;
        }

        @Override
        public void visit(BetweenExpression expression) {
            if (!expression.hasAnd()) {
                String variable = this.visitor.queryContext.literal(expression.getUpperBoundExpression(), LiteralType.IDENTIFICATION_VARIABLE);
                if (variable != "") {
                    this.appendable = false;
                } else {
                    expression.getUpperBoundExpression().accept(this);
                }
            } else {
                boolean oldConditionalExpression = this.conditionalExpression;
                this.conditionalExpression = false;
                expression.getUpperBoundExpression().accept(this);
                this.conditionalExpression = oldConditionalExpression;
            }
        }

        @Override
        public void visit(CaseExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasEnd();
        }

        @Override
        public void visit(CoalesceExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(CollectionExpression expression) {
            this.collectionExpression = expression;
            this.positionInCollection = expression.childrenSize() - 1;
            this.hasComma = expression.hasComma(this.positionInCollection - 1);
            if (this.appendableType == AppendableType.CLAUSE && this.positionInCollection + 1 < this.collectionExpression.childrenSize()) {
                this.appendable = false;
            } else {
                expression.accept(this.positionInCollection, this);
            }
            this.hasComma = false;
            this.positionInCollection = -1;
            this.collectionExpression = null;
        }

        @Override
        public void visit(CollectionMemberDeclaration expression) {
            if (this.appendableType == AppendableType.COMPLETE) {
                if (expression.hasIdentificationVariable()) {
                    expression.getIdentificationVariable().accept(this);
                }
            } else {
                this.appendable = !expression.hasAs() && !expression.hasSpaceAfterIn() && !expression.hasLeftParenthesis() && !expression.hasRightParenthesis() && !expression.hasIdentificationVariable() && !expression.hasSpaceAfterRightParenthesis() && !expression.hasCollectionValuedPathExpression();
            }
        }

        @Override
        public void visit(CollectionMemberExpression expression) {
            boolean bl = this.appendable = (this.appendableType == AppendableType.LOGICAL || this.appendableType == AppendableType.COMPLETE) && expression.hasCollectionValuedPathExpression();
            if (this.appendable) {
                boolean oldConditionalExpression = this.conditionalExpression;
                this.conditionalExpression = false;
                expression.getCollectionValuedPathExpression().accept(this);
                this.conditionalExpression = oldConditionalExpression;
            }
        }

        @Override
        public void visit(CollectionValuedPathExpression expression) {
            this.appendable = !this.conditionalExpression && !expression.endsWithDot();
        }

        @Override
        public void visit(ComparisonExpression expression) {
            if (this.appendableType == AppendableType.ARITHMETIC || this.appendableType == AppendableType.COMPARISON || this.appendableType == AppendableType.COMPOUNDABLE) {
                this.appendable = false;
            } else if (this.appendableType == AppendableType.LOGICAL) {
                AppendableType oldAppendableType = this.appendableType;
                this.appendableType = AppendableType.COMPLETE;
                expression.getRightExpression().accept(this);
                this.appendableType = oldAppendableType;
            } else if (expression.hasRightExpression()) {
                boolean oldConditionalExpression = this.conditionalExpression;
                this.conditionalExpression = false;
                expression.getRightExpression().accept(this);
                this.conditionalExpression = oldConditionalExpression;
            }
        }

        @Override
        public void visit(ConcatExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(ConstructorExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(CountFunction expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(DateTime expression) {
            this.appendable = this.conditionalExpression && this.appendableType == AppendableType.COMPLETE ? false : !(expression.isJDBCDate() && !expression.toActualText().endsWith("}") || this.appendableType != AppendableType.ARITHMETIC && this.appendableType != AppendableType.COMPARISON && this.appendableType != AppendableType.COMPLETE && this.appendableType != AppendableType.COMPOUNDABLE);
        }

        @Override
        public void visit(DeleteClause expression) {
            if (expression.hasRangeVariableDeclaration()) {
                expression.getRangeVariableDeclaration().accept(this);
            }
        }

        @Override
        public void visit(DeleteStatement expression) {
            if (expression.hasWhereClause()) {
                expression.getWhereClause().accept(this);
            } else {
                expression.getDeleteClause().accept(this);
            }
        }

        @Override
        public void visit(DivisionExpression expression) {
            if (expression.hasRightExpression()) {
                expression.getRightExpression().accept(this);
            }
        }

        @Override
        public void visit(EmptyCollectionComparisonExpression expression) {
            this.appendable = this.appendableType == AppendableType.COMPLETE || this.appendableType == AppendableType.LOGICAL;
        }

        @Override
        public void visit(EntityTypeLiteral expression) {
            this.appendable = !this.conditionalExpression;
        }

        @Override
        public void visit(EntryExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(ExistsExpression expression) {
            this.appendable = (this.appendableType == AppendableType.COMPLETE || this.appendableType == AppendableType.LOGICAL) && expression.hasRightParenthesis();
        }

        @Override
        protected void visit(Expression expression) {
            this.appendable = false;
        }

        @Override
        public void visit(FromClause expression) {
            if (expression.hasAsOfClause()) {
                expression.getAsOfClause().accept(this);
            } else if (expression.hasHierarchicalQueryClause()) {
                expression.getHierarchicalQueryClause().accept(this);
            } else if (expression.hasDeclaration()) {
                this.clauseOfItems = true;
                expression.getDeclaration().accept(this);
                this.clauseOfItems = false;
            }
        }

        @Override
        public void visit(FunctionExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(GroupByClause expression) {
            if (expression.hasGroupByItems()) {
                this.clauseOfItems = true;
                expression.getGroupByItems().accept(this);
                this.clauseOfItems = false;
            }
        }

        @Override
        public void visit(HavingClause expression) {
            if (expression.hasConditionalExpression()) {
                this.conditionalExpression = true;
                expression.getConditionalExpression().accept(this);
                this.conditionalExpression = false;
            }
        }

        @Override
        public void visit(IdentificationVariable expression) {
            if (this.appendableType == AppendableType.COMPLETE) {
                this.appendable = true;
            } else if (this.clauseOfItems || !this.clauseOfItems && this.appendableType == AppendableType.CLAUSE) {
                this.appendable = !this.hasComma && this.positionInCollection > -1 && !this.visitor.isFollowingInvalidExpression(expression);
            } else if (this.positionInCollection > 1) {
                Expression child = this.collectionExpression.getChild(this.positionInCollection - 1);
                String text = child.toActualText();
                this.appendable = !text.equals("IS") && !text.equals("IS NOT");
            } else {
                switch (this.appendableType) {
                    case ARITHMETIC: {
                        this.appendable = false;
                        break;
                    }
                    case COMPOUNDABLE: 
                    case LOGICAL: 
                    case SUBQUERY: {
                        this.appendable = true;
                        break;
                    }
                    case CLAUSE: {
                        this.appendable = false;
                        break;
                    }
                    case COMPARISON: 
                    case COMPLETE: {
                        this.appendable = true;
                    }
                }
            }
        }

        @Override
        public void visit(IdentificationVariableDeclaration expression) {
            if (this.appendableType != AppendableType.COMPLETE && (this.positionInCollection == -1 || this.hasComma)) {
                this.appendable = false;
            } else if (expression.hasJoins()) {
                expression.getJoins().accept(this);
            } else {
                expression.getRangeVariableDeclaration().accept(this);
            }
        }

        @Override
        public void visit(IndexExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(InExpression expression) {
            this.appendable = (this.appendableType == AppendableType.COMPLETE || this.appendableType == AppendableType.LOGICAL) && expression.hasRightParenthesis();
        }

        @Override
        public void visit(InputParameter expression) {
            this.appendable = !this.conditionalExpression;
        }

        @Override
        public void visit(Join expression) {
            if (expression.hasOnClause()) {
                expression.getOnClause().accept(this);
            } else {
                this.appendable = expression.hasFetch() ? (expression.hasAs() ? expression.hasIdentificationVariable() : expression.hasJoinAssociationPath()) : expression.hasIdentificationVariable();
            }
        }

        @Override
        public void visit(KeyExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(KeywordExpression expression) {
            this.appendable = !this.conditionalExpression && (this.appendableType == AppendableType.LOGICAL || this.appendableType == AppendableType.COMPLETE);
        }

        @Override
        public void visit(LengthExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(LikeExpression expression) {
            boolean bl = this.appendable = this.appendableType == AppendableType.COMPLETE || this.appendableType == AppendableType.LOGICAL;
            if (this.appendable) {
                boolean oldConditionalExpression = this.conditionalExpression;
                this.conditionalExpression = false;
                if (expression.hasEscape()) {
                    expression.getEscapeCharacter().accept(this);
                } else {
                    expression.getPatternValue().accept(this);
                }
                this.conditionalExpression = oldConditionalExpression;
            }
        }

        @Override
        public void visit(LocateExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(LowerExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(MaxFunction expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(MinFunction expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(ModExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(MultiplicationExpression expression) {
            if (expression.hasRightExpression()) {
                expression.getRightExpression().accept(this);
            }
        }

        @Override
        public void visit(NotExpression expression) {
            if (expression.hasExpression()) {
                String variable = this.visitor.queryContext.literal(expression.getExpression(), LiteralType.IDENTIFICATION_VARIABLE);
                if (variable != "") {
                    this.appendable = this.appendableType == AppendableType.COMPOUNDABLE;
                } else {
                    boolean oldConditionalExpression = this.conditionalExpression;
                    this.conditionalExpression = false;
                    expression.getExpression().accept(this);
                    this.conditionalExpression = oldConditionalExpression;
                }
            }
        }

        @Override
        public void visit(NullComparisonExpression expression) {
            this.appendable = this.appendableType == AppendableType.COMPLETE || this.appendableType == AppendableType.LOGICAL;
        }

        @Override
        public void visit(NullIfExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(NumericLiteral expression) {
            this.appendable = !this.conditionalExpression;
        }

        @Override
        public void visit(ObjectExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(OnClause expression) {
            if (expression.hasConditionalExpression()) {
                this.conditionalExpression = true;
                expression.getConditionalExpression().accept(this);
                this.conditionalExpression = false;
            }
        }

        @Override
        public void visit(OrderByClause expression) {
            if (expression.hasOrderByItems()) {
                this.clauseOfItems = true;
                expression.getOrderByItems().accept(this);
                this.clauseOfItems = false;
            }
        }

        @Override
        public void visit(OrderByItem expression) {
            this.appendable = expression.hasSpaceAfterExpression() && expression.isDefault() || expression.hasSpaceAfterOrdering() && !expression.isNullsFirst() && !expression.isNullsLast();
        }

        @Override
        public void visit(OrExpression expression) {
            if (expression.hasRightExpression()) {
                expression.getRightExpression().accept(this);
            }
        }

        @Override
        public void visit(RangeVariableDeclaration expression) {
            if (this.appendableType == AppendableType.COMPLETE) {
                if (expression.hasIdentificationVariable()) {
                    expression.getIdentificationVariable().accept(this);
                }
            } else {
                boolean bl = this.appendable = !expression.hasSpaceAfterRootObject() && !expression.hasAs() && !expression.hasIdentificationVariable();
                if (!this.appendable && expression.hasRootObject() && expression.hasIdentificationVariable()) {
                    expression.getIdentificationVariable().accept(this);
                }
            }
        }

        @Override
        public void visit(ResultVariable expression) {
            this.appendable = !expression.hasAs() && !expression.hasSpaceAfterAs() && expression.hasResultVariable();
        }

        @Override
        public void visit(SelectClause expression) {
            if (expression.hasSelectExpression()) {
                this.clauseOfItems = true;
                expression.getSelectExpression().accept(this);
                this.clauseOfItems = false;
            }
        }

        @Override
        public void visit(SelectStatement expression) {
            if (expression.hasUnionClauses()) {
                expression.getUnionClauses().accept(this);
            } else if (expression.hasOrderByClause()) {
                expression.getOrderByClause().accept(this);
            } else if (expression.hasHavingClause()) {
                expression.getHavingClause().accept(this);
            } else if (expression.hasGroupByClause()) {
                expression.getGroupByClause().accept(this);
            } else if (expression.hasWhereClause()) {
                expression.getWhereClause().accept(this);
            } else if (expression.hasFromClause()) {
                expression.getFromClause().accept(this);
            } else {
                expression.getSelectClause().accept(this);
            }
        }

        @Override
        public void visit(SimpleFromClause expression) {
            if (expression.hasAsOfClause()) {
                expression.getAsOfClause().accept(this);
            } else if (expression.hasHierarchicalQueryClause()) {
                expression.getHierarchicalQueryClause().accept(this);
            } else if (expression.hasDeclaration()) {
                this.clauseOfItems = true;
                expression.getDeclaration().accept(this);
                this.clauseOfItems = true;
            }
        }

        @Override
        public void visit(SimpleSelectClause expression) {
            if (expression.hasSelectExpression()) {
                this.clauseOfItems = true;
                expression.getSelectExpression().accept(this);
                this.clauseOfItems = true;
            }
        }

        @Override
        public void visit(SimpleSelectStatement expression) {
            if (this.subExpression && this.appendableType == AppendableType.ARITHMETIC) {
                this.appendable = true;
            } else if (expression.hasHavingClause()) {
                expression.getHavingClause().accept(this);
            } else if (expression.hasGroupByClause()) {
                expression.getGroupByClause().accept(this);
            } else if (expression.hasWhereClause()) {
                expression.getWhereClause().accept(this);
            } else if (expression.hasFromClause()) {
                expression.getFromClause().accept(this);
            } else {
                expression.getSelectClause().accept(this);
            }
        }

        @Override
        public void visit(SizeExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(SqrtExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(StateFieldPathExpression expression) {
            if (expression.endsWithDot()) {
                this.appendable = false;
            } else if (this.appendableType == AppendableType.CLAUSE || this.appendableType == AppendableType.COMPLETE) {
                this.appendable = !this.conditionalExpression;
            } else {
                IMapping mapping = this.visitor.queryContext.getMapping(expression);
                if (mapping == null) {
                    this.appendable = false;
                } else {
                    IType type = mapping.getType();
                    switch (this.appendableType) {
                        case ARITHMETIC: {
                            this.appendable = this.visitor.queryContext.getTypeHelper().isNumericType(type);
                            break;
                        }
                        case COMPARISON: {
                            TypeHelper typeHelper = this.visitor.queryContext.getTypeHelper();
                            this.appendable = !typeHelper.isCollectionType(type) && !typeHelper.isMapType(type);
                            break;
                        }
                        case COMPOUNDABLE: {
                            this.appendable = true;
                            break;
                        }
                        case LOGICAL: {
                            this.appendable = this.visitor.queryContext.getTypeHelper().isBooleanType(type);
                        }
                    }
                }
            }
        }

        @Override
        public void visit(StringLiteral expression) {
            this.appendable = !this.conditionalExpression && expression.hasCloseQuote();
        }

        @Override
        public void visit(SubExpression expression) {
            if (this.appendableType == AppendableType.COMPLETE) {
                this.appendable = expression.hasRightParenthesis();
            } else if (expression.hasExpression()) {
                this.subExpression = true;
                boolean oldConditionalExpression = this.conditionalExpression;
                this.conditionalExpression = false;
                expression.getExpression().accept(this);
                this.appendable &= expression.hasRightParenthesis();
                this.subExpression = false;
                this.conditionalExpression = oldConditionalExpression;
            } else {
                this.appendable = this.appendableType == AppendableType.SUBQUERY;
            }
        }

        @Override
        public void visit(SubstringExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(SubtractionExpression expression) {
            if (expression.hasRightExpression()) {
                expression.getRightExpression().accept(this);
            }
        }

        @Override
        public void visit(SumFunction expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(TreatExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(TrimExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(TypeExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(UpdateClause expression) {
            if (expression.hasUpdateItems()) {
                expression.getUpdateItems().accept(this);
            }
        }

        @Override
        public void visit(UpdateItem expression) {
            expression.getNewValue().accept(this);
        }

        @Override
        public void visit(UpdateStatement expression) {
            if (expression.hasWhereClause()) {
                expression.getWhereClause().accept(this);
            } else {
                expression.getUpdateClause().accept(this);
            }
        }

        @Override
        public void visit(UpperExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(ValueExpression expression) {
            this.appendable = !this.conditionalExpression && expression.hasRightParenthesis();
        }

        @Override
        public void visit(WhenClause expression) {
            if (expression.hasWhenExpression()) {
                this.conditionalExpression = true;
                expression.getWhenExpression().accept(this);
                this.conditionalExpression = false;
            }
        }

        @Override
        public void visit(WhereClause expression) {
            if (expression.hasConditionalExpression()) {
                this.conditionalExpression = true;
                expression.getConditionalExpression().accept(this);
                this.conditionalExpression = false;
            }
        }
    }

    protected static enum AppendableType {
        ARITHMETIC,
        CLAUSE,
        COMPARISON,
        COMPLETE,
        COMPOUNDABLE,
        LOGICAL,
        SUBQUERY;

    }

    protected static interface CollectionExpressionHelper<T extends Expression> {
        public void addAtTheEndOfChild(T var1, CollectionExpression var2, int var3, boolean var4, boolean var5);

        public void addIdentifier(T var1, String var2);

        public void addTheBeginningOfChild(T var1, CollectionExpression var2, int var3, boolean var4);

        public CollectionExpression buildCollectionExpression(T var1);

        public boolean canContinue(T var1, CollectionExpression var2, int var3);

        public boolean hasDelimiterAfterIdentifier(T var1);

        public int maxCollectionSize(T var1);

        public int preExpressionLength(T var1);

        public JPQLQueryBNF queryBNF(T var1, int var2);
    }

    protected static final class CollectionExpressionVisitor
    extends AbstractExpressionVisitor {
        protected CollectionExpression expression;

        protected CollectionExpressionVisitor() {
        }

        public void dispose() {
            this.expression = null;
        }

        @Override
        public void visit(CollectionExpression expression) {
            this.expression = expression;
        }
    }

    protected static final class CollectionMappingFilter
    implements Filter<IMapping> {
        protected CollectionMappingFilter() {
        }

        @Override
        public boolean accept(IMapping value) {
            return value.isRelationship();
        }
    }

    protected static final class ConcatExpressionCollectionHelper
    extends AbstractVisitorHelper
    implements CollectionExpressionHelper<ConcatExpression> {
        protected ConcatExpressionCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addAtTheEndOfChild(ConcatExpression expression, CollectionExpression collectionExpression, int index, boolean hasComma, boolean virtualSpace) {
            if (this.queryBNF(expression, index).handleAggregate()) {
                Expression child = collectionExpression.getChild(index);
                if (index == 0 && !virtualSpace) {
                    if (this.visitor.areArithmeticSymbolsAppendable(child)) {
                        this.visitor.addArithmeticIdentifiers();
                    }
                } else {
                    if (this.visitor.areArithmeticSymbolsAppendable(child)) {
                        this.visitor.addArithmeticIdentifiers();
                    }
                    if (this.visitor.areComparisonSymbolsAppendable(child)) {
                        this.visitor.addComparisonIdentifiers(child);
                    }
                }
            }
        }

        @Override
        public void addIdentifier(ConcatExpression expression, String identifier) {
            this.visitor.proposals.addIdentifier(identifier);
            this.visitor.addIdentificationVariables();
            this.visitor.addFunctionIdentifiers(expression.getParent().findQueryBNF(expression));
        }

        @Override
        public void addTheBeginningOfChild(ConcatExpression expression, CollectionExpression collectionExpression, int index, boolean hasComma) {
            this.visitor.addIdentificationVariables();
            this.visitor.addFunctionIdentifiers(this.queryBNF(expression, index));
        }

        @Override
        public CollectionExpression buildCollectionExpression(ConcatExpression expression) {
            CollectionExpression collectionExpression = this.visitor.getCollectionExpression(expression.getExpression());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean canContinue(ConcatExpression expression, CollectionExpression collectionExpression, int index) {
            return false;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(ConcatExpression expression) {
            return expression.hasSpaceAfterIdentifier() || expression.hasLeftParenthesis();
        }

        @Override
        public int maxCollectionSize(ConcatExpression expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(ConcatExpression expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(ConcatExpression expression, int index) {
            return this.visitor.getQueryBNF(expression.getEncapsulatedExpressionQueryBNFId());
        }
    }

    protected static final class ConditionalClauseCollectionHelper
    extends AbstractConditionalClauseCollectionHelper<AbstractConditionalClause> {
        protected ConditionalClauseCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public CollectionExpression buildCollectionExpression(AbstractConditionalClause expression) {
            CollectionExpression collectionExpression = this.visitor.getCollectionExpression(expression.getConditionalExpression());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(AbstractConditionalClause expression) {
            return expression.hasSpaceAfterIdentifier();
        }
    }

    protected static final class ConstrutorCollectionHelper
    extends AbstractVisitorHelper
    implements CollectionExpressionHelper<ConstructorExpression> {
        protected ConstrutorCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addAtTheEndOfChild(ConstructorExpression expression, CollectionExpression collectionExpression, int index, boolean hasComma, boolean virtualSpace) {
            if (this.queryBNF(expression, index).handleAggregate()) {
                Expression child = collectionExpression.getChild(index);
                if (index == 0 && !virtualSpace) {
                    if (this.visitor.areArithmeticSymbolsAppendable(child)) {
                        this.visitor.addArithmeticIdentifiers();
                    }
                } else {
                    if (this.visitor.areArithmeticSymbolsAppendable(child)) {
                        this.visitor.addArithmeticIdentifiers();
                    }
                    if (this.visitor.areComparisonSymbolsAppendable(child)) {
                        this.visitor.addComparisonIdentifiers(child);
                    }
                }
            }
        }

        @Override
        public void addIdentifier(ConstructorExpression expression, String identifier) {
            this.visitor.proposals.addIdentifier(identifier);
        }

        @Override
        public void addTheBeginningOfChild(ConstructorExpression expression, CollectionExpression collectionExpression, int index, boolean hasComma) {
            this.visitor.addIdentificationVariables(expression, IdentificationVariableType.ALL);
            this.visitor.addFunctionIdentifiers("constructor_item");
        }

        @Override
        public CollectionExpression buildCollectionExpression(ConstructorExpression expression) {
            CollectionExpression collectionExpression = this.visitor.getCollectionExpression(expression.getConstructorItems());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean canContinue(ConstructorExpression expression, CollectionExpression collectionExpression, int index) {
            return false;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(ConstructorExpression expression) {
            return expression.hasLeftParenthesis();
        }

        @Override
        public int maxCollectionSize(ConstructorExpression expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(ConstructorExpression expression) {
            if (expression.hasSpaceAfterNew()) {
                return expression.getClassName().length() + 1;
            }
            return expression.getClassName().length();
        }

        @Override
        public JPQLQueryBNF queryBNF(ConstructorExpression expression, int index) {
            return this.visitor.getQueryBNF("constructor_item");
        }
    }

    protected static final class DeclarationVisitor
    extends AnonymousExpressionVisitor {
        protected boolean declaration;

        protected DeclarationVisitor() {
        }

        public void dispose() {
            this.declaration = false;
        }

        public boolean isDeclaration() {
            return this.declaration;
        }

        @Override
        public void visit(CollectionValuedPathExpression expression) {
            expression.getParent().accept(this);
        }

        @Override
        public void visit(RangeVariableDeclaration expression) {
            this.declaration = true;
        }
    }

    protected static final class DefaultMappingCollector
    implements MappingCollector {
        protected DefaultMappingCollector() {
        }

        @Override
        public Collection<IMapping> buildProposals() {
            return Collections.emptyList();
        }
    }

    protected static final class DeleteClauseCollectionHelper
    extends AbstractVisitorHelper
    implements CollectionExpressionHelper<DeleteClause> {
        protected DeleteClauseCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addAtTheEndOfChild(DeleteClause expression, CollectionExpression collectionExpression, int index, boolean hasComma, boolean virtualSpace) {
        }

        @Override
        public void addIdentifier(DeleteClause expression, String identifier) {
            this.visitor.proposals.addIdentifier(identifier);
        }

        @Override
        public void addTheBeginningOfChild(DeleteClause expression, CollectionExpression collectionExpression, int index, boolean hasComma) {
            if (index == 0) {
                this.visitor.addEntities();
            }
        }

        @Override
        public CollectionExpression buildCollectionExpression(DeleteClause expression) {
            CollectionExpression collectionExpression = this.visitor.getCollectionExpression(expression.getRangeVariableDeclaration());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean canContinue(DeleteClause expression, CollectionExpression collectionExpression, int index) {
            return false;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(DeleteClause expression) {
            return expression.hasSpaceAfterFrom();
        }

        @Override
        public int maxCollectionSize(DeleteClause expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(DeleteClause expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(DeleteClause expression, int index) {
            return this.visitor.getQueryBNF("range_variable_declaration");
        }
    }

    protected static final class DeleteClauseStatementHelper
    extends AbstractVisitorHelper
    implements StatementHelper<DeleteStatement> {
        protected DeleteClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addClauseProposals() {
            this.visitor.addIdentifier("DELETE FROM");
        }

        @Override
        public void addInternalClauseProposals(DeleteStatement expression) {
        }

        @Override
        public Expression getClause(DeleteStatement expression) {
            return expression.getDeleteClause();
        }

        public WhereClauseDeleteStatementHelper getNextHelper() {
            return this.visitor.getWhereClauseDeleteStatementHelper();
        }

        @Override
        public boolean hasClause(DeleteStatement expression) {
            return true;
        }

        @Override
        public boolean hasSpaceAfterClause(DeleteStatement expression) {
            return expression.hasSpaceAfterDeleteClause();
        }

        @Override
        public boolean isClauseComplete(DeleteStatement expression) {
            return this.visitor.isComplete(expression.getDeleteClause());
        }

        @Override
        public boolean isRequired() {
            return true;
        }
    }

    protected static final class DifferentComparisonFilter
    extends AnonymousExpressionVisitor
    implements Filter<Expression> {
        protected boolean valid;

        protected DifferentComparisonFilter() {
        }

        @Override
        public boolean accept(Expression expression) {
            try {
                expression.accept(this);
                boolean bl = this.valid;
                return bl;
            }
            finally {
                this.valid = false;
            }
        }

        @Override
        protected void visit(Expression expression) {
            this.valid = true;
        }

        @Override
        public void visit(IdentificationVariable expression) {
            this.valid = false;
        }
    }

    protected static final class DoubleEncapsulatedCollectionHelper
    extends AbstractVisitorHelper
    implements CollectionExpressionHelper<AbstractDoubleEncapsulatedExpression> {
        protected DoubleEncapsulatedCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addAtTheEndOfChild(AbstractDoubleEncapsulatedExpression expression, CollectionExpression collectionExpression, int index, boolean hasComma, boolean virtualSpace) {
            if (this.queryBNF(expression, index).handleAggregate()) {
                Expression child = collectionExpression.getChild(index);
                if (index == 0 && !virtualSpace) {
                    if (this.visitor.areArithmeticSymbolsAppendable(child)) {
                        this.visitor.addArithmeticIdentifiers();
                    }
                } else {
                    if (this.visitor.areArithmeticSymbolsAppendable(child)) {
                        this.visitor.addArithmeticIdentifiers();
                    }
                    if (this.visitor.areComparisonSymbolsAppendable(child)) {
                        this.visitor.addComparisonIdentifiers(child);
                    }
                }
            }
        }

        @Override
        public void addIdentifier(AbstractDoubleEncapsulatedExpression expression, String identifier) {
            this.visitor.proposals.addIdentifier(identifier);
            this.visitor.addIdentificationVariables();
            this.visitor.addFunctionIdentifiers(expression.getParent().findQueryBNF(expression));
        }

        @Override
        public void addTheBeginningOfChild(AbstractDoubleEncapsulatedExpression expression, CollectionExpression collectionExpression, int index, boolean hasComma) {
            this.visitor.addIdentificationVariables();
            this.visitor.addFunctionIdentifiers(this.queryBNF(expression, index));
        }

        @Override
        public CollectionExpression buildCollectionExpression(AbstractDoubleEncapsulatedExpression expression) {
            return expression.buildCollectionExpression();
        }

        @Override
        public boolean canContinue(AbstractDoubleEncapsulatedExpression expression, CollectionExpression collectionExpression, int index) {
            return false;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(AbstractDoubleEncapsulatedExpression expression) {
            return expression.hasSpaceAfterIdentifier() || expression.hasLeftParenthesis();
        }

        @Override
        public int maxCollectionSize(AbstractDoubleEncapsulatedExpression expression) {
            return 2;
        }

        @Override
        public int preExpressionLength(AbstractDoubleEncapsulatedExpression expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(AbstractDoubleEncapsulatedExpression expression, int index) {
            return this.visitor.getQueryBNF(expression.parameterExpressionBNF(index));
        }
    }

    protected static final class EncapsulatedExpressionVisitor
    extends AnonymousExpressionVisitor {
        protected boolean encapsulated;
        protected boolean visited;

        protected EncapsulatedExpressionVisitor() {
        }

        public void dispose() {
            this.encapsulated = false;
        }

        public boolean isEncapsulated() {
            return this.encapsulated;
        }

        @Override
        protected void visit(Expression expression) {
            if (!this.visited) {
                this.visited = true;
                expression.getParent().accept(this);
                this.visited = false;
            }
        }

        @Override
        public void visit(SubExpression expression) {
            this.encapsulated = true;
        }
    }

    protected static class EndingQueryPositionBuilder
    extends AbstractVisitorHelper
    implements ExpressionVisitor {
        protected boolean badExpression;
        protected int correction;
        protected Expression invalidExpression;
        protected int positionWithinInvalidExpression;
        public QueryPosition queryPosition;
        public boolean virtualSpace;

        protected EndingQueryPositionBuilder(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        public void dispose() {
            this.correction = 0;
            this.virtualSpace = false;
            this.queryPosition = null;
            this.invalidExpression = null;
            this.positionWithinInvalidExpression = -1;
        }

        public QueryPosition getQueryPosition() {
            return this.queryPosition;
        }

        public boolean hasVirtualSpace() {
            return this.virtualSpace;
        }

        public void prepare(Expression invalidExpression) {
            QueryPosition oldQueryPosition = this.visitor.queryPosition;
            this.invalidExpression = invalidExpression;
            this.positionWithinInvalidExpression = oldQueryPosition.getPosition(invalidExpression);
            this.queryPosition = new QueryPosition(oldQueryPosition.getPosition(invalidExpression.getParent()));
        }

        @Override
        public void visit(AbsExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(AbstractSchemaName expression) {
            if (this.badExpression) {
                this.correction = expression.getLength() - this.positionWithinInvalidExpression;
            }
            if (this.invalidExpression == expression) {
                this.queryPosition.setExpression(expression);
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(AdditionExpression expression) {
            this.visitCompoundExpression(expression);
        }

        @Override
        public void visit(AllOrAnyExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(AndExpression expression) {
            this.visitCompoundExpression(expression);
        }

        @Override
        public void visit(ArithmeticFactor expression) {
            if (!this.badExpression) {
                if (expression.hasExpression()) {
                    expression.getExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(AvgFunction expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(BadExpression expression) {
            this.badExpression = true;
            expression.getExpression().accept(this);
            this.badExpression = false;
        }

        @Override
        public void visit(BetweenExpression expression) {
            if (this.badExpression) {
                if (!expression.hasExpression() && !expression.hasNot() && this.positionWithinInvalidExpression <= 7) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasUpperBoundExpression()) {
                    expression.getUpperBoundExpression().accept(this);
                } else if (expression.hasLowerBoundExpression() && !expression.hasAnd()) {
                    expression.getLowerBoundExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(CaseExpression expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= 4) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (!expression.hasEnd()) {
                    if (expression.hasElseExpression()) {
                        expression.getElseExpression().accept(this);
                    } else if (expression.hasWhenClauses()) {
                        expression.getWhenClauses();
                    } else if (expression.hasCaseOperand()) {
                        expression.getCaseOperand().accept(this);
                    }
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(CoalesceExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(CollectionExpression expression) {
            if (!this.badExpression) {
                Expression previousChild;
                Expression child2;
                int index = 0;
                for (Expression child2 : expression.children()) {
                    if (child2.isAncestor(this.invalidExpression)) break;
                    ++index;
                }
                if (index == expression.childrenSize()) {
                    --index;
                }
                child2 = expression.getChild(index);
                child2.accept(this);
                if (index > 0 && !this.visitor.isComplete(previousChild = expression.getChild(index - 1))) {
                    this.queryPosition.setExpression(previousChild);
                    this.queryPosition.addPosition(previousChild, previousChild.getLength());
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                int length = expression.toActualText(index + 1).length() - this.correction;
                this.queryPosition.addPosition(expression, length);
                this.correction = expression.getLength() - length;
            }
        }

        @Override
        public void visit(CollectionMemberDeclaration expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= 2) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasIdentificationVariable()) {
                    expression.getIdentificationVariable().accept(this);
                } else if (expression.hasCollectionValuedPathExpression() && !expression.hasAs()) {
                    expression.getCollectionValuedPathExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(CollectionMemberExpression expression) {
            if (this.badExpression) {
                if (!expression.hasEntityExpression() && !expression.hasNot() && this.positionWithinInvalidExpression <= 6) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasCollectionValuedPathExpression()) {
                    expression.getCollectionValuedPathExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(CollectionValuedPathExpression expression) {
            if (this.badExpression) {
                this.correction = expression.getLength() - this.positionWithinInvalidExpression;
            }
            if (this.invalidExpression == expression) {
                this.queryPosition.setExpression(expression);
                this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
            }
        }

        @Override
        public void visit(ComparisonExpression expression) {
            this.visitCompoundExpression(expression);
        }

        @Override
        public void visit(ConcatExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(ConstructorExpression expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= 3) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasConstructorItems() && !expression.hasRightParenthesis()) {
                    expression.getConstructorItems().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(CountFunction expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(DateTime expression) {
            if (!expression.isJDBCDate()) {
                if (this.badExpression) {
                    this.correction = expression.getLength() - this.positionWithinInvalidExpression;
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                } else if (this.invalidExpression == expression) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            }
        }

        @Override
        public void visit(DeleteClause expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= 6) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasRangeVariableDeclaration()) {
                    expression.getRangeVariableDeclaration().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(DeleteStatement expression) {
            if (!this.badExpression) {
                if (expression.hasWhereClause()) {
                    expression.getWhereClause().accept(this);
                } else {
                    expression.getDeleteClause().accept(this);
                    if (expression.hasSpaceAfterDeleteClause()) {
                        this.virtualSpace = true;
                    }
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(DivisionExpression expression) {
            this.visitCompoundExpression(expression);
        }

        @Override
        public void visit(EmptyCollectionComparisonExpression expression) {
            if (this.badExpression) {
                if (!expression.hasExpression() && !expression.hasNot() && this.positionWithinInvalidExpression <= 5) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else if (this.invalidExpression == expression) {
                this.queryPosition.setExpression(expression);
                this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
            }
        }

        @Override
        public void visit(EntityTypeLiteral expression) {
            if (this.badExpression) {
                this.correction = expression.getLength() - this.positionWithinInvalidExpression;
            }
            if (this.invalidExpression == expression) {
                this.queryPosition.setExpression(expression);
                this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
            }
        }

        @Override
        public void visit(EntryExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(ExistsExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(FromClause expression) {
            this.visitAbstractFromClause(expression);
        }

        @Override
        public void visit(FunctionExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(GroupByClause expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= 5) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasGroupByItems()) {
                    expression.getGroupByItems().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(HavingClause expression) {
            this.visitAbstractConditionalClause(expression);
        }

        @Override
        public void visit(IdentificationVariable expression) {
            if (this.badExpression) {
                this.correction = expression.getLength() - this.positionWithinInvalidExpression;
            }
            this.queryPosition.setExpression(expression);
            this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
        }

        @Override
        public void visit(IdentificationVariableDeclaration expression) {
            if (!this.badExpression) {
                if (expression.hasJoins()) {
                    expression.getJoins().accept(this);
                } else if (expression.hasRangeVariableDeclaration()) {
                    expression.getRangeVariableDeclaration().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(IndexExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(InExpression expression) {
            if (this.badExpression) {
                if (!expression.hasExpression() && this.positionWithinInvalidExpression <= 2) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasInItems() && !expression.hasRightParenthesis()) {
                    expression.getInItems();
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(InputParameter expression) {
            if (!this.badExpression && this.invalidExpression == expression) {
                this.queryPosition.setExpression(expression);
                this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
            }
        }

        @Override
        public void visit(Join expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= 4) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasOnClause()) {
                    expression.getOnClause().accept(this);
                } else if (expression.hasIdentificationVariable()) {
                    expression.getIdentificationVariable().accept(this);
                    if (expression.hasSpaceAfterIdentificationVariable()) {
                        this.virtualSpace = true;
                    }
                } else if (expression.hasJoinAssociationPath() && !expression.hasAs()) {
                    expression.getJoinAssociationPath().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(JPQLExpression expression) {
            if (expression.hasQueryStatement()) {
                Expression queryStatement = expression.getQueryStatement();
                queryStatement.accept(this);
                this.queryPosition.addPosition(expression, queryStatement.getLength() - this.correction);
            } else {
                this.queryPosition.setExpression(expression);
                this.queryPosition.addPosition(expression, 0);
            }
        }

        @Override
        public void visit(KeyExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(KeywordExpression expression) {
            if (this.badExpression) {
                this.correction = expression.getLength() - this.positionWithinInvalidExpression;
                this.queryPosition.setExpression(expression);
                this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
            } else if (this.invalidExpression == expression) {
                this.queryPosition.setExpression(expression);
                this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
            }
        }

        @Override
        public void visit(LengthExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(LikeExpression expression) {
            if (this.badExpression) {
                if (!expression.hasStringExpression() && this.positionWithinInvalidExpression <= 4) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasEscapeCharacter()) {
                    expression.getEscapeCharacter().accept(this);
                } else if (expression.hasPatternValue() && !expression.hasEscape()) {
                    expression.getPatternValue().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(LocateExpression expression) {
            this.visitAbstractTripleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(LowerExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(MaxFunction expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(MinFunction expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(ModExpression expression) {
            this.visitAbstractDoubleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(MultiplicationExpression expression) {
            this.visitCompoundExpression(expression);
        }

        @Override
        public void visit(NotExpression expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= 3) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasExpression()) {
                    expression.getExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(NullComparisonExpression expression) {
            if (this.badExpression) {
                if (!expression.hasExpression() && !expression.hasNot() && this.positionWithinInvalidExpression <= 2) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasExpression()) {
                    expression.getExpression().accept(this);
                }
                this.queryPosition.setExpression(expression);
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(NullExpression expression) {
            if (!this.badExpression && this.invalidExpression == expression) {
                this.queryPosition.setExpression(expression);
                this.queryPosition.addPosition(expression, 0);
            }
        }

        @Override
        public void visit(NullIfExpression expression) {
            this.visitAbstractDoubleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(NumericLiteral expression) {
            if (!this.badExpression && this.invalidExpression == expression) {
                this.queryPosition.setExpression(expression);
                this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
            }
        }

        @Override
        public void visit(ObjectExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(OnClause expression) {
            this.visitAbstractConditionalClause(expression);
        }

        @Override
        public void visit(OrderByClause expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= 5) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasOrderByItems()) {
                    expression.getOrderByItems().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(OrderByItem expression) {
            if (!this.badExpression) {
                if (expression.hasExpression()) {
                    expression.getExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(OrExpression expression) {
            this.visitCompoundExpression(expression);
        }

        @Override
        public void visit(RangeVariableDeclaration expression) {
            if (!this.badExpression) {
                if (expression.hasIdentificationVariable()) {
                    expression.getIdentificationVariable().accept(this);
                } else if (!expression.hasAs()) {
                    expression.getRootObject().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(ResultVariable expression) {
            if (this.badExpression) {
                if (!expression.hasResultVariable() && expression.hasAs() || !expression.hasSelectExpression()) {
                    this.correction = expression.getLength() - this.positionWithinInvalidExpression;
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasResultVariable()) {
                    expression.getResultVariable().accept(this);
                } else if (!expression.hasAs()) {
                    expression.getSelectExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(SelectClause expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= 6) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasSelectExpression()) {
                    expression.getSelectExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(SelectStatement expression) {
            if (!this.badExpression) {
                if (expression.hasUnionClauses()) {
                    expression.getUnionClauses().accept(this);
                } else if (expression.hasOrderByClause()) {
                    expression.getOrderByClause().accept(this);
                    if (expression.hasSpaceBeforeUnion()) {
                        this.virtualSpace = true;
                    }
                } else if (expression.hasHavingClause()) {
                    expression.getHavingClause().accept(this);
                    if (expression.hasSpaceBeforeOrderBy()) {
                        this.virtualSpace = true;
                    }
                } else if (expression.hasGroupByClause()) {
                    expression.getGroupByClause().accept(this);
                    if (expression.hasSpaceAfterGroupBy()) {
                        this.virtualSpace = true;
                    }
                } else if (expression.hasWhereClause()) {
                    expression.getWhereClause().accept(this);
                    if (expression.hasSpaceAfterWhere()) {
                        this.virtualSpace = true;
                    }
                } else if (expression.hasFromClause()) {
                    expression.getFromClause().accept(this);
                    if (expression.hasSpaceAfterFrom()) {
                        this.virtualSpace = true;
                    }
                } else {
                    expression.getSelectClause().accept(this);
                    if (expression.hasSpaceAfterSelect()) {
                        this.virtualSpace = true;
                    }
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(SimpleFromClause expression) {
            this.visitAbstractFromClause(expression);
        }

        @Override
        public void visit(SimpleSelectClause expression) {
            if (!this.badExpression) {
                if (expression.hasSelectExpression()) {
                    expression.getSelectExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(SimpleSelectStatement expression) {
            if (!this.badExpression) {
                if (expression.hasHavingClause()) {
                    expression.getHavingClause().accept(this);
                } else if (expression.hasGroupByClause()) {
                    expression.getGroupByClause().accept(this);
                    if (expression.hasSpaceAfterGroupBy()) {
                        this.virtualSpace = true;
                    }
                } else if (expression.hasWhereClause()) {
                    expression.getWhereClause().accept(this);
                    if (expression.hasSpaceAfterWhere()) {
                        this.virtualSpace = true;
                    }
                } else if (expression.hasFromClause()) {
                    expression.getFromClause().accept(this);
                    if (expression.hasSpaceAfterFrom()) {
                        this.virtualSpace = true;
                    }
                } else {
                    expression.getSelectClause().accept(this);
                    if (expression.hasSpaceAfterSelect()) {
                        this.virtualSpace = true;
                    }
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(SizeExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(SqrtExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(StateFieldPathExpression expression) {
            if (this.badExpression) {
                this.correction = expression.getLength() - this.positionWithinInvalidExpression;
            }
            if (this.invalidExpression == expression) {
                this.queryPosition.setExpression(expression);
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(StringLiteral expression) {
            if (!this.badExpression && this.invalidExpression == expression) {
                this.queryPosition.setExpression(expression);
                this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
            }
        }

        @Override
        public void visit(SubExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(SubstringExpression expression) {
            this.visitAbstractTripleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(SubtractionExpression expression) {
            this.visitCompoundExpression(expression);
        }

        @Override
        public void visit(SumFunction expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(TreatExpression expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= 5) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasEntityType() && !expression.hasRightParenthesis()) {
                    expression.getEntityType().accept(this);
                } else if (expression.hasCollectionValuedPathExpression() && !expression.hasAs()) {
                    expression.getCollectionValuedPathExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(TrimExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(TypeExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(UnknownExpression expression) {
        }

        @Override
        public void visit(UpdateClause expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= 6) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasUpdateItems()) {
                    expression.getUpdateItems().accept(this);
                } else if (expression.hasRangeVariableDeclaration()) {
                    expression.getRangeVariableDeclaration().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(UpdateItem expression) {
            if (!this.badExpression) {
                if (expression.hasNewValue()) {
                    expression.getNewValue().accept(this);
                } else if (!expression.hasEqualSign() && expression.hasSpaceAfterStateFieldPathExpression()) {
                    expression.getStateFieldPathExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(UpdateStatement expression) {
            if (!this.badExpression) {
                if (expression.hasWhereClause()) {
                    expression.getWhereClause().accept(this);
                } else {
                    expression.getUpdateClause().accept(this);
                    if (expression.hasSpaceAfterUpdateClause()) {
                        this.virtualSpace = true;
                    }
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(UpperExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(ValueExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        @Override
        public void visit(WhenClause expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= 4) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasThenExpression()) {
                    expression.getThenExpression().accept(this);
                } else if (expression.hasWhenExpression() && expression.hasThen()) {
                    expression.getWhenExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        @Override
        public void visit(WhereClause expression) {
            this.visitAbstractConditionalClause(expression);
        }

        protected void visitAbstractConditionalClause(AbstractConditionalClause expression) {
            if (!this.badExpression) {
                if (expression.hasConditionalExpression()) {
                    expression.getConditionalExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        protected void visitAbstractDoubleEncapsulatedExpression(AbstractDoubleEncapsulatedExpression expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= expression.getIdentifier().length()) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasSecondExpression() && !expression.hasRightParenthesis()) {
                    expression.getSecondExpression().accept(this);
                } else if (expression.hasFirstExpression() && !expression.hasSpaceAfterComma()) {
                    expression.getFirstExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        protected void visitAbstractFromClause(AbstractFromClause expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= 4) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasAsOfClause()) {
                    expression.getAsOfClause().accept(this);
                } else if (expression.hasHierarchicalQueryClause()) {
                    expression.getHierarchicalQueryClause().accept(this);
                    if (expression.hasSpaceAfterHierarchicalQueryClause()) {
                        this.virtualSpace = true;
                    }
                } else if (expression.hasDeclaration()) {
                    expression.getDeclaration().accept(this);
                    if (expression.hasSpaceAfterDeclaration()) {
                        this.virtualSpace = true;
                    }
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        protected void visitAbstractSingleEncapsulatedExpression(AbstractSingleEncapsulatedExpression expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= expression.getIdentifier().length()) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasEncapsulatedExpression() && !expression.hasRightParenthesis()) {
                    expression.getExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        protected void visitAbstractTripleEncapsulatedExpression(AbstractTripleEncapsulatedExpression expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= expression.getIdentifier().length()) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasThirdExpression() && !expression.hasRightParenthesis()) {
                    expression.getThirdExpression().accept(this);
                } else if (expression.hasSecondExpression() && !expression.hasSecondComma()) {
                    expression.getSecondExpression().accept(this);
                } else if (expression.hasFirstExpression() && !expression.hasFirstComma()) {
                    expression.getFirstExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }

        protected void visitCompoundExpression(CompoundExpression expression) {
            if (this.badExpression) {
                if (this.positionWithinInvalidExpression <= expression.getIdentifier().length() && !expression.hasLeftExpression()) {
                    this.queryPosition.setExpression(expression);
                    this.queryPosition.addPosition(expression, this.positionWithinInvalidExpression);
                }
            } else {
                if (expression.hasRightExpression()) {
                    expression.getRightExpression().accept(this);
                }
                if (this.queryPosition.getExpression() == null) {
                    this.queryPosition.setExpression(expression);
                }
                this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
            }
        }
    }

    protected static final class EnumVisitor
    extends AbstractExpressionVisitor {
        protected AbstractPathExpression pathExpression;
        protected boolean valid;

        protected EnumVisitor() {
        }

        public void dispose() {
            this.valid = false;
            this.pathExpression = null;
        }

        public boolean isValid() {
            return this.valid;
        }

        @Override
        public void visit(CaseExpression expression) {
            this.valid = this.pathExpression == expression.getElseExpression();
        }

        @Override
        public void visit(CoalesceExpression expression) {
            this.valid = this.pathExpression == expression.getExpression();
        }

        @Override
        public void visit(CollectionMemberExpression expression) {
            this.valid = this.pathExpression == expression.getEntityExpression();
        }

        @Override
        public void visit(CollectionValuedPathExpression expression) {
            expression.getParent().accept(this);
        }

        @Override
        public void visit(ComparisonExpression expression) {
            String identifier = expression.getComparisonOperator();
            this.valid = identifier == "=" || identifier == "<>";
        }

        @Override
        public void visit(ConstructorExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(FunctionExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(InExpression expression) {
            this.valid = this.pathExpression != expression.getExpression();
        }

        @Override
        public void visit(NullIfExpression expression) {
            this.valid = this.pathExpression == expression.getSecondExpression();
        }

        @Override
        public void visit(StateFieldPathExpression expression) {
            expression.getParent().accept(this);
        }

        @Override
        public void visit(UpdateItem expression) {
            this.valid = this.pathExpression == expression.getNewValue();
        }

        @Override
        public void visit(WhenClause expression) {
            this.valid = this.pathExpression == expression.getThenExpression() || this.pathExpression == expression.getWhenExpression();
        }
    }

    protected static final class FilteringMappingCollector
    implements MappingCollector {
        protected final Filter<IMapping> filter;
        protected final Resolver resolver;
        protected final String suffix;

        FilteringMappingCollector(Resolver resolver, Filter<IMapping> filter, String suffix) {
            this.filter = filter;
            this.suffix = suffix;
            this.resolver = resolver;
        }

        protected void addFilteredMappings(IManagedType managedType, List<IMapping> mappings) {
            Filter<IMapping> filter = this.buildFilter(this.suffix);
            for (IMapping mapping : managedType.mappings()) {
                if (!filter.accept(mapping)) continue;
                mappings.add(mapping);
            }
        }

        protected Filter<IMapping> buildFilter(String suffix) {
            if (suffix.length() == 0) {
                return this.filter;
            }
            return new AndFilter<IMapping>(this.filter, this.buildMappingNameFilter(suffix));
        }

        protected Filter<IMapping> buildMappingNameFilter(final String suffix) {
            return new Filter<IMapping>(){

                @Override
                public boolean accept(IMapping mapping) {
                    return mapping.getName().startsWith(suffix);
                }
            };
        }

        @Override
        public Collection<IMapping> buildProposals() {
            IManagedType managedType = this.resolver.getManagedType();
            if (managedType == null) {
                return Collections.emptyList();
            }
            ArrayList<IMapping> mappings = new ArrayList<IMapping>();
            this.addFilteredMappings(managedType, mappings);
            return mappings;
        }
    }

    protected static class FollowingClausesVisitor
    extends AbstractTraverseParentVisitor {
        protected String afterIdentifier;
        protected String beforeIdentifier;
        protected boolean hasFollowUpClauses;

        protected FollowingClausesVisitor() {
        }

        public void dispose() {
            this.afterIdentifier = null;
            this.beforeIdentifier = null;
            this.hasFollowUpClauses = false;
        }

        protected boolean hasFromClause(AbstractSelectStatement expression) {
            return this.afterIdentifier != "FROM" && expression.hasFromClause();
        }

        @Override
        public void visit(SelectStatement expression) {
            if (this.afterIdentifier == "SELECT") {
                this.hasFollowUpClauses = this.beforeIdentifier == "WHERE" ? this.hasFromClause(expression) : (this.beforeIdentifier == "GROUP BY" ? this.hasFromClause(expression) || expression.hasWhereClause() : (this.beforeIdentifier == "HAVING" ? this.hasFromClause(expression) || expression.hasWhereClause() || expression.hasGroupByClause() : (this.beforeIdentifier == "ORDER BY" ? this.hasFromClause(expression) || expression.hasWhereClause() || expression.hasGroupByClause() || expression.hasHavingClause() : (this.beforeIdentifier == null ? this.hasFromClause(expression) || expression.hasWhereClause() || expression.hasGroupByClause() || expression.hasHavingClause() || expression.hasOrderByClause() : this.hasFromClause(expression)))));
            } else if (this.afterIdentifier == "FROM") {
                this.hasFollowUpClauses = this.beforeIdentifier == "GROUP BY" ? this.hasFromClause(expression) || expression.hasWhereClause() : (this.beforeIdentifier == "HAVING" ? this.hasFromClause(expression) || expression.hasWhereClause() || expression.hasGroupByClause() : (this.beforeIdentifier == "ORDER BY" ? this.hasFromClause(expression) || expression.hasWhereClause() || expression.hasGroupByClause() || expression.hasHavingClause() : (this.beforeIdentifier == null ? this.hasFromClause(expression) || expression.hasWhereClause() || expression.hasGroupByClause() || expression.hasHavingClause() || expression.hasOrderByClause() : this.hasFromClause(expression))));
            } else if (this.afterIdentifier == "WHERE") {
                if (this.beforeIdentifier == "HAVING") {
                    this.hasFollowUpClauses = expression.hasGroupByClause();
                } else if (this.beforeIdentifier == "ORDER BY") {
                    this.hasFollowUpClauses = expression.hasGroupByClause() || expression.hasHavingClause();
                } else if (this.beforeIdentifier == null) {
                    this.hasFollowUpClauses = expression.hasGroupByClause() || expression.hasHavingClause() || expression.hasOrderByClause();
                }
            } else if (this.afterIdentifier == "GROUP BY") {
                if (this.beforeIdentifier == "ORDER BY") {
                    this.hasFollowUpClauses = expression.hasHavingClause();
                } else if (this.beforeIdentifier == null) {
                    this.hasFollowUpClauses = expression.hasHavingClause() || expression.hasOrderByClause();
                }
            } else {
                this.hasFollowUpClauses = this.afterIdentifier == "HAVING" ? expression.hasOrderByClause() : this.hasFromClause(expression);
            }
        }

        @Override
        public void visit(SimpleFromClause expression) {
            expression.getParent().accept(this);
        }

        @Override
        public void visit(SimpleSelectStatement expression) {
            if (this.afterIdentifier == "SELECT") {
                if (this.beforeIdentifier == "WHERE") {
                    this.hasFollowUpClauses = this.hasFromClause(expression);
                } else if (this.beforeIdentifier == "GROUP BY") {
                    this.hasFollowUpClauses = this.hasFromClause(expression) || expression.hasWhereClause();
                } else if (this.beforeIdentifier == "HAVING") {
                    this.hasFollowUpClauses = this.hasFromClause(expression) || expression.hasWhereClause() || expression.hasGroupByClause();
                } else if (this.beforeIdentifier == null) {
                    this.hasFollowUpClauses = this.hasFromClause(expression) || expression.hasWhereClause() || expression.hasGroupByClause() || expression.hasHavingClause();
                }
            } else if (this.afterIdentifier == "FROM") {
                if (this.beforeIdentifier == "GROUP BY") {
                    this.hasFollowUpClauses = this.hasFromClause(expression) || expression.hasWhereClause();
                } else if (this.beforeIdentifier == "HAVING") {
                    this.hasFollowUpClauses = this.hasFromClause(expression) || expression.hasWhereClause() || expression.hasGroupByClause();
                } else if (this.beforeIdentifier == null) {
                    this.hasFollowUpClauses = this.hasFromClause(expression) || expression.hasWhereClause() || expression.hasGroupByClause() || expression.hasHavingClause();
                }
            } else if (this.afterIdentifier == "WHERE") {
                if (this.beforeIdentifier == "HAVING") {
                    this.hasFollowUpClauses = expression.hasGroupByClause();
                } else if (this.beforeIdentifier == null) {
                    this.hasFollowUpClauses = expression.hasGroupByClause() || expression.hasHavingClause();
                }
            }
        }
    }

    protected static final class FollowingInvalidExpressionVisitor
    extends AbstractTraverseParentVisitor {
        protected final AbstractContentAssistVisitor visitor;
        protected Expression expression;
        protected boolean followingInvalidExpression;

        protected FollowingInvalidExpressionVisitor(AbstractContentAssistVisitor visitor) {
            this.visitor = visitor;
        }

        public void dispose() {
            this.expression = null;
            this.followingInvalidExpression = false;
        }

        public boolean isFollowingInvalidExpression() {
            return this.followingInvalidExpression;
        }

        @Override
        public void visit(CollectionExpression expression) {
            Expression child;
            int index = expression.childrenSize();
            while (--index >= 0) {
                child = expression.getChild(index);
                if (child == this.expression) break;
            }
            while (--index >= 0) {
                child = expression.getChild(index);
                this.followingInvalidExpression = this.visitor.isInvalidExpression(child);
                if (!this.followingInvalidExpression) continue;
                index = -1;
            }
        }

        @Override
        protected void visit(Expression expression) {
            this.expression = expression;
            super.visit(expression);
        }
    }

    protected static class FromClauseCollectionHelper
    extends AbstractVisitorHelper
    implements CollectionExpressionHelper<AbstractFromClause> {
        protected FromClauseCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addAtTheEndOfChild(AbstractFromClause expression, CollectionExpression collectionExpression, int index, boolean hasComma, boolean virtualSpace) {
            if ((index == 0 || hasComma) && virtualSpace) {
                if (this.visitor.isComplete(collectionExpression.getChild(0))) {
                    this.visitor.addJoinIdentifiers();
                    this.visitor.addIdentifier("ON");
                }
            } else {
                boolean end;
                boolean bl = end = index + 1 == collectionExpression.childrenSize();
                if (index > 0 && end && !hasComma) {
                    int position = this.visitor.queryPosition.getPosition();
                    if (!this.visitor.hasClausesDefinedBetween(expression, "FROM", "HAVING")) {
                        this.visitor.addCompositeIdentifier("GROUP BY", 4);
                    }
                    if (!this.visitor.hasClausesDefinedBetween(expression, "FROM", "ORDER BY")) {
                        this.visitor.addCompositeIdentifier("ORDER BY", 4);
                    }
                }
            }
        }

        @Override
        public void addIdentifier(AbstractFromClause expression, String identifier) {
            this.visitor.proposals.addIdentifier(identifier);
        }

        @Override
        public void addTheBeginningOfChild(AbstractFromClause expression, CollectionExpression collectionExpression, int index, boolean hasComma) {
            if (index == 0 || hasComma) {
                this.visitor.addEntities();
            } else if (index > 0 && !hasComma) {
                this.visitor.addJoinIdentifiers();
            }
            if (index > 0 && hasComma) {
                this.visitor.addIdentifier("IN");
            }
        }

        @Override
        public CollectionExpression buildCollectionExpression(AbstractFromClause expression) {
            CollectionExpression collectionExpression = this.visitor.getCollectionExpression(expression.getDeclaration());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean canContinue(AbstractFromClause expression, CollectionExpression collectionExpression, int index) {
            return true;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(AbstractFromClause expression) {
            return expression.hasSpaceAfterFrom();
        }

        @Override
        public int maxCollectionSize(AbstractFromClause expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(AbstractFromClause expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(AbstractFromClause expression, int index) {
            return this.visitor.getQueryBNF(expression.getDeclarationQueryBNFId());
        }
    }

    protected static class FromClauseStatementHelper
    extends AbstractFromClauseStatementHelper<SelectStatement> {
        protected FromClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        public WhereClauseSelectStatementHelper getNextHelper() {
            return this.visitor.getWhereClauseSelectStatementHelper();
        }
    }

    protected static final class GroupByClauseCollectionHelper
    extends AbstractVisitorHelper
    implements CollectionExpressionHelper<GroupByClause> {
        protected GroupByClauseCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addAtTheEndOfChild(GroupByClause expression, CollectionExpression collectionExpression, int index, boolean hasComma, boolean virtualSpace) {
        }

        @Override
        public void addIdentifier(GroupByClause expression, String identifier) {
            this.visitor.proposals.addIdentifier(identifier);
        }

        @Override
        public void addTheBeginningOfChild(GroupByClause expression, CollectionExpression collectionExpression, int index, boolean hasComma) {
            if (index == 0 || hasComma) {
                this.visitor.addFunctionIdentifiers("groupby_item");
                this.visitor.addIdentificationVariables();
            }
        }

        @Override
        public CollectionExpression buildCollectionExpression(GroupByClause expression) {
            CollectionExpression collectionExpression = this.visitor.getCollectionExpression(expression.getGroupByItems());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean canContinue(GroupByClause expression, CollectionExpression collectionExpression, int index) {
            return false;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(GroupByClause expression) {
            return expression.hasSpaceAfterGroupBy();
        }

        @Override
        public int maxCollectionSize(GroupByClause expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(GroupByClause expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(GroupByClause expression, int index) {
            return this.visitor.getQueryBNF("groupby_item");
        }
    }

    protected static final class GroupByClauseStatementHelper
    extends AbstractGroupByClauseStatementHelper<SelectStatement> {
        protected GroupByClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        public HavingClauseStatementHelper getNextHelper() {
            return this.visitor.getHavingClauseStatementHelper();
        }
    }

    protected static final class HavingClauseStatementHelper
    extends AbstractHavingClauseStatementHelper<SelectStatement> {
        protected HavingClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        public OrderByClauseStatementHelper getNextHelper() {
            return this.visitor.getOrderByClauseStatementHelper();
        }

        @Override
        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return expression.hasSpaceBeforeOrderBy();
        }
    }

    protected static enum IdentificationVariableType {
        ALL{

            @Override
            protected boolean add(AbstractContentAssistVisitor contentAssist, Declaration declaration, Expression expression) {
                if (declaration.getType() == JPQLQueryDeclaration.Type.RANGE) {
                    contentAssist.addRangeIdentificationVariable(declaration.getVariableName());
                } else {
                    contentAssist.addIdentificationVariable(declaration.getVariableName());
                }
                for (Join join : declaration.getJoins()) {
                    String variableName = contentAssist.queryContext.literal(join.getIdentificationVariable(), LiteralType.IDENTIFICATION_VARIABLE);
                    contentAssist.addIdentificationVariable(variableName);
                }
                return false;
            }
        }
        ,
        COLLECTION{

            @Override
            protected boolean add(AbstractContentAssistVisitor contentAssist, Declaration declaration, Expression expression) {
                contentAssist.addIdentificationVariable(declaration.getVariableName());
                for (Join join : declaration.getJoins()) {
                    String variableName = contentAssist.queryContext.literal(join.getIdentificationVariable(), LiteralType.IDENTIFICATION_VARIABLE);
                    contentAssist.addIdentificationVariable(variableName);
                }
                return false;
            }
        }
        ,
        LEFT{

            @Override
            protected boolean add(AbstractContentAssistVisitor contentAssist, Declaration declaration, Expression expression) {
                boolean shouldStop = declaration.getDeclarationExpression().isAncestor(expression);
                if (shouldStop && !declaration.getJoins().contains(expression)) {
                    return true;
                }
                if (declaration.getType() == JPQLQueryDeclaration.Type.RANGE) {
                    contentAssist.addRangeIdentificationVariable(declaration.getVariableName());
                } else {
                    contentAssist.addIdentificationVariable(declaration.getVariableName());
                }
                for (Join join : declaration.getJoins()) {
                    if (join.isAncestor(expression)) {
                        return true;
                    }
                    String variableName = contentAssist.queryContext.literal(join.getIdentificationVariable(), LiteralType.IDENTIFICATION_VARIABLE);
                    contentAssist.addIdentificationVariable(variableName);
                }
                return false;
            }
        }
        ,
        LEFT_COLLECTION{

            @Override
            protected boolean add(AbstractContentAssistVisitor contentAssist, Declaration declaration, Expression expression) {
                boolean shouldStop = declaration.getDeclarationExpression().isAncestor(expression);
                if (shouldStop && declaration.getJoins().contains(expression)) {
                    return true;
                }
                if (!shouldStop && declaration.getType() == JPQLQueryDeclaration.Type.COLLECTION) {
                    contentAssist.addIdentificationVariable(declaration.getVariableName());
                } else {
                    for (Join join : declaration.getJoins()) {
                        if (join.isAncestor(expression)) {
                            return true;
                        }
                        String variableName = contentAssist.queryContext.literal(join.getIdentificationVariable(), LiteralType.IDENTIFICATION_VARIABLE);
                        contentAssist.addIdentificationVariable(variableName);
                    }
                }
                return false;
            }
        }
        ,
        NONE{

            @Override
            protected boolean add(AbstractContentAssistVisitor contentAssist, Declaration declaration, Expression expression) {
                return true;
            }
        };


        protected abstract boolean add(AbstractContentAssistVisitor var1, Declaration var2, Expression var3);
    }

    protected static class IncompleteCollectionExpressionVisitor
    extends AbstractExpressionVisitor {
        protected String clause;
        protected boolean complete;
        protected boolean insideCollection;

        protected IncompleteCollectionExpressionVisitor() {
        }

        protected List<String> compositeIdentifiersAfter(String afterIdentifier) {
            if (this.clause == "FROM") {
                return CollectionTools.list("GROUP BY", "ORDER BY");
            }
            if (this.clause == "WHERE") {
                return CollectionTools.list("GROUP BY", "ORDER BY");
            }
            if (this.clause == "HAVING") {
                return CollectionTools.list("ORDER BY");
            }
            return new LinkedList<String>();
        }

        public void dispose() {
            this.complete = false;
        }

        public boolean isComplete() {
            return this.complete;
        }

        protected boolean isPossibleCompositeIdentifier(String clause, String fragment) {
            for (String identifier : this.compositeIdentifiersAfter(clause)) {
                if (!identifier.toLowerCase(Locale.ROOT).startsWith(fragment)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void visit(CollectionExpression expression) {
            int lastIndex = expression.childrenSize() - 1;
            this.insideCollection = true;
            if (!expression.hasComma(lastIndex - 1)) {
                expression.getChild(lastIndex).accept(this);
            }
            this.insideCollection = false;
        }

        @Override
        public void visit(FromClause expression) {
            this.clause = "FROM";
            expression.getDeclaration().accept(this);
            this.clause = null;
        }

        @Override
        public void visit(GroupByClause expression) {
            this.clause = "GROUP BY";
            expression.getGroupByItems().accept(this);
            this.clause = null;
        }

        @Override
        public void visit(HavingClause expression) {
            this.clause = "HAVING";
            expression.getConditionalExpression().accept(this);
            this.clause = null;
        }

        @Override
        public void visit(IdentificationVariable expression) {
            this.complete = true;
        }

        @Override
        public void visit(IdentificationVariableDeclaration expression) {
            if (this.insideCollection && !expression.hasJoins()) {
                expression.getRangeVariableDeclaration().accept(this);
            }
        }

        @Override
        public void visit(OrderByClause expression) {
            this.clause = "ORDER BY";
            expression.getOrderByItems().accept(this);
            this.clause = null;
        }

        @Override
        public void visit(RangeVariableDeclaration expression) {
            if (this.insideCollection) {
                boolean bl = this.complete = !expression.hasAs() && !expression.hasIdentificationVariable();
                if (!this.complete) {
                    String fragment = expression.toParsedText().toLowerCase(Locale.ROOT);
                    this.complete = this.isPossibleCompositeIdentifier(this.clause, fragment);
                }
            }
        }

        @Override
        public void visit(WhereClause expression) {
            this.clause = "WHERE";
            expression.getConditionalExpression().accept(this);
            this.clause = null;
        }
    }

    protected static final class InvalidExpressionVisitor
    extends AbstractExpressionVisitor {
        protected Expression expression;

        protected InvalidExpressionVisitor() {
        }

        public void dispose() {
            this.expression = null;
        }

        public boolean isInvalid() {
            return this.expression != null;
        }

        @Override
        public void visit(BadExpression expression) {
            this.expression = expression;
        }

        @Override
        public void visit(UnknownExpression expression) {
            this.expression = expression;
        }
    }

    protected static final class JoinCollectionHelper
    extends AbstractVisitorHelper
    implements CollectionExpressionHelper<IdentificationVariableDeclaration> {
        protected JoinCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addAtTheEndOfChild(IdentificationVariableDeclaration expression, CollectionExpression collectionExpression, int index, boolean hasComma, boolean virtualSpace) {
        }

        @Override
        public void addIdentifier(IdentificationVariableDeclaration expression, String identifier) {
            this.visitor.proposals.addIdentifier(identifier);
        }

        @Override
        public void addTheBeginningOfChild(IdentificationVariableDeclaration expression, CollectionExpression collectionExpression, int index, boolean hasComma) {
            this.visitor.addJoinIdentifiers();
        }

        @Override
        public CollectionExpression buildCollectionExpression(IdentificationVariableDeclaration expression) {
            CollectionExpression collectionExpression = this.visitor.getCollectionExpression(expression.getJoins());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean canContinue(IdentificationVariableDeclaration expression, CollectionExpression collectionExpression, int index) {
            return false;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(IdentificationVariableDeclaration expression) {
            return expression.hasSpace();
        }

        @Override
        public int maxCollectionSize(IdentificationVariableDeclaration expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(IdentificationVariableDeclaration expression) {
            return expression.getRangeVariableDeclaration().getLength();
        }

        @Override
        public JPQLQueryBNF queryBNF(IdentificationVariableDeclaration expression, int index) {
            return this.visitor.getQueryBNF("join*");
        }
    }

    protected static interface MappingCollector {
        public Collection<IMapping> buildProposals();
    }

    protected static final class MappingFilterBuilder
    extends AbstractTraverseParentVisitor {
        protected final AbstractContentAssistVisitor visitor;
        protected Filter<IMapping> filter;

        protected MappingFilterBuilder(AbstractContentAssistVisitor visitor) {
            this.visitor = visitor;
        }

        public void dispose() {
            this.filter = null;
        }

        @Override
        public void visit(AbsExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(AvgFunction expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(BetweenExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(CoalesceExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(CollectionMemberDeclaration expression) {
            this.filter = this.visitor.getMappingCollectionFilter();
        }

        @Override
        public void visit(CollectionValuedPathExpression expression) {
            this.filter = this.visitor.getMappingCollectionFilter();
        }

        @Override
        public void visit(ConcatExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(CountFunction expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(EmptyCollectionComparisonExpression expression) {
            this.filter = this.visitor.getMappingCollectionFilter();
        }

        @Override
        public void visit(FunctionExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(HavingClause expression) {
            this.filter = NullFilter.instance();
        }

        @Override
        public void visit(Join expression) {
            this.filter = this.visitor.getMappingCollectionFilter();
        }

        @Override
        public void visit(JPQLExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(LengthExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(LocateExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(LowerExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(MaxFunction expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(MinFunction expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(ModExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(NullComparisonExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(OnClause expression) {
            this.filter = NullFilter.instance();
        }

        @Override
        public void visit(SizeExpression expression) {
            this.filter = this.visitor.getMappingCollectionFilter();
        }

        @Override
        public void visit(SqrtExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(SubstringExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(SumFunction expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(TreatExpression expression) {
            this.filter = this.visitor.getMappingCollectionFilter();
        }

        @Override
        public void visit(TrimExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(UpperExpression expression) {
            this.filter = this.visitor.getMappingPropertyFilter();
        }

        @Override
        public void visit(WhenClause expression) {
            this.filter = NullFilter.instance();
        }

        @Override
        public void visit(WhereClause expression) {
            this.filter = NullFilter.instance();
        }
    }

    protected static final class MappingTypeFilter
    extends AbstractVisitorHelper
    implements Filter<IMapping> {
        protected final IType type;

        MappingTypeFilter(IType type, AbstractContentAssistVisitor visitor) {
            super(visitor);
            this.type = type;
        }

        @Override
        public boolean accept(IMapping value) {
            if (value.isRelationship() && !value.isCollection()) {
                return true;
            }
            IType mappingType = value.getType();
            mappingType = this.visitor.queryContext.getTypeHelper().convertPrimitive(mappingType);
            return mappingType.isAssignableTo(this.type);
        }
    }

    protected static final class NotExpressionVisitor
    extends AbstractExpressionVisitor {
        protected NotExpression expression;

        protected NotExpressionVisitor() {
        }

        public void dispose() {
            this.expression = null;
        }

        public boolean isNotExpression() {
            return this.expression != null;
        }

        @Override
        public void visit(NotExpression expression) {
            this.expression = expression;
        }
    }

    protected static final class OrderByClauseCollectionHelper
    extends AbstractVisitorHelper
    implements CollectionExpressionHelper<AbstractOrderByClause> {
        protected OrderByClauseCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addAtTheEndOfChild(AbstractOrderByClause expression, CollectionExpression collectionExpression, int index, boolean hasComma, boolean virtualSpace) {
            OrderByItem item = (OrderByItem)collectionExpression.getChild(index);
            if (item.getOrdering() == OrderByItem.Ordering.DEFAULT) {
                this.visitor.addIdentifier("ASC");
                this.visitor.addIdentifier("DESC");
            }
        }

        @Override
        public void addIdentifier(AbstractOrderByClause expression, String identifier) {
            this.visitor.proposals.addIdentifier(identifier);
        }

        @Override
        public void addTheBeginningOfChild(AbstractOrderByClause expression, CollectionExpression collectionExpression, int index, boolean hasComma) {
            if (index == 0 || hasComma) {
                this.visitor.addIdentificationVariables();
                this.visitor.addResultVariables();
            }
        }

        @Override
        public CollectionExpression buildCollectionExpression(AbstractOrderByClause expression) {
            CollectionExpression collectionExpression = this.visitor.getCollectionExpression(expression.getOrderByItems());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean canContinue(AbstractOrderByClause expression, CollectionExpression collectionExpression, int index) {
            return false;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(AbstractOrderByClause expression) {
            return expression.hasSpaceAfterIdentifier();
        }

        @Override
        public int maxCollectionSize(AbstractOrderByClause expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(AbstractOrderByClause expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(AbstractOrderByClause expression, int index) {
            return this.visitor.getQueryBNF("orderby_item");
        }
    }

    protected static class OrderByClauseStatementHelper
    extends AbstractVisitorHelper
    implements StatementHelper<SelectStatement> {
        protected OrderByClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addClauseProposals() {
            this.visitor.addCompositeIdentifier("ORDER BY", -1);
        }

        @Override
        public void addInternalClauseProposals(SelectStatement expression) {
        }

        @Override
        public Expression getClause(SelectStatement expression) {
            return expression.getOrderByClause();
        }

        @Override
        public StatementHelper<SelectStatement> getNextHelper() {
            return null;
        }

        @Override
        public boolean hasClause(SelectStatement expression) {
            return expression.hasOrderByClause();
        }

        @Override
        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return false;
        }

        @Override
        public boolean isClauseComplete(SelectStatement expression) {
            return this.visitor.isComplete(expression.getOrderByClause());
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    }

    protected static final class PropertyMappingFilter
    implements Filter<IMapping> {
        protected PropertyMappingFilter() {
        }

        @Override
        public boolean accept(IMapping value) {
            return !value.isTransient() && !value.isCollection();
        }
    }

    protected static final class RangeVariableDeclarationVisitor
    extends AbstractExpressionVisitor {
        protected RangeVariableDeclaration expression;

        protected RangeVariableDeclarationVisitor() {
        }

        public void dispose() {
            this.expression = null;
        }

        @Override
        public void visit(RangeVariableDeclaration expression) {
            this.expression = expression;
        }
    }

    protected static final class ResultVariableVisitor
    extends AbstractExpressionVisitor {
        protected ResultVariable expression;

        protected ResultVariableVisitor() {
        }

        public void dispose() {
            this.expression = null;
        }

        @Override
        public void visit(ResultVariable expression) {
            this.expression = expression;
        }
    }

    protected static final class SelectClauseCollectionHelper
    extends AbstractSelectClauseCollectionHelper<SelectClause> {
        protected SelectClauseCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addAtTheEndOfChild(SelectClause expression, CollectionExpression collectionExpression, int index, boolean hasComma, boolean virtualSpace) {
            super.addAtTheEndOfChild(expression, collectionExpression, index, hasComma, virtualSpace);
            Expression child = collectionExpression.getChild(index);
            if (virtualSpace && this.visitor.isComplete(child)) {
                this.visitor.addIdentifier("AS");
            }
        }

        @Override
        public void addTheBeginningOfChild(SelectClause expression, CollectionExpression collectionExpression, int index, boolean hasComma) {
            super.addTheBeginningOfChild(expression, collectionExpression, index, hasComma);
            if (index == 0) {
                this.visitor.addIdentifier("DISTINCT");
            }
        }

        @Override
        public int preExpressionLength(SelectClause expression) {
            int length = 0;
            if (expression.hasDistinct()) {
                length = 8;
                if (expression.hasSpaceAfterDistinct()) {
                    ++length;
                }
            }
            return length;
        }
    }

    protected static final class SelectClauseStatementHelper
    extends AbstractSelectClauseStatementHelper {
        protected SelectClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        public FromClauseStatementHelper getNextHelper() {
            return this.visitor.getFromClauseStatementHelper();
        }
    }

    protected static class SimpleFromClauseStatementHelper
    extends AbstractFromClauseStatementHelper<SimpleSelectStatement> {
        protected SimpleFromClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        public SimpleWhereClauseSelectStatementHelper getNextHelper() {
            return this.visitor.getSimpleWhereClauseSelectStatementHelper();
        }
    }

    protected static final class SimpleGroupByClauseStatementHelper
    extends AbstractGroupByClauseStatementHelper<SimpleSelectStatement> {
        protected SimpleGroupByClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        public SimpleHavingClauseStatementHelper getNextHelper() {
            return this.visitor.getSimpleHavingClauseStatementHelper();
        }
    }

    protected static final class SimpleHavingClauseStatementHelper
    extends AbstractHavingClauseStatementHelper<SimpleSelectStatement> {
        protected SimpleHavingClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public StatementHelper<SimpleSelectStatement> getNextHelper() {
            return null;
        }

        @Override
        public boolean hasSpaceAfterClause(SimpleSelectStatement expression) {
            return false;
        }
    }

    protected static final class SimpleSelectClauseCollectionHelper
    extends AbstractSelectClauseCollectionHelper<SimpleSelectClause> {
        protected SimpleSelectClauseCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }
    }

    protected static final class SimpleSelectClauseStatementHelper
    extends AbstractSelectClauseStatementHelper {
        protected SimpleSelectClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public StatementHelper<SimpleSelectStatement> getNextHelper() {
            return this.visitor.getSimpleFromClauseStatementHelper();
        }
    }

    protected static final class SimpleWhereClauseSelectStatementHelper
    extends AbstractWhereClauseSelectStatementHelper<SimpleSelectStatement> {
        protected SimpleWhereClauseSelectStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public StatementHelper<SimpleSelectStatement> getNextHelper() {
            return this.visitor.getSimpleGroupByClauseStatementHelper();
        }
    }

    protected static interface StatementHelper<T extends Expression> {
        public void addClauseProposals();

        public void addInternalClauseProposals(T var1);

        public Expression getClause(T var1);

        public StatementHelper<? extends T> getNextHelper();

        public boolean hasClause(T var1);

        public boolean hasSpaceAfterClause(T var1);

        public boolean isClauseComplete(T var1);

        public boolean isRequired();
    }

    protected static final class SubqueryAppendableExpressionVisitor
    extends AbstractAppendableExpressionVisitor {
        protected boolean subExpression;

        protected SubqueryAppendableExpressionVisitor() {
        }

        @Override
        public void visit(IdentificationVariable expression) {
            this.appendable = this.subExpression;
        }

        @Override
        public void visit(NullExpression expression) {
            this.appendable = this.subExpression;
        }

        @Override
        public void visit(SubExpression expression) {
            this.subExpression = true;
            expression.getExpression().accept(this);
            this.subExpression = false;
        }
    }

    protected static final class SubqueryVisitor
    extends AbstractTraverseParentVisitor {
        protected SimpleSelectStatement expression;

        protected SubqueryVisitor() {
        }

        public void dispose() {
            this.expression = null;
        }

        public boolean isInSubquery() {
            return this.expression != null;
        }

        @Override
        public void visit(SimpleSelectStatement expression) {
            this.expression = expression;
        }
    }

    protected static final class TripleEncapsulatedCollectionHelper
    extends AbstractVisitorHelper
    implements CollectionExpressionHelper<AbstractTripleEncapsulatedExpression> {
        protected TripleEncapsulatedCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addAtTheEndOfChild(AbstractTripleEncapsulatedExpression expression, CollectionExpression collectionExpression, int index, boolean hasComma, boolean virtualSpace) {
            if (this.queryBNF(expression, index).handleAggregate()) {
                Expression child = collectionExpression.getChild(index);
                if (index == 0 && !virtualSpace) {
                    if (this.visitor.areArithmeticSymbolsAppendable(child)) {
                        this.visitor.addArithmeticIdentifiers();
                    }
                } else {
                    if (this.visitor.areArithmeticSymbolsAppendable(child)) {
                        this.visitor.addArithmeticIdentifiers();
                    }
                    if (this.visitor.areComparisonSymbolsAppendable(child)) {
                        this.visitor.addComparisonIdentifiers(child);
                    }
                }
            }
        }

        @Override
        public void addIdentifier(AbstractTripleEncapsulatedExpression expression, String identifier) {
            this.visitor.proposals.addIdentifier(identifier);
            this.visitor.addFunctionIdentifiers(expression);
        }

        @Override
        public void addTheBeginningOfChild(AbstractTripleEncapsulatedExpression expression, CollectionExpression collectionExpression, int index, boolean hasComma) {
            this.visitor.addIdentificationVariables();
            this.visitor.addFunctionIdentifiers(this.queryBNF(expression, index));
        }

        @Override
        public CollectionExpression buildCollectionExpression(AbstractTripleEncapsulatedExpression expression) {
            return expression.buildCollectionExpression();
        }

        @Override
        public boolean canContinue(AbstractTripleEncapsulatedExpression expression, CollectionExpression collectionExpression, int index) {
            return false;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(AbstractTripleEncapsulatedExpression expression) {
            return expression.hasSpaceAfterIdentifier() || expression.hasLeftParenthesis();
        }

        @Override
        public int maxCollectionSize(AbstractTripleEncapsulatedExpression expression) {
            return 3;
        }

        @Override
        public int preExpressionLength(AbstractTripleEncapsulatedExpression expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(AbstractTripleEncapsulatedExpression expression, int index) {
            return this.visitor.getQueryBNF(expression.getParameterQueryBNFId(index));
        }
    }

    protected static final class UpdateClauseStatementHelper
    extends AbstractVisitorHelper
    implements StatementHelper<UpdateStatement> {
        protected UpdateClauseStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addClauseProposals() {
            this.visitor.addIdentifier("UPDATE");
        }

        @Override
        public void addInternalClauseProposals(UpdateStatement expression) {
        }

        @Override
        public Expression getClause(UpdateStatement expression) {
            return expression.getUpdateClause();
        }

        @Override
        public StatementHelper<UpdateStatement> getNextHelper() {
            return this.visitor.getWhereClauseUpdateStatementHelper();
        }

        @Override
        public boolean hasClause(UpdateStatement expression) {
            return true;
        }

        @Override
        public boolean hasSpaceAfterClause(UpdateStatement expression) {
            return expression.hasSpaceAfterUpdateClause();
        }

        @Override
        public boolean isClauseComplete(UpdateStatement expression) {
            return this.visitor.isComplete(expression.getUpdateClause());
        }

        @Override
        public boolean isRequired() {
            return true;
        }
    }

    protected static final class UpdateItemCollectionHelper
    extends AbstractVisitorHelper
    implements CollectionExpressionHelper<UpdateClause> {
        protected UpdateItemCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addAtTheEndOfChild(UpdateClause expression, CollectionExpression collectionExpression, int index, boolean hasComma, boolean virtualSpace) {
            this.visitor.addAggregateIdentifiers("new_value");
        }

        @Override
        public void addIdentifier(UpdateClause expression, String identifier) {
            this.visitor.proposals.addIdentifier(identifier);
        }

        @Override
        public void addTheBeginningOfChild(UpdateClause expression, CollectionExpression collectionExpression, int index, boolean hasComma) {
            this.visitor.addIdentificationVariables();
        }

        @Override
        public CollectionExpression buildCollectionExpression(UpdateClause expression) {
            CollectionExpression collectionExpression = this.visitor.getCollectionExpression(expression.getUpdateItems());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean canContinue(UpdateClause expression, CollectionExpression collectionExpression, int index) {
            return false;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(UpdateClause expression) {
            return expression.hasSpaceAfterUpdate();
        }

        @Override
        public int maxCollectionSize(UpdateClause expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(UpdateClause expression) {
            return "UPDATE".length() + 1 + expression.getRangeVariableDeclaration().getLength() + 1 + "SET".length();
        }

        @Override
        public JPQLQueryBNF queryBNF(UpdateClause expression, int index) {
            return this.visitor.getQueryBNF("new_value");
        }
    }

    protected static final class VisitParentVisitor
    extends AnonymousExpressionVisitor {
        protected final AbstractContentAssistVisitor visitor;

        protected VisitParentVisitor(AbstractContentAssistVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        protected void visit(Expression expression) {
            expression.getParent().accept(this.visitor);
        }

        @Override
        public void visit(InExpression expression) {
            int position = this.visitor.queryPosition.getPosition(expression) - this.visitor.corrections.peek();
            int length = 0;
            if (expression.hasExpression()) {
                length += expression.getExpression().getLength() + 1;
            }
            if (this.visitor.isPositionWithin(position, length, expression.getIdentifier())) {
                boolean hasOnlyIdentifier;
                boolean bl = hasOnlyIdentifier = !expression.hasExpression() && !expression.hasInItems();
                if (hasOnlyIdentifier) {
                    this.visitor.corrections.add(this.visitor.queryPosition.getPosition(expression));
                }
                super.visit(expression);
                if (hasOnlyIdentifier) {
                    this.visitor.corrections.pop();
                }
            } else {
                super.visit(expression);
            }
        }
    }

    protected static final class WhenClauseConditionalClauseCollectionHelper
    extends AbstractConditionalClauseCollectionHelper<WhenClause> {
        protected WhenClauseConditionalClauseCollectionHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public CollectionExpression buildCollectionExpression(WhenClause expression) {
            CollectionExpression collectionExpression = this.visitor.getCollectionExpression(expression.getWhenExpression());
            if (collectionExpression == null) {
                collectionExpression = expression.buildWhenCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(WhenClause expression) {
            return expression.hasSpaceAfterWhen();
        }
    }

    protected static final class WhereClauseDeleteStatementHelper
    extends AbstractVisitorHelper
    implements StatementHelper<DeleteStatement> {
        protected WhereClauseDeleteStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addClauseProposals() {
            this.visitor.addIdentifier("WHERE");
        }

        @Override
        public void addInternalClauseProposals(DeleteStatement expression) {
        }

        @Override
        public Expression getClause(DeleteStatement expression) {
            return expression.getWhereClause();
        }

        @Override
        public StatementHelper<? extends DeleteStatement> getNextHelper() {
            return null;
        }

        @Override
        public boolean hasClause(DeleteStatement expression) {
            return expression.hasWhereClause();
        }

        @Override
        public boolean hasSpaceAfterClause(DeleteStatement expression) {
            return false;
        }

        @Override
        public boolean isClauseComplete(DeleteStatement expression) {
            return this.visitor.isComplete(expression.getWhereClause());
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    }

    protected static final class WhereClauseSelectStatementHelper
    extends AbstractWhereClauseSelectStatementHelper<SelectStatement> {
        protected WhereClauseSelectStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public StatementHelper<SelectStatement> getNextHelper() {
            return this.visitor.getGroupByClauseStatementHelper();
        }
    }

    protected static final class WhereClauseUpdateStatementHelper
    extends AbstractVisitorHelper
    implements StatementHelper<UpdateStatement> {
        protected WhereClauseUpdateStatementHelper(AbstractContentAssistVisitor visitor) {
            super(visitor);
        }

        @Override
        public void addClauseProposals() {
            this.visitor.addIdentifier("WHERE");
        }

        @Override
        public void addInternalClauseProposals(UpdateStatement expression) {
        }

        @Override
        public Expression getClause(UpdateStatement expression) {
            return expression.getWhereClause();
        }

        @Override
        public StatementHelper<? extends UpdateStatement> getNextHelper() {
            return null;
        }

        @Override
        public boolean hasClause(UpdateStatement expression) {
            return expression.hasWhereClause();
        }

        @Override
        public boolean hasSpaceAfterClause(UpdateStatement expression) {
            return false;
        }

        @Override
        public boolean isClauseComplete(UpdateStatement expression) {
            return this.visitor.isComplete(expression.getWhereClause());
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    }

    protected static final class WithinInvalidExpressionVisitor
    extends AbstractTraverseParentVisitor {
        protected boolean withinInvalidExpression;

        protected WithinInvalidExpressionVisitor() {
        }

        public void dispose() {
            this.withinInvalidExpression = false;
        }

        public boolean isWithinInvalidExpression() {
            return this.withinInvalidExpression;
        }

        @Override
        public void visit(BadExpression expression) {
            this.withinInvalidExpression = true;
        }

        @Override
        public void visit(UnknownExpression expression) {
            this.withinInvalidExpression = true;
        }
    }
}

