/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.nosql;

import java.util.Iterator;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLAdapterMetaData;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLConnection;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLJCAConnectionSpec;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLRecordFactory;

public class OracleNoSQLConnectionFactory
implements ConnectionFactory {
    public Connection getConnection() throws ResourceException {
        return this.getConnection(new OracleNoSQLJCAConnectionSpec());
    }

    public Connection getConnection(ConnectionSpec spec) throws ResourceException {
        OracleNoSQLJCAConnectionSpec connectionSpec = (OracleNoSQLJCAConnectionSpec)spec;
        KVStore store = null;
        try {
            KVStoreFactory factory = new KVStoreFactory();
            String[] hosts = new String[connectionSpec.getHosts().size()];
            int index = 0;
            Iterator<String> iterator = connectionSpec.getHosts().iterator();
            while (iterator.hasNext()) {
                String host;
                hosts[index] = host = iterator.next();
                ++index;
            }
            KVStoreConfig config = new KVStoreConfig(connectionSpec.getStore(), hosts);
            store = KVStoreFactory.getStore((KVStoreConfig)config);
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException(exception.toString());
            resourceException.initCause((Throwable)exception);
            throw resourceException;
        }
        return new OracleNoSQLConnection(store, connectionSpec);
    }

    public ResourceAdapterMetaData getMetaData() {
        return new OracleNoSQLAdapterMetaData();
    }

    public RecordFactory getRecordFactory() {
        return new OracleNoSQLRecordFactory();
    }

    public Reference getReference() {
        return new Reference(this.getClass().getName());
    }

    public void setReference(Reference reference) {
    }
}

