/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.LoadGroup;
import org.eclipse.persistence.sessions.CopyGroup;

public class AttributeGroup
implements Serializable,
Cloneable {
    protected String name;
    protected String typeName;
    protected Class type;
    protected AttributeGroup superClassGroup;
    protected transient Set<AttributeGroup> subClasses;
    protected Map<Object, AttributeGroup> allsubclasses;
    protected Map<String, AttributeItem> items;

    public AttributeGroup(String name) {
        this.name = name;
    }

    public AttributeGroup(String name, Class type, boolean isValidated) {
        this(name);
        this.type = type;
    }

    public AttributeGroup(String name, String type, boolean isValidated) {
        this(name);
        this.typeName = type;
    }

    public AttributeGroup() {
        this("");
    }

    protected AttributeItem newItem(AttributeGroup group, String attrName) {
        return new AttributeItem(group, attrName);
    }

    protected AttributeGroup newGroup(String name, AttributeGroup parent) {
        return new AttributeGroup(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AttributeGroup findGroup(ClassDescriptor type) {
        if (this.type == null || this.type.equals(type.getJavaClass())) {
            return this;
        }
        if (this.hasInheritance()) {
            AttributeGroup result = this.getSubClassGroups().get(type.getJavaClass());
            while (result == null && type.getInheritancePolicy().getParentDescriptor() != null) {
                type = type.getInheritancePolicy().getParentDescriptor();
                result = this.getSubClassGroups().get(type.getJavaClass());
            }
            if (result != null) {
                return result;
            }
        }
        return this;
    }

    public Set<String> getAttributeNames() {
        HashSet<String> attributes = new HashSet<String>();
        if (this.superClassGroup != null && this.superClassGroup != this) {
            attributes.addAll(this.superClassGroup.getAttributeNames());
        }
        attributes.addAll(this.getItems().keySet());
        return attributes;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setAttributeNames(Set attributeNames) {
        Iterator it = attributeNames.iterator();
        while (it.hasNext()) {
            this.addAttribute((String)it.next());
        }
    }

    public void setAllSubclasses(Map<Object, AttributeGroup> subclasses) {
        this.allsubclasses = subclasses;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public boolean hasInheritance() {
        return this.subClasses != null && !this.subClasses.isEmpty() || this.superClassGroup != null;
    }

    public Map<Object, AttributeGroup> getSubClassGroups() {
        if (this.allsubclasses == null) {
            this.allsubclasses = new HashMap<Object, AttributeGroup>();
        }
        return this.allsubclasses;
    }

    public Map<String, AttributeItem> getItems() {
        if (this.items == null) {
            this.items = new HashMap<String, AttributeItem>();
        }
        return this.items;
    }

    public Map<String, AttributeItem> getAllItems() {
        HashMap<String, AttributeItem> allItems = new HashMap<String, AttributeItem>();
        if (this.superClassGroup != null) {
            allItems.putAll(this.superClassGroup.getAllItems());
        }
        allItems.putAll(this.getItems());
        return allItems;
    }

    public boolean containsAttributeInternal(String attributeName) {
        if (this.items != null && this.items.containsKey(attributeName)) {
            return true;
        }
        if (this.hasInheritance() && this.superClassGroup != null) {
            return this.superClassGroup.containsAttributeInternal(attributeName);
        }
        return false;
    }

    public boolean containsAttribute(String attributeNameOrPath) {
        String[] path = this.convert(attributeNameOrPath);
        if (this.getItem(path, false) != null) {
            return true;
        }
        if (this.hasInheritance() && this.superClassGroup != null) {
            return this.superClassGroup.containsAttribute(attributeNameOrPath);
        }
        return false;
    }

    public void addAttribute(String attributeNameOrPath) {
        this.addAttribute(attributeNameOrPath, (AttributeGroup)null);
    }

    public void addAttribute(String attributeNameOrPath, AttributeGroup group) {
        AttributeItem item = this.getItem(this.convert(attributeNameOrPath), true);
        item.addSubGroup(group);
    }

    public void addAttribute(String attributeNameOrPath, Collection<AttributeGroup> groups) {
        AttributeItem item = this.getItem(this.convert(attributeNameOrPath), true);
        item.addGroups(groups);
    }

    public void addAttributeKey(String attributeNameOrPath, AttributeGroup group) {
        AttributeItem item = this.getItem(this.convert(attributeNameOrPath), true);
        item.addKeyGroup(group);
    }

    public void addAttributes(Collection<String> attrOrPaths) {
        for (String attr : attrOrPaths) {
            this.addAttribute(attr);
        }
    }

    public AttributeGroup getGroup(String attributeNameOrPath) {
        AttributeItem item = this.getItem(this.convert(attributeNameOrPath), false);
        if (item != null) {
            return item.getGroup();
        }
        if (this.hasInheritance()) {
            return this.superClassGroup.getGroup(attributeNameOrPath);
        }
        return null;
    }

    public AttributeItem getItem(String attributeNameOrPath) {
        return this.getItem(this.convert(attributeNameOrPath), false);
    }

    protected AttributeItem getItem(String[] attributePath, boolean create) {
        AttributeItem item = null;
        AttributeGroup currentGroup = this;
        int index = 0;
        while (index < attributePath.length) {
            String attrName = attributePath[index];
            item = currentGroup.getItems().get(attrName);
            if (item == null) {
                if (!create) {
                    if (this.superClassGroup != null) {
                        return this.superClassGroup.getItem(attributePath, create);
                    }
                    return null;
                }
                item = this.newItem(currentGroup, attrName);
                currentGroup.getItems().put(attrName, item);
            }
            if (item.getGroup() == null && index < attributePath.length - 1) {
                if (!create) {
                    return null;
                }
                AttributeGroup newGroup = this.newGroup(attrName, currentGroup);
                item.setRootGroup(newGroup);
            }
            currentGroup = item.getGroup();
            ++index;
        }
        return item;
    }

    public void removeAttribute(String attributeNameOrPath) {
        AttributeItem item = this.getItem(attributeNameOrPath);
        if (item != null) {
            item.getParent().getItems().remove(item.getAttributeName());
        }
    }

    public boolean isSupersetOf(AttributeGroup anotherGroup) {
        if (anotherGroup == null) {
            return false;
        }
        if (anotherGroup != this) {
            if (this.hasItems()) {
                if (anotherGroup.hasItems()) {
                    for (Map.Entry<String, AttributeItem> otherItemEntry : anotherGroup.getItems().entrySet()) {
                        AttributeGroup otherElement;
                        String otherAttributeName = otherItemEntry.getKey();
                        AttributeItem item = this.items.get(otherAttributeName);
                        if (item == null) {
                            return false;
                        }
                        AttributeGroup group = item.getGroup();
                        AttributeGroup otherGroup = otherItemEntry.getValue().getGroup();
                        if (group != null) {
                            if (!group.isSupersetOf(otherGroup)) {
                                return false;
                            }
                        } else if (otherGroup != null) {
                            return true;
                        }
                        group = item.getKeyGroup();
                        otherGroup = otherItemEntry.getValue().getKeyGroup();
                        if (group != null) {
                            if (!group.isSupersetOf(otherGroup)) {
                                return false;
                            }
                        } else if (otherGroup != null) {
                            return true;
                        }
                        if (item.getGroups() != null) {
                            if (otherItemEntry.getValue().getGroups() == null) {
                                return true;
                            }
                            for (AttributeGroup element : item.getGroups().values()) {
                                if (element.isSupersetOf(otherElement = otherItemEntry.getValue().getGroups().get(element.getType()))) continue;
                                return false;
                            }
                        }
                        if (item.getKeyGroups() == null) continue;
                        if (otherItemEntry.getValue().getKeyGroups() == null) {
                            return true;
                        }
                        for (AttributeGroup element : item.getKeyGroups().values()) {
                            if (element.isSupersetOf(otherElement = otherItemEntry.getValue().getKeyGroups().get(element.getType()))) continue;
                            return false;
                        }
                    }
                    return true;
                }
                return true;
            }
            return !anotherGroup.hasItems();
        }
        return true;
    }

    protected String[] convert(String ... nameOrPath) {
        if (nameOrPath == null || nameOrPath.length == 0 || nameOrPath.length == 1 && (nameOrPath[0] == null || nameOrPath[0].length() == 0)) {
            throw new IllegalArgumentException("Inavlid name or path: " + (nameOrPath.length == 1 ? nameOrPath[0] : null));
        }
        String[] path = nameOrPath;
        if (nameOrPath.length > 1 || !nameOrPath[0].contains(".")) {
            path = nameOrPath;
        } else {
            if (nameOrPath[0].endsWith(".")) {
                throw new IllegalArgumentException("Invalid path: " + nameOrPath[0]);
            }
            path = nameOrPath[0].split("\\.");
        }
        if (path.length == 0) {
            throw new IllegalArgumentException("Invalid path: " + nameOrPath[0]);
        }
        int index = 0;
        while (index < path.length) {
            if (path[index] == null || path[index].length() == 0 || !path[index].trim().equals(path[index])) {
                throw new IllegalArgumentException("Invalid path: " + nameOrPath[0]);
            }
            ++index;
        }
        return path;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.type == null) {
            block11: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            this.type = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.typeName, true, classLoader));
                            break block11;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.typeName, exception.getException());
                        }
                    }
                    this.type = PrivilegedAccessHelper.getClassForName(this.typeName, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.typeName, exc);
                }
            }
            if (this.items != null) {
                for (AttributeItem item : this.items.values()) {
                    item.convertClassNamesToClasses(classLoader);
                }
            }
            if (this.allsubclasses != null) {
                HashMap<Object, AttributeGroup> allGroups = new HashMap<Object, AttributeGroup>();
                this.subClasses = new HashSet<AttributeGroup>();
                for (AttributeGroup subClass : this.allsubclasses.values()) {
                    subClass.convertClassNamesToClasses(classLoader);
                    allGroups.put(subClass.getType(), subClass);
                }
                this.allsubclasses = allGroups;
                for (AttributeGroup subClass : this.subClasses) {
                    if (!AttributeItem.orderInheritance(subClass, allGroups)) continue;
                    subClass.insertSubClass(this);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) {
            return false;
        }
        AttributeGroup anotherGroup = null;
        try {
            anotherGroup = (AttributeGroup)obj;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (this.hasItems()) {
            if (!anotherGroup.hasItems()) return false;
            if (!this.getItems().equals(anotherGroup.getItems())) {
                return false;
            }
        } else if (anotherGroup.hasItems()) {
            return false;
        }
        if (this.superClassGroup == null) return anotherGroup.superClassGroup == null;
        if (anotherGroup.superClassGroup == null) return false;
        return this.superClassGroup.equals(anotherGroup.superClassGroup);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.getName() + ")" + this.toStringAdditionalInfo() + "{" + this.toStringItems() + "}";
    }

    protected String toStringAdditionalInfo() {
        return "";
    }

    protected String toStringItems() {
        String str = "";
        if (this.items != null) {
            Iterator<AttributeItem> it = this.items.values().iterator();
            boolean isFirst = true;
            while (it.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    str = String.valueOf(str) + ", ";
                }
                str = String.valueOf(str) + it.next().toStringNoClassName();
            }
        }
        if (this.superClassGroup != null) {
            str = String.valueOf(str) + ", " + this.superClassGroup.toStringItems();
        }
        return str;
    }

    protected static String toStringPath(String[] attributePath, int position) {
        StringWriter writer = new StringWriter();
        int index = 0;
        while (index <= position) {
            writer.write(attributePath[index]);
            if (index < position) {
                writer.write(".");
            }
            ++index;
        }
        return writer.toString();
    }

    public boolean isFetchGroup() {
        return false;
    }

    public FetchGroup toFetchGroup() {
        if (this.isFetchGroup()) {
            return (FetchGroup)this;
        }
        return this.toFetchGroup(new HashMap<AttributeGroup, FetchGroup>());
    }

    public FetchGroup toFetchGroup(Map<AttributeGroup, FetchGroup> cloneMap) {
        FetchGroup clone = cloneMap.get(this);
        if (clone != null) {
            return clone;
        }
        clone = new FetchGroup(this.name);
        clone.type = this.type;
        clone.typeName = this.typeName;
        cloneMap.put(this, clone);
        if (this.superClassGroup != null) {
            clone.superClassGroup = this.superClassGroup.toFetchGroup(cloneMap);
        }
        if (this.allsubclasses != null) {
            for (AttributeGroup group : this.allsubclasses.values()) {
                clone.getSubClassGroups().put(group.getType(), group.toFetchGroup(cloneMap));
            }
        }
        if (this.subClasses != null) {
            clone.subClasses = new HashSet();
            for (AttributeGroup group : this.subClasses) {
                clone.subClasses.add(group.toFetchGroup(cloneMap));
            }
        }
        clone.items = null;
        if (this.hasItems()) {
            clone.items = new HashMap();
            for (AttributeItem item : this.items.values()) {
                clone.items.put(item.getAttributeName(), item.toFetchGroup(cloneMap, clone));
            }
        }
        return clone;
    }

    public boolean isCopyGroup() {
        return false;
    }

    public CopyGroup toCopyGroup() {
        if (this.isCopyGroup()) {
            return (CopyGroup)this;
        }
        IdentityHashMap<AttributeGroup, CopyGroup> cloneMap = new IdentityHashMap<AttributeGroup, CopyGroup>();
        return this.toCopyGroup(cloneMap, new HashMap());
    }

    public CopyGroup toCopyGroup(Map<AttributeGroup, CopyGroup> cloneMap, Map copies) {
        CopyGroup clone = cloneMap.get(this);
        if (clone != null) {
            return clone;
        }
        clone = new CopyGroup(this.name);
        clone.cascadeTree();
        clone.setCopies(copies);
        clone.type = this.type;
        clone.typeName = this.typeName;
        cloneMap.put(this, clone);
        if (this.allsubclasses != null) {
            for (AttributeGroup group : this.allsubclasses.values()) {
                clone.getSubClassGroups().put(group.getType(), group.toCopyGroup(cloneMap, copies));
            }
        }
        if (this.superClassGroup != null) {
            clone.superClassGroup = this.superClassGroup.toCopyGroup(cloneMap, copies);
        }
        if (this.subClasses != null) {
            clone.subClasses = new HashSet();
            for (AttributeGroup group : this.subClasses) {
                clone.subClasses.add(group.toCopyGroup(cloneMap, copies));
            }
        }
        clone.items = null;
        if (this.hasItems()) {
            clone.items = new HashMap();
            for (AttributeItem item : this.items.values()) {
                clone.items.put(item.getAttributeName(), item.toCopyGroup(cloneMap, clone, copies));
            }
        }
        return clone;
    }

    public boolean isLoadGroup() {
        return false;
    }

    public LoadGroup toLoadGroup() {
        if (this.isLoadGroup()) {
            return (LoadGroup)this;
        }
        return this.toLoadGroup(new HashMap<AttributeGroup, LoadGroup>(), false);
    }

    public LoadGroup toLoadGroup(Map<AttributeGroup, LoadGroup> cloneMap, boolean loadOnly) {
        LoadGroup clone = cloneMap.get(this);
        if (clone != null) {
            return clone;
        }
        clone = new LoadGroup(this.name);
        clone.type = this.type;
        clone.typeName = this.typeName;
        cloneMap.put(this, clone);
        if (this.allsubclasses != null) {
            for (AttributeGroup group : this.allsubclasses.values()) {
                clone.getSubClassGroups().put(group.getType(), group.toLoadGroup(cloneMap, loadOnly));
            }
        }
        if (this.superClassGroup != null) {
            clone.superClassGroup = this.superClassGroup.toLoadGroup(cloneMap, loadOnly);
        }
        if (this.subClasses != null) {
            clone.subClasses = new HashSet();
            for (AttributeGroup group : this.subClasses) {
                clone.subClasses.add(group.toLoadGroup(cloneMap, loadOnly));
            }
        }
        clone.items = null;
        if (this.hasItems()) {
            clone.items = new HashMap();
            for (AttributeItem item : this.items.values()) {
                clone.items.put(item.getAttributeName(), item.toLoadGroup(cloneMap, clone, loadOnly));
            }
        }
        return clone;
    }

    public AttributeGroup clone() {
        IdentityHashMap<AttributeGroup, AttributeGroup> cloneMap = new IdentityHashMap<AttributeGroup, AttributeGroup>();
        return this.clone(cloneMap);
    }

    public AttributeGroup clone(Map<AttributeGroup, AttributeGroup> cloneMap) {
        AttributeGroup clone = cloneMap.get(this);
        if (clone != null) {
            return clone;
        }
        try {
            clone = (AttributeGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.name = this.name;
        clone.type = this.type;
        clone.typeName = this.typeName;
        cloneMap.put(this, clone);
        if (this.allsubclasses != null) {
            for (AttributeGroup group : this.allsubclasses.values()) {
                clone.getSubClassGroups().put(group.getType(), group.clone(cloneMap));
            }
        }
        if (this.superClassGroup != null) {
            clone.superClassGroup = this.superClassGroup.clone(cloneMap);
        }
        if (this.subClasses != null) {
            clone.subClasses = new HashSet<AttributeGroup>();
            for (AttributeGroup group : this.subClasses) {
                clone.subClasses.add(group.clone(cloneMap));
            }
        }
        clone.items = null;
        if (this.hasItems()) {
            clone.items = new HashMap<String, AttributeItem>();
            for (AttributeItem item : this.items.values()) {
                clone.items.put(item.getAttributeName(), item.clone(cloneMap, clone));
            }
        }
        return clone;
    }

    public boolean isConcurrent() {
        return false;
    }

    public void insertSubClass(AttributeGroup group) {
        if (this == group) {
            return;
        }
        group.superClassGroup = this;
        if (this.subClasses != null) {
            Iterator<AttributeGroup> subClasses = this.subClasses.iterator();
            while (subClasses.hasNext()) {
                AttributeGroup subClass = subClasses.next();
                if (!group.getType().isAssignableFrom(subClass.getType())) continue;
                group.subClasses.add(subClass);
                subClass.superClassGroup = group;
                subClasses.remove();
            }
        } else {
            this.subClasses = new HashSet<AttributeGroup>();
        }
        this.subClasses.add(group);
    }
}

