/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.jaxb.TypeMappingInfo;

public class JaxbClassLoader
extends ClassLoader {
    private ClassLoader nestedClassLoader;
    private Map<String, Type> generatedClasses;

    public JaxbClassLoader(ClassLoader nestedClassLoader) {
        this.nestedClassLoader = nestedClassLoader;
        this.generatedClasses = new HashMap<String, Type>();
    }

    public JaxbClassLoader(ClassLoader nestedClassLoader, Class[] classes) {
        this.nestedClassLoader = nestedClassLoader;
        this.generatedClasses = new HashMap<String, Type>();
        if (classes != null) {
            for (int i = 0; i < classes.length; ++i) {
                Class nextClass = classes[i];
                this.generatedClasses.put(nextClass.getName(), nextClass);
            }
        }
    }

    public JaxbClassLoader(ClassLoader nestedClassLoader, Type[] types) {
        this.nestedClassLoader = nestedClassLoader;
        this.generatedClasses = new HashMap<String, Type>();
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                Type nextType = types[i];
                if (!(nextType instanceof Class)) continue;
                this.generatedClasses.put(((Class)nextType).getName(), nextType);
            }
        }
    }

    public JaxbClassLoader(ClassLoader nestedClassLoader, TypeMappingInfo[] types) {
        this.nestedClassLoader = nestedClassLoader;
        this.generatedClasses = new HashMap<String, Type>();
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                TypeMappingInfo tmi = types[i];
                Type nextType = tmi.getType();
                if (nextType == null) {
                    throw JAXBException.nullTypeOnTypeMappingInfo((QName)tmi.getXmlTagName());
                }
                if (!(nextType instanceof Class)) continue;
                this.generatedClasses.put(((Class)nextType).getName(), nextType);
            }
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        Class javaClass;
        block4: {
            javaClass = null;
            try {
                javaClass = this.nestedClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                javaClass = (Class)this.generatedClasses.get(className);
                if (javaClass != null) {
                    return javaClass;
                }
                throw e;
            }
            catch (NoClassDefFoundError error) {
                javaClass = (Class)this.generatedClasses.get(className);
                if (javaClass != null) break block4;
                throw error;
            }
        }
        return javaClass;
    }

    public Class generateClass(String className, byte[] bytes) {
        Class<?> theClass = this.defineClass(className, bytes, 0, bytes.length);
        this.generatedClasses.put(className, theClass);
        return theClass;
    }

    public void putClass(String className, Class clazz) {
        this.generatedClasses.put(className, clazz);
    }
}

