/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.ClassExtractor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.DiscriminatorColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.inheritance.InheritanceMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityClassListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.SecondaryTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityAccessor
extends MappedSuperclassAccessor {
    private InheritanceMetadata m_inheritance;
    private DiscriminatorColumnMetadata m_discriminatorColumn;
    private List<MappedSuperclassAccessor> m_mappedSuperclasses = new ArrayList<MappedSuperclassAccessor>();
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();
    private List<SecondaryTableMetadata> m_secondaryTables = new ArrayList<SecondaryTableMetadata>();
    private MetadataClass m_classExtractor;
    private String m_classExtractorName;
    private String m_discriminatorValue;
    private String m_entityName;
    private TableMetadata m_table;

    public EntityAccessor() {
        super("<entity>");
    }

    public EntityAccessor(MetadataAnnotation annotation, MetadataClass cls, MetadataProject project) {
        super(annotation, cls, project);
    }

    protected void addMultipleTableKeyFields(PrimaryKeyJoinColumnsMetadata primaryKeyJoinColumns, DatabaseTable sourceTable, DatabaseTable targetTable, String PK_CTX, String FK_CTX) {
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn : this.processPrimaryKeyJoinColumns(primaryKeyJoinColumns)) {
            String defaultPKFieldName = this.getDescriptor().getPrimaryKeyFieldName();
            DatabaseField pkField = primaryKeyJoinColumn.getPrimaryKeyField();
            this.setFieldName(pkField, defaultPKFieldName, PK_CTX);
            pkField.setTable(sourceTable);
            DatabaseField fkField = primaryKeyJoinColumn.getForeignKeyField();
            this.setFieldName(fkField, pkField.getName(), FK_CTX);
            fkField.setTable(targetTable);
            this.getDescriptor().addForeignKeyFieldForMultipleTable(fkField, pkField);
        }
    }

    protected void addPotentialMappedSuperclass(MetadataClass metadataClass, boolean addMappedSuperclassAccessors) {
        MappedSuperclassAccessor accessor = this.getProject().getMappedSuperclassAccessor(metadataClass);
        if (accessor == null) {
            if (addMappedSuperclassAccessors && metadataClass.isAnnotationPresent(MappedSuperclass.class)) {
                this.m_mappedSuperclasses.add(new MappedSuperclassAccessor(metadataClass.getAnnotation(MappedSuperclass.class), metadataClass, this.getDescriptor()));
                this.getProject().addMetamodelMappedSuperclass(metadataClass, new MappedSuperclassAccessor(metadataClass.getAnnotation(MappedSuperclass.class), metadataClass, this.getProject()));
            }
        } else if (addMappedSuperclassAccessors) {
            this.m_mappedSuperclasses.add(this.reloadMappedSuperclass(accessor, this.getDescriptor()));
            this.getProject().addMetamodelMappedSuperclass(metadataClass, this.reloadMappedSuperclass(accessor, new MetadataDescriptor(metadataClass)));
        } else {
            this.m_mappedSuperclasses.add(accessor);
        }
    }

    protected void clearMappedSuperclassesAndInheritanceParents() {
        if (!this.m_mappedSuperclasses.isEmpty()) {
            this.m_mappedSuperclasses.clear();
        }
        this.getDescriptor().setInheritanceParentDescriptor(null);
        this.getDescriptor().setInheritanceRootDescriptor(null);
    }

    protected void discoverMappedSuperclassesAndInheritanceParents(boolean addMappedSuperclassAccessors) {
        this.clearMappedSuperclassesAndInheritanceParents();
        EntityAccessor currentEntityAccessor = this;
        MetadataClass parentClass = this.getJavaClass().getSuperclass();
        List<String> genericTypes = this.getJavaClass().getGenericType();
        ArrayList<EntityAccessor> subclassEntityAccessors = new ArrayList<EntityAccessor>();
        subclassEntityAccessors.add(currentEntityAccessor);
        if (!parentClass.isObject()) {
            while (!parentClass.isObject()) {
                if (this.getProject().hasEntity(parentClass)) {
                    EntityAccessor parentEntityAccessor = this.getProject().getEntityAccessor(parentClass);
                    currentEntityAccessor.getDescriptor().setInheritanceParentDescriptor(parentEntityAccessor.getDescriptor());
                    currentEntityAccessor = parentEntityAccessor;
                    currentEntityAccessor.clearMappedSuperclassesAndInheritanceParents();
                    if (currentEntityAccessor.hasInheritance()) {
                        for (EntityAccessor subclassEntityAccessor : subclassEntityAccessors) {
                            subclassEntityAccessor.getDescriptor().setInheritanceRootDescriptor(currentEntityAccessor.getDescriptor());
                        }
                        subclassEntityAccessors.clear();
                    }
                    subclassEntityAccessors.add(currentEntityAccessor);
                } else {
                    currentEntityAccessor.addPotentialMappedSuperclass(parentClass, addMappedSuperclassAccessors);
                }
                currentEntityAccessor.resolveGenericTypes(genericTypes, parentClass);
                genericTypes = parentClass.getGenericType();
                parentClass = parentClass.getSuperclass();
            }
        } else {
            currentEntityAccessor.resolveGenericTypes(genericTypes, parentClass);
        }
        if (!subclassEntityAccessors.isEmpty()) {
            for (EntityAccessor subclassEntityAccessor : subclassEntityAccessors) {
                if (subclassEntityAccessor == currentEntityAccessor) continue;
                subclassEntityAccessor.getDescriptor().setInheritanceRootDescriptor(currentEntityAccessor.getDescriptor());
            }
        }
    }

    public String getClassExtractorName() {
        return this.m_classExtractorName;
    }

    public DiscriminatorColumnMetadata getDiscriminatorColumn() {
        return this.m_discriminatorColumn;
    }

    public String getDiscriminatorValue() {
        return this.m_discriminatorValue;
    }

    public String getEntityName() {
        return this.m_entityName;
    }

    public InheritanceMetadata getInheritance() {
        return this.m_inheritance;
    }

    public List<MappedSuperclassAccessor> getMappedSuperclasses() {
        return this.m_mappedSuperclasses;
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    public List<SecondaryTableMetadata> getSecondaryTables() {
        return this.m_secondaryTables;
    }

    public TableMetadata getTable() {
        return this.m_table;
    }

    public boolean hasClassExtractor() {
        if (this.m_classExtractorName != null && this.m_discriminatorColumn != null) {
            return !this.m_discriminatorColumn.loadedFromEclipseLinkXML();
        }
        if (this.m_classExtractorName != null) {
            return true;
        }
        if (this.m_discriminatorColumn != null) {
            return false;
        }
        if (this.isAnnotationPresent(ClassExtractor.class) && (this.isAnnotationPresent(DiscriminatorColumn.class) || this.isAnnotationPresent(DiscriminatorValue.class))) {
            throw ValidationException.classExtractorCanNotBeSpecifiedWithDiscriminatorMetadata((String)this.getJavaClassName());
        }
        return this.isAnnotationPresent(ClassExtractor.class);
    }

    public boolean hasInheritance() {
        if (this.m_inheritance == null) {
            return this.isAnnotationPresent(Inheritance.class);
        }
        return true;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_classExtractor = this.initXMLClassName(this.m_classExtractorName);
        this.initXMLObject(this.m_inheritance, accessibleObject);
        this.initXMLObject(this.m_discriminatorColumn, accessibleObject);
        this.initXMLObject(this.m_table, accessibleObject);
        this.initXMLObjects(this.m_secondaryTables, accessibleObject);
        this.initXMLObjects(this.m_primaryKeyJoinColumns, accessibleObject);
    }

    @Override
    public boolean isEntityAccessor() {
        return true;
    }

    @Override
    public boolean isMappedSuperclass() {
        return false;
    }

    @Override
    public void merge(ORMetadata metadata) {
        super.merge(metadata);
        EntityAccessor accessor = (EntityAccessor)metadata;
        this.m_entityName = (String)this.mergeSimpleObjects(this.m_entityName, accessor.getEntityName(), accessor, "@name");
        this.m_discriminatorValue = (String)this.mergeSimpleObjects(this.m_discriminatorValue, accessor.getDiscriminatorValue(), accessor, "<discriminator-value>");
        this.m_classExtractorName = (String)this.mergeSimpleObjects(this.m_classExtractorName, accessor.getClassExtractorName(), accessor, "<class-extractor>");
        this.m_discriminatorColumn = (DiscriminatorColumnMetadata)this.mergeORObjects(this.m_discriminatorColumn, accessor.getDiscriminatorColumn());
        this.m_inheritance = (InheritanceMetadata)this.mergeORObjects(this.m_inheritance, accessor.getInheritance());
        this.m_table = (TableMetadata)this.mergeORObjects(this.m_table, accessor.getTable());
        this.m_secondaryTables = this.mergeORObjectLists(this.m_secondaryTables, accessor.getSecondaryTables());
        this.m_primaryKeyJoinColumns = this.mergeORObjectLists(this.m_primaryKeyJoinColumns, accessor.getPrimaryKeyJoinColumns());
    }

    @Override
    public void preProcess() {
        EntityAccessor parentAccessor;
        this.setIsPreProcessed();
        this.processParentClass();
        if (!this.getDescriptor().isInheritanceSubclass()) {
            this.discoverMappedSuperclassesAndInheritanceParents(true);
        }
        if (this.getDescriptor().isInheritanceSubclass() && !(parentAccessor = (EntityAccessor)this.getDescriptor().getInheritanceParentDescriptor().getClassAccessor()).isPreProcessed()) {
            parentAccessor.preProcess();
        }
        this.processAccessType();
        this.processVirtualClass();
        this.processAccessMethods();
        this.processMetadataComplete();
        this.processExcludeDefaultMappings();
        this.initIdClass();
        this.processCacheable();
        for (MappedSuperclassAccessor mappedSuperclass : this.m_mappedSuperclasses) {
            mappedSuperclass.preProcess();
        }
        this.addAccessors();
        this.addConverters();
    }

    @Override
    public void preProcessForCanonicalModel() {
        EntityAccessor parentAccessor;
        this.setIsPreProcessed();
        this.processParentClass();
        if (!this.getDescriptor().isInheritanceSubclass()) {
            this.discoverMappedSuperclassesAndInheritanceParents(false);
        }
        if (this.getDescriptor().isInheritanceSubclass() && !(parentAccessor = (EntityAccessor)this.getDescriptor().getInheritanceParentDescriptor().getClassAccessor()).isPreProcessed()) {
            parentAccessor.preProcessForCanonicalModel();
        }
        this.processAccessType();
        this.processMetadataComplete();
        this.processExcludeDefaultMappings();
        this.getDescriptor().clearAccessors();
        this.addAccessors();
    }

    @Override
    public void process() {
        ClassAccessor parentAccessor;
        this.setIsProcessed();
        this.processEntity();
        if (this.getDescriptor().isInheritanceSubclass() && !(parentAccessor = this.getDescriptor().getInheritanceParentDescriptor().getClassAccessor()).isProcessed()) {
            parentAccessor.process();
        }
        this.processTableAndInheritance();
        this.processClassMetadata();
        for (MappedSuperclassAccessor mappedSuperclass : this.m_mappedSuperclasses) {
            mappedSuperclass.process();
        }
        this.processAccessors();
    }

    @Override
    protected void processCaching() {
        if (this.getProject().isCacheAll()) {
            if (this.getDescriptor().isCacheableFalse()) {
                this.getLogger().logConfigMessage("metadata_warning_ignore_cacheable_false", this.getJavaClass());
            }
            this.processCachingMetadata();
        } else if (this.getProject().isCacheNone()) {
            if (this.getDescriptor().isCacheableTrue()) {
                this.getLogger().logConfigMessage("metadata_warning_ignore_cacheable_true", this.getJavaClass());
            }
            this.getDescriptor().useNoCache();
        } else if (this.getProject().isCacheEnableSelective()) {
            if (this.getDescriptor().isCacheableTrue()) {
                this.processCachingMetadata();
            } else {
                this.getDescriptor().useNoCache();
            }
        } else if (this.getProject().isCacheDisableSelective()) {
            if (this.getDescriptor().isCacheableFalse()) {
                this.getDescriptor().useNoCache();
            } else {
                this.processCachingMetadata();
            }
        }
    }

    public String processClassExtractor() {
        MetadataAnnotation classExtractor = this.getAnnotation(ClassExtractor.class);
        if (this.m_classExtractor == null) {
            this.m_classExtractor = this.getMetadataClass((String)classExtractor.getAttribute("value"));
        } else {
            this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", classExtractor, (Object)this.getJavaClassName(), this.getLocation());
        }
        return this.m_classExtractor.getName();
    }

    @Override
    public void processDerivedId(HashSet<ClassAccessor> processing, HashSet<ClassAccessor> processed) {
        if (!processed.contains(this)) {
            super.processDerivedId(processing, processed);
            this.validatePrimaryKey();
            this.processSecondaryTables();
        }
    }

    public DatabaseField processDiscriminatorColumn() {
        MetadataAnnotation discriminatorColumn = this.getAnnotation(DiscriminatorColumn.class);
        if (this.m_discriminatorColumn == null) {
            this.m_discriminatorColumn = new DiscriminatorColumnMetadata(discriminatorColumn, this.getAccessibleObject());
        } else if (this.isAnnotationPresent(DiscriminatorColumn.class)) {
            this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", discriminatorColumn, (Object)this.getJavaClassName(), this.getLocation());
        }
        return this.m_discriminatorColumn.process(this.getDescriptor(), this.getAnnotatedElementName(), "metadata_default_inheritance_discriminator_column");
    }

    public String processDiscriminatorValue() {
        if (!Modifier.isAbstract(this.getJavaClass().getModifiers())) {
            if (this.m_discriminatorValue == null) {
                MetadataAnnotation discriminatorValue = this.getAnnotation(DiscriminatorValue.class);
                if (discriminatorValue == null) {
                    return Helper.getShortClassName((String)this.getJavaClassName());
                }
                return (String)discriminatorValue.getAttribute("value");
            }
            return this.m_discriminatorValue;
        }
        return null;
    }

    public void processAccessMethods() {
        if (this.usesVirtualAccess()) {
            if (this.hasAccessMethods()) {
                this.getDescriptor().setDefaultAccessMethods(this.getAccessMethods());
            } else {
                for (MappedSuperclassAccessor mappedSuperclass : this.getMappedSuperclasses()) {
                    if (!mappedSuperclass.hasAccessMethods()) continue;
                    this.getDescriptor().setDefaultAccessMethods(mappedSuperclass.getAccessMethods());
                    return;
                }
                if (this.getDescriptor().isInheritanceSubclass()) {
                    MetadataDescriptor parentDescriptor = this.getDescriptor().getInheritanceParentDescriptor();
                    while (parentDescriptor.isInheritanceSubclass()) {
                        if (parentDescriptor.getClassAccessor().hasAccessMethods()) {
                            this.getDescriptor().setDefaultAccessMethods(parentDescriptor.getClassAccessor().getAccessMethods());
                            return;
                        }
                        parentDescriptor = parentDescriptor.getInheritanceParentDescriptor();
                    }
                }
            }
        }
    }

    @Override
    public void processAccessors() {
        super.processAccessors();
        this.validateOptimisticLocking();
        if (!this.hasDerivedId()) {
            this.validatePrimaryKey();
            this.processSecondaryTables();
        }
    }

    @Override
    public void processAccessType() {
        String explicitAccessType = this.getAccess();
        String defaultAccessType = null;
        if (this.getDescriptor().isInheritanceSubclass()) {
            for (MetadataDescriptor parent = this.getDescriptor().getInheritanceParentDescriptor(); parent != null; parent = parent.getInheritanceParentDescriptor()) {
                if (parent.getClassAccessor().hasAccess()) continue;
                defaultAccessType = parent.getDefaultAccess();
                break;
            }
        }
        if (defaultAccessType == null) {
            for (MappedSuperclassAccessor mappedSuperclass : this.m_mappedSuperclasses) {
                if (mappedSuperclass.hasAccess()) continue;
                if (this.havePersistenceFieldAnnotationsDefined(mappedSuperclass.getJavaClass().getFields().values())) {
                    defaultAccessType = "FIELD";
                    break;
                }
                if (!this.havePersistenceMethodAnnotationsDefined(mappedSuperclass.getJavaClass().getMethods().values())) break;
                defaultAccessType = "PROPERTY";
                break;
            }
            if (defaultAccessType == null) {
                defaultAccessType = this.havePersistenceFieldAnnotationsDefined(this.getJavaClass().getFields().values()) ? "FIELD" : (this.havePersistenceMethodAnnotationsDefined(this.getJavaClass().getMethods().values()) ? "PROPERTY" : (this.getDescriptor().getDefaultAccess() != null ? this.getDescriptor().getDefaultAccess() : "FIELD"));
            }
        }
        this.getDescriptor().setDefaultAccess(defaultAccessType);
        if (explicitAccessType == null) {
            this.getLogger().logConfigMessage("metadata_access_type", defaultAccessType, (Object)this.getJavaClass());
        }
        this.getDescriptor().setAccessTypeOnClassDescriptor(this.getAccessType());
    }

    protected void processEntity() {
        if (this.m_entityName == null) {
            String string = this.m_entityName = this.getAnnotation(Entity.class) == null ? "" : (String)this.getAnnotation(Entity.class).getAttributeString("name");
        }
        if (this.m_entityName.equals("")) {
            this.m_entityName = Helper.getShortClassName((String)this.getJavaClassName());
            this.getLogger().logConfigMessage("metadata_default_alias", this.getDescriptor(), (Object)this.m_entityName);
        }
        this.getProject().addAlias(this.m_entityName, this.getDescriptor());
    }

    protected void processExcludeDefaultMappings() {
        if (this.getExcludeDefaultMappings() != null) {
            this.getDescriptor().setIgnoreDefaultMappings(this.excludeDefaultMappings());
        } else {
            for (MappedSuperclassAccessor mappedSuperclass : this.m_mappedSuperclasses) {
                if (mappedSuperclass.getExcludeDefaultMappings() == null) continue;
                this.getDescriptor().setIgnoreDefaultMappings(mappedSuperclass.excludeDefaultMappings());
                break;
            }
        }
    }

    protected void processInheritance() {
        if (this.m_inheritance == null) {
            this.m_inheritance = new InheritanceMetadata(this.getAnnotation(Inheritance.class), this.getAccessibleObject());
        }
        this.m_inheritance.process(this.getDescriptor());
    }

    public void processInheritancePrimaryKeyJoinColumns() {
        PrimaryKeyJoinColumnsMetadata pkJoinColumns;
        if (this.m_primaryKeyJoinColumns.isEmpty()) {
            MetadataAnnotation primaryKeyJoinColumn = this.getAnnotation(PrimaryKeyJoinColumn.class);
            MetadataAnnotation primaryKeyJoinColumns = this.getAnnotation(PrimaryKeyJoinColumns.class);
            pkJoinColumns = new PrimaryKeyJoinColumnsMetadata(primaryKeyJoinColumns, primaryKeyJoinColumn, this.getAccessibleObject());
        } else {
            pkJoinColumns = new PrimaryKeyJoinColumnsMetadata(this.m_primaryKeyJoinColumns);
        }
        this.addMultipleTableKeyFields(pkJoinColumns, this.getDescriptor().getPrimaryKeyTable(), this.getDescriptor().getPrimaryTable(), "metadata_default_inheritance_pk_column", "metadata_default_inheritance_fk_column");
    }

    public void processListeners(ClassLoader loader) {
        for (EntityListenerMetadata defaultListener : this.getProject().getDefaultListeners()) {
            ((EntityListenerMetadata)defaultListener.clone()).process(this.getDescriptor(), loader, true);
        }
        this.discoverMappedSuperclassesAndInheritanceParents(true);
        if (!this.getDescriptor().excludeSuperclassListeners()) {
            int mappedSuperclassesSize = this.m_mappedSuperclasses.size();
            for (int i = mappedSuperclassesSize - 1; i >= 0; --i) {
                this.m_mappedSuperclasses.get(i).processEntityListeners(loader);
            }
        }
        this.processEntityListeners(loader);
        new EntityClassListenerMetadata(this).process(this.m_mappedSuperclasses, loader);
    }

    protected void processMetadataComplete() {
        if (this.getMetadataComplete() != null) {
            this.getDescriptor().setIgnoreAnnotations(this.isMetadataComplete());
        } else {
            for (MappedSuperclassAccessor mappedSuperclass : this.m_mappedSuperclasses) {
                if (mappedSuperclass.getMetadataComplete() == null) continue;
                this.getDescriptor().setIgnoreAnnotations(mappedSuperclass.isMetadataComplete());
                break;
            }
        }
    }

    protected void processSecondaryTable(SecondaryTableMetadata secondaryTable) {
        this.processTable(secondaryTable, secondaryTable.getName());
        this.getDescriptor().addTable(secondaryTable.getDatabaseTable());
        this.addMultipleTableKeyFields(new PrimaryKeyJoinColumnsMetadata(secondaryTable.getPrimaryKeyJoinColumns()), this.getDescriptor().getPrimaryTable(), secondaryTable.getDatabaseTable(), "metadata_default_secondary_table_pk_column", "metadata_default_secondary_table_fk_column");
    }

    protected void processSecondaryTables() {
        block6: {
            MetadataAnnotation secondaryTables;
            MetadataAnnotation secondaryTable;
            block4: {
                block5: {
                    secondaryTable = this.getAnnotation(SecondaryTable.class);
                    secondaryTables = this.getAnnotation(SecondaryTables.class);
                    if (!this.m_secondaryTables.isEmpty()) break block4;
                    if (secondaryTables == null) break block5;
                    for (Object table : (Object[])secondaryTables.getAttributeArray("value")) {
                        this.processSecondaryTable(new SecondaryTableMetadata((MetadataAnnotation)table, this.getAccessibleObject()));
                    }
                    break block6;
                }
                if (secondaryTable == null) break block6;
                this.processSecondaryTable(new SecondaryTableMetadata(secondaryTable, this.getAccessibleObject()));
                break block6;
            }
            if (secondaryTable != null) {
                this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", secondaryTable, (Object)this.getJavaClassName(), this.getLocation());
            }
            if (secondaryTables != null) {
                this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", secondaryTables, (Object)this.getJavaClassName(), this.getLocation());
            }
            for (SecondaryTableMetadata table : this.m_secondaryTables) {
                this.processSecondaryTable(table);
            }
        }
    }

    protected void processTable() {
        MetadataAnnotation table = this.getAnnotation(Table.class);
        if (this.m_table == null) {
            this.processTable(new TableMetadata(table, this.getAccessibleObject()));
        } else {
            if (table != null) {
                this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", table, (Object)this.getJavaClassName(), this.getLocation());
            }
            this.processTable(this.m_table);
        }
    }

    protected void processTable(TableMetadata table) {
        this.processTable(table, this.getDescriptor().getDefaultTableName());
        this.getDescriptor().setPrimaryTable(table.getDatabaseTable());
    }

    protected void processTableAndInheritance() {
        if (this.getDescriptor().isInheritanceSubclass()) {
            MetadataDescriptor rootDescriptor = this.getDescriptor().getInheritanceRootDescriptor();
            EntityAccessor rootAccessor = (EntityAccessor)rootDescriptor.getClassAccessor();
            if (!rootAccessor.hasInheritance()) {
                rootAccessor.processInheritance();
            }
            if (this.hasInheritance() || !rootDescriptor.usesSingleTableInheritanceStrategy()) {
                this.processTable();
            }
            if (this.hasInheritance()) {
                this.processInheritance();
            } else {
                rootAccessor.getInheritance().process(this.getDescriptor());
            }
        } else {
            this.processTable();
            if (this.hasInheritance()) {
                this.processInheritance();
            }
        }
    }

    protected void resolveGenericTypes(List<String> genericTypes, MetadataClass parent) {
        this.getMetadataFactory().resolveGenericTypes(this.getJavaClass(), genericTypes, parent, this.getDescriptor());
    }

    public void setClassExtractorName(String classExtractorName) {
        this.m_classExtractorName = classExtractorName;
    }

    public void setDiscriminatorColumn(DiscriminatorColumnMetadata discriminatorColumn) {
        this.m_discriminatorColumn = discriminatorColumn;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.m_discriminatorValue = discriminatorValue;
    }

    public void setEntityName(String entityName) {
        this.m_entityName = entityName;
    }

    public void setInheritance(InheritanceMetadata inheritance) {
        this.m_inheritance = inheritance;
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns) {
        this.m_primaryKeyJoinColumns = primaryKeyJoinColumns;
    }

    public void setSecondaryTables(List<SecondaryTableMetadata> secondaryTables) {
        this.m_secondaryTables = secondaryTables;
    }

    public void setTable(TableMetadata table) {
        this.m_table = table;
    }

    protected void validateOptimisticLocking() {
        if (this.getDescriptor().usesVersionColumnOptimisticLocking() && !this.getDescriptor().usesOptimisticLocking()) {
            throw ValidationException.optimisticLockingVersionElementNotSpecified((Object)this.getJavaClass());
        }
    }

    protected void validatePrimaryKey() {
        if (this.getDescriptor().hasCompositePrimaryKey()) {
            if (this.getDescriptor().pkClassWasNotValidated()) {
                throw ValidationException.invalidCompositePKSpecification((Object)this.getJavaClass(), (String)this.getDescriptor().getPKClassName());
            }
        } else if (!this.getDescriptor().hasPrimaryKeyFields() && !this.getDescriptor().isInheritanceSubclass()) {
            throw ValidationException.noPrimaryKeyAnnotationsFound((Object)this.getJavaClass());
        }
    }
}

